/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.manage.InvoiceManage;
import com.ebaiyihui.circulation.mapper.MosDrugDetailMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DynamicServerConfigEntity;
import com.ebaiyihui.circulation.pojo.vo.dynamic.DynamicServerVO;
import com.ebaiyihui.circulation.service.IDynamicServerService;
import com.ebaiyihui.circulation.utils.BigDecimalUtil;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.three.invoice.dto.InvoiceOperationResponseDTO;
import com.ebaiyihui.three.invoice.vo.InvoiceRequestBodyVO;
import com.ebaiyihui.three.invoice.vo.InvoiceRequestChargeDetailVO;
import com.ebaiyihui.three.invoice.vo.InvoiceRequestListDetailVO;
import com.ebaiyihui.three.invoice.vo.InvoiceRequestPayChannelDetailVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@PresRoamProcessCode(value="INVOICE_BY_YC_CREATE")
@Service(value="bYOrderInvoiceCreateServiceImpl")
public class BYOrderInvoiceCreateServiceImpl
implements IDynamicServerService {
    private static final Logger log = LoggerFactory.getLogger(BYOrderInvoiceCreateServiceImpl.class);
    @Autowired
    private InvoiceManage invoiceManage;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private MosDrugDetailMapper mosDrugDetailMapper;
    public static final String CHARGE_NAME_XY = "\u897f\u836f\u8d39";
    public static final String CHARGE_NAME_ZY = "\u4e2d\u836f\u8d39";
    public static final String CHARGE_CODE_XY = "44903";
    public static final String CHARGE_CODE_ZY = "44901";

    public <T> void invoke(DynamicServerVO dynamicServerVO, T param) {
        String mainId = (String)param;
        log.info("\u8c03\u7528\u4e86\u4f70\u533b\u751f\u6210\u53d1\u7968\u7684\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)mainId);
        DrugOrderEntity drugOrderEntity = dynamicServerVO.getDrugOrderEntity();
        DrugMainEntity drugMainEntity = dynamicServerVO.getDrugMainEntity();
        DynamicServerConfigEntity configEntity = dynamicServerVO.getConfigEntity();
        List drugDetailEntityList = this.mosDrugDetailMapper.getByMainId(drugMainEntity.getxId());
        if (CollectionUtils.isEmpty((Collection)drugDetailEntityList)) {
            throw new BusinessException("\u5f53\u524d\u836f\u54c1\u5217\u8868\u627e\u4e0d\u5230\u4e86");
        }
        InvoiceRequestBodyVO invoiceRequestBodyVO = new InvoiceRequestBodyVO();
        ArrayList<InvoiceRequestChargeDetailVO> chargeDetail = new ArrayList<InvoiceRequestChargeDetailVO>();
        ArrayList<InvoiceRequestListDetailVO> listDetail = new ArrayList<InvoiceRequestListDetailVO>();
        for (int i = 0; i < drugDetailEntityList.size(); ++i) {
            DrugDetailEntity drugDetailEntity = (DrugDetailEntity)drugDetailEntityList.get(i);
            InvoiceRequestListDetailVO invoiceRequestListDetailVO = new InvoiceRequestListDetailVO();
            invoiceRequestListDetailVO.setStd(BigDecimalUtil.getNoZeros((BigDecimal)drugDetailEntity.getTotalPrice()));
            invoiceRequestListDetailVO.setCode(drugDetailEntity.getDrugCommonCode());
            invoiceRequestListDetailVO.setAmt(BigDecimalUtil.getNoZeros((BigDecimal)drugDetailEntity.getTotalPrice()));
            invoiceRequestListDetailVO.setSortNo(i + 1 + "");
            invoiceRequestListDetailVO.setNumber(BigDecimalUtil.getNoZeros((BigDecimal)drugDetailEntity.getAmount()));
            invoiceRequestListDetailVO.setName(drugDetailEntity.getDrugName());
            invoiceRequestListDetailVO.setSelfAmt(BigDecimalUtil.getNoZeros((BigDecimal)drugDetailEntity.getTotalPrice()));
            invoiceRequestListDetailVO.setChargeName(CHARGE_NAME_XY);
            invoiceRequestListDetailVO.setChargeCode(CHARGE_CODE_XY);
            listDetail.add(invoiceRequestListDetailVO);
            invoiceRequestBodyVO.setListDetail(listDetail);
        }
        InvoiceRequestChargeDetailVO invoiceRequestChargeDetailVO = new InvoiceRequestChargeDetailVO();
        invoiceRequestChargeDetailVO.setSortNo("1");
        invoiceRequestChargeDetailVO.setNumber("1");
        invoiceRequestChargeDetailVO.setUnit("\u9879");
        invoiceRequestChargeDetailVO.setStd(BigDecimalUtil.getNoZeros((BigDecimal)drugOrderEntity.getTotalDrugAmount()));
        invoiceRequestChargeDetailVO.setAmt(BigDecimalUtil.getNoZeros((BigDecimal)drugOrderEntity.getTotalDrugAmount()));
        invoiceRequestChargeDetailVO.setSelfAmt(BigDecimalUtil.getNoZeros((BigDecimal)drugOrderEntity.getTotalDrugAmount()));
        invoiceRequestChargeDetailVO.setChargeName(CHARGE_NAME_XY);
        invoiceRequestChargeDetailVO.setChargeCode(CHARGE_CODE_XY);
        chargeDetail.add(invoiceRequestChargeDetailVO);
        invoiceRequestBodyVO.setChargeDetail(chargeDetail);
        invoiceRequestBodyVO.setAppCode(drugMainEntity.getPresOrgan());
        invoiceRequestBodyVO.setHospitalId(drugMainEntity.getOrganId());
        invoiceRequestBodyVO.setServiceName("CFLZ");
        invoiceRequestBodyVO.setPatientId(drugMainEntity.getPatientCredNo());
        invoiceRequestBodyVO.setPayer(drugMainEntity.getPatientName());
        invoiceRequestBodyVO.setCardNo(drugMainEntity.getPatientCredNo());
        invoiceRequestBodyVO.setSelfCashPay(BigDecimalUtil.getNoZeros((BigDecimal)drugOrderEntity.getTotalDrugAmount()));
        invoiceRequestBodyVO.setTel(drugMainEntity.getPatientPhone());
        invoiceRequestBodyVO.setMedicalCareType("\u81ea\u8d39");
        invoiceRequestBodyVO.setBusType("02");
        invoiceRequestBodyVO.setPatientNo(drugMainEntity.getPatientCredNo());
        invoiceRequestBodyVO.setBusDateTime(DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
        invoiceRequestBodyVO.setTotalAmt(drugOrderEntity.getTotalDrugAmount().toString());
        invoiceRequestBodyVO.setPatientCategoryCode(drugMainEntity.getPresDeptCode());
        invoiceRequestBodyVO.setIdCardNo(drugMainEntity.getPatientCredNo());
        invoiceRequestBodyVO.setPatientCategory(drugMainEntity.getPresDeptName());
        ArrayList<InvoiceRequestPayChannelDetailVO> payChannelDetail = new ArrayList<InvoiceRequestPayChannelDetailVO>();
        InvoiceRequestPayChannelDetailVO invoiceRequestPayChannelDetailVO = new InvoiceRequestPayChannelDetailVO();
        invoiceRequestPayChannelDetailVO.setPayChannelCode("02");
        invoiceRequestPayChannelDetailVO.setPayChannelValue(drugOrderEntity.getPayAmount().toString());
        payChannelDetail.add(invoiceRequestPayChannelDetailVO);
        invoiceRequestBodyVO.setPayChannelDetail(payChannelDetail);
        invoiceRequestBodyVO.setSex(drugMainEntity.getPatientGender() == 1 ? "\u7537" : "\u5973");
        invoiceRequestBodyVO.setCardType("1101");
        invoiceRequestBodyVO.setOwnPay(drugOrderEntity.getPayAmount().toString());
        invoiceRequestBodyVO.setOtherfundPay("0");
        invoiceRequestBodyVO.setPayerType("1");
        invoiceRequestBodyVO.setConsultationDate(DateUtils.formatDate((Date)drugMainEntity.getxCreateTime(), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
        invoiceRequestBodyVO.setBusNo(drugOrderEntity.getxId());
        InvoiceOperationResponseDTO responseDTO = this.invoiceManage.getInvoiceRequest(configEntity.getRequestUrl(), invoiceRequestBodyVO);
        DrugOrderEntity orderEntityNew = new DrugOrderEntity();
        orderEntityNew.setxId(drugOrderEntity.getxId());
        orderEntityNew.setInvoiceNo(responseDTO.getBillNo());
        orderEntityNew.setInvoiceUrl(responseDTO.getPictureNetUrl());
        this.mosDrugOrderMapper.updateByPrimaryKeySelective(orderEntityNew);
    }
}

