/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.manage.InvoiceManage;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DynamicServerConfigEntity;
import com.ebaiyihui.circulation.pojo.vo.dynamic.DynamicServerVO;
import com.ebaiyihui.circulation.service.IDynamicServerService;
import com.ebaiyihui.three.invoice.dto.InvoiceOperationResponseDTO;
import com.ebaiyihui.three.invoice.vo.InvoiceRequestBodyVO;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@PresRoamProcessCode(value="INVOICE_BY_YC_REWRITE")
@Service(value="byOrderInvoiceCreateServiceImpl")
public class BYOrderInvoiceRewriteServiceImpl
implements IDynamicServerService {
    private static final Logger log = LoggerFactory.getLogger(BYOrderInvoiceRewriteServiceImpl.class);
    @Autowired
    private InvoiceManage invoiceManage;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;

    public <T> void invoke(DynamicServerVO dynamicServerVO, T param) {
        String mainId = (String)param;
        log.info("\u8c03\u7528\u4e86\u4f70\u533b\u751f\u6210\u53d1\u7968\u7684\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)mainId);
        DrugOrderEntity drugOrderEntity = dynamicServerVO.getDrugOrderEntity();
        if (StringUtils.isEmpty((CharSequence)drugOrderEntity.getInvoiceUrl()) && StringUtils.isEmpty((CharSequence)drugOrderEntity.getInvoiceNo())) {
            log.info("\u5f53\u524d\u8ba2\u5355\u6ca1\u6709\u53d1\u7968\uff0c\u4e0d\u51b2\u7ea2\uff01");
            return;
        }
        DrugMainEntity drugMainEntity = dynamicServerVO.getDrugMainEntity();
        DynamicServerConfigEntity configEntity = dynamicServerVO.getConfigEntity();
        if (Objects.isNull(drugMainEntity)) {
            throw new BusinessException("\u5f53\u524d\u5904\u65b9\u627e\u4e0d\u5230\u4e86");
        }
        InvoiceRequestBodyVO invoiceRequestBodyVO = new InvoiceRequestBodyVO();
        invoiceRequestBodyVO.setBusNo(drugOrderEntity.getxId());
        invoiceRequestBodyVO.setPatientId(drugMainEntity.getPatientCredNo());
        invoiceRequestBodyVO.setAppCode(drugMainEntity.getPresOrgan());
        invoiceRequestBodyVO.setHospitalId(drugMainEntity.getOrganId());
        invoiceRequestBodyVO.setServiceName("CFLZ");
        invoiceRequestBodyVO.setBusType("02");
        InvoiceOperationResponseDTO responseDTO = this.invoiceManage.getInvoiceRequest(configEntity.getRequestUrl(), invoiceRequestBodyVO);
        DrugOrderEntity orderEntityNew = new DrugOrderEntity();
        orderEntityNew.setxId(drugOrderEntity.getxId());
        orderEntityNew.setRedInvoiceUrl(responseDTO.getPictureNetUrl());
        this.mosDrugOrderMapper.updateByPrimaryKeySelective(orderEntityNew);
    }
}

