/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.common.enums.AuditStatusEnum;
import com.ebaiyihui.circulation.common.enums.BuyMedicineQuicklyEnum;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.MainTypeEnum;
import com.ebaiyihui.circulation.common.enums.PayMethodEnum;
import com.ebaiyihui.circulation.common.enums.PrescriptionChangesEnum;
import com.ebaiyihui.circulation.common.enums.PrescriptionSourceEnum;
import com.ebaiyihui.circulation.common.enums.RemarkTypeEnum;
import com.ebaiyihui.circulation.common.enums.SystemTypeEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.MosDrugDetailMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugRemarkMapper;
import com.ebaiyihui.circulation.pojo.dto.GetDrugMainTodoValueDto;
import com.ebaiyihui.circulation.pojo.dto.GetDrugMainTodoValueResponseDto;
import com.ebaiyihui.circulation.pojo.entity.DrugLogisticsOrderEntity;
import com.ebaiyihui.circulation.pojo.vo.circulation.BuyMedicineQuicklyVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.LogisticsInformationVo;
import com.ebaiyihui.circulation.pojo.vo.circulation.OrderPagingListDescRespVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.OrderPagingListReqVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.OrderPagingListRespVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.PresDrugDetailVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.PresOperationRemarkVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.PrescriptionDetailReqVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.PrescriptionDetailRespVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.QuickPrescribingBackListVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.SendPagingListReqVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.SendPagingListRespVO;
import com.ebaiyihui.circulation.pojo.vo.order.GetOrderListReqVO;
import com.ebaiyihui.circulation.pojo.vo.order.GetOrderListResVO;
import com.ebaiyihui.circulation.service.CirculationService;
import com.ebaiyihui.circulation.utils.BigDecimalUtil;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CirculationServiceImpl
implements CirculationService {
    private static final Logger log = LoggerFactory.getLogger(CirculationServiceImpl.class);
    public static final String DESC = " DESC";
    public static final int TWO = 2;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugDetailMapper mosDrugDetailMapper;
    @Autowired
    private MosDrugRemarkMapper mosDrugRemarkMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    private static final String START_SUFFIX = " 00:00:00";
    private static final String END_SUFFIX = " 23:59:59";
    private static final Integer ZERO = 0;
    private static final String DOSAGE_PREFIX = "\u6bcf\u6b21";

    public BaseResponse<PageResult<OrderPagingListRespVO>> orderPagingList(PageRequest<OrderPagingListReqVO> pageVo) {
        PageResult result = new PageResult();
        PageHelper.startPage((int)pageVo.getPageNum(), (int)pageVo.getPageSize());
        OrderPagingListReqVO orderPagingListReqVO = (OrderPagingListReqVO)pageVo.getQuery();
        this.queryCode(orderPagingListReqVO);
        List list = this.mosDrugMainMapper.orderPagingList(orderPagingListReqVO);
        list.forEach(item -> {
            item.setLastUpdateUser(this.returnDoctorName(item.getRemarkType(), item.getRemarkUser()));
            item.setRemarkType(null);
            item.setRemarkUser(null);
            item.setPresDoctorName("99999");
            item.setPrescriptionSource(PrescriptionSourceEnum.getInfo((String)item.getPrescriptionSource()));
        });
        PageInfo info = new PageInfo(list);
        result.setContent(list);
        result.setPageSize(pageVo.getPageSize());
        result.setPageNum(pageVo.getPageNum());
        result.setTotal(new Long(info.getTotal()).intValue());
        result.setTotalPages(info.getPages());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<OrderPagingListDescRespVO> orderPagingListDesc(PageRequest<OrderPagingListReqVO> pageVo) {
        OrderPagingListReqVO orderPagingListReqVO = (OrderPagingListReqVO)pageVo.getQuery();
        this.queryCode(orderPagingListReqVO);
        OrderPagingListDescRespVO respVo = this.mosDrugMainMapper.getDescCount(orderPagingListReqVO);
        respVo.setPayAmount(StringUtils.isEmpty((String)respVo.getPayAmount()) ? ZERO.toString() : new BigDecimal(respVo.getPayAmount()).setScale(2, 4).toString());
        return BaseResponse.success((Object)respVo);
    }

    public BaseResponse<PageResult<SendPagingListRespVO>> sendPagingList(PageRequest<SendPagingListReqVO> pageVo) {
        PageResult result = new PageResult();
        if (StringUtils.isNotEmpty((String)((SendPagingListReqVO)pageVo.getQuery()).getStartTime()) && StringUtils.isNotEmpty((String)((SendPagingListReqVO)pageVo.getQuery()).getEndTime())) {
            ((SendPagingListReqVO)pageVo.getQuery()).setStartTime(((SendPagingListReqVO)pageVo.getQuery()).getStartTime() + START_SUFFIX);
            ((SendPagingListReqVO)pageVo.getQuery()).setEndTime(((SendPagingListReqVO)pageVo.getQuery()).getEndTime() + END_SUFFIX);
        }
        PageHelper.startPage((int)pageVo.getPageNum(), (int)pageVo.getPageSize());
        List list = this.mosDrugMainMapper.sendPagingList((SendPagingListReqVO)pageVo.getQuery());
        list.forEach(item -> {
            item.setLastUpdateUser(this.returnDoctorName(item.getRemarkType(), item.getRemarkUser()));
            item.setRemarkType(null);
            item.setRemarkUser(null);
            item.setPresDoctorName("99999");
        });
        PageInfo info = new PageInfo(list);
        result.setContent(list);
        result.setPageSize(pageVo.getPageSize());
        result.setPageNum(pageVo.getPageNum());
        result.setTotal(new Long(info.getTotal()).intValue());
        result.setTotalPages(info.getPages());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<PrescriptionDetailRespVO> getPresDetail(PrescriptionDetailReqVO prescriptionDetailReqVO) {
        PrescriptionDetailRespVO respVo = this.mosDrugMainMapper.queryPresDetailBack(prescriptionDetailReqVO);
        if (respVo == null) {
            throw new BusinessException("\u5904\u65b9\u5931\u6548\u6216\u8005\u60a8\u65e0\u6743\u67e5\u770b\uff01");
        }
        respVo.setPresDoctorPhone("");
        respVo.setVerifierPhone("");
        if (SystemTypeEnum.MANAGE.getValue().equals(prescriptionDetailReqVO.getType()) || SystemTypeEnum.MLMANAGE.getValue().equalsIgnoreCase(prescriptionDetailReqVO.getType())) {
            this.setDrugRemarkData(respVo);
        }
        this.setDrugDetailData(respVo);
        respVo.setPresDoctorPhone("");
        respVo.setPresDoctorName("99999");
        respVo.setPresDoctorCode("99999");
        respVo.setVerifierCode("99999");
        respVo.setVerifier("99999");
        respVo.setVerifierOrganName(respVo.getHospitalName());
        respVo.setPrescriptionSource(PrescriptionSourceEnum.getInfo((String)respVo.getPrescriptionSource()));
        this.customState(respVo);
        respVo.setWriteOffStatus(respVo.getItemStatus() != null ? this.replacementWriteOffCode(respVo.getItemStatus()) : respVo.getItemStatus());
        respVo.setDrugPayMethod(StringUtils.isNotEmpty((String)respVo.getDrugPayMethod()) ? PayMethodEnum.getDesc((String)respVo.getDrugPayMethod()) : "");
        respVo.setPrice(StringUtils.isNotEmpty((String)respVo.getPrice()) ? new BigDecimal(respVo.getPrice()).setScale(2, RoundingMode.HALF_UP).toString() : ZERO.toString());
        respVo.setDrugPayAmount(StringUtils.isNotEmpty((String)respVo.getDrugPayAmount()) ? new BigDecimal(respVo.getDrugPayAmount()).setScale(2, RoundingMode.HALF_UP).toString() : ZERO.toString());
        respVo.setAuditStatusMsg(respVo.getAuditStatus() != null ? AuditStatusEnum.getDesc((Integer)respVo.getAuditStatus()) : "");
        if (!StringUtils.isEmpty((String)respVo.getMainImageUrls())) {
            respVo.setDrugImages(JSON.parseArray((String)respVo.getMainImageUrls(), String.class));
        }
        return BaseResponse.success((Object)respVo);
    }

    public BaseResponse<PageResult<QuickPrescribingBackListVO>> sendBuyMedicineQuicklyPagingList(PageRequest<BuyMedicineQuicklyVO> pageVo) {
        if (null == pageVo.getQuery() || ((BuyMedicineQuicklyVO)pageVo.getQuery()).getPharmacistCode() == null || "".equals(((BuyMedicineQuicklyVO)pageVo.getQuery()).getPharmacistCode())) {
            throw new BusinessException("\u5546\u6237/\u836f\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        pageVo.setOrderBy(BuyMedicineQuicklyEnum.getValue((String)pageVo.getOrderBy()));
        if (!pageVo.isAsc()) {
            pageVo.setOrderBy(pageVo.getOrderBy() + DESC);
        }
        PageHelper.startPage((int)pageVo.getPageNum(), (int)pageVo.getPageSize(), (String)pageVo.getOrderBy());
        ((BuyMedicineQuicklyVO)pageVo.getQuery()).setPrescriptionType(MainTypeEnum.STORE_OPEN_DRUG_MAIN.getValue());
        Page list = this.mosDrugMainMapper.sendBuyMedicineQuicklyPagingList((BuyMedicineQuicklyVO)pageVo.getQuery());
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Long.valueOf(list.getTotal()).intValue());
        pageResult.setContent((List)list);
        pageResult.setPageSize(pageVo.getPageSize());
        pageResult.setPageNum(pageVo.getPageNum());
        pageResult.setTotalPages(list.getPages());
        return BaseResponse.success((Object)pageResult);
    }

    public String modifyLogisticsInformation(LogisticsInformationVo logisticsInformationVo) {
        DrugLogisticsOrderEntity mosDrugLogisticsOrderEntity;
        log.info("=======>\u4fee\u6539\u7269\u6d41\u4fe1\u606f\u4f20\u53c2----->{}", (Object)JSON.toJSONString((Object)logisticsInformationVo));
        if (Objects.isNull(logisticsInformationVo) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)logisticsInformationVo.getMainId()) || logisticsInformationVo.getUpdateType() == null) {
            throw new BusinessException("\u53c2\u6570\u5f02\u5e38");
        }
        if (logisticsInformationVo.getUpdateType().equals(PrescriptionChangesEnum.LOGISTICS_INFORMATION.getValue())) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)logisticsInformationVo.getLogisticsName()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)logisticsInformationVo.getMainNo())) {
                throw new BusinessException("\u7269\u6d41\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)logisticsInformationVo.getDistributor()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)logisticsInformationVo.getDistributorPhone())) {
            throw new BusinessException("\u914d\u9001\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByMainId(logisticsInformationVo.getMainId()))) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u8be5\u8ba2\u5355");
        }
        if (logisticsInformationVo.getUpdateType().equals(PrescriptionChangesEnum.LOGISTICS_INFORMATION.getValue())) {
            mosDrugLogisticsOrderEntity.setLogisticsName(logisticsInformationVo.getLogisticsName());
            mosDrugLogisticsOrderEntity.setMainNo(logisticsInformationVo.getMainNo());
        } else {
            mosDrugLogisticsOrderEntity.setDistributor(logisticsInformationVo.getDistributor());
            mosDrugLogisticsOrderEntity.setDistributorPhone(logisticsInformationVo.getDistributorPhone());
        }
        this.mosDrugLogisticsOrderMapper.updateByPrimaryKey(mosDrugLogisticsOrderEntity);
        return logisticsInformationVo.getMainId();
    }

    public GetDrugMainTodoValueResponseDto getDrugMainTodoValue(List<String> storeCodes) {
        GetDrugMainTodoValueResponseDto responseDto = new GetDrugMainTodoValueResponseDto();
        List data = this.mosDrugMainMapper.getDrugMainTodoValue(storeCodes);
        Map<Integer, Integer> dataMap = data.stream().collect(Collectors.toMap(GetDrugMainTodoValueDto::getItemStatus, GetDrugMainTodoValueDto::getCount));
        responseDto.setUnpaid(dataMap.get(DrugMainStatusEnum.UNPAID.getValue()));
        responseDto.setToTake(dataMap.get(DrugMainStatusEnum.TO_TAKE.getValue()));
        responseDto.setToSend(dataMap.get(DrugMainStatusEnum.TO_SEND.getValue()));
        return responseDto;
    }

    public List<GetOrderListResVO> getOrderList(GetOrderListReqVO getOrderListReqVO) {
        return null;
    }

    private void setDrugDetailData(PrescriptionDetailRespVO respVO) {
        ArrayList drugDetailData = new ArrayList();
        List drugDetailList = this.mosDrugDetailMapper.queryByMainId(respVO.getMainId());
        drugDetailList.stream().forEach(item -> {
            PresDrugDetailVO vo = new PresDrugDetailVO();
            vo.setPresDetailId(item.getxId());
            vo.setDrugName(item.getDrugName());
            vo.setDrugSpec(item.getDrugSpec());
            vo.setManufacturer(item.getManufacturer());
            vo.setAmount(BigDecimalUtil.getNoZeros((BigDecimal)item.getAmount()));
            vo.setAmountUnit(item.getAmountUnit());
            vo.setUnitPrice(item.getUnitPrice().setScale(2, RoundingMode.HALF_UP).toString());
            vo.setTotalPrice(item.getTotalPrice().setScale(2, RoundingMode.HALF_UP).toString());
            vo.setDocRemark(item.getDocRemark());
            vo.setDuration(item.getDuration());
            vo.setReasonDesc(item.getReasonDesc());
            if (!PrescriptionSourceEnum.E_COMMERCE.getValue().toString().equals(respVO.getPrescriptionSource())) {
                vo.setDosage(DOSAGE_PREFIX + BigDecimalUtil.getNoZeros((BigDecimal)item.getSingleDose()) + item.getMeasureUnit() + "," + item.getUsageDesc() + "," + item.getFrequencyDesc());
            } else {
                vo.setDosage("\u65e0");
            }
            drugDetailData.add(vo);
        });
        respVO.setDrugDetailData(drugDetailData);
    }

    private void setDrugRemarkData(PrescriptionDetailRespVO respVO) {
        ArrayList drugRemarkData = new ArrayList();
        List remarkList = this.mosDrugRemarkMapper.queryByMainId(respVO.getMainId());
        remarkList.stream().forEach(item -> {
            PresOperationRemarkVO vo = new PresOperationRemarkVO();
            vo.setRemarkUser(this.returnDoctorName(item.getRemarkType(), item.getRemarkUser()));
            vo.setRemarkContent(item.getRemarkContent());
            vo.setRemarkTime(DateTimeUtil.formatTime((Date)item.getxCreateTime()));
            vo.setRemarkType(item.getRemarkType());
            vo.setRemarkTypeMsg(RemarkTypeEnum.getDesc((Integer)item.getRemarkType()));
            drugRemarkData.add(vo);
        });
        respVO.setDrugRemarkData(drugRemarkData);
    }

    public String returnDoctorName(Integer remarkType, String remarkUser) {
        if (Objects.isNull(remarkType) || StringUtils.isEmpty((String)remarkUser)) {
            return "";
        }
        if (RemarkTypeEnum.ADD_PRES.getValue().equals(remarkType) || RemarkTypeEnum.VERIFIER.getValue().equals(remarkType)) {
            return "99999";
        }
        return remarkUser;
    }

    private void queryCode(OrderPagingListReqVO sendPagingListReqVO) {
        if (sendPagingListReqVO.getItemStatus() != null && DrugMainStatusEnum.NOTWRITTEROff.getValue().equals(sendPagingListReqVO.getItemStatus())) {
            sendPagingListReqVO.setItemStatusList(new Integer[]{DrugMainStatusEnum.ZRYH_UNPAID.getValue(), DrugMainStatusEnum.OFFLINE_CONFIRM.getValue(), DrugMainStatusEnum.DEPLOYING.getValue(), DrugMainStatusEnum.TO_TAKE.getValue(), DrugMainStatusEnum.TO_SEND.getValue()});
            sendPagingListReqVO.setItemStatus(null);
        }
        if (sendPagingListReqVO.getItemStatus() != null && DrugMainStatusEnum.WRITTEROff.getValue().equals(sendPagingListReqVO.getItemStatus())) {
            sendPagingListReqVO.setItemStatusList(new Integer[]{DrugMainStatusEnum.FINISH.getValue(), DrugMainStatusEnum.SENT.getValue()});
            sendPagingListReqVO.setItemStatus(null);
        }
        if (sendPagingListReqVO.getItemStatus() != null && DrugMainStatusEnum.EXPIRED.getValue().equals(sendPagingListReqVO.getItemStatus())) {
            sendPagingListReqVO.setItemStatusList(new Integer[]{DrugMainStatusEnum.USELESS.getValue(), DrugMainStatusEnum.UNPAID_TIME_OUT.getValue(), DrugMainStatusEnum.DEPLOY_BACK.getValue()});
            sendPagingListReqVO.setItemStatus(null);
        }
    }

    private Integer replacementWriteOffCode(Integer status) {
        if (status.equals(DrugMainStatusEnum.ZRYH_UNPAID.getValue()) || status.equals(DrugMainStatusEnum.OFFLINE_CONFIRM.getValue()) || status.equals(DrugMainStatusEnum.DEPLOYING.getValue()) || status.equals(DrugMainStatusEnum.TO_TAKE.getValue()) || status.equals(DrugMainStatusEnum.TO_SEND.getValue())) {
            return DrugMainStatusEnum.NOTWRITTEROff.getValue();
        }
        if (status.equals(DrugMainStatusEnum.FINISH.getValue()) || status.equals(DrugMainStatusEnum.SENT.getValue())) {
            return DrugMainStatusEnum.WRITTEROff.getValue();
        }
        if (status.equals(DrugMainStatusEnum.USELESS.getValue()) || status.equals(DrugMainStatusEnum.UNPAID_TIME_OUT.getValue()) || status.equals(DrugMainStatusEnum.DEPLOY_BACK.getValue())) {
            return DrugMainStatusEnum.EXPIRED.getValue();
        }
        return status;
    }

    private void customState(PrescriptionDetailRespVO respVo) {
        if (respVo.getOrderStatusMsg() == null || "".equals(respVo.getOrderStatusMsg())) {
            if (DrugMainStatusEnum.USELESS.getValue().equals(respVo.getItemStatus())) {
                respVo.setOrderStatusMsg("\u5df2\u5931\u6548");
            } else if (DrugMainStatusEnum.UNPAID_TIME_OUT.getValue().equals(respVo.getItemStatus())) {
                respVo.setOrderStatusMsg("\u8d85\u65f6\u672a\u652f\u4ed8");
            } else if (DrugMainStatusEnum.DEPLOY_BACK.getValue().equals(respVo.getItemStatus())) {
                respVo.setOrderStatusMsg("\u5df2\u9000\u6b3e");
            } else if (DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(respVo.getItemStatus())) {
                respVo.setOrderStatusMsg("\u5f85\u652f\u4ed8");
            } else if (DrugMainStatusEnum.OFFLINE_CONFIRM.getValue().equals(respVo.getItemStatus())) {
                respVo.setOrderStatusMsg("\u5f85\u5230\u5e97\u652f\u4ed8");
            } else if (DrugMainStatusEnum.DEPLOYING.getValue().equals(respVo.getItemStatus())) {
                respVo.setOrderStatusMsg("\u8c03\u914d\u4e2d");
            } else if (DrugMainStatusEnum.TO_TAKE.getValue().equals(respVo.getItemStatus())) {
                respVo.setOrderStatusMsg("\u5f85\u53d6\u836f");
            } else if (DrugMainStatusEnum.TO_SEND.getValue().equals(respVo.getItemStatus())) {
                respVo.setOrderStatusMsg("\u5f85\u53d1\u8d27");
            } else if (DrugMainStatusEnum.FINISH.getValue().equals(respVo.getItemStatus())) {
                respVo.setOrderStatusMsg("\u5df2\u5b8c\u6210");
            } else if (DrugMainStatusEnum.ZRYH_CONFIRM.getValue().equals(respVo.getItemStatus())) {
                respVo.setOrderStatusMsg("\u5f85\u7b7e\u6536");
            } else if (DrugMainStatusEnum.SENT.getValue().equals(respVo.getItemStatus())) {
                respVo.setOrderStatusMsg("\u5f85\u7b7e\u6536");
            } else {
                respVo.setOrderStatusMsg(respVo.getItemStatus() != null ? DrugMainStatusEnum.getDesc((Integer)respVo.getItemStatus()) : "");
            }
        }
    }
}

