/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.common.enums.AccountDataAuthEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.AccountInfoMapper;
import com.ebaiyihui.circulation.mapper.UserDataAuthsMapper;
import com.ebaiyihui.circulation.pojo.bo.DataAuthListBO;
import com.ebaiyihui.circulation.pojo.dto.auth.DataAuthBaseListDto;
import com.ebaiyihui.circulation.pojo.entity.AccountInfoEntity;
import com.ebaiyihui.circulation.pojo.entity.UserDataAuthsEntity;
import com.ebaiyihui.circulation.pojo.qo.UserDataAuthsQO;
import com.ebaiyihui.circulation.pojo.vo.auth.GetDataAuthBaseListRequestVO;
import com.ebaiyihui.circulation.pojo.vo.auth.InsertOrUpdateDataAuthVO;
import com.ebaiyihui.circulation.service.AccountService;
import com.ebaiyihui.circulation.service.IDataAuthService;
import com.ebaiyihui.circulation.service.impl.DataAuthServiceImpl;
import com.ebaiyihui.circulation.utils.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="iDataAuthService")
public class DataAuthServiceImpl
implements IDataAuthService {
    private static final Logger log = LoggerFactory.getLogger(DataAuthServiceImpl.class);
    @Autowired
    private AccountInfoMapper accountInfoMapper;
    @Autowired
    private UserDataAuthsMapper userDataAuthsMapper;
    @Autowired
    private AccountService accountService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public List<DataAuthBaseListDto> getDataAuthBaseList(GetDataAuthBaseListRequestVO requestVO) {
        if (Objects.isNull(requestVO) || Objects.isNull(requestVO.getAuthLevel()) || Objects.isNull(requestVO.getUserId())) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        AccountDataAuthEnum updateLevelEnum = AccountDataAuthEnum.getEnumByValue((Integer)requestVO.getAuthLevel());
        if (Objects.isNull(updateLevelEnum)) {
            throw new BusinessException("\u6743\u9650\u7c7b\u578b\u9519\u8bef");
        }
        AccountInfoEntity accountInfoEntity = this.accountInfoMapper.selectByPrimaryKey(requestVO.getUserId());
        this.checkDataAuthType(accountInfoEntity, updateLevelEnum, requestVO.getPharmacyId());
        List<Object> checkedIds = null;
        AccountInfoEntity updateInfoEntity = null;
        Map<Object, Object> dataAuthsNameMap = null;
        boolean isCompare = false;
        if (StringUtils.isNotBlank((CharSequence)requestVO.getUpdateUserId())) {
            updateInfoEntity = this.accountInfoMapper.selectByPrimaryKey(requestVO.getUpdateUserId());
            if (Objects.isNull(updateInfoEntity) || !Integer.valueOf(1).equals(updateInfoEntity.getStatus())) {
                throw new BusinessException("\u88ab\u4fee\u6539\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01");
            }
            boolean bl = isCompare = Objects.nonNull(updateInfoEntity.getAuthType()) && (updateLevelEnum.getValue().equals(updateInfoEntity.getAuthType()) || AccountDataAuthEnum.DATA_STORE.getValue().equals(updateInfoEntity.getAuthType()) && AccountDataAuthEnum.DATA_PHARMACEUTICAL.getValue().equals(updateLevelEnum.getValue()));
            if (isCompare) {
                List updateListBOS = this.userDataAuthsMapper.getUserDataAuthsByUserId(requestVO.getUpdateUserId());
                switch (1.$SwitchMap$com$ebaiyihui$circulation$common$enums$AccountDataAuthEnum[updateLevelEnum.ordinal()]) {
                    case 1: {
                        checkedIds = updateListBOS.stream().map(UserDataAuthsEntity::getStoreId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                        dataAuthsNameMap = updateListBOS.stream().collect(Collectors.toMap(UserDataAuthsEntity::getStoreId, DataAuthListBO::getStoreName, (entity1, entity2) -> entity1));
                        break;
                    }
                    case 2: {
                        checkedIds = updateListBOS.stream().map(UserDataAuthsEntity::getPharmacyId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                        dataAuthsNameMap = updateListBOS.stream().collect(Collectors.toMap(UserDataAuthsEntity::getPharmacyId, DataAuthListBO::getPharmaceuticalCompanyName, (entity1, entity2) -> entity1));
                        break;
                    }
                    case 3: {
                        checkedIds = updateListBOS.stream().map(UserDataAuthsEntity::getHospitalId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                        dataAuthsNameMap = updateListBOS.stream().collect(Collectors.toMap(UserDataAuthsEntity::getHospitalId, DataAuthListBO::getHospitalName, (entity1, entity2) -> entity1));
                        break;
                    }
                    default: {
                        checkedIds = new ArrayList();
                        dataAuthsNameMap = new HashMap();
                    }
                }
            }
        }
        List<Object> baseListDtos = new ArrayList<DataAuthBaseListDto>();
        if (!AccountDataAuthEnum.DATA_ALL.equals((Object)updateLevelEnum)) {
            UserDataAuthsQO userDataAuthsQO = new UserDataAuthsQO();
            userDataAuthsQO.setUserId(accountInfoEntity.getId());
            userDataAuthsQO.setAuthLevel(updateLevelEnum.getValue());
            userDataAuthsQO.setPharmacyId(requestVO.getPharmacyId());
            List dataAuthListBOS = this.userDataAuthsMapper.getBaseUserDataAuthsByUser(userDataAuthsQO);
            if (AccountDataAuthEnum.DATA_HOSPITAL.getValue().equals(updateLevelEnum.getValue())) {
                for (DataAuthListBO dataAuthListBO : dataAuthListBOS) {
                    DataAuthBaseListDto dataAuthBaseListDto = new DataAuthBaseListDto();
                    dataAuthBaseListDto.setAuthId(dataAuthListBO.getHospitalId());
                    dataAuthBaseListDto.setAuthName(dataAuthListBO.getHospitalName());
                    dataAuthBaseListDto.setChildList(new ArrayList());
                    dataAuthBaseListDto.setIsCheck(Boolean.valueOf(isCompare && checkedIds.contains(dataAuthListBO.getHospitalId())));
                    baseListDtos.add(dataAuthBaseListDto);
                }
            } else if (AccountDataAuthEnum.DATA_PHARMACEUTICAL.getValue().equals(updateLevelEnum.getValue())) {
                for (DataAuthListBO dataAuthListBO : dataAuthListBOS) {
                    DataAuthBaseListDto dataAuthBaseListDto = new DataAuthBaseListDto();
                    dataAuthBaseListDto.setAuthId(dataAuthListBO.getPharmacyId());
                    dataAuthBaseListDto.setAuthName(dataAuthListBO.getPharmaceuticalCompanyName());
                    dataAuthBaseListDto.setChildList(new ArrayList());
                    dataAuthBaseListDto.setIsCheck(Boolean.valueOf(isCompare && checkedIds.contains(dataAuthListBO.getPharmacyId())));
                    baseListDtos.add(dataAuthBaseListDto);
                }
            } else if (AccountDataAuthEnum.DATA_STORE.getValue().equals(updateLevelEnum.getValue())) {
                Map<String, List<DataAuthListBO>> mapMap = dataAuthListBOS.stream().collect(Collectors.groupingBy(UserDataAuthsEntity::getPharmacyId));
                for (String string : mapMap.keySet()) {
                    List child = mapMap.get(string).parallelStream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getStoreId())).collect(Collectors.toList());
                    for (DataAuthListBO authListBO : child) {
                        DataAuthBaseListDto baseStoreListDto = new DataAuthBaseListDto();
                        baseStoreListDto.setAuthId(authListBO.getStoreId());
                        baseStoreListDto.setAuthName(authListBO.getStoreName());
                        baseStoreListDto.setIsCheck(Boolean.valueOf(isCompare && checkedIds.contains(authListBO.getStoreId())));
                        baseListDtos.add(baseStoreListDto);
                    }
                }
            }
            if (isCompare && !AccountDataAuthEnum.DATA_ALL.getValue().equals(accountInfoEntity.getAuthType())) {
                List baseListString = baseListDtos.stream().map(DataAuthBaseListDto::getAuthId).collect(Collectors.toList());
                for (String string : checkedIds) {
                    if (baseListString.contains(string)) continue;
                    DataAuthBaseListDto baseStoreListDto = new DataAuthBaseListDto();
                    baseStoreListDto.setAuthId(string);
                    baseStoreListDto.setAuthName((String)dataAuthsNameMap.get(string));
                    baseStoreListDto.setIsCheck(Boolean.valueOf(true));
                    baseStoreListDto.setIsDisable(Boolean.valueOf(true));
                    baseListDtos.add(baseStoreListDto);
                }
            }
            baseListDtos = baseListDtos.stream().sorted(Comparator.comparing(DataAuthBaseListDto::getIsCheck).reversed()).collect(Collectors.toList());
        }
        return baseListDtos;
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertOrUpdateUserDataAuth(InsertOrUpdateDataAuthVO insertOrUpdateDataAuthVO) {
        if (Objects.isNull(insertOrUpdateDataAuthVO)) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u6570\u636e\u6743\u9650\u53c2\u6570");
        }
        AccountDataAuthEnum updateLevelEnum = AccountDataAuthEnum.getEnumByValue((Integer)insertOrUpdateDataAuthVO.getDataAuthType());
        if (Objects.isNull(updateLevelEnum)) {
            throw new BusinessException("\u6743\u9650\u7c7b\u578b\u9519\u8bef");
        }
        if (!AccountDataAuthEnum.DATA_ALL.getValue().equals(updateLevelEnum.getValue()) && CollectionUtils.isEmpty((Collection)insertOrUpdateDataAuthVO.getAuthIds())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u6570\u636e\u6743\u9650");
        }
        if (AccountDataAuthEnum.DATA_STORE.getValue().equals(updateLevelEnum.getValue()) && StringUtils.isBlank((CharSequence)insertOrUpdateDataAuthVO.getParentId())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u836f\u5546\u6570\u636e\u6743\u9650");
        }
        AccountInfoEntity optionAccount = this.accountInfoMapper.selectByPrimaryKey(insertOrUpdateDataAuthVO.getOptionUserId());
        if (optionAccount == null || !Integer.valueOf(1).equals(optionAccount.getStatus())) {
            throw new BusinessException("\u60a8\u7684\u8d26\u6237\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\uff01");
        }
        this.checkDataAuthType(optionAccount, updateLevelEnum, insertOrUpdateDataAuthVO.getParentId());
        AccountInfoEntity updateAccountInfo = insertOrUpdateDataAuthVO.getUpdateAccountInfo();
        if (updateAccountInfo == null && StringUtils.isBlank((CharSequence)insertOrUpdateDataAuthVO.getUpdateUserId())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u88ab\u4fee\u6539\u7684\u7528\u6237");
        }
        if (updateAccountInfo == null && StringUtils.isNotBlank((CharSequence)insertOrUpdateDataAuthVO.getUpdateUserId()) && ((updateAccountInfo = this.accountInfoMapper.selectByPrimaryKey(insertOrUpdateDataAuthVO.getUpdateUserId())) == null || !Integer.valueOf(1).equals(updateAccountInfo.getStatus()))) {
            throw new BusinessException("\u88ab\u4fee\u6539\u7684\u7528\u6237\u5df2\u7981\u7528\uff01");
        }
        if (updateAccountInfo == null) {
            throw new BusinessException("\u51fa\u73b0\u9519\u8bef");
        }
        this.userDataAuthsMapper.updateUserDataAuthToDisable(updateAccountInfo.getId());
        ArrayList<UserDataAuthsEntity> userDataAuthsEntities = new ArrayList<UserDataAuthsEntity>();
        if (AccountDataAuthEnum.DATA_ALL.getValue().equals(updateLevelEnum.getValue())) {
            ArrayList<String> auths = new ArrayList<String>();
            auths.add("0");
            insertOrUpdateDataAuthVO.setAuthIds(auths);
        }
        Date date = new Date();
        for (String authId : insertOrUpdateDataAuthVO.getAuthIds()) {
            UserDataAuthsEntity userDataAuthsEntity = new UserDataAuthsEntity();
            userDataAuthsEntity.setUserId(updateAccountInfo.getId());
            userDataAuthsEntity.setAuthType(updateLevelEnum.getValue().intValue());
            userDataAuthsEntity.setCreateBy(optionAccount.getId());
            userDataAuthsEntity.setStatus(1);
            userDataAuthsEntity.setCreateTime(date);
            userDataAuthsEntity.setUpdateTime(date);
            switch (1.$SwitchMap$com$ebaiyihui$circulation$common$enums$AccountDataAuthEnum[updateLevelEnum.ordinal()]) {
                case 3: {
                    userDataAuthsEntity.setHospitalId(authId);
                    break;
                }
                case 2: {
                    userDataAuthsEntity.setPharmacyId(authId);
                    break;
                }
                case 1: {
                    userDataAuthsEntity.setStoreId(authId);
                    userDataAuthsEntity.setPharmacyId(insertOrUpdateDataAuthVO.getParentId());
                }
            }
            userDataAuthsEntities.add(userDataAuthsEntity);
        }
        this.userDataAuthsMapper.batchInsertUserDataAuth(userDataAuthsEntities);
        AccountInfoEntity updateInfoNew = new AccountInfoEntity();
        updateInfoNew.setAuthType(updateLevelEnum.getValue());
        updateInfoNew.setUpdateTime(new Date());
        updateInfoNew.setId(updateAccountInfo.getId());
        this.accountInfoMapper.updateByPrimaryKeySelective(updateInfoNew);
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateUserDataAuthByStore(String pharmaceuticalCompanyId, String storeCode) {
        if (StringUtils.isEmpty((CharSequence)pharmaceuticalCompanyId) || StringUtils.isEmpty((CharSequence)storeCode)) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u5bf9\u5e94\u836f\u623f\u836f\u5546\u53c2\u6570");
        }
        return this.userDataAuthsMapper.updateUserDataAuthByStore(DateUtils.getDateTime(), pharmaceuticalCompanyId, storeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteUserDataAuthByStore(String storeCode) {
        if (StringUtils.isEmpty((CharSequence)storeCode)) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u5bf9\u5e94\u836f\u623f\u53c2\u6570");
        }
        int count = 0;
        List userIds = this.userDataAuthsMapper.selectUserIdBystoreId(storeCode);
        if (userIds.size() > 0) {
            log.info("\u9700\u8981\u8bb0\u7a7a\u5220\u9664\u836f\u623f:{}\uff0c\u6ca1\u6709\u6743\u9650\u7684\u7528\u6237:{}", (Object)storeCode, (Object)userIds.toArray());
            count = this.accountInfoMapper.updateAuthTypeByUsersIds(userIds);
            log.info("\u6743\u9650\u8bb0\u7a7a\u6570:{}", (Object)count);
        }
        this.threadPoolTaskExecutor.execute(() -> userIds.forEach(s -> this.accountService.deleteLoginCache(s)));
        count = this.userDataAuthsMapper.updateUserDataAuthByStoreByStoreCod(DateUtils.getDateTime(), storeCode);
        return count;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteUserDataAuthByPharmacyId(String pharmacyId) {
        if (StringUtils.isEmpty((CharSequence)pharmacyId)) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u5bf9\u5e94\u836f\u5546\u53c2\u6570");
        }
        int count = 0;
        List userIds = this.userDataAuthsMapper.selectUserIdByPharmacyId(pharmacyId);
        if (userIds.size() > 0) {
            log.info("\u9700\u8981\u8bb0\u7a7a\u5220\u9664\u836f\u5546:{}\uff0c\u6ca1\u6709\u6743\u9650\u7684\u7528\u6237:{}", (Object)pharmacyId, (Object)userIds.toArray());
            count = this.accountInfoMapper.updateAuthTypeByUsersIds(userIds);
            log.info("\u6743\u9650\u8bb0\u7a7a\u6570:{}", (Object)count);
        }
        this.threadPoolTaskExecutor.execute(() -> userIds.forEach(s -> this.accountService.deleteLoginCache(s)));
        count = this.userDataAuthsMapper.updateUserDataAuthByStoreByPharmacyId(DateUtils.getDateTime(), pharmacyId);
        return count;
    }

    private void checkDataAuthType(AccountInfoEntity optionAccount, AccountDataAuthEnum updateLevelEnum, String pharmaceId) {
        if (Objects.isNull(optionAccount.getAuthType()) || optionAccount.getAuthType() > updateLevelEnum.getValue() && (!AccountDataAuthEnum.DATA_STORE.getValue().equals(optionAccount.getAuthType()) || !updateLevelEnum.getValue().equals(AccountDataAuthEnum.DATA_PHARMACEUTICAL.getValue()))) {
            throw new BusinessException("\u62b1\u6b49\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u7ea7\u522b\u4f4e\u4e8e\u9009\u4e2d\u7684\u6743\u9650\uff01");
        }
        if (AccountDataAuthEnum.DATA_STORE.getValue().equals(updateLevelEnum.getValue()) && AccountDataAuthEnum.DATA_HOSPITAL.getValue().equals(optionAccount.getAuthType())) {
            throw new BusinessException("\u53ea\u6709\u5168\u90e8\u533b\u9662\u6216\u8005\u836f\u5546\u6743\u9650\u624d\u80fd\u67e5\u770b\u5168\u90e8\u836f\u623f\uff01");
        }
        if (AccountDataAuthEnum.DATA_STORE.getValue().equals(updateLevelEnum.getValue()) && StringUtils.isBlank((CharSequence)pharmaceId)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u4e00\u5bb6\u836f\u5546\uff01");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteUserDataAuthByStoreAndPharmacyId(String pharmacyId, String storeCode) {
        if (StringUtils.isEmpty((CharSequence)pharmacyId) || StringUtils.isEmpty((CharSequence)storeCode)) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u5bf9\u5e94\u836f\u623f\u836f\u5546\u53c2\u6570");
        }
        return this.userDataAuthsMapper.updateUserDataAuthByStoreAndPharmacyId(DateUtils.getDateTime(), pharmacyId, storeCode);
    }
}

