/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.mapper.DynamicServerConfigMapper;
import com.ebaiyihui.circulation.pojo.entity.DynamicServerConfigEntity;
import com.ebaiyihui.circulation.service.IDynamicServerConfigService;
import com.ebaiyihui.circulation.utils.RedisUtil;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DynamicServerConfigServiceImpl
implements IDynamicServerConfigService {
    private static final Logger log = LoggerFactory.getLogger(DynamicServerConfigServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DynamicServerConfigMapper dynamicServerConfigMapper;
    private static final String DYNAMIC_SERVER_CACHE_KEY = "CFLZ:CONFIG:DYNAMIC_SERVER_";
    private static final String INVALID_RESULT_VALUE = "NO_RESULT";
    private static final Integer DYNAMIC_SERVER_CACHE_TIME = 3600;

    public DynamicServerConfigEntity getServerConfigCacheByFlag(Integer hospital, String FlagName, Integer flagType) {
        DynamicServerConfigEntity dynamicServerConfigEntity = null;
        String key = DYNAMIC_SERVER_CACHE_KEY + hospital + "_" + FlagName;
        String result = (String)this.redisUtil.get(key);
        if (INVALID_RESULT_VALUE.equalsIgnoreCase(result)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            try {
                dynamicServerConfigEntity = (DynamicServerConfigEntity)JSON.parseObject((String)result, DynamicServerConfigEntity.class);
                return dynamicServerConfigEntity;
            }
            catch (Exception e) {
                return null;
            }
        }
        dynamicServerConfigEntity = this.dynamicServerConfigMapper.getConfigByHospitalAndFlag(hospital, FlagName, flagType);
        if (Objects.nonNull(dynamicServerConfigEntity) && Integer.valueOf(1).equals(dynamicServerConfigEntity.getStatus())) {
            this.redisUtil.set(key, (Object)JSON.toJSONString((Object)dynamicServerConfigEntity), (long)DYNAMIC_SERVER_CACHE_TIME.intValue());
            return dynamicServerConfigEntity;
        }
        this.redisUtil.set(key, (Object)INVALID_RESULT_VALUE, 300L);
        return null;
    }
}

