/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.common.enums.BaseStatusEnum;
import com.ebaiyihui.circulation.mapper.HisLogMapper;
import com.ebaiyihui.circulation.pojo.entity.HisLogEntity;
import com.ebaiyihui.circulation.service.HisLogService;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HisLogServiceImpl
implements HisLogService {
    private static final Logger log = LoggerFactory.getLogger(HisLogServiceImpl.class);
    @Autowired
    private HisLogMapper hisLogMapper;

    public HisLogEntity savaEntity(FrontRequest frontRequest, String url, String hospitalId) {
        HisLogEntity hisLogEntity = new HisLogEntity();
        hisLogEntity.setId(GenSeqUtils.getUniqueNo());
        hisLogEntity.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        hisLogEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        hisLogEntity.setStatus(BaseStatusEnum.NORMAL.getValue());
        hisLogEntity.setInterfaceName(url);
        hisLogEntity.setOrganCode(hospitalId);
        hisLogEntity.setRequest(JSONObject.toJSONString((Object)frontRequest));
        log.info("=======\u8bb0\u5f55\u4fdd\u5b58his\u63a5\u53e3\u65e5\u5fd7\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)hisLogEntity));
        this.hisLogMapper.insert(hisLogEntity);
        return hisLogEntity;
    }

    public int update(HisLogEntity hisLogEntity) {
        return this.hisLogMapper.update(hisLogEntity);
    }
}

