/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.mapper.HospitalConfigMapper;
import com.ebaiyihui.circulation.pojo.dto.HospitalConfigDto;
import com.ebaiyihui.circulation.pojo.dto.HospitalListDTO;
import com.ebaiyihui.circulation.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.circulation.pojo.vo.auth.UserAuthVo;
import com.ebaiyihui.circulation.pojo.vo.circulation.DrugMainHospatlVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.HospitalReqVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugStoreResVO;
import com.ebaiyihui.circulation.service.HospitalConfigService;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HospitalConfigServiceImpl
implements HospitalConfigService {
    private static final Logger log = LoggerFactory.getLogger(HospitalConfigServiceImpl.class);
    @Autowired
    private HospitalConfigMapper mosHospitalConfigMapper;

    public PageResult<HospitalConfigDto> sendHospitalList(PageRequest<HospitalReqVO> pageVo) {
        PageHelper.startPage((int)pageVo.getPageNum(), (int)pageVo.getPageSize());
        Page list = this.mosHospitalConfigMapper.sendHospitalList((HospitalReqVO)pageVo.getQuery());
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Integer.parseInt(String.valueOf(list.getTotal())));
        pageResult.setContent(list.getResult());
        pageResult.setPageSize(pageVo.getPageSize());
        pageResult.setPageNum(pageVo.getPageNum());
        pageResult.setTotalPages(list.getPages());
        return pageResult;
    }

    public PageResult<HospitalConfigDto> sendHospitalListAll(PageRequest<HospitalReqVO> pageVo) {
        PageHelper.startPage((int)pageVo.getPageNum(), (int)pageVo.getPageSize());
        Page list = this.mosHospitalConfigMapper.sendHospitalListAll((HospitalReqVO)pageVo.getQuery());
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Integer.parseInt(String.valueOf(list.getTotal())));
        pageResult.setContent(list.getResult());
        pageResult.setPageSize(pageVo.getPageSize());
        pageResult.setPageNum(pageVo.getPageNum());
        pageResult.setTotalPages(list.getPages());
        return pageResult;
    }

    public HospitalConfigEntity hospitalDetails(HospitalReqVO hospitalReqVO) {
        return this.mosHospitalConfigMapper.selectHospitalDetails(hospitalReqVO);
    }

    public List<HospitalListDTO> hospitalListFilters(UserAuthVo userAuthVo) {
        return this.mosHospitalConfigMapper.hospitalListFilters(userAuthVo);
    }

    public PageResult<DrugStoreResVO> viewHospitalPartnerPharmacies(PageRequest<HospitalReqVO> pageVo) {
        PageHelper.startPage((int)pageVo.getPageNum(), (int)pageVo.getPageSize());
        Page list = this.mosHospitalConfigMapper.viewHospitalPartnerPharmacies((HospitalReqVO)pageVo.getQuery());
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Integer.parseInt(String.valueOf(list.getTotal())));
        pageResult.setContent(list.getResult());
        pageResult.setPageSize(pageVo.getPageSize());
        pageResult.setPageNum(pageVo.getPageNum());
        pageResult.setTotalPages(list.getPages());
        return pageResult;
    }

    public String addHospital(DrugMainHospatlVO vo) {
        HospitalConfigEntity record = new HospitalConfigEntity();
        record.setHospitalCode(vo.getHospitalCode());
        record.setName(vo.getHospitalName());
        record.setDetailAddress(vo.getHospitalDistrict());
        record.setProvince(vo.getProvince());
        record.setCity(vo.getCity());
        log.info("addHospital record :{}", (Object)JSON.toJSONString((Object)record));
        int insert = this.mosHospitalConfigMapper.insert(record);
        return String.valueOf(insert);
    }

    public String updateHospital(DrugMainHospatlVO vo) {
        HospitalConfigEntity record = new HospitalConfigEntity();
        record.setHospitalCode(vo.getHospitalCode());
        record.setName(vo.getHospitalName());
        record.setDetailAddress(vo.getHospitalDistrict());
        record.setProvince(vo.getProvince());
        record.setCity(vo.getCity());
        log.info("updateHospital record :{}", (Object)JSON.toJSONString((Object)record));
        int insert = this.mosHospitalConfigMapper.updateByPrimaryKeySelective(record);
        return String.valueOf(insert);
    }
}

