/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.mapper.MosHospitalStoreRegMapper;
import com.ebaiyihui.circulation.pojo.entity.HospitalStoreRegEntity;
import com.ebaiyihui.circulation.pojo.vo.store.DrugstoreSaveReqVO;
import com.ebaiyihui.circulation.service.IHospitalStoreRegService;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="iHospitalStoreRegService")
public class HospitalStoreRegServiceImpl
implements IHospitalStoreRegService {
    private static final Logger log = LoggerFactory.getLogger(HospitalStoreRegServiceImpl.class);
    @Autowired
    private MosHospitalStoreRegMapper mosHospitalStoreRegMapper;
    public static final Integer STATUS = 1;

    public void insterHospitalStoreReg(DrugstoreSaveReqVO drugstoreSaveReqVO) {
        ArrayList<HospitalStoreRegEntity> hospitalStoreRegEntities = new ArrayList<HospitalStoreRegEntity>();
        for (String hospitalId : drugstoreSaveReqVO.getHospitalIds()) {
            HospitalStoreRegEntity hospitalStoreReg = new HospitalStoreRegEntity();
            hospitalStoreReg.setStatus(STATUS.intValue());
            hospitalStoreReg.setHospitalId(hospitalId);
            hospitalStoreReg.setStoreId(drugstoreSaveReqVO.getId());
            hospitalStoreReg.setPharmaceuticalId(drugstoreSaveReqVO.getPharmaceuticalCompanyId());
            hospitalStoreReg.setCreateBy(drugstoreSaveReqVO.getCreateBy());
            hospitalStoreReg.setCreateTime(new Date());
            hospitalStoreRegEntities.add(hospitalStoreReg);
        }
        int count = this.mosHospitalStoreRegMapper.insertList(hospitalStoreRegEntities);
        log.info("======>\u6dfb\u52a0\u836f\u623f\u533b\u9662\u5173\u7cfb - \u6dfb\u52a0\u6570\u91cf:{},\u6210\u529f\u6570\u91cf:{}", (Object)drugstoreSaveReqVO.getHospitalIds().size(), (Object)count);
    }
}

