/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.common.enums.DrugTypeEnum;
import com.ebaiyihui.circulation.config.PrescPdfConfig;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.HospitalConfigMapper;
import com.ebaiyihui.circulation.mapper.MosDrugDetailMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.circulation.mapper.MosPdfAddressMapper;
import com.ebaiyihui.circulation.pojo.dto.DrugDetailDataDTO;
import com.ebaiyihui.circulation.pojo.dto.load.DownloadMainExcelDataDTO;
import com.ebaiyihui.circulation.pojo.dto.load.DownloadMainPdfDataDTO;
import com.ebaiyihui.circulation.pojo.dto.load.DrugDetailExcelInfoDTO;
import com.ebaiyihui.circulation.pojo.dto.load.DrugDetailPdfInfoDTO;
import com.ebaiyihui.circulation.pojo.dto.load.DrugDetailReceiveDTO;
import com.ebaiyihui.circulation.pojo.dto.load.ExpressExcelDTO;
import com.ebaiyihui.circulation.pojo.dto.load.ExpressExcelInfoDTO;
import com.ebaiyihui.circulation.pojo.dto.load.MainExcelInfoDTO;
import com.ebaiyihui.circulation.pojo.dto.load.PresPdfInfoDTO;
import com.ebaiyihui.circulation.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.circulation.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.circulation.pojo.entity.PdfAddressEntity;
import com.ebaiyihui.circulation.pojo.entity.PresPdfPathEntity;
import com.ebaiyihui.circulation.pojo.vo.circulation.SendPagingListReqVO;
import com.ebaiyihui.circulation.pojo.vo.load.DownloadMainExcelReqVO;
import com.ebaiyihui.circulation.pojo.vo.load.DownloadMainPdfReqVO;
import com.ebaiyihui.circulation.service.LoadService;
import com.ebaiyihui.circulation.service.MosDrugMainService;
import com.ebaiyihui.circulation.utils.BigDecimalUtil;
import com.ebaiyihui.circulation.utils.ExcelUtils;
import com.ebaiyihui.circulation.utils.FileUtils;
import com.ebaiyihui.circulation.utils.PdfUtil;
import com.ebaiyihui.circulation.utils.PresPdfUtil;
import com.ebaiyihui.circulation.utils.ZipUtils;
import com.ebaiyihui.circulation.utils.drugutil.DesensitizationUtil;
import com.ebaiyihui.circulation.utils.drugutil.StatusUtil;
import com.ebaiyihui.circulation.utils.medicalcloud.RandomUtils;
import com.ebaiyihui.circulation.utils.medicalcloud.UrlConnectionFileUtil;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@EnableAsync
public class LoadServiceImpl
implements LoadService {
    private static final Logger log = LoggerFactory.getLogger(LoadServiceImpl.class);
    @Resource
    private PrescPdfConfig pdfConfig;
    @Autowired
    private MosDrugDetailMapper mosDrugDetailMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugPrescriptionMapper mosDrugPrescriptionMapper;
    @Autowired
    private MosPdfAddressMapper mosPdfAddressMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;
    @Autowired
    private MosDrugMainService mosDrugMainService;
    @Autowired
    private ThreadPoolTaskExecutor executorService;
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private static final Integer TWO = 2;
    private static final Integer EXPRESS_PAGESIZE = 50000;
    private static final String DOSAGE_PREFIX = "\u6bcf\u6b21";
    private static final String MAIN_PDF_PREFIX = "byh-";
    private static final String EXPRESS_EXCEL_NAME = "\u6536\u4ef6\u4fe1\u606f";
    private static final String MAIN_EXCEL_NAME = "\u5904\u65b9\u8ba2\u5355\u4fe1\u606f";
    private static final String MAIN_PDF_NAME = "\u5904\u65b9\u6e05\u5355_";
    private static final String PRESCRIPTION_PDF_TEMPLATE = "prescriptionPdf.ftl";
    private static final String ORDER_DETAIL_KEY = "orderDetail";
    private static final String PDF_DATE_PATTERN = "yyyyMMdd";
    private static final String PRES_TEMPLATE = "prescTemplate";
    private static final String START_SUFFIX = " 00:00:00";
    private static final String END_SUFFIX = " 23:59:59";

    @Transactional(rollbackFor={Exception.class})
    public void downloadExpressExcel(SendPagingListReqVO sendPagingListReqVO, HttpServletResponse response) throws IOException {
        List workbook = this.getWorkbook(sendPagingListReqVO);
        ExcelUtils.exportExcel((List)this.getMainExcelInfoData(workbook), null, (String)EXPRESS_EXCEL_NAME, ExpressExcelDTO.class, (String)EXPRESS_EXCEL_NAME, (HttpServletResponse)response);
    }

    public void downloadMainExcel(DownloadMainExcelReqVO downloadMainExcelReqVO, HttpServletResponse response) throws IOException {
        List dataList = this.mosDrugMainMapper.queryByMainIds(downloadMainExcelReqVO.getMainIds());
        ExcelUtils.exportExcel((List)this.getMainInfoData(dataList), null, (String)MAIN_EXCEL_NAME, MainExcelInfoDTO.class, (String)MAIN_EXCEL_NAME, (HttpServletResponse)response);
    }

    public void downloadMainPdf(DownloadMainPdfReqVO downloadMainPdfReqVO, HttpServletResponse response) {
        List downloadMainPdfDataList = this.mosDrugMainMapper.queryDownloadPdfInfoByMainIds(downloadMainPdfReqVO.getMainIds());
        List drugDetailList = this.mosDrugDetailMapper.queryByMainIds(downloadMainPdfReqVO.getMainIds());
        downloadMainPdfDataList = this.getDownloadMainPdfData(downloadMainPdfDataList, drugDetailList);
        this.downloadPdf(downloadMainPdfDataList, response);
    }

    public void downloadMainPrescriptionPad(DownloadMainPdfReqVO downloadMainPdfReqVO, HttpServletResponse response) {
        String path = this.getClass().getClassLoader().getResource("bootstrap.yml").getPath();
        String pdfPath = FileUtils.getPath((String)path, (String)("prescriptionPdf/" + RandomUtils.generateRandom((int)10) + "/"));
        List drugPrescriptionEntities = this.mosDrugPrescriptionMapper.queryPrescriptionUrlByMainIds(downloadMainPdfReqVO.getMainIds());
        long count = drugPrescriptionEntities.stream().filter(s -> StringUtils.isNotBlank((String)s.getOssUrl())).count();
        CountDownLatch countDownLatch = new CountDownLatch(Integer.parseInt(String.valueOf(count)));
        drugPrescriptionEntities.stream().filter(s -> StringUtils.isNotBlank((String)s.getOssUrl())).forEach(drugPrescriptionEntity -> this.executorService.submit(() -> {
            log.info(drugPrescriptionEntity.getOssUrl());
            UrlConnectionFileUtil.downLoadFromUrl((String)drugPrescriptionEntity.getOssUrl(), (String)(drugPrescriptionEntity.getxId() + ".pdf"), (String)pdfPath);
            countDownLatch.countDown();
        }));
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.error("countDownLatch.await()\u5f02\u5e38------>{}", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        String zipPath = FileUtils.getPath((String)path, (String)("prescriptionPdfZip/" + RandomUtils.generateRandom((int)10) + "/"));
        ZipUtils.saveZip((String)pdfPath, (String)zipPath, (String)(MAIN_PDF_NAME + DateFormatUtils.format((Date)new Date(), (String)PDF_DATE_PATTERN)), (HttpServletResponse)response);
    }

    @Transactional(rollbackFor={Exception.class})
    public void reloadTemplate(String mainId, String presId) {
        log.info("=======>\u751f\u6210pdf - \u53c2\u6570 - mainId:{},presId:{}", (Object)mainId, (Object)presId);
        List presPdfInfoList = this.mosDrugMainMapper.queryForReloadPdf(mainId, presId);
        this.getPresPdfInfoList(presPdfInfoList, mainId);
        log.info("=======>\u751f\u6210pdf - \u5904\u65b9\u8be6\u60c5 - list:{}", (Object)JSON.toJSONString((Object)presPdfInfoList));
        this.setTemplate(((PresPdfInfoDTO)presPdfInfoList.get(ZERO)).getAppCode(), ((PresPdfInfoDTO)presPdfInfoList.get(ZERO)).getHospitalNameFirstLetter(), ((PresPdfInfoDTO)presPdfInfoList.get(ZERO)).getPresType());
        PdfAddressEntity pdfAddressEntity = this.mosPdfAddressMapper.queryByAppCode(((PresPdfInfoDTO)presPdfInfoList.get(ZERO)).getAppCode());
        if (pdfAddressEntity != null) {
            this.producePdf(presPdfInfoList, pdfAddressEntity.getOssHost(), pdfAddressEntity.getHtmlPath());
        }
    }

    private void getPresPdfInfoList(List<PresPdfInfoDTO> presPdfInfoList, String mainId) {
        if (CollectionUtils.isEmpty(presPdfInfoList)) {
            return;
        }
        presPdfInfoList.stream().forEach(presPdfInfo -> {
            List drugDetailList = this.mosDrugDetailMapper.queryByMainId(mainId);
            if (CollectionUtils.isNotEmpty((Collection)drugDetailList)) {
                ArrayList drugDetailPdfInfoList = new ArrayList();
                drugDetailList.stream().forEach(drugDetailEntity -> {
                    DrugDetailPdfInfoDTO drugDetailPdfInfoDTO = new DrugDetailPdfInfoDTO();
                    drugDetailPdfInfoDTO.setDrugName(drugDetailEntity.getDrugName());
                    drugDetailPdfInfoDTO.setDrugSpec(drugDetailEntity.getDrugSpec());
                    drugDetailPdfInfoDTO.setManufacturer(drugDetailEntity.getManufacturer());
                    drugDetailPdfInfoDTO.setAmount(BigDecimalUtil.getNoZeros((BigDecimal)drugDetailEntity.getAmount()));
                    drugDetailPdfInfoDTO.setAmountUnit(drugDetailEntity.getAmountUnit());
                    drugDetailPdfInfoDTO.setDuration(drugDetailEntity.getDuration());
                    drugDetailPdfInfoDTO.setDosage(DOSAGE_PREFIX + BigDecimalUtil.getNoZeros((BigDecimal)drugDetailEntity.getSingleDose()) + drugDetailEntity.getMeasureUnit() + "," + drugDetailEntity.getUsageDesc() + "," + drugDetailEntity.getFrequencyDesc());
                    drugDetailPdfInfoList.add(drugDetailPdfInfoDTO);
                });
                presPdfInfo.setDrugInfos(drugDetailPdfInfoList);
            }
        });
    }

    private void setTemplate(String appCode, String hospitalNameFirstLetter, Integer presType) {
        HospitalConfigEntity configEntity = this.hospitalConfigMapper.selectByAppcode(appCode);
        if (Objects.nonNull(configEntity)) {
            String templateContent = "";
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_25);
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            templateContent = DrugTypeEnum.CM.getValue().equals(presType) ? PresPdfUtil.getZryhTemplateName((String)this.pdfConfig.getBasePath(), (String)configEntity.getCmTemplate()) : PresPdfUtil.getZryhTemplateName((String)this.pdfConfig.getBasePath(), (String)configEntity.getWmTemplate());
            stringLoader.putTemplate(PRES_TEMPLATE, templateContent);
            configuration.setTemplateLoader((TemplateLoader)stringLoader);
            this.pdfConfig.setConfiguration(configuration);
        }
    }

    public void producePdf(List<PresPdfInfoDTO> presPdfInfoList, String ossHost, String htmlPath) {
        List presPdfPathEntities = this.createPdfAndUploadOss(presPdfInfoList, ossHost, htmlPath);
        if (CollectionUtils.isEmpty((Collection)presPdfPathEntities)) {
            log.error("=======>\u751f\u6210pdf\u5931\u8d25");
            return;
        }
        PresPdfPathEntity presPdfPathEntity = (PresPdfPathEntity)presPdfPathEntities.get(ZERO);
        if (presPdfPathEntity == null) {
            return;
        }
        presPdfInfoList.stream().forEach(presInfo -> {
            DrugPrescriptionEntity drugPrescriptionEntity = new DrugPrescriptionEntity();
            drugPrescriptionEntity.setxId(presInfo.getPresId());
            drugPrescriptionEntity.setOssUrl(presPdfPathEntity.getOssPath());
            drugPrescriptionEntity.setHtmlUrl(presPdfPathEntity.getHtmlPath());
            this.mosDrugPrescriptionMapper.updateByPrimaryKeySelective(drugPrescriptionEntity);
            log.info("=======>\u751f\u6210pdf - \u66f4\u65b0\u5904\u65b9oss\u548chtml\u5730\u5740\u6210\u529f - list:{}", (Object)JSON.toJSONString((Object)presPdfInfoList));
        });
    }

    public List<PresPdfPathEntity> createPdfAndUploadOss(List<PresPdfInfoDTO> presInfoList, String ossHost, String htmlPath) {
        PresPdfUtil prescPdf = new PresPdfUtil(presInfoList, this.pdfConfig, ossHost, htmlPath);
        boolean pdfSuccess = prescPdf.toPdf();
        if (!pdfSuccess) {
            throw new BusinessException("\u751f\u6210PDF\u5e76\u4e0a\u4f20\u81f3OSS\u5931\u8d25");
        }
        log.info("\u751f\u6210pdf\u6210\u529f\u5730\u5740\uff1a{}", (Object)prescPdf.getPdfPath());
        return prescPdf.getPdfPath();
    }

    private List<DownloadMainPdfDataDTO> getDownloadMainPdfData(List<DownloadMainPdfDataDTO> downloadMainPdfDataList, List<DrugDetailEntity> drugDetailList) {
        Map<String, List<DrugDetailEntity>> drugDetailEntityListMap = drugDetailList.stream().collect(Collectors.groupingBy(drugDetailEntity -> drugDetailEntity.getMainId()));
        return downloadMainPdfDataList.parallelStream().map(mainPdfData -> {
            mainPdfData.setDrugPayAmount(StringUtils.isNotEmpty((String)mainPdfData.getDrugPayAmount()) ? new BigDecimal(mainPdfData.getDrugPayAmount()).setScale((int)TWO, RoundingMode.HALF_UP).toString() : ZERO.toString());
            List drugList = (List)drugDetailEntityListMap.get(mainPdfData.getMainId());
            List drugDetailDataList = drugList.stream().map(drugDetailEntity -> {
                DrugDetailDataDTO drugDetailDataDTO = new DrugDetailDataDTO();
                drugDetailDataDTO.setUnitPrice(BigDecimalUtil.getNoZeros((BigDecimal)drugDetailEntity.getUnitPrice()));
                drugDetailDataDTO.setDrugName(drugDetailEntity.getDrugName());
                drugDetailDataDTO.setDrugSpec(drugDetailEntity.getDrugSpec());
                drugDetailDataDTO.setAmount(BigDecimalUtil.getNoZeros((BigDecimal)drugDetailEntity.getAmount()));
                drugDetailDataDTO.setDosage(DOSAGE_PREFIX + BigDecimalUtil.getNoZeros((BigDecimal)drugDetailEntity.getSingleDose()) + drugDetailEntity.getMeasureUnit() + "," + drugDetailEntity.getUsageDesc() + "," + drugDetailEntity.getFrequencyDesc());
                return drugDetailDataDTO;
            }).collect(Collectors.toList());
            mainPdfData.setDrugDetailData(drugDetailDataList);
            mainPdfData.setPresDoctorName("99999");
            mainPdfData.setPatientName(DesensitizationUtil.desensitizedName((String)mainPdfData.getPatientName()));
            mainPdfData.setPatientNo(DesensitizationUtil.desensitizedMedicalCard((String)mainPdfData.getPatientNo()));
            mainPdfData.setPatientCredNo(DesensitizationUtil.desensitizedIdNumber((String)mainPdfData.getPatientCredNo()));
            return mainPdfData;
        }).collect(Collectors.toList());
    }

    private void downloadPdf(List<DownloadMainPdfDataDTO> downloadMainPdfDataList, HttpServletResponse response) {
        String path = this.getClass().getClassLoader().getResource("bootstrap.yml").getPath();
        String pdfPath = FileUtils.getPath((String)path, (String)("pdf/" + RandomUtils.generateRandom((int)10) + "/"));
        CountDownLatch countDownLatch = new CountDownLatch(downloadMainPdfDataList.size());
        downloadMainPdfDataList.stream().forEach(mainPdfData -> this.executorService.submit(() -> {
            HashMap<String, DownloadMainPdfDataDTO> dataMap = new HashMap<String, DownloadMainPdfDataDTO>();
            dataMap.put(ORDER_DETAIL_KEY, (DownloadMainPdfDataDTO)mainPdfData);
            String htmlStr = PdfUtil.freemarkerRender(dataMap, (String)PRESCRIPTION_PDF_TEMPLATE);
            try {
                String fileName = MAIN_PDF_PREFIX + mainPdfData.getMainId() + ".pdf";
                PdfUtil.createPdf((String)htmlStr, (String)(pdfPath + fileName));
            }
            catch (Exception e) {
                log.error("\u521b\u5efapdf\u5f02\u5e38------>{}", (Throwable)e);
            }
            countDownLatch.countDown();
        }));
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.error("countDownLatch.await()\u5f02\u5e38------>{}", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        String zipPath = FileUtils.getPath((String)path, (String)("pdfzip/" + RandomUtils.generateRandom((int)10) + "/"));
        ZipUtils.saveZip((String)pdfPath, (String)zipPath, (String)(MAIN_PDF_NAME + DateFormatUtils.format((Date)new Date(), (String)PDF_DATE_PATTERN)), (HttpServletResponse)response);
    }

    private List<MainExcelInfoDTO> getMainInfoData(List<DownloadMainExcelDataDTO> dataList) {
        ArrayList<MainExcelInfoDTO> mainInfoList = new ArrayList<MainExcelInfoDTO>();
        List recipeNos = dataList.stream().map(DownloadMainExcelDataDTO::getRecipeNo).distinct().collect(Collectors.toList());
        recipeNos.stream().forEach(recipeNo -> {
            MainExcelInfoDTO mainInfo = new MainExcelInfoDTO();
            ArrayList drugDetailInfoList = new ArrayList();
            dataList.stream().forEach(item -> {
                boolean flag = false;
                if (recipeNo.equals(item.getRecipeNo())) {
                    DrugDetailExcelInfoDTO drugDetailInfo = new DrugDetailExcelInfoDTO();
                    BeanUtils.copyProperties((Object)item, (Object)drugDetailInfo);
                    drugDetailInfo.setDosage(DOSAGE_PREFIX + BigDecimalUtil.getNoZeros((BigDecimal)item.getSingleDose()) + item.getMeasureUnit() + "," + item.getUsageDesc() + "," + item.getFrequencyDesc());
                    if (!flag) {
                        BeanUtils.copyProperties((Object)item, (Object)mainInfo);
                        StatusUtil.customState((MainExcelInfoDTO)mainInfo);
                        flag = true;
                    }
                    drugDetailInfoList.add(drugDetailInfo);
                }
            });
            mainInfo.setDrugDetailExcelInfoDTOList(drugDetailInfoList);
            mainInfoList.add(mainInfo);
        });
        return mainInfoList;
    }

    private List<ExpressExcelDTO> getMainExcelInfoData(List<ExpressExcelInfoDTO> dataList) {
        ArrayList<ExpressExcelDTO> mainInfoList = new ArrayList<ExpressExcelDTO>();
        List recipeNos = dataList.stream().map(ExpressExcelInfoDTO::getRecipeNo).distinct().collect(Collectors.toList());
        recipeNos.stream().forEach(recipeNo -> {
            ExpressExcelDTO mainInfo = new ExpressExcelDTO();
            ArrayList drugDetailInfoList = new ArrayList();
            dataList.stream().forEach(item -> {
                boolean flag = false;
                if (recipeNo.equals(item.getRecipeNo())) {
                    DrugDetailReceiveDTO drugDetailInfo = new DrugDetailReceiveDTO();
                    BeanUtils.copyProperties((Object)item, (Object)drugDetailInfo);
                    drugDetailInfo.setDosage(DOSAGE_PREFIX + BigDecimalUtil.getNoZeros((BigDecimal)item.getSingleDose()) + item.getMeasureUnit() + "," + item.getUsageDesc() + "," + item.getFrequencyDesc());
                    if (!flag) {
                        BeanUtils.copyProperties((Object)item, (Object)mainInfo);
                        flag = true;
                    }
                    drugDetailInfoList.add(drugDetailInfo);
                }
            });
            if (CollectionUtils.isNotEmpty(drugDetailInfoList)) {
                mainInfo.setDrugDetailReceiveDTOList(drugDetailInfoList);
                if (mainInfo != null) {
                    mainInfoList.add(mainInfo);
                }
            }
        });
        return mainInfoList;
    }

    private List<ExpressExcelInfoDTO> getWorkbook(SendPagingListReqVO sendPagingListReqVO) throws IOException {
        if (StringUtils.isNotEmpty((String)sendPagingListReqVO.getStartTime()) && StringUtils.isNotEmpty((String)sendPagingListReqVO.getEndTime())) {
            sendPagingListReqVO.setStartTime(sendPagingListReqVO.getStartTime() + START_SUFFIX);
            sendPagingListReqVO.setEndTime(sendPagingListReqVO.getEndTime() + END_SUFFIX);
        }
        List expressInfoList = null;
        ArrayList<ExpressExcelInfoDTO> expressInfoListAll = new ArrayList<ExpressExcelInfoDTO>();
        Integer count = null != sendPagingListReqVO.getMainIds() && sendPagingListReqVO.getMainIds().size() > 0 ? sendPagingListReqVO.getMainIds().size() : this.mosDrugMainMapper.queryExpressCount(sendPagingListReqVO).intValue();
        if (ZERO.equals(count)) {
            return null;
        }
        int pageCount = (count - ONE) / EXPRESS_PAGESIZE + ONE;
        for (int i = ONE.intValue(); i <= pageCount; ++i) {
            expressInfoList = this.mosDrugMainService.queryExpressPage(Integer.valueOf(i), EXPRESS_PAGESIZE, sendPagingListReqVO);
            expressInfoListAll.addAll(expressInfoList);
            expressInfoList.clear();
        }
        return expressInfoListAll;
    }
}

