/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.common.enums.ErrorEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.AccountInfoMapper;
import com.ebaiyihui.circulation.mapper.AuthInfoMapper;
import com.ebaiyihui.circulation.pojo.entity.AccountInfoEntity;
import com.ebaiyihui.circulation.pojo.entity.AuthInfoEntity;
import com.ebaiyihui.circulation.pojo.entity.TokenEntity;
import com.ebaiyihui.circulation.pojo.vo.account.AccountDetailRespVO;
import com.ebaiyihui.circulation.pojo.vo.account.LoginReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.LoginRespVO;
import com.ebaiyihui.circulation.pojo.vo.account.LoginoutReqVO;
import com.ebaiyihui.circulation.pojo.vo.account.VercodeRespVO;
import com.ebaiyihui.circulation.service.LoginService;
import com.ebaiyihui.circulation.service.impl.AuthServiceImpl;
import com.ebaiyihui.circulation.utils.JwtUtil;
import com.ebaiyihui.circulation.utils.PasswordUtil;
import com.ebaiyihui.circulation.utils.RandomUtil;
import com.ebaiyihui.circulation.utils.RedisUtil;
import com.ebaiyihui.circulation.utils.VerifyCodeUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import sun.misc.BASE64Encoder;

@Service
public class LoginServiceImpl
implements LoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private AccountInfoMapper accountInfoMapper;
    @Autowired
    private AuthInfoMapper authInfoMapper;
    @Autowired
    private AuthServiceImpl authService;
    public static final String VERCODE = "vercode_";
    public static final String PNG = "png";
    public static final String BASE64_PRE = "data:image/jpeg;base64,";
    public static final Integer ZERO = 0;
    public static final Integer SIX_HUNDRED = 600;
    public static final Integer TWENTY_FOUR_HOUR = 86400;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<LoginRespVO> login(LoginReqVO loginReqVO) {
        if (ObjectUtils.isEmpty((Object)loginReqVO) || StringUtils.isBlank((String)loginReqVO.getAccountNo())) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        LoginRespVO loginRespVO = new LoginRespVO();
        BaseResponse baseResponse = this.verifyVercodeWithManage(loginReqVO.getVercodeKey(), loginReqVO.getVercodeValue());
        if (!baseResponse.isSuccess()) {
            return baseResponse;
        }
        AccountInfoEntity accountInfoEntity = this.accountInfoMapper.selectByAccountInfo(loginReqVO.getAccountNo());
        if (accountInfoEntity == null) {
            return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
        }
        String mix = PasswordUtil.mix((String)loginReqVO.getPassword(), (String)accountInfoEntity.getPwSalt());
        if (!mix.equals(accountInfoEntity.getAccountPw())) {
            return BaseResponse.error((IError)ErrorEnum.INVALID_PASSWORD);
        }
        List authInfoList = this.authInfoMapper.getAuthListByUserId(accountInfoEntity.getId());
        List authInfoDTOS = this.authService.getAuthInfoDTOS(authInfoList);
        try {
            TokenEntity tokenEntity = new TokenEntity();
            tokenEntity.setId(accountInfoEntity.getId());
            tokenEntity.setDataAuthType(accountInfoEntity.getAuthType());
            tokenEntity.setAccountNo(accountInfoEntity.getAccountNo());
            tokenEntity.setPermissions(authInfoList.parallelStream().filter(dto -> Integer.valueOf(2).equals(dto.getType()) && StringUtils.isNotEmpty((String)dto.getPermission())).map(AuthInfoEntity::getPermission).collect(Collectors.joining("&&")));
            Gson gson = new Gson();
            String subject = gson.toJson((Object)tokenEntity);
            String token = JwtUtil.createJWT((String)accountInfoEntity.getId(), (String)subject);
            this.redisUtil.set(accountInfoEntity.getId() + accountInfoEntity.getAccountNo(), (Object)token, (long)TWENTY_FOUR_HOUR.intValue());
            loginRespVO.setAccountId(accountInfoEntity.getId());
            loginRespVO.setToken(token);
            loginRespVO.setAccountNo(accountInfoEntity.getAccountNo());
            loginRespVO.setLoginName(accountInfoEntity.getLoginName());
            loginRespVO.setAuthType(accountInfoEntity.getAuthType());
            AccountDetailRespVO accountDetailRespVO = this.accountInfoMapper.selectAccountDetailById(accountInfoEntity.getId());
            loginRespVO.setRoleIds(accountDetailRespVO != null ? accountDetailRespVO.getRoleIds() : "");
            loginRespVO.setAuthInfoDTOS(authInfoDTOS);
        }
        catch (Exception e) {
            return BaseResponse.error((IError)ErrorEnum.TOKEN_SECRYKEY_NOT_EXIST);
        }
        return BaseResponse.success((Object)loginRespVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> logout(LoginoutReqVO loginoutReqVO) {
        AccountInfoEntity accountInfoEntity = this.accountInfoMapper.selectByPrimaryKey(loginoutReqVO.getAccountId());
        if (accountInfoEntity != null) {
            this.redisUtil.del(new String[]{accountInfoEntity.getId() + accountInfoEntity.getAccountNo()});
        }
        return BaseResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<VercodeRespVO> getVerCode(int width, int height) {
        VerifyCodeUtil vc = new VerifyCodeUtil();
        if (height != ZERO && width != ZERO) {
            vc.setHeight(height);
            vc.setWidth(width);
        }
        BufferedImage image = vc.getImage();
        String text = vc.getText();
        String random = RandomUtil.getRandom();
        this.redisUtil.set(VERCODE + random, (Object)text, (long)SIX_HUNDRED.intValue());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, PNG, baos);
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801 \u5f02\u5e38", (Throwable)e);
        }
        byte[] bytes = baos.toByteArray();
        BASE64Encoder encoder = new BASE64Encoder();
        String png_base64 = encoder.encodeBuffer(bytes).trim();
        png_base64 = png_base64.replaceAll("\n", "").replaceAll("\r", "");
        VercodeRespVO vercodeRespVo = new VercodeRespVO();
        vercodeRespVo.setVercodeKey(VERCODE + random);
        vercodeRespVo.setVercodeValue(text);
        vercodeRespVo.setVercodeBase64(BASE64_PRE + png_base64);
        log.info("\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801 \u9a8c\u8bc1\u7801:" + text);
        return BaseResponse.success((Object)vercodeRespVo);
    }

    public BaseResponse<LoginRespVO> getAccountAuthInfo(String mobilePhone) {
        LoginRespVO loginRespVO = new LoginRespVO();
        AccountInfoEntity accountInfoEntity = this.accountInfoMapper.selectByAccountInfo(mobilePhone);
        loginRespVO.setAccountId(accountInfoEntity.getId());
        loginRespVO.setAccountNo(accountInfoEntity.getAccountNo());
        loginRespVO.setLoginName(accountInfoEntity.getLoginName());
        loginRespVO.setAuthType(accountInfoEntity.getAuthType());
        AccountDetailRespVO accountDetailRespVO = this.accountInfoMapper.selectAccountDetailById(accountInfoEntity.getId());
        loginRespVO.setRoleIds(accountDetailRespVO != null ? accountDetailRespVO.getRoleIds() : "");
        List authInfoList = this.authInfoMapper.getAuthListByUserId(accountInfoEntity.getId());
        List authInfoDTOS = this.authService.getAuthInfoDTOS(authInfoList);
        loginRespVO.setAuthInfoDTOS(authInfoDTOS);
        return BaseResponse.success((Object)loginRespVO);
    }

    private BaseResponse<LoginRespVO> verifyVercodeWithManage(String vercodeKey, String vercodeValue) {
        Object vercode = null;
        if (StringUtils.isEmpty((String)vercodeKey) || StringUtils.isEmpty((String)vercodeValue)) {
            return BaseResponse.error((IError)ErrorEnum.VERCODE_ERROR);
        }
        vercode = this.redisUtil.get(vercodeKey);
        if (vercode == null) {
            return BaseResponse.error((IError)ErrorEnum.VERCODE_EXPIRES);
        }
        if (!vercodeValue.equalsIgnoreCase(vercode.toString())) {
            log.info("\u56fe\u6587\u9a8c\u8bc1\u4e0d\u901a\u8fc7--\u5165\u53c2\uff1a{},\u5b9e\u9645\u9a8c\u8bc1\u7801\uff1a{}", (Object)vercodeValue, vercode);
            return BaseResponse.error((IError)ErrorEnum.VERCODE_ERROR);
        }
        try {
            log.info("\u56fe\u6587\u9a8c\u8bc1\u901a\u8fc7--\u5165\u53c2\uff1a{},\u5b9e\u9645\u9a8c\u8bc1\u7801\uff1a{}", (Object)vercodeValue, vercode);
            this.redisUtil.del(new String[]{vercodeKey});
            return BaseResponse.success();
        }
        catch (Exception e) {
            return BaseResponse.error((IError)ErrorEnum.VERCODE_ERROR);
        }
    }
}

