/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.manage.LogisticsManage;
import com.ebaiyihui.circulation.mapper.HospitalConfigMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.circulation.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.circulation.service.LogisticService;
import com.ebaiyihui.circulation.service.MosDrugPrescriptionService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.ExtraQueryReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.FreightQueryReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.SieveOrderReqVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogisticServiceImpl
implements LogisticService {
    private static final Logger log = LoggerFactory.getLogger(LogisticServiceImpl.class);
    @Autowired
    private LogisticsManage logisticsManage;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper mosDrugLogisticsOrderRegMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugPrescriptionService prescriptionService;
    @Autowired
    private MosDrugPrescriptionMapper mosDrugPrescriptionMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;

    public BaseResponse<String> extraQuery(ExtraQueryReqVO vo) {
        HospitalConfigEntity configEntity = this.hospitalConfigMapper.selectByAppcode(vo.getAppCode());
        Object drugMainEntity = null;
        if (configEntity != null) {
            SieveOrderReqVO sieveOrderReqVO = new SieveOrderReqVO();
            sieveOrderReqVO.setDestAddress(vo.getDestProvince() + vo.getDestCity() + vo.getDestDistrict() + vo.getDestAddress());
            sieveOrderReqVO.setSrcAddress(vo.getSrcProvince() + vo.getSrcCity() + vo.getSrcDistrict() + vo.getSrcAddress());
            Object sieveOrderResVO = null;
            FreightQueryReqVO freightQueryReqVO = new FreightQueryReqVO();
            BeanUtils.copyProperties((Object)vo, (Object)freightQueryReqVO);
            return this.logisticsManage.freightQuery(vo.getLogisticsType(), freightQueryReqVO, configEntity);
        }
        return BaseResponse.error((String)"\u7cfb\u7edf\u5f02\u5e38");
    }
}

