/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.OrderTypeEnum;
import com.ebaiyihui.circulation.common.enums.PayTypeEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.manage.MLPushManage;
import com.ebaiyihui.circulation.mapper.MosDrugDetailMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugLogisticsOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.vo.dynamic.DynamicServerVO;
import com.ebaiyihui.circulation.service.IDynamicServerService;
import com.ebaiyihui.ml.pojo.vo.MLPushMainDrugInfoVO;
import com.ebaiyihui.ml.pojo.vo.MLPushMainPayInfoVO;
import com.ebaiyihui.ml.pojo.vo.MLPushMainRequestVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@PresRoamProcessCode(value="DRUG_STORE_PUSH_MAIN")
@Service(value="mLDrugStorePushMainServiceImpl")
public class MLDrugStorePushMainServiceImpl
implements IDynamicServerService {
    private static final Logger log = LoggerFactory.getLogger(MLDrugStorePushMainServiceImpl.class);
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private MosDrugDetailMapper mosDrugDetailMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private MLPushManage mlPushManage;

    @Transactional(rollbackFor={Exception.class})
    public <T> void invoke(DynamicServerVO dynamicServerVO, T param) {
        DrugLogisticsOrderEntity logisticsOrderEntity;
        log.info("\u8c03\u7528\u4e86\u4f70\u533b\u63a8\u9001\u7f8e\u96f6\u5904\u65b9\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a\uff1a{}", param);
        DrugMainEntity drugMainEntity = dynamicServerVO.getDrugMainEntity();
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.queryByMainId(drugMainEntity.getxId());
        if (Objects.isNull(drugOrderEntity)) {
            throw new BusinessException("\u5f53\u524d\u8ba2\u5355\u627e\u4e0d\u5230\u4e86");
        }
        MLPushMainRequestVO mlPushMainRequestVO = (MLPushMainRequestVO)JSONObject.parseObject((String)dynamicServerVO.getConfigEntity().getParamDesc(), MLPushMainRequestVO.class);
        mlPushMainRequestVO.setOrderId(drugOrderEntity.getxId());
        mlPushMainRequestVO.setMainId(drugMainEntity.getxId());
        mlPushMainRequestVO.setOrderType(drugOrderEntity.getOrderType());
        mlPushMainRequestVO.setCodeImage(drugMainEntity.getFetchMedicalCode());
        mlPushMainRequestVO.setStatus(DrugMainStatusEnum.OFFLINE_CONFIRM.getValue());
        mlPushMainRequestVO.setShopId(drugMainEntity.getStoreId());
        mlPushMainRequestVO.setTotalPrice(drugOrderEntity.getOrderAmount().toString());
        mlPushMainRequestVO.setPayPrice(mlPushMainRequestVO.getTotalPrice());
        mlPushMainRequestVO.setActualIncome(mlPushMainRequestVO.getTotalPrice());
        mlPushMainRequestVO.setRemark(drugMainEntity.getRemark());
        mlPushMainRequestVO.setCreateTime(new Date());
        mlPushMainRequestVO.setPayStatus(Integer.valueOf(PayTypeEnum.WECHAT_PAY.getValue().equalsIgnoreCase(drugOrderEntity.getPayMethod()) ? 2 : 0));
        mlPushMainRequestVO.setPrePaymentType(PayTypeEnum.WECHAT_PAY.getValue().equalsIgnoreCase(drugOrderEntity.getPayMethod()) ? Integer.valueOf(0) : null);
        mlPushMainRequestVO.setOrdererName(drugMainEntity.getPatientName());
        mlPushMainRequestVO.setOrdererPhone(drugMainEntity.getPatientPhone());
        mlPushMainRequestVO.setPatientLoginPhone(drugMainEntity.getPatientLoginPhone());
        if (OrderTypeEnum.COURIER_ORDER.getValue().equals(drugOrderEntity.getOrderType()) && Objects.nonNull(logisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByMainId(drugMainEntity.getxId()))) {
            mlPushMainRequestVO.setRecipientAddress(logisticsOrderEntity.getDestAddress());
            mlPushMainRequestVO.setRecipientPhone(logisticsOrderEntity.getDestPhone());
            mlPushMainRequestVO.setRecipientName(logisticsOrderEntity.getDestName());
        }
        List drugDetailEntityList = this.mosDrugDetailMapper.getByMainId(drugMainEntity.getxId());
        mlPushMainRequestVO.setGoodsDetail(MLPushMainDrugInfoVO.getListToDetailList((List)drugDetailEntityList));
        if (PayTypeEnum.WECHAT_PAY.getValue().equalsIgnoreCase(drugOrderEntity.getPayMethod())) {
            try {
                mlPushMainRequestVO.setCreateTime(drugOrderEntity.getPayTime());
            }
            catch (Exception e) {
                mlPushMainRequestVO.setCreateTime(new Date());
            }
            mlPushMainRequestVO.setStatus(OrderTypeEnum.COURIER_ORDER.getValue().equals(drugOrderEntity.getOrderType()) ? DrugMainStatusEnum.DEPLOYING.getValue() : DrugMainStatusEnum.TO_TAKE.getValue());
            MLPushMainPayInfoVO mlPushMainPayInfoVO = new MLPushMainPayInfoVO();
            mlPushMainPayInfoVO.setPayCode(Integer.valueOf(1));
            mlPushMainPayInfoVO.setPayPrice(drugOrderEntity.getPayAmount());
            mlPushMainPayInfoVO.setPayName("\u5fae\u4fe1\u652f\u4ed8");
            mlPushMainPayInfoVO.setTradeNo(drugOrderEntity.getBankTradeNo());
            mlPushMainPayInfoVO.setPayTime(Long.valueOf(System.currentTimeMillis()));
            ArrayList<MLPushMainPayInfoVO> mainPayInfoVOS = new ArrayList<MLPushMainPayInfoVO>();
            mainPayInfoVOS.add(mlPushMainPayInfoVO);
            mlPushMainRequestVO.setPayList(mainPayInfoVOS);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)dynamicServerVO.getConfigEntity().getParamDesc());
        this.mlPushManage.pushMain(dynamicServerVO.getConfigEntity().getRequestUrl(), mlPushMainRequestVO, jsonObject.getString("signKey"));
    }
}

