/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.manage.MLPushManage;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugStoreMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugStoreEntity;
import com.ebaiyihui.circulation.pojo.vo.dynamic.DynamicServerVO;
import com.ebaiyihui.circulation.service.IDynamicServerService;
import com.ebaiyihui.ml.pojo.vo.MLCommonRequestVO;
import com.ebaiyihui.ml.pojo.vo.MLUpdateSynchronizationMainStatusVO;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@PresRoamProcessCode(value="DRUG_STORE_UPDATE_MAIN_STATUS")
@Service(value="mLDrugStoreUpdateMainStatusServiceImpl")
public class MLDrugStoreUpdateMainStatusServiceImpl
implements IDynamicServerService {
    private static final Logger log = LoggerFactory.getLogger(MLDrugStoreUpdateMainStatusServiceImpl.class);
    @Autowired
    private MosDrugStoreMapper mosDrugStoreMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MLPushManage mlPushManage;

    @Transactional(rollbackFor={Exception.class})
    public <T> void invoke(DynamicServerVO dynamicServerVO, T param) {
        DrugMainEntity drugMainEntity;
        log.info("\u8c03\u7528\u4e86\u4f70\u533b\u540c\u6b65\u7f8e\u96f6\u5904\u65b9\u72b6\u6001\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(param));
        MLUpdateSynchronizationMainStatusVO mlUpdateOrderMainStatusVO = (MLUpdateSynchronizationMainStatusVO)JSONObject.parseObject((String)JSONObject.toJSONString(param), MLUpdateSynchronizationMainStatusVO.class);
        MLCommonRequestVO mlPushMainRequestVO = (MLCommonRequestVO)JSONObject.parseObject((String)dynamicServerVO.getConfigEntity().getParamDesc(), MLCommonRequestVO.class);
        BeanUtils.copyProperties((Object)mlPushMainRequestVO, (Object)mlUpdateOrderMainStatusVO);
        if (StringUtils.isEmpty((CharSequence)mlUpdateOrderMainStatusVO.getOrderId())) {
            DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.queryByMainId(mlUpdateOrderMainStatusVO.getMainId());
            mlUpdateOrderMainStatusVO.setOrderId(drugOrderEntity.getxId());
        }
        if (Objects.isNull(drugMainEntity = this.mosDrugMainMapper.selectByPrimaryKey(mlUpdateOrderMainStatusVO.getMainId()))) {
            throw new BusinessException("\u5f53\u524d\u5904\u65b9\u627e\u4e0d\u5230\u4e86");
        }
        DrugStoreEntity storeEntity = this.mosDrugStoreMapper.queryById(drugMainEntity.getStoreId());
        if (Objects.isNull(storeEntity)) {
            throw new BusinessException("\u5f53\u524d\u836f\u623f\u627e\u4e0d\u5230\u4e86");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)dynamicServerVO.getConfigEntity().getParamDesc());
        this.mlPushManage.updateMainStatus(dynamicServerVO.getConfigEntity().getRequestUrl(), mlUpdateOrderMainStatusVO, jsonObject.getString("signKey"));
    }
}

