/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.MLDrugMainOptionEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.factory.PresRoamProcessStrategyFactory;
import com.ebaiyihui.circulation.mapper.MosDrugItemMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugStoreMapper;
import com.ebaiyihui.circulation.pojo.dto.load.DownloadMainExcelDataDTO;
import com.ebaiyihui.circulation.pojo.dto.load.DrugDetailExcelInfoDTO;
import com.ebaiyihui.circulation.pojo.dto.load.MainExcelInfoDTO;
import com.ebaiyihui.circulation.pojo.vo.circulation.PrescriptionDetailReqVO;
import com.ebaiyihui.circulation.pojo.vo.load.DownloadMainExcelReqVO;
import com.ebaiyihui.circulation.service.CirculationService;
import com.ebaiyihui.circulation.service.IMLPushMainService;
import com.ebaiyihui.circulation.service.IMLUpdateMainOrderStatusService;
import com.ebaiyihui.circulation.utils.BigDecimalUtil;
import com.ebaiyihui.circulation.utils.drugutil.StatusUtil;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.ml.pojo.dto.MLQueryDrugItemListDTO;
import com.ebaiyihui.ml.pojo.dto.MLQueryDrugStoreListDTO;
import com.ebaiyihui.ml.pojo.dto.MLQueryMainDetailDTO;
import com.ebaiyihui.ml.pojo.vo.MLPaySuccessRequestVO;
import com.ebaiyihui.ml.pojo.vo.MLQueryDrugItemVO;
import com.ebaiyihui.ml.pojo.vo.MLQueryDrugStoreVO;
import com.ebaiyihui.ml.pojo.vo.MLQueryMainDetailVO;
import com.ebaiyihui.ml.pojo.vo.MLUpdateOrderMainStatusVO;
import com.ebaiyihui.ml.pojo.vo.MLUpdateOrderStatusCommonVO;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="iMLPushMainService")
public class MLPushMainServiceImpl
implements IMLPushMainService {
    private static final Logger log = LoggerFactory.getLogger(MLPushMainServiceImpl.class);
    @Autowired
    private MosDrugStoreMapper mosDrugStoreMapper;
    @Autowired
    private MosDrugItemMapper mosDrugItemMapper;
    @Autowired
    private CirculationService circulationService;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    private static final String DOSAGE_PREFIX = "\u6bcf\u6b21";
    public static final String ML_UPDATE_ORDER_STATUS_SUFFIX = "_ML_UPDATE_MAIN_ORDER";
    public static final String ML_UPDATE_PAY_ORDER_STATUS_SUFFIX = "_ML_UPDATE_PAY_ORDER_STATUS_SUFFIX";

    public Integer updateOrderMainStatus(MLUpdateOrderMainStatusVO mlUpdateOrderMainStatusVO) {
        log.info("\u7f8e\u96f6\u8c03\u7528\u6211\u65b9\u533b\u5631\u8ba2\u5355\u4fee\u6539\u63a5\u53e3  \u4e3b\u8981\u64cd\u4f5c\u6709 \u53d1\u8d27\u3001\u53d6\u836f\uff0c\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)mlUpdateOrderMainStatusVO));
        if (Objects.isNull(mlUpdateOrderMainStatusVO)) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u64cd\u4f5c\u7c7b\u578b");
        }
        IMLUpdateMainOrderStatusService imlUpdateMainOrderStatusService = this.getImlUpdateMainOrderStatusService(mlUpdateOrderMainStatusVO.getOperationType(), ML_UPDATE_ORDER_STATUS_SUFFIX);
        return imlUpdateMainOrderStatusService.updateStatus(new MLUpdateOrderStatusCommonVO(mlUpdateOrderMainStatusVO));
    }

    public PageResult<MLQueryDrugStoreListDTO> queryDrugStoreList(PageRequest<MLQueryDrugStoreVO> mlQueryDrugStoreVO) {
        PageHelper.startPage((int)mlQueryDrugStoreVO.getPageNum(), (int)mlQueryDrugStoreVO.getPageSize());
        Page page = this.mosDrugStoreMapper.selectDrugStoreListByQO((MLQueryDrugStoreVO)mlQueryDrugStoreVO.getQuery());
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Long.valueOf(page.getTotal()).intValue());
        pageResult.setContent(page.getResult());
        log.info("pageResult:{}" + JSONObject.toJSONString((Object)pageResult));
        return MLQueryDrugStoreListDTO.toPage((PageResult)pageResult);
    }

    public PageResult<MLQueryDrugItemListDTO> queryDrugItemList(PageRequest<MLQueryDrugItemVO> mlQueryDrugItemVO) {
        PageHelper.startPage((int)mlQueryDrugItemVO.getPageNum(), (int)mlQueryDrugItemVO.getPageSize());
        Page page = this.mosDrugItemMapper.selectDrugItemListByQO((MLQueryDrugItemVO)mlQueryDrugItemVO.getQuery());
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Long.valueOf(page.getTotal()).intValue());
        pageResult.setContent(page.getResult());
        log.info("pageResult:{}" + JSONObject.toJSONString((Object)pageResult));
        return MLQueryDrugItemListDTO.toPage((PageResult)pageResult);
    }

    public Integer updateOrderPayStatus(MLPaySuccessRequestVO mlPaySuccessRequestVO) {
        log.info("\u7f8e\u96f6\u8c03\u7528\u6211\u65b9\u533b\u5631\u8ba2\u5355\u4fee\u6539\u63a5\u53e3  \u4e3b\u8981\u64cd\u4f5c\u6709 \u652f\u4ed8\u5b8c\u6210\u3001\u9000\u6b3e\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)mlPaySuccessRequestVO));
        if (Objects.isNull(mlPaySuccessRequestVO)) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u64cd\u4f5c\u7c7b\u578b");
        }
        IMLUpdateMainOrderStatusService imlUpdateMainOrderStatusService = this.getImlUpdateMainOrderStatusService(mlPaySuccessRequestVO.getOperationType(), ML_UPDATE_PAY_ORDER_STATUS_SUFFIX);
        return imlUpdateMainOrderStatusService.updateStatus(new MLUpdateOrderStatusCommonVO(mlPaySuccessRequestVO));
    }

    public MLQueryMainDetailDTO queryMainDetail(MLQueryMainDetailVO mlQueryMainDetailVO) {
        if (Objects.isNull(mlQueryMainDetailVO) || StringUtils.isEmpty((CharSequence)mlQueryMainDetailVO.getMainId())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u5904\u65b9id");
        }
        PrescriptionDetailReqVO prescriptionDetailReqVO = new PrescriptionDetailReqVO();
        BeanUtils.copyProperties((Object)mlQueryMainDetailVO, (Object)prescriptionDetailReqVO);
        BaseResponse respVo = this.circulationService.getPresDetail(prescriptionDetailReqVO);
        MLQueryMainDetailDTO mlQueryMainDetailDTO = new MLQueryMainDetailDTO();
        BeanUtils.copyProperties((Object)respVo.getData(), (Object)mlQueryMainDetailDTO);
        mlQueryMainDetailDTO.setIsWriteOff(Integer.valueOf(mlQueryMainDetailDTO.getItemStatus() > DrugMainStatusEnum.TO_TAKE.getValue() ? 1 : 0));
        return mlQueryMainDetailDTO;
    }

    public List<MainExcelInfoDTO> getPrescribingInformation(DownloadMainExcelReqVO downloadMainExcelReqVO) {
        if (Objects.isNull(downloadMainExcelReqVO) || CollectionUtils.isEmpty((Collection)downloadMainExcelReqVO.getMainIds())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5904\u65b9");
        }
        List dataList = this.mosDrugMainMapper.queryByMainIds(downloadMainExcelReqVO.getMainIds());
        return this.getMainInfoData(dataList);
    }

    private List<MainExcelInfoDTO> getMainInfoData(List<DownloadMainExcelDataDTO> dataList) {
        ArrayList<MainExcelInfoDTO> mainInfoList = new ArrayList<MainExcelInfoDTO>();
        List recipeNos = dataList.stream().map(DownloadMainExcelDataDTO::getRecipeNo).distinct().collect(Collectors.toList());
        for (String recipeNo : recipeNos) {
            MainExcelInfoDTO mainInfo = new MainExcelInfoDTO();
            ArrayList<DrugDetailExcelInfoDTO> drugDetailInfoList = new ArrayList<DrugDetailExcelInfoDTO>();
            for (DownloadMainExcelDataDTO downloadMainExcelDataDTO : dataList) {
                boolean flag = false;
                if (!recipeNo.equals(downloadMainExcelDataDTO.getRecipeNo())) continue;
                DrugDetailExcelInfoDTO drugDetailInfo = new DrugDetailExcelInfoDTO();
                BeanUtils.copyProperties((Object)downloadMainExcelDataDTO, (Object)drugDetailInfo);
                drugDetailInfo.setDosage(DOSAGE_PREFIX + BigDecimalUtil.getNoZeros((BigDecimal)downloadMainExcelDataDTO.getSingleDose()) + downloadMainExcelDataDTO.getMeasureUnit() + "," + downloadMainExcelDataDTO.getUsageDesc() + "," + downloadMainExcelDataDTO.getFrequencyDesc());
                if (!flag) {
                    BeanUtils.copyProperties((Object)downloadMainExcelDataDTO, (Object)mainInfo);
                    StatusUtil.customState((MainExcelInfoDTO)mainInfo);
                    flag = true;
                }
                drugDetailInfoList.add(drugDetailInfo);
            }
            mainInfo.setDrugDetailExcelInfoDTOList(drugDetailInfoList);
            mainInfoList.add(mainInfo);
        }
        return mainInfoList;
    }

    private IMLUpdateMainOrderStatusService getImlUpdateMainOrderStatusService(Integer operationType, String suffixString) {
        if (Objects.isNull(operationType)) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u64cd\u4f5c\u7c7b\u578b");
        }
        MLDrugMainOptionEnum optionEnum = MLDrugMainOptionEnum.getOptionEnum((Integer)operationType);
        if (Objects.isNull(optionEnum)) {
            throw new BusinessException("\u4f20\u5165\u64cd\u4f5c\u7c7b\u578b\u6709\u8bef");
        }
        IMLUpdateMainOrderStatusService imlUpdateMainOrderStatusService = PresRoamProcessStrategyFactory.getMLUpdateOrderStatusProcessStrategy((String)(optionEnum.getValue() + suffixString));
        if (Objects.isNull(imlUpdateMainOrderStatusService)) {
            throw new BusinessException("\u4f20\u5165\u64cd\u4f5c\u7c7b\u578b\u6709\u8bef");
        }
        return imlUpdateMainOrderStatusService;
    }
}

