/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.service.IMLUpdateMainOrderStatusService;
import com.ebaiyihui.circulation.service.MosDrugPrescriptionService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.vo.ConfirmMedicineReqVO;
import com.ebaiyihui.ml.pojo.vo.MLUpdateOrderStatusCommonVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="mLUpdateMainSuccessServiceImpl")
@PresRoamProcessCode(value="700_ML_UPDATE_MAIN_ORDER")
public class MLUpdateMainSuccessServiceImpl
implements IMLUpdateMainOrderStatusService {
    private static final Logger log = LoggerFactory.getLogger(MLUpdateMainSuccessServiceImpl.class);
    @Autowired
    private MosDrugPrescriptionService mosDrugPrescriptionService;

    @Transactional(rollbackFor={Exception.class})
    public Integer updateStatus(MLUpdateOrderStatusCommonVO mlUpdateOrderMainStatusVO) {
        log.info("\u7f8e\u96f6\u5f00\u59cb\u8c03\u7528\u53d6\u836f\u63a5\u53e3");
        if (StringUtils.isEmpty((CharSequence)mlUpdateOrderMainStatusVO.getMlUpdateOrderMainStatusVO().getFetchMedicalCode())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u53d6\u836f\u7801");
        }
        ConfirmMedicineReqVO confirmMedicineReqVO = new ConfirmMedicineReqVO();
        BeanUtils.copyProperties((Object)mlUpdateOrderMainStatusVO.getMlUpdateOrderMainStatusVO(), (Object)confirmMedicineReqVO);
        BaseResponse response = this.mosDrugPrescriptionService.confirmMedicine(confirmMedicineReqVO);
        if (response.isSuccess()) {
            return 1;
        }
        throw new BusinessException(response.getCode(), response.getMsg());
    }
}

