/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.OrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.OrderTypeEnum;
import com.ebaiyihui.circulation.common.enums.PayBillOrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.PayStatusEnum;
import com.ebaiyihui.circulation.common.enums.RemarkTypeEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.circulation.pojo.entity.ServicePayBillEntity;
import com.ebaiyihui.circulation.service.IMLUpdateMainOrderStatusService;
import com.ebaiyihui.circulation.service.MosDrugMainService;
import com.ebaiyihui.circulation.service.MosDrugOrderService;
import com.ebaiyihui.circulation.service.MosDrugRemarkService;
import com.ebaiyihui.circulation.service.ServicePayBillService;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import com.ebaiyihui.circulation.utils.HanyuPinyinUtil;
import com.ebaiyihui.ml.pojo.vo.MLPaySuccessRequestVO;
import com.ebaiyihui.ml.pojo.vo.MLUpdateOrderStatusCommonVO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="mLUpdateOrderPaySuccessServiceImpl")
@PresRoamProcessCode(value="1_ML_UPDATE_PAY_ORDER_STATUS_SUFFIX")
public class MLUpdateOrderPaySuccessServiceImpl
implements IMLUpdateMainOrderStatusService {
    private static final Logger log = LoggerFactory.getLogger(MLUpdateOrderPaySuccessServiceImpl.class);
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private MosDrugOrderService mosDrugOrderService;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugMainService mosDrugMainService;
    @Autowired
    private ServicePayBillService servicePayBillService;
    @Autowired
    private MosDrugRemarkService mosDrugRemarkService;

    @Transactional(rollbackFor={Exception.class})
    public Integer updateStatus(MLUpdateOrderStatusCommonVO mlUpdateOrderMainStatusVO) {
        log.info("\u7f8e\u96f6\u8c03\u7528\u4e86\u6211\u65b9 \u652f\u4ed8 \u5b8c\u6210\u4fee\u6539\u72b6\u6001\u63a5\u53e3");
        MLPaySuccessRequestVO mlPaySuccessRequestVO = mlUpdateOrderMainStatusVO.getMlPaySuccessRequestVO();
        if (StringUtils.isEmpty((String)mlPaySuccessRequestVO.getPayAmount()) || StringUtils.isEmpty((String)mlPaySuccessRequestVO.getOrderAmount())) {
            throw new BusinessException("\u652f\u4ed8\u3001\u8ba2\u5355\u91d1\u989d\u4e3a\u7a7a");
        }
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.queryById(mlPaySuccessRequestVO.getOrderId());
        if (Objects.isNull(drugOrderEntity)) {
            throw new BusinessException("\u8be5\u8ba2\u5355ID\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355");
        }
        DrugOrderEntity drugOrderEntityNew = new DrugOrderEntity();
        drugOrderEntityNew.setxId(drugOrderEntity.getxId());
        drugOrderEntityNew.setStatus(OrderStatusEnum.PAID.getValue());
        drugOrderEntityNew.setPayTime(DateUtils.getDateByTimeStampSecond((Long)mlPaySuccessRequestVO.getPayTime()));
        drugOrderEntityNew.setDealSeq(mlPaySuccessRequestVO.getThreeOrderId());
        drugOrderEntityNew.setBankTradeNo("");
        drugOrderEntityNew.setMchId("");
        drugOrderEntityNew.setPayAmount(MLUpdateOrderPaySuccessServiceImpl.getAmount((String)mlPaySuccessRequestVO.getPayAmount()));
        drugOrderEntityNew.setBankAmount(MLUpdateOrderPaySuccessServiceImpl.getAmount((String)mlPaySuccessRequestVO.getBankAmount()));
        drugOrderEntityNew.setRmbAmount(MLUpdateOrderPaySuccessServiceImpl.getAmount((String)mlPaySuccessRequestVO.getRmbAmount()));
        drugOrderEntityNew.setWxAmount(MLUpdateOrderPaySuccessServiceImpl.getAmount((String)mlPaySuccessRequestVO.getWxAmount()));
        drugOrderEntityNew.setZfbAmount(MLUpdateOrderPaySuccessServiceImpl.getAmount((String)mlPaySuccessRequestVO.getZfbAmount()));
        drugOrderEntityNew.setMeberAmount(MLUpdateOrderPaySuccessServiceImpl.getAmount((String)mlPaySuccessRequestVO.getMemberAmount()));
        drugOrderEntityNew.setCouponAmount(MLUpdateOrderPaySuccessServiceImpl.getAmount((String)mlPaySuccessRequestVO.getCouponAmount()));
        drugOrderEntityNew.setFundAmount(MLUpdateOrderPaySuccessServiceImpl.getAmount((String)mlPaySuccessRequestVO.getMedicalCardAmount()));
        drugOrderEntityNew.setSelfAmount(drugOrderEntityNew.getBankAmount().add(drugOrderEntityNew.getRmbAmount()).add(drugOrderEntityNew.getWxAmount()).add(drugOrderEntityNew.getZfbAmount()));
        this.mosDrugOrderService.update(drugOrderEntityNew);
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.selectByPrimaryKey(drugOrderEntity.getMainId());
        drugMainEntity.setOrderType(OrderTypeEnum.DRUG_ORDER.getValue());
        drugMainEntity.setItemStatus(DrugMainStatusEnum.TO_TAKE.getValue());
        this.mosDrugMainService.update(drugMainEntity);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setAppCode(drugMainEntity.getPresOrgan());
        servicePayBillEntity.setApplyCode("");
        servicePayBillEntity.setDealAmount(drugOrderEntityNew.getPayAmount());
        servicePayBillEntity.setDealTradeNo(mlPaySuccessRequestVO.getThreeOrderId());
        servicePayBillEntity.setGoodsInfo("\u7f8e\u96f6\u652f\u4ed8-\u4e92\u8054\u7f51\u533b\u9662-\u836f\u54c1\u8d39-\u670d\u52a1\u8d39");
        servicePayBillEntity.setOrderAmount(MLUpdateOrderPaySuccessServiceImpl.getAmount((String)mlPaySuccessRequestVO.getOrderAmount()));
        servicePayBillEntity.setOrganId(drugMainEntity.getOrganId());
        servicePayBillEntity.setOutTradeNo(drugOrderEntity.getOrderSeq());
        servicePayBillEntity.setPayChannel("ML_MANAGE_PAY_CHANNEL");
        String firstLettersUp = HanyuPinyinUtil.getFirstLettersUp((String)drugMainEntity.getPresOrganName());
        log.info("\u533b\u9662\u9996\u5b57\u6bcd\u5927\u5199:{}", (Object)firstLettersUp);
        servicePayBillEntity.setServiceCode(drugMainEntity.getPresOrgan() + "_" + firstLettersUp + "_" + "yyy");
        servicePayBillEntity.setOrganName(drugMainEntity.getHospitalNameFirstLetter());
        servicePayBillEntity.setTradeStatus(PayStatusEnum.SUCCESS.getValue());
        servicePayBillEntity.setStatus(PayBillOrderStatusEnum.PAID.getValue());
        servicePayBillEntity.setTradeNo("");
        servicePayBillEntity.setTradeTime(DateUtils.getDateByTimeStampSecond((Long)mlPaySuccessRequestVO.getPayTime()));
        servicePayBillEntity.setWorkServiceCode("yyy");
        log.info("\u836f\u54c1\u652f\u4ed8\u56de\u8c03\u4fdd\u5b58\u8d26\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.save(servicePayBillEntity);
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
        drugRemarkEntity.setxUpdateTime(new Date());
        drugRemarkEntity.setRemarkContent("\u7f8e\u96f6\u8c03\u7528\u4f70\u533b\u652f\u4ed8\u63a5\u53e3");
        drugRemarkEntity.setMainId(drugMainEntity.getxId());
        drugRemarkEntity.setRemarkType(RemarkTypeEnum.PAY_SUCCESS.getValue());
        drugRemarkEntity.setRemarkUser("ADMIN");
        drugRemarkEntity.setxCreateTime(new Date());
        this.mosDrugRemarkService.insert(drugRemarkEntity);
        return 1;
    }

    public static BigDecimal getAmount(String amount) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(StringUtils.isEmpty((String)amount) ? "0" : amount);
        }
        catch (Exception e) {
            throw new BusinessException("\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
        }
        return bigDecimal;
    }
}

