/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.OrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.PayBillOrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.PayStatusEnum;
import com.ebaiyihui.circulation.common.enums.RemarkTypeEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.circulation.pojo.entity.ServicePayBillEntity;
import com.ebaiyihui.circulation.service.IMLUpdateMainOrderStatusService;
import com.ebaiyihui.circulation.service.MosDrugMainService;
import com.ebaiyihui.circulation.service.MosDrugOrderService;
import com.ebaiyihui.circulation.service.MosDrugRemarkService;
import com.ebaiyihui.circulation.service.ServicePayBillService;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import com.ebaiyihui.ml.pojo.vo.MLPaySuccessRequestVO;
import com.ebaiyihui.ml.pojo.vo.MLUpdateOrderStatusCommonVO;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="mLUpdateOrderRefundSuccessServiceImpl")
@PresRoamProcessCode(value="2_ML_UPDATE_PAY_ORDER_STATUS_SUFFIX")
public class MLUpdateOrderRefundSuccessServiceImpl
implements IMLUpdateMainOrderStatusService {
    private static final Logger log = LoggerFactory.getLogger(MLUpdateOrderRefundSuccessServiceImpl.class);
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private MosDrugOrderService mosDrugOrderService;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugRemarkService mosDrugRemarkService;
    @Autowired
    private MosDrugMainService mosDrugMainService;
    @Autowired
    private ServicePayBillService servicePayBillService;

    @Transactional(rollbackFor={Exception.class})
    public Integer updateStatus(MLUpdateOrderStatusCommonVO mlUpdateOrderMainStatusVO) {
        log.info("\u7f8e\u96f6\u8c03\u7528\u4e86\u6211\u65b9 \u9000\u6b3e \u5b8c\u6210\u4fee\u6539\u72b6\u6001\u63a5\u53e3");
        MLPaySuccessRequestVO mlPaySuccessRequestVO = mlUpdateOrderMainStatusVO.getMlPaySuccessRequestVO();
        if (Objects.isNull(mlPaySuccessRequestVO.getRefundTime())) {
            throw new BusinessException("\u9000\u6b3e\u65f6\u95f4\u4e3a\u7a7a");
        }
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.queryById(mlPaySuccessRequestVO.getOrderId());
        if (Objects.isNull(drugOrderEntity)) {
            throw new BusinessException("\u8be5\u8ba2\u5355ID\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355");
        }
        DrugOrderEntity drugOrderEntityNew = new DrugOrderEntity();
        drugOrderEntityNew.setxId(drugOrderEntity.getxId());
        drugOrderEntityNew.setStatus(OrderStatusEnum.REFUNDED.getValue());
        drugOrderEntityNew.setRefundTime(DateUtils.getDateByTimeStampSecond((Long)mlPaySuccessRequestVO.getRefundTime()));
        this.mosDrugOrderService.update(drugOrderEntityNew);
        DrugMainEntity drugMainEntity = this.mosDrugMainService.queryById(drugOrderEntity.getMainId());
        drugMainEntity.setRefundStatus(OrderStatusEnum.REFUNDED.getValue());
        drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOY_BACK.getValue());
        this.mosDrugMainService.update(drugMainEntity);
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(drugOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.PAID.getValue());
        servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDED.getValue());
        servicePayBillEntity.setTradeStatus(PayStatusEnum.SUCCESS.getValue());
        servicePayBillEntity.setRefundTime(DateUtils.getDateByTimeStampSecond((Long)mlPaySuccessRequestVO.getRefundTime()));
        servicePayBillEntity.setRefundAmount(servicePayBillEntity.getDealAmount());
        log.info("\u836f\u54c1\u9000\u6b3e\u56de\u8c03\u63a5\u53e3\u66f4\u65b0\u8d26\u5355\u4fe1\u606f\u8ba2\u5355\u72b6\u6001:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.update(servicePayBillEntity);
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
        drugRemarkEntity.setxUpdateTime(new Date());
        drugRemarkEntity.setRemarkContent("\u7f8e\u96f6\u8c03\u7528\u4f70\u533b\u9000\u6b3e\u63a5\u53e3");
        drugRemarkEntity.setMainId(drugMainEntity.getxId());
        drugRemarkEntity.setRemarkType(RemarkTypeEnum.REFUND.getValue());
        drugRemarkEntity.setRemarkUser("ADMIN");
        drugRemarkEntity.setxCreateTime(new Date());
        this.mosDrugRemarkService.insert(drugRemarkEntity);
        return 1;
    }
}

