/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.service.IMLUpdateMainOrderStatusService;
import com.ebaiyihui.circulation.service.MosDrugPrescriptionService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.vo.ConfireResVO;
import com.ebaiyihui.ml.pojo.vo.MLUpdateOrderStatusCommonVO;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="mLUpdateSendDrugServiceImpl")
@PresRoamProcessCode(value="503_ML_UPDATE_MAIN_ORDER")
public class MLUpdateSendDrugServiceImpl
implements IMLUpdateMainOrderStatusService {
    private static final Logger log = LoggerFactory.getLogger(MLUpdateSendDrugServiceImpl.class);
    @Autowired
    private MosDrugPrescriptionService mosDrugPrescriptionService;

    @Transactional(rollbackFor={Exception.class})
    public Integer updateStatus(MLUpdateOrderStatusCommonVO mlUpdateOrderMainStatusVO) {
        log.info("\u7f8e\u96f6\u5f00\u59cb\u8c03\u7528\u53d1\u8d27\u63a5\u53e3");
        if (Objects.isNull(mlUpdateOrderMainStatusVO.getMlUpdateOrderMainStatusVO().getSendType())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u53d1\u8d27\u7c7b\u578b");
        }
        if (Integer.valueOf(1).equals(mlUpdateOrderMainStatusVO.getMlUpdateOrderMainStatusVO().getSendType()) && (StringUtils.isEmpty((CharSequence)mlUpdateOrderMainStatusVO.getMlUpdateOrderMainStatusVO().getLogisticsName()) || StringUtils.isEmpty((CharSequence)mlUpdateOrderMainStatusVO.getMlUpdateOrderMainStatusVO().getMainNo()))) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u5feb\u9012\u516c\u53f8\u548c\u8ba2\u5355\u53f7");
        }
        if (Integer.valueOf(2).equals(mlUpdateOrderMainStatusVO.getMlUpdateOrderMainStatusVO().getSendType()) && (StringUtils.isEmpty((CharSequence)mlUpdateOrderMainStatusVO.getMlUpdateOrderMainStatusVO().getDistributor()) || StringUtils.isEmpty((CharSequence)mlUpdateOrderMainStatusVO.getMlUpdateOrderMainStatusVO().getDistributorPhone()))) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u914d\u9001\u5458\u4e0e\u914d\u9001\u7535\u8bdd");
        }
        ConfireResVO confireResVO = new ConfireResVO();
        BeanUtils.copyProperties((Object)mlUpdateOrderMainStatusVO.getMlUpdateOrderMainStatusVO(), (Object)confireResVO);
        confireResVO.setSender(mlUpdateOrderMainStatusVO.getMlUpdateOrderMainStatusVO().getOperationUser());
        confireResVO.setSendRemark(mlUpdateOrderMainStatusVO.getMlUpdateOrderMainStatusVO().getRemarkContent());
        BaseResponse response = this.mosDrugPrescriptionService.confirmDelivery(confireResVO);
        if (response.isSuccess()) {
            return 1;
        }
        throw new BusinessException(response.getCode(), response.getMsg());
    }
}

