/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.MosDrugItemClassificationMapper;
import com.ebaiyihui.circulation.mapper.MosDrugItemClassificationRegMapper;
import com.ebaiyihui.circulation.pojo.dto.DrugMosDrugItemClassificationDTO;
import com.ebaiyihui.circulation.pojo.entity.MosDrugItemClassificationEntity;
import com.ebaiyihui.circulation.pojo.entity.MosDrugItemClassificationRegEntity;
import com.ebaiyihui.circulation.pojo.vo.item.DrugMosDrugItemClassificationSaveVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugMosDrugItemClassificationVO;
import com.ebaiyihui.circulation.service.MosDrugItemClassificationService;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class MosDrugItemClassificationServiceImpl
implements MosDrugItemClassificationService {
    private static final Logger log = LoggerFactory.getLogger(MosDrugItemClassificationServiceImpl.class);
    public static final int STATUS = 1;
    public static final int DELSTATUS = 0;
    @Resource
    private MosDrugItemClassificationMapper mosDrugItemClassificationMapper;
    @Resource
    private MosDrugItemClassificationRegMapper mosDrugItemClassificationRegMapper;

    public int deleteByPrimaryKey(String id) {
        return this.mosDrugItemClassificationMapper.deleteByPrimaryKey(id);
    }

    public int insert(MosDrugItemClassificationEntity record) {
        return this.mosDrugItemClassificationMapper.insert(record);
    }

    public int insertSelective(MosDrugItemClassificationEntity record) {
        return this.mosDrugItemClassificationMapper.insertSelective(record);
    }

    public int updateByPrimaryKeySelective(MosDrugItemClassificationEntity record) {
        return this.mosDrugItemClassificationMapper.updateByPrimaryKeySelective(record);
    }

    public int updateByPrimaryKey(MosDrugItemClassificationEntity record) {
        return this.mosDrugItemClassificationMapper.updateByPrimaryKey(record);
    }

    public List<DrugMosDrugItemClassificationDTO> queryClassification(DrugMosDrugItemClassificationVO drugMosDrugItemClassification) {
        if (ObjectUtils.isEmpty((Object)drugMosDrugItemClassification) || StringUtils.isEmpty((CharSequence)drugMosDrugItemClassification.getClassificationType())) {
            throw new BusinessException("\u67e5\u8be2\u5206\u7c7b\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.mosDrugItemClassificationMapper.queryClassification(drugMosDrugItemClassification);
    }

    public DrugMosDrugItemClassificationDTO queryClassificationDatile(DrugMosDrugItemClassificationVO drugMosDrugItemClassification) {
        if (ObjectUtils.isEmpty((Object)drugMosDrugItemClassification) || StringUtils.isEmpty((CharSequence)drugMosDrugItemClassification.getClassificationCode())) {
            throw new BusinessException("\u67e5\u8be2\u5206\u7c7b\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.mosDrugItemClassificationMapper.queryClassificationDatile(drugMosDrugItemClassification);
    }

    public PageInfo<DrugMosDrugItemClassificationDTO> queryClassificationList(DrugMosDrugItemClassificationVO drugMosDrugItemClassification) {
        if (ObjectUtils.isEmpty((Object)drugMosDrugItemClassification) || StringUtils.isEmpty((CharSequence)drugMosDrugItemClassification.getClassificationType()) || null == drugMosDrugItemClassification.getPageIndex() || null == drugMosDrugItemClassification.getPageSize()) {
            throw new BusinessException("\u67e5\u8be2\u5206\u7c7b\u53c2\u6570\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)drugMosDrugItemClassification.getPageIndex(), (int)drugMosDrugItemClassification.getPageSize());
        List drugMosDrugItem = this.mosDrugItemClassificationMapper.queryClassification(drugMosDrugItemClassification);
        return new PageInfo(drugMosDrugItem);
    }

    public int saveClassification(DrugMosDrugItemClassificationSaveVO drugMosDrugItemClassificationSaveVO) {
        if (ObjectUtils.isEmpty((Object)drugMosDrugItemClassificationSaveVO)) {
            throw new BusinessException("\u5206\u7c7b\u53c2\u6570\u4e3a\u7a7a");
        }
        MosDrugItemClassificationEntity record = new MosDrugItemClassificationEntity();
        BeanUtils.copyProperties((Object)drugMosDrugItemClassificationSaveVO, (Object)record);
        MosDrugItemClassificationEntity recordqo = new MosDrugItemClassificationEntity();
        recordqo.setClassificationName(record.getClassificationName());
        List mosDrugItemClassificationEntities = this.mosDrugItemClassificationMapper.selectByPrimaryKey(recordqo);
        if (!CollectionUtils.isEmpty((Collection)mosDrugItemClassificationEntities)) {
            throw new BusinessException("\u836f\u54c1\u5206\u7c7b\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)record.getClassificationCode())) {
            String uuid = UUIDUtils.getUUID();
            record.setId(uuid);
            record.setClassificationCode(uuid);
            record.setStatus(Integer.valueOf(1));
            record.setCreateTime(new Date());
            record.setUpdateTime(new Date());
            return this.mosDrugItemClassificationMapper.insertSelective(record);
        }
        MosDrugItemClassificationEntity recordquer = new MosDrugItemClassificationEntity();
        recordquer.setClassificationCode(drugMosDrugItemClassificationSaveVO.getClassificationCode());
        MosDrugItemClassificationEntity mosDrugItemClassification = this.mosDrugItemClassificationMapper.selectByPrimary(recordquer);
        if (ObjectUtils.isEmpty((Object)mosDrugItemClassification)) {
            throw new BusinessException("\u836f\u54c1\u4e0d\u5b58\u5728\uff01");
        }
        mosDrugItemClassification.setClassificationName(record.getClassificationName());
        if (record.getSort() != null) {
            mosDrugItemClassification.setSort(record.getSort());
        }
        if (!StringUtils.isEmpty((CharSequence)record.getLogoUrl())) {
            mosDrugItemClassification.setLogoUrl(record.getLogoUrl());
        }
        mosDrugItemClassification.setUpdateTime(new Date());
        return this.mosDrugItemClassificationMapper.updateByPrimaryKeySelective(mosDrugItemClassification);
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteClassification(DrugMosDrugItemClassificationSaveVO record) {
        log.info("\u8c03\u7528\u5220\u9664\u5206\u7c7b:{}", (Object)record);
        if (ObjectUtils.isEmpty((Object)record) || StringUtils.isEmpty((CharSequence)record.getClassificationCode())) {
            throw new BusinessException("\u53c2\u6570\u4e3a\u7a7a");
        }
        MosDrugItemClassificationEntity recordqo = new MosDrugItemClassificationEntity();
        recordqo.setClassificationCode(record.getClassificationCode());
        MosDrugItemClassificationEntity mosDrugItemClassification = this.mosDrugItemClassificationMapper.selectByPrimary(recordqo);
        if (ObjectUtils.isEmpty((Object)mosDrugItemClassification)) {
            throw new BusinessException("\u836f\u54c1\u4e0d\u5b58\u5728\uff01");
        }
        if (mosDrugItemClassification.getHomeDisplay() == 1) {
            throw new BusinessException("\u5206\u7c7b\u5df2\u5728\u9996\u9875\u5c55\u793a\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        mosDrugItemClassification.setStatus(Integer.valueOf(0));
        this.mosDrugItemClassificationMapper.updateByPrimaryKeySelective(mosDrugItemClassification);
        MosDrugItemClassificationRegEntity recordreg = new MosDrugItemClassificationRegEntity();
        recordreg.setClassificationCode(record.getClassificationCode());
        int i = this.mosDrugItemClassificationRegMapper.updateByCode(recordreg);
        log.info("\u5220\u9664\u5206\u7c7b\u5173\u8054\u6570{}", (Object)i);
        return i;
    }
}

