/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.common.enums.DrugItemSpecialPolicyTypeEnum;
import com.ebaiyihui.circulation.common.qo.DrugItemQO;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.MosDrugDetailMapper;
import com.ebaiyihui.circulation.mapper.MosDrugItemClassificationMapper;
import com.ebaiyihui.circulation.mapper.MosDrugItemClassificationRegMapper;
import com.ebaiyihui.circulation.mapper.MosDrugItemMapper;
import com.ebaiyihui.circulation.mapper.MosDrugItemStoreRegMapper;
import com.ebaiyihui.circulation.mapper.MosDrugStoreMapper;
import com.ebaiyihui.circulation.mapper.MosDrugUnitMapper;
import com.ebaiyihui.circulation.mapper.MosDrugUsageMapper;
import com.ebaiyihui.circulation.mapper.PharmaceuticalCompanyMapper;
import com.ebaiyihui.circulation.pojo.bo.DrugItemBO;
import com.ebaiyihui.circulation.pojo.bo.MosDrugItemStoreRegEntityBO;
import com.ebaiyihui.circulation.pojo.dto.CommonCodeDTO;
import com.ebaiyihui.circulation.pojo.dto.DrugItemListDTO;
import com.ebaiyihui.circulation.pojo.dto.DrugItemResDTO;
import com.ebaiyihui.circulation.pojo.dto.DrugUnitEntityBO;
import com.ebaiyihui.circulation.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugItemEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugStoreEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugUnitEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugUsageEntity;
import com.ebaiyihui.circulation.pojo.entity.MosDrugItemClassificationRegEntity;
import com.ebaiyihui.circulation.pojo.entity.MosDrugItemStoreRegEntity;
import com.ebaiyihui.circulation.pojo.entity.PharmaceuticalCompanyEntity;
import com.ebaiyihui.circulation.pojo.vo.item.AddDrugItemVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugIteamListReqVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugIteamListResVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugIteamReqVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugItemResVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugItemStatusReqVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugUnitReqVO;
import com.ebaiyihui.circulation.pojo.vo.item.DrugUsageReqVO;
import com.ebaiyihui.circulation.pojo.vo.item.ShoppingDrugDetailVO;
import com.ebaiyihui.circulation.pojo.vo.item.ShoppingDrugItemVO;
import com.ebaiyihui.circulation.service.DrugDetailService;
import com.ebaiyihui.circulation.service.MosDrugItemService;
import com.ebaiyihui.circulation.service.MosDrugPrescriptionService;
import com.ebaiyihui.circulation.utils.HanyuPinyinUtil;
import com.ebaiyihui.circulation.utils.StringUtil;
import com.ebaiyihui.circulation.utils.drugutil.DrugHandling;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.medicalcloud.pojo.vo.drugItem.JYItemMedicalInsuranceVO;
import com.ebaiyihui.medicalcloud.pojo.vo.drugItem.PatientChooseDrugReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.drugItem.PatientChooseDrugResVo;
import com.ebaiyihui.medicalcloud.pojo.vo.drugItem.PatientSelectsDefaultMedicationVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.util.HtmlUtils;

@Service
public class MosDrugItemServiceImpl
implements MosDrugItemService {
    private static final Logger log = LoggerFactory.getLogger(MosDrugItemServiceImpl.class);
    public static final int MAX_CLASSIFICATION_SIZE = 8;
    public static final int MAX_PHONE_SIZE = 5;
    public static final String ALL_TYPE = "0";
    @Autowired
    private MosDrugUsageMapper mosDrugUsageMapper;
    @Autowired
    private MosDrugUnitMapper mosDrugUnitMapper;
    @Autowired
    private MosDrugItemMapper mosDrugItemMapper;
    @Autowired
    private MosDrugItemStoreRegMapper mosDrugItemStoreRegMapper;
    @Autowired
    private PharmaceuticalCompanyMapper pharmaceuticalCompanyMapper;
    @Autowired
    private MosDrugStoreMapper mosDrugStoreMapper;
    @Autowired
    private MosDrugDetailMapper mosDrugDetailMapper;
    @Autowired
    private DrugDetailService detailService;
    @Autowired
    private MosDrugPrescriptionService mosDrugPrescriptionService;
    @Resource
    private MosDrugItemClassificationRegMapper mosDrugItemClassificationRegMapper;
    @Resource
    private MosDrugItemClassificationMapper mosDrugItemClassificationMapper;
    public static final Integer INVALID_STATUS = 0;
    public static final Integer STATUS = 1;
    public static final Integer STOP_SELL_STATUS = 3;
    public static final int FOUR = 4;
    public static final int TWO = 2;
    public static final int ONE = 1;
    public static final int ZERO = 0;
    public static final int NUMBEROFDATA = 1;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> addDrugItem(AddDrugItemVO addDrugItemVO) {
        log.info("\u8c03\u7528\u4e86\u4fdd\u5b58\u836f\u54c1\u4fe1\u606f\u7684\u63a5\u53e3");
        if (Objects.isNull(addDrugItemVO)) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u836f\u54c1\u7684\u901a\u7528\u540d");
        }
        if (!ObjectUtils.isEmpty((Object)addDrugItemVO.getClassificationCode()) && addDrugItemVO.getClassificationCode().size() > 8) {
            throw new BusinessException("\u836f\u54c1\u5206\u7c7b\u6570\u8fc7\u591a");
        }
        if (addDrugItemVO.getDrugPictureList().size() > 5) {
            throw new BusinessException("\u836f\u54c1\u56fe\u7247\u6570\u8fc7\u591a");
        }
        if (!ObjectUtils.isEmpty((Object)addDrugItemVO.getDetailedDescription())) {
            addDrugItemVO.setDetailedDescription(HtmlUtils.htmlEscapeHex((String)addDrugItemVO.getDetailedDescription()));
        }
        DrugItemEntity drugItemEntity = new DrugItemEntity();
        BeanUtils.copyProperties((Object)addDrugItemVO, (Object)drugItemEntity);
        if (!ObjectUtils.isEmpty((Object)addDrugItemVO.getDrugPictureList())) {
            drugItemEntity.setDrugPicture(StringUtils.join((Object[])addDrugItemVO.getDrugPictureList().toArray(), (String)","));
        }
        int count = 0;
        CommonCodeDTO commonCode = this.mosDrugItemMapper.getCommonCode(addDrugItemVO.getCommonCode());
        if (StringUtils.isNotEmpty((String)addDrugItemVO.getDrugItemId())) {
            DrugItemEntity entity = this.mosDrugItemMapper.selectById(addDrugItemVO.getDrugItemId());
            if (null == entity) {
                throw new BusinessException("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
            }
            if (Objects.nonNull(commonCode) && !entity.getId().equals(commonCode.getDrugItemId())) {
                throw new BusinessException("\u836f\u54c1\u901a\u7528\u7f16\u53f7\u4e0d\u80fd\u91cd\u590d");
            }
            drugItemEntity.setSpecialPolicyType(Integer.valueOf(0));
            drugItemEntity.setUpdateTime(new Date());
            drugItemEntity.setId(addDrugItemVO.getDrugItemId());
            drugItemEntity.setStatus(STATUS);
            count = this.mosDrugItemMapper.updateById(drugItemEntity);
            if (!ObjectUtils.isEmpty((Object)addDrugItemVO.getClassificationCode())) {
                this.updateDrugClassification(addDrugItemVO.getClassificationCode(), drugItemEntity.getId());
            }
            log.info("\u4fee\u6539\u836f\u54c1\u4fe1\u606f\u6210\u529f\uff0c\u6761\u6570\u4e3a:{}", (Object)count);
            MosDrugItemStoreRegEntityBO storeRegEntityBO = new MosDrugItemStoreRegEntityBO();
            storeRegEntityBO.setTotalId(addDrugItemVO.getTotalId());
            storeRegEntityBO.setDrugId(addDrugItemVO.getDrugItemId());
            storeRegEntityBO.setIsPharmaceuticalCompany(addDrugItemVO.getTotalType());
            List itemStoreRegEntities = this.mosDrugItemStoreRegMapper.selectByCompanyId(storeRegEntityBO);
            if (CollectionUtils.isNotEmpty((Collection)itemStoreRegEntities)) {
                MosDrugItemStoreRegEntity storeRegEntity = (MosDrugItemStoreRegEntity)itemStoreRegEntities.get(0);
                MosDrugItemStoreRegEntity regEntity = new MosDrugItemStoreRegEntity();
                regEntity.setId(storeRegEntity.getId());
                regEntity.setUpdateTime(new Date());
                regEntity.setQty(addDrugItemVO.getQty());
                regEntity.setPrice(String.valueOf(addDrugItemVO.getPrice()));
                regEntity.setStatus(addDrugItemVO.getStatus());
                count = this.mosDrugItemStoreRegMapper.updateById(regEntity);
                log.info("\u66f4\u65b0\u836f\u623f\u8ddf\u836f\u54c1\u5173\u7cfb\u8868,\u6210\u529f\u6761\u6570:{}", (Object)count);
                return BaseResponse.success((Object)drugItemEntity.getId());
            }
        } else {
            if (null != commonCode && StringUtils.isNotEmpty((String)commonCode.getCommonCode())) {
                throw new BusinessException("\u836f\u54c1\u901a\u7528\u7f16\u53f7\u4e0d\u80fd\u91cd\u590d");
            }
            DrugStoreEntity drugStoreEntity = this.mosDrugStoreMapper.selectById(addDrugItemVO.getTotalId());
            if (Objects.isNull(drugStoreEntity)) {
                throw new BusinessException("\u5f53\u524d\u836f\u623f\u627e\u4e0d\u5230\u4e86");
            }
            drugItemEntity.setAppCode(drugStoreEntity.getAppCode());
            drugItemEntity.setId(UUIDUtils.getUUID());
            drugItemEntity.setCreateTime(new Date());
            drugItemEntity.setUpdateTime(new Date());
            drugItemEntity.setStatus(STATUS);
            count = this.mosDrugItemMapper.insert(drugItemEntity);
            if (!ObjectUtils.isEmpty((Object)addDrugItemVO.getClassificationCode())) {
                this.updateDrugClassification(addDrugItemVO.getClassificationCode(), drugItemEntity.getId());
            }
            log.info("\u65b0\u589e\u836f\u54c1\u4fe1\u606f\u6210\u529f\uff0c\u6761\u6570\u4e3a:{}", (Object)count);
        }
        MosDrugItemStoreRegEntity mosDrugItemStoreRegEntity = new MosDrugItemStoreRegEntity();
        mosDrugItemStoreRegEntity.setDrugId(drugItemEntity.getId());
        mosDrugItemStoreRegEntity.setStatus(addDrugItemVO.getStatus());
        mosDrugItemStoreRegEntity.setIsPharmaceuticalCompany(addDrugItemVO.getTotalType());
        mosDrugItemStoreRegEntity.setUpdateTime(new Date());
        mosDrugItemStoreRegEntity.setQty(addDrugItemVO.getQty());
        mosDrugItemStoreRegEntity.setCreateTime(new Date());
        mosDrugItemStoreRegEntity.setId(UUIDUtils.getUUID());
        mosDrugItemStoreRegEntity.setPrice(String.valueOf(addDrugItemVO.getPrice()));
        mosDrugItemStoreRegEntity.setTotalId(addDrugItemVO.getTotalId());
        mosDrugItemStoreRegEntity.setTotalName(addDrugItemVO.getTotalName());
        count = this.mosDrugItemStoreRegMapper.insert(mosDrugItemStoreRegEntity);
        log.info("\u65b0\u589e\u836f\u54c1\u4e0e\u836f\u623f\u5173\u7cfb,\u6210\u529f\u6761\u6570\u4e3a:{}", (Object)count);
        return BaseResponse.success((Object)drugItemEntity.getId());
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.SUPPORTS)
    public void updateDrugClassification(List<String> classificationCodelist, String drugId) {
        log.info("\u53d8\u66f4\u5206\u7c7b\u5173\u7cfbdrugId\uff1a{}", (Object)drugId);
        MosDrugItemClassificationRegEntity record = new MosDrugItemClassificationRegEntity();
        record.setDrugId(drugId);
        this.mosDrugItemClassificationRegMapper.updateByDrugId(record);
        ArrayList<MosDrugItemClassificationRegEntity> records = new ArrayList<MosDrugItemClassificationRegEntity>();
        for (String classificationCode : classificationCodelist) {
            MosDrugItemClassificationRegEntity mos = new MosDrugItemClassificationRegEntity();
            mos.setClassificationCode(classificationCode);
            mos.setDrugId(drugId);
            mos.setStatus(STATUS);
            mos.setId(UUIDUtils.getUUID());
            records.add(mos);
        }
        int i = this.mosDrugItemClassificationRegMapper.batchInsert(records);
        log.info("\u65b0\u589e\u836f\u54c1\u4e0e\u5206\u7c7b\u5173\u7cfb,\u6210\u529f\u6761\u6570\u4e3a:{}", (Object)i);
    }

    public BaseResponse<List<DrugUnitEntityBO>> findDrugUnitByType(DrugUnitReqVO drugUnitReqVO) {
        List listAlias = this.mosDrugUnitMapper.findDrugUnitByType(drugUnitReqVO.getType());
        if (listAlias.isEmpty()) {
            return BaseResponse.error((String)"\u5355\u4f4d\u4e3a\u7a7a");
        }
        ArrayList<DrugUnitEntityBO> list = new ArrayList<DrugUnitEntityBO>();
        for (DrugUnitEntity alias : listAlias) {
            DrugUnitEntityBO drugUnitEntityBO = new DrugUnitEntityBO();
            BeanUtils.copyProperties((Object)alias, (Object)drugUnitEntityBO);
            drugUnitEntityBO.setRemark(alias.getXRemark());
            drugUnitEntityBO.setId(alias.getXId());
            drugUnitEntityBO.setCreateTime(alias.getXCreateTime());
            drugUnitEntityBO.setUpdateTime(alias.getXUpdateTime());
            list.add(drugUnitEntityBO);
        }
        return BaseResponse.success(list);
    }

    public BaseResponse<List<DrugUsageEntity>> findDrugUsage(DrugUsageReqVO drugUsageReqVO) {
        log.info("\u67e5\u8be2\u836f\u54c1\u7684\u670d\u7528\u65b9\u5f0f,{}", (Object)drugUsageReqVO.getHospitalName());
        String hospitalNameFirstLetter = this.getHospitalNameFirstLetter(drugUsageReqVO.getHospitalName());
        List drugUsageEntityList = new ArrayList();
        drugUsageEntityList = this.mosDrugUsageMapper.findDrugUsageByHospitalNameFirstLetter(hospitalNameFirstLetter);
        if (CollectionUtils.isEmpty(drugUsageEntityList)) {
            drugUsageEntityList = this.mosDrugUsageMapper.findDrugUsageByHospitalNameFirstLetter(null);
        }
        log.info("\u67e5\u8be2\u836f\u54c1\u7684\u670d\u7528\u65b9\u5f0fdrugUsageEntityList:{}", (Object)JSON.toJSONString(drugUsageEntityList));
        if (drugUsageEntityList == null) {
            return BaseResponse.error((String)"\u6682\u65e0\u670d\u7528\u6a21\u5f0f");
        }
        return BaseResponse.success(drugUsageEntityList);
    }

    public BaseResponse<DrugItemResVO> selectDrugItem(DrugIteamReqVO drugIteamReqVO) {
        DrugItemResVO drugItemResVO = this.mosDrugItemMapper.selectByDrugId(drugIteamReqVO);
        if (!ObjectUtils.isEmpty((Object)drugItemResVO.getDrugPicture())) {
            drugItemResVO.setDrugPictureList(Arrays.asList(drugItemResVO.getDrugPicture().split(",")));
        }
        if (!ObjectUtils.isEmpty((Object)drugItemResVO.getDetailedDescription())) {
            drugItemResVO.setDetailedDescription(HtmlUtils.htmlUnescape((String)drugItemResVO.getDetailedDescription()));
        }
        List mosDrugItemClassificationEntities = this.mosDrugItemClassificationMapper.selectByDrugId(drugItemResVO.getId());
        drugItemResVO.setMosDrugItemClassificationList(mosDrugItemClassificationEntities);
        log.info("\u67e5\u8be2\u7684\u836f\u54c1\u8be6\u60c5\u4e3a:{}", (Object)JSON.toJSONString((Object)drugItemResVO));
        return BaseResponse.success((Object)drugItemResVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> deleteDrugItem(DrugIteamReqVO drugIteamReqVO) {
        DrugItemEntity drugItemEntity = new DrugItemEntity();
        int count = 0;
        drugItemEntity.setId(drugIteamReqVO.getDrugItemId());
        drugItemEntity.setStatus(STATUS);
        drugItemEntity.setUpdateTime(new Date());
        count = this.mosDrugItemMapper.updateById(drugItemEntity);
        log.info("\u5220\u9664\u836f\u54c1\u6210\u529f,\u6761\u6570:{}", (Object)count);
        MosDrugItemStoreRegEntity mosDrugItemStoreRegEntity = new MosDrugItemStoreRegEntity();
        mosDrugItemStoreRegEntity.setDrugId(drugIteamReqVO.getDrugItemId());
        mosDrugItemStoreRegEntity.setStatus(INVALID_STATUS);
        mosDrugItemStoreRegEntity.setUpdateTime(new Date());
        count = this.mosDrugItemStoreRegMapper.updateByDrugItemId(mosDrugItemStoreRegEntity);
        log.info("\u5220\u9664\u836f\u54c1\u836f\u5546\u5173\u7cfb\u6210\u529f,\u6761\u6570:{}", (Object)count);
        return BaseResponse.success((Object)"\u66f4\u65b0\u6210\u529f");
    }

    public BaseResponse<String> updateStatus(DrugItemStatusReqVO drugItemStatusReqVO) {
        if (3 == drugItemStatusReqVO.getStatus()) {
            String pharmaceuticalCompanyId = drugItemStatusReqVO.getPharmaceuticalCompanyId();
            DrugStoreEntity drugStoreEntity = this.mosDrugStoreMapper.queryById(pharmaceuticalCompanyId);
            if (Objects.isNull(drugStoreEntity)) {
                throw new BusinessException("\u5f53\u524d\u836f\u623f\u4e0d\u5b58\u5728");
            }
            if (1 == drugStoreEntity.getOnlineStatus()) {
                throw new BusinessException("\u836f\u623f\u5df2\u4e0a\u7ebf\uff0c\u4e0d\u5141\u8bb8\u4e0b\u67b6\u836f\u54c1");
            }
        }
        int count = this.mosDrugItemStoreRegMapper.updateStatus(drugItemStatusReqVO.getIds(), drugItemStatusReqVO.getStatus(), new Date());
        log.info("\u66f4\u65b0\u72b6\u6001\u6210\u529f,\u6761\u6570\u4e3a:{}", (Object)count);
        return BaseResponse.success((Object)"\u66f4\u65b0\u6210\u529f");
    }

    public BaseResponse<DrugIteamListResVO> drugItemList(PageRequest<DrugIteamListReqVO> drugItemListReqVO) {
        DrugIteamListReqVO vo;
        if (Objects.isNull(drugItemListReqVO) || Objects.isNull(drugItemListReqVO.getQuery()) || StringUtils.isEmpty((String)((DrugIteamListReqVO)drugItemListReqVO.getQuery()).getPharmaceuticalCompanyId())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u836f\u623f");
        }
        vo.setSourceType(Integer.valueOf(Objects.isNull((vo = (DrugIteamListReqVO)drugItemListReqVO.getQuery()).getSourceType()) ? 2 : vo.getSourceType()));
        PageHelper.startPage((int)drugItemListReqVO.getPageNum(), (int)drugItemListReqVO.getPageSize());
        PageResult pageResult = new PageResult();
        DrugIteamListResVO drugIteamListResVO = new DrugIteamListResVO();
        Page list = this.mosDrugItemMapper.selectDrugItemByParam(vo);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DrugItemListDTO drugItem;
            drugItem.setStatus(Integer.valueOf((drugItem = (DrugItemListDTO)iterator.next()).getStatus() == 3 ? 3 : (drugItem.getQty() == 0 ? 2 : drugItem.getStatus())));
        }
        if (list.size() > 0) {
            drugIteamListResVO = this.mosDrugItemMapper.selectDrugCount(new DrugItemQO(vo.getPharmaceuticalCompanyId()));
        } else {
            drugIteamListResVO.setCount(Integer.valueOf(0));
            drugIteamListResVO.setStopSellCount(Integer.valueOf(0));
            drugIteamListResVO.setZeroCount(Integer.valueOf(0));
        }
        pageResult.setTotal(Long.valueOf(list.getTotal()).intValue());
        pageResult.setContent(list.getResult());
        drugIteamListResVO.setList(pageResult);
        return BaseResponse.success((Object)drugIteamListResVO);
    }

    public Integer updateItemStoreCount(AddDrugItemVO addDrugItemVO) {
        if (Objects.isNull(addDrugItemVO) || StringUtils.isEmpty((String)addDrugItemVO.getDrugItemId()) || StringUtils.isEmpty((String)addDrugItemVO.getTotalId()) || Objects.isNull(addDrugItemVO.getTotalType())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u836f\u54c1\u6216\u8005\u836f\u623f");
        }
        if (Objects.isNull(addDrugItemVO.getQty()) || addDrugItemVO.getQty() <= 0) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u6709\u6548\u7684\u8865\u8d27\u6570\u91cf");
        }
        MosDrugItemStoreRegEntityBO regEntityBO = new MosDrugItemStoreRegEntityBO();
        regEntityBO.setTotalId(addDrugItemVO.getTotalId());
        regEntityBO.setDrugId(addDrugItemVO.getDrugItemId());
        regEntityBO.setIsPharmaceuticalCompany(addDrugItemVO.getTotalType());
        List itemStoreRegEntities = this.mosDrugItemStoreRegMapper.selectByCompanyId(regEntityBO);
        if (CollectionUtils.isNotEmpty((Collection)itemStoreRegEntities)) {
            MosDrugItemStoreRegEntity storeRegEntity = (MosDrugItemStoreRegEntity)itemStoreRegEntities.get(0);
            MosDrugItemStoreRegEntity regEntity = new MosDrugItemStoreRegEntity();
            regEntity.setId(storeRegEntity.getId());
            regEntity.setUpdateTime(new Date());
            regEntity.setQty(addDrugItemVO.getQty());
            int count = this.mosDrugItemStoreRegMapper.updateDrugStoreCount(regEntity);
            if (count <= 0) {
                throw new BusinessException("\u66f4\u65b0\u836f\u54c1\u5e93\u5b58\u5931\u8d25\uff01");
            }
            return 1;
        }
        throw new BusinessException("\u6ca1\u6709\u627e\u5230\u8be5\u836f\u623f\u6216\u836f\u5546\u4e0b\u7684\u836f\u54c1");
    }

    private String getHospitalNameFirstLetter(String hospitalNameFirstLetter) {
        String hospitalNameFirstLetter1 = null;
        if (StringUtils.isNotEmpty((String)hospitalNameFirstLetter)) {
            hospitalNameFirstLetter1 = HanyuPinyinUtil.getFirstLetters((String)hospitalNameFirstLetter, (HanyuPinyinCaseType)HanyuPinyinCaseType.UPPERCASE);
        }
        return hospitalNameFirstLetter1;
    }

    public BaseResponse<List<PatientChooseDrugResVo>> selectDrugByParams(PatientChooseDrugReqVo patientChooseDrugReqVo) {
        List drugItemEntityList;
        DrugDetailEntity drugDetailEntity;
        int index;
        String commonName = patientChooseDrugReqVo.getDrugCommonName();
        if (commonName.contains(patientChooseDrugReqVo.getDrugSpec()) && (index = commonName.indexOf(patientChooseDrugReqVo.getDrugSpec())) > 0) {
            commonName = commonName.substring(0, index - 1);
        }
        ArrayList hash = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(patientChooseDrugReqVo.getDrugCommonName());
        arrayList.add(commonName);
        List drugHandling = DrugHandling.getDrugHandling((String)patientChooseDrugReqVo.getDrugCommonName());
        arrayList.addAll(drugHandling);
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        detailMap.put("drugSpec", patientChooseDrugReqVo.getDrugSpec());
        detailMap.put("arrayList", arrayList);
        hash.add(detailMap);
        String code = null;
        if (StringUtils.isNotBlank((String)patientChooseDrugReqVo.getPresDetailId()) && Objects.nonNull(drugDetailEntity = this.mosDrugDetailMapper.getById(patientChooseDrugReqVo.getPresDetailId()))) {
            code = drugDetailEntity.getArcimCode();
        }
        if (CollectionUtils.isEmpty((Collection)(drugItemEntityList = this.mosDrugItemMapper.selectDrugByParamsandlistname(hash, patientChooseDrugReqVo.getPharmaceuticalCompanyId(), code)))) {
            return BaseResponse.success();
        }
        DrugStoreEntity drugStoreEntity = this.mosDrugStoreMapper.queryById(patientChooseDrugReqVo.getPharmaceuticalCompanyId());
        if (Objects.isNull(drugStoreEntity)) {
            throw new BusinessException("\u5f53\u524d\u836f\u623f\u4e0d\u5b58\u5728");
        }
        PharmaceuticalCompanyEntity pharmaceuticalCompany = this.pharmaceuticalCompanyMapper.selectPharmacistById(drugStoreEntity.getPharmaceuticalCompanyId());
        String pharmaceuticalCompanyName = StringUtil.isEmpty((String)pharmaceuticalCompany.getPharmaceuticalCompanyName()) ? "" : pharmaceuticalCompany.getPharmaceuticalCompanyName();
        List patientChooseDrugResVoList = drugItemEntityList.stream().map(drugItemEntity -> {
            PatientChooseDrugResVo patientChooseDrugResVo = new PatientChooseDrugResVo();
            patientChooseDrugResVo.setRegId(drugItemEntity.getRegId());
            patientChooseDrugResVo.setDrugId(drugItemEntity.getId());
            patientChooseDrugResVo.setCommonCode(drugItemEntity.getCommonCode());
            patientChooseDrugResVo.setCommonName(drugItemEntity.getCommonName());
            patientChooseDrugResVo.setDrugSpec(drugItemEntity.getDrugSpec());
            patientChooseDrugResVo.setManufacturer(drugItemEntity.getManufacturer());
            patientChooseDrugResVo.setWholePackingUnitName(drugItemEntity.getWholePackingUnitName());
            if (StringUtils.isEmpty((String)drugItemEntity.getPrice())) {
                throw new BusinessException("\u836f\u54c1\u4ef7\u683c\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            patientChooseDrugResVo.setDrugId(drugItemEntity.getId());
            patientChooseDrugResVo.setPrice(new BigDecimal(drugItemEntity.getPrice()));
            patientChooseDrugResVo.setMedicalCompany(pharmaceuticalCompanyName);
            patientChooseDrugResVo.setInjectionDrugFlag(Integer.valueOf(1).equals(drugItemEntity.getSpecialNewType()));
            return patientChooseDrugResVo;
        }).collect(Collectors.toList());
        return BaseResponse.success(patientChooseDrugResVoList);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<List<PatientChooseDrugResVo>> selectDefaultMedicine(PatientSelectsDefaultMedicationVo param) {
        log.info("=======>\u60a3\u8005\u7aef\u67e5\u627e\u9ed8\u8ba4\u836f\u54c1\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)param));
        ArrayList data = new ArrayList();
        List drugDetailList = this.mosDrugDetailMapper.getByMainId(param.getMainId());
        if (drugDetailList.size() == 0) {
            return new BaseResponse();
        }
        for (DrugDetailEntity drugDetailEntity : drugDetailList) {
            this.getDefaultMedicine(param, data, drugDetailEntity);
        }
        return BaseResponse.success(data);
    }

    public boolean isHaveMedicalInsurance(JYItemMedicalInsuranceVO jyItemMedicalInsuranceVO) {
        if (Objects.isNull(jyItemMedicalInsuranceVO) || CollectionUtils.isEmpty((Collection)jyItemMedicalInsuranceVO.getProductCodes())) {
            return false;
        }
        int count = this.mosDrugItemMapper.selectSpecialTypeCount(jyItemMedicalInsuranceVO.getAppCode(), DrugItemSpecialPolicyTypeEnum.MEDICAL_INSURANCE_DOUBLE_CHANNEL.getValue(), jyItemMedicalInsuranceVO.getProductCodes().stream().distinct().collect(Collectors.toList()));
        return (long)count >= jyItemMedicalInsuranceVO.getProductCodes().stream().distinct().count();
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public void getDefaultMedicine(PatientSelectsDefaultMedicationVo param, List<PatientChooseDrugResVo> data, DrugDetailEntity drugDetailEntity) {
        ArrayList arrayList = new ArrayList();
        ArrayList hash = new ArrayList();
        HashMap<String, Object> detailMap = new HashMap<String, Object>(3);
        this.getDrugName(drugDetailEntity, arrayList);
        detailMap.put("drugSpec", drugDetailEntity.getDrugSpec());
        detailMap.put("arrayList", arrayList);
        hash.add(detailMap);
        List drugItemEntityList = this.mosDrugItemMapper.selectDrugByParamsandlistnameManufacturer(hash, param.getPharmaceuticalCompanyId(), drugDetailEntity.getArcimCode());
        if (drugItemEntityList.size() == 1) {
            List patientChooseDrugResVoList = drugItemEntityList.stream().map(drugItemEntity -> {
                PatientChooseDrugResVo patientChooseDrugResVo = new PatientChooseDrugResVo();
                patientChooseDrugResVo.setCommonCode(drugItemEntity.getCommonCode());
                patientChooseDrugResVo.setCommonName(drugDetailEntity.getDrugName());
                patientChooseDrugResVo.setDrugSpec(drugItemEntity.getDrugSpec());
                patientChooseDrugResVo.setManufacturer(drugItemEntity.getManufacturer());
                patientChooseDrugResVo.setWholePackingUnitName(drugItemEntity.getWholePackingUnitName());
                if (StringUtils.isEmpty((String)drugItemEntity.getPrice())) {
                    throw new BusinessException("\u836f\u54c1\u4ef7\u683c\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                patientChooseDrugResVo.setDrugId(drugItemEntity.getId());
                patientChooseDrugResVo.setPrice(new BigDecimal(drugItemEntity.getPrice()));
                patientChooseDrugResVo.setMedicalCompany(drugItemEntity.getManufacturer());
                patientChooseDrugResVo.setInjectionDrugFlag(Integer.valueOf(1).equals(drugItemEntity.getSpecialNewType()));
                patientChooseDrugResVo.setSelected(true);
                return patientChooseDrugResVo;
            }).collect(Collectors.toList());
            data.add((PatientChooseDrugResVo)patientChooseDrugResVoList.get(0));
            this.updatePresPrice(drugDetailEntity.getxId(), (DrugItemBO)drugItemEntityList.get(0));
        }
        this.modifyPrescriptionPrice(drugDetailEntity);
    }

    private void getDrugName(DrugDetailEntity drugDetailEntity, List<String> arrayList) {
        int index;
        String commonName = drugDetailEntity.getDrugName();
        if (commonName.contains(drugDetailEntity.getDrugSpec()) && (index = commonName.indexOf(drugDetailEntity.getDrugSpec())) > 0) {
            commonName = commonName.substring(0, index - 1);
        }
        arrayList.add(drugDetailEntity.getDrugName());
        arrayList.add(commonName);
        List drugHandling = DrugHandling.getDrugHandling((String)drugDetailEntity.getDrugName());
        arrayList.addAll(drugHandling);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public void updatePresPrice(String presDetailId, DrugItemBO drugItemBO) {
        DrugDetailEntity drugDetailEntity = this.detailService.getById(presDetailId);
        BigDecimal price = new BigDecimal(drugItemBO.getPrice());
        if (Objects.nonNull(drugItemBO.getId())) {
            DrugItemEntity itemEntity = this.mosDrugItemMapper.selectById(drugItemBO.getId());
            drugDetailEntity.setDrugCommonCode(itemEntity.getCommonCode());
            drugDetailEntity.setManufacturer(itemEntity.getManufacturer());
        }
        drugDetailEntity.setUnitPrice(price);
        drugDetailEntity.setDrugId(drugItemBO.getId());
        drugDetailEntity.setTotalPrice(price.multiply(drugDetailEntity.getAmount()));
        drugDetailEntity.setAmountUnit(drugItemBO.getWholePackingUnitName());
        drugDetailEntity.setWholePackingUnit(drugItemBO.getWholePackingUnitName());
        this.detailService.updateById(drugDetailEntity);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public void modifyPrescriptionPrice(DrugDetailEntity drugDetailEntity) {
        List drugDetailEntityList = this.detailService.listByMainId(drugDetailEntity.getMainId());
        double totalCostDouble = drugDetailEntityList.stream().mapToDouble(drugPrescriptionEntity -> drugPrescriptionEntity.getTotalPrice().doubleValue()).sum();
        BigDecimal totalCost = BigDecimal.valueOf(totalCostDouble);
        DrugPrescriptionEntity drugPrescriptionEntity2 = this.mosDrugPrescriptionService.queryByMainId(drugDetailEntity.getMainId());
        drugPrescriptionEntity2.setStorePrice(totalCost.setScale(4, 4));
        drugPrescriptionEntity2.setPrice(totalCost.setScale(2, 4));
        this.mosDrugPrescriptionService.update(drugPrescriptionEntity2);
    }

    public BaseResponse<PageResult<DrugItemListDTO>> selectDrugByPharmacy(PageRequest<DrugIteamListReqVO> vo) {
        if (((DrugIteamListReqVO)vo.getQuery()).getSearchParams().isEmpty()) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u836f\u54c1\u540d\u79f0\u6216\u7f16\u7801\u641c\u7d22\u836f\u54c1");
        }
        ((DrugIteamListReqVO)vo.getQuery()).setSourceType(Integer.valueOf(2));
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        Page list = this.mosDrugItemMapper.selectDrugItemByParam((DrugIteamListReqVO)vo.getQuery());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DrugItemListDTO drugItem;
            drugItem.setStatus(Integer.valueOf((drugItem = (DrugItemListDTO)iterator.next()).getStatus() == 3 ? 3 : (drugItem.getQty() == 0 ? 2 : drugItem.getStatus())));
        }
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Long.valueOf(list.getTotal()).intValue());
        pageResult.setContent((List)list);
        pageResult.setPageSize(vo.getPageSize());
        pageResult.setPageNum(vo.getPageNum());
        pageResult.setTotalPages(list.getPages());
        return BaseResponse.success((Object)pageResult);
    }

    public PageInfo<DrugItemListDTO> shoppingDrugItemList(ShoppingDrugItemVO shoppingDrugItem) {
        log.info("\u67e5\u8be2\u5546\u57ce\u836f\u54c1\uff0c\u4f20\u53c2:{}", (Object)JSON.toJSONString((Object)shoppingDrugItem));
        if (ObjectUtils.isEmpty((Object)shoppingDrugItem)) {
            throw new BusinessException("\u53c2\u6570\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)shoppingDrugItem.getClassificationCode()) && ALL_TYPE.equals(shoppingDrugItem.getClassificationCode())) {
            shoppingDrugItem.setClassificationCode(null);
        }
        PageHelper.startPage((int)shoppingDrugItem.getPageNum(), (int)shoppingDrugItem.getPageSize());
        List list = this.mosDrugItemMapper.selectDrugItemByShopping(shoppingDrugItem);
        for (DrugItemListDTO item : list) {
            if (ObjectUtils.isEmpty((Object)item.getDrugPicture())) continue;
            item.setDrugPictureList(Arrays.asList(item.getDrugPicture().split(",")));
        }
        return new PageInfo(list);
    }

    public DrugItemResDTO shoppingSelectDrugItem(ShoppingDrugDetailVO shoppingDrugDetailVO) {
        log.info("\u67e5\u8be2\u836f\u54c1\u8be6\u60c5\u4f20\u53c2:{}", (Object)JSON.toJSONString((Object)shoppingDrugDetailVO));
        if (ObjectUtils.isEmpty((Object)shoppingDrugDetailVO) || StringUtils.isEmpty((String)shoppingDrugDetailVO.getDrugItemId()) || StringUtils.isEmpty((String)shoppingDrugDetailVO.getAppCode())) {
            throw new BusinessException("\u8be6\u60c5\u53c2\u6570\u7a7a");
        }
        DrugItemResDTO drugItemResDTO = this.mosDrugItemMapper.selectDrugItemByDrugId(shoppingDrugDetailVO);
        if (ObjectUtils.isEmpty((Object)drugItemResDTO)) {
            throw new BusinessException("\u836f\u54c1\u4e0d\u5b58\u5728");
        }
        if (!StringUtils.isEmpty((String)drugItemResDTO.getDrugPicture())) {
            drugItemResDTO.setDrugPictureList(Arrays.asList(drugItemResDTO.getDrugPicture().split(",")));
        }
        if (!StringUtils.isEmpty((String)drugItemResDTO.getDetailedDescription())) {
            drugItemResDTO.setDetailedDescription(HtmlUtils.htmlUnescape((String)drugItemResDTO.getDetailedDescription()));
        }
        return drugItemResDTO;
    }
}

