/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.circulation.abstracts.DynamicInvokePlatformServer;
import com.ebaiyihui.circulation.common.enums.AuditStatusEnum;
import com.ebaiyihui.circulation.common.enums.BaseStatusEnum;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.DynamicMethodTypeEnum;
import com.ebaiyihui.circulation.common.enums.MLDrugMainOptionEnum;
import com.ebaiyihui.circulation.common.enums.OrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.OrderTypeEnum;
import com.ebaiyihui.circulation.common.enums.RemarkTypeEnum;
import com.ebaiyihui.circulation.common.enums.ReturnCodeEnum;
import com.ebaiyihui.circulation.manage.DoctorRetmoteManage;
import com.ebaiyihui.circulation.manage.OrderPayManage;
import com.ebaiyihui.circulation.manage.PushManage;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugRemarkMapper;
import com.ebaiyihui.circulation.pojo.dto.load.ExpressExcelInfoDTO;
import com.ebaiyihui.circulation.pojo.entity.DrugExtendEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.circulation.pojo.vo.circulation.SendPagingListReqVO;
import com.ebaiyihui.circulation.service.DrugExtendService;
import com.ebaiyihui.circulation.service.IMLPushMainService;
import com.ebaiyihui.circulation.service.MosDrugMainService;
import com.ebaiyihui.circulation.service.MosDrugOrderService;
import com.ebaiyihui.circulation.service.MosDrugRemarkService;
import com.ebaiyihui.circulation.service.PrescriptionPdfService;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import com.ebaiyihui.circulation.utils.StringUtil;
import com.ebaiyihui.circulation.utils.medicalcloud.PageUtil;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.dto.ComplateOrBackDtoReq;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugMainItemStatusDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.QueryPharmacistMainDto;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.ManageListResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.ManageListResultDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.ManageDescReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.ManageDescResVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.PatientSignFinished;
import com.ebaiyihui.ml.pojo.vo.MLUpdateSynchronizationMainStatusVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MosDrugMainServiceImpl
implements MosDrugMainService {
    private static final Logger log = LoggerFactory.getLogger(MosDrugMainServiceImpl.class);
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private DrugExtendService drugExtendService;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private IMLPushMainService imlPushMainService;
    @Autowired
    private MosDrugRemarkMapper mosDrugRemarkMapper;
    @Autowired
    private PrescriptionPdfService prescriptionPdfService;
    @Autowired
    private DynamicInvokePlatformServer dynamicInvokePlatformServer;
    @Autowired
    private MosDrugRemarkMapper remarkMapper;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private MosDrugRemarkService mosDrugRemarkService;
    @Autowired
    private MosDrugOrderService mosDrugOrderService;
    private static final String VALUE = "value";

    public DrugMainEntity queryById(String xId) {
        return this.mosDrugMainMapper.queryById(xId);
    }

    public DrugMainEntity insert(DrugMainEntity mosDrugMain) {
        this.mosDrugMainMapper.insert(mosDrugMain);
        return mosDrugMain;
    }

    public DrugMainEntity update(DrugMainEntity mosDrugMain) {
        this.mosDrugMainMapper.updateByPrimaryKeySelective(mosDrugMain);
        return this.queryById(mosDrugMain.getxId());
    }

    public List<ExpressExcelInfoDTO> queryExpressPage(Integer pageNum, Integer pageSize, SendPagingListReqVO sendPagingListReqVO) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return this.mosDrugMainMapper.queryExpressPage(sendPagingListReqVO);
    }

    public void saveDrugExtend(String mainId, String doctorName, String doctorCode, String doctorSign, String remark, Integer auditStatus) {
        if (StringUtils.isNotEmpty((String)mainId)) {
            DrugExtendEntity drugExtendEntity = this.drugExtendService.getByMainId(mainId);
            if (drugExtendEntity == null) {
                drugExtendEntity = new DrugExtendEntity();
                drugExtendEntity.setxId(GenSeqUtils.getUniqueNo());
                drugExtendEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setMainId(mainId);
                drugExtendEntity.setVerifier(doctorName);
                drugExtendEntity.setVerifierCode(doctorCode);
                log.info("=========\u533b\u751fcode" + doctorCode);
                DoctorEntityInfoVO verifierVO = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(doctorCode)));
                if (verifierVO != null) {
                    drugExtendEntity.setVerifierDeptName(verifierVO.getHospitalDeptName());
                    QueryOrganDetailVO organDetailVO = this.doctorRetmoteManage.queryOrganDetail(verifierVO.getOrganId());
                    if (organDetailVO != null) {
                        drugExtendEntity.setVerifierOrganName(StringUtils.isEmpty((String)organDetailVO.getOrganName()) ? "" : organDetailVO.getOrganName());
                    }
                    drugExtendEntity.setVerifierPhone(StringUtils.isEmpty((String)verifierVO.getContactMobile()) ? "" : verifierVO.getContactMobile());
                }
                drugExtendEntity.setVerifyTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setVerifyRemark(remark);
                drugExtendEntity.setAuditStatus(auditStatus);
                drugExtendEntity.setVerifySign(doctorSign);
                this.drugExtendService.insert(drugExtendEntity);
            } else {
                drugExtendEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setVerifyTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setVerifyRemark(remark);
                drugExtendEntity.setAuditStatus(auditStatus);
                drugExtendEntity.setVerifySign(doctorSign);
                this.drugExtendService.updateById(drugExtendEntity);
            }
        }
    }

    public void updateItemStatusByMainId(DrugMainItemStatusDTO drugMainItemStatusDTO) {
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.selectByPrimaryKey(drugMainItemStatusDTO.getMainId());
        this.mosDrugMainMapper.updateItemStatusById(drugMainItemStatusDTO.getItemStatus(), drugMainItemStatusDTO.getMainId());
        if (DrugMainStatusEnum.OFFLINE_CONFIRM.getValue().equals(drugMainItemStatusDTO.getItemStatus())) {
            this.dynamicInvokePlatformServer.adapterConfig(DynamicMethodTypeEnum.DRUG_STORE_PUSH_MAIN.name(), Integer.valueOf(drugMainEntity.getOrganId()), (Object)new MLUpdateSynchronizationMainStatusVO(drugMainEntity.getxId()));
        }
    }

    public void patientSignFinished(PatientSignFinished patientSignForVo) {
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(patientSignForVo.getMainId());
        if (!drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.FINISH.getValue())) {
            drugMainEntity.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
            drugMainEntity.setFailureTime(DateTimeUtil.addDay((Date)new Date(), (int)3));
            int i = this.mosDrugMainMapper.updateByPrimaryKeySelective(drugMainEntity);
            log.info("\u5904\u65b9\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)drugMainEntity));
            if (i == 1) {
                drugMainEntity.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
                this.mosDrugMainMapper.updateByPrimaryKeySelective(drugMainEntity);
                log.info("{}\uff0c\u5904\u65b9\u7528\u6237\u5df2\u624b\u52a8\u5b8c\u6210\u786e\u8ba4\u6536\u8d27", (Object)drugMainEntity.getxId());
                DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
                drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
                drugRemarkEntity.setxUpdateTime(new Date());
                drugRemarkEntity.setRemarkContent("\u7528\u6237\u786e\u8ba4\u6536\u8d27");
                drugRemarkEntity.setMainId(drugMainEntity.getxId());
                drugRemarkEntity.setRemarkType(RemarkTypeEnum.RECEIVING.getValue());
                drugRemarkEntity.setRemarkUser(drugMainEntity.getPatientName());
                drugRemarkEntity.setxCreateTime(new Date());
                this.mosDrugRemarkService.insert(drugRemarkEntity);
            }
            this.mosDrugMainMapper.updateByPrimaryKeySelective(drugMainEntity);
            MLUpdateSynchronizationMainStatusVO mlUpdateSynchronizationMainStatusVO = new MLUpdateSynchronizationMainStatusVO();
            mlUpdateSynchronizationMainStatusVO.setStatus(MLDrugMainOptionEnum.ML_MAIN_SUCCESS.getValue().toString());
            mlUpdateSynchronizationMainStatusVO.setMainId(drugMainEntity.getxId());
            this.dynamicInvokePlatformServer.adapterConfig(DynamicMethodTypeEnum.DRUG_STORE_UPDATE_MAIN_STATUS.name(), Integer.valueOf(drugMainEntity.getOrganId()), (Object)mlUpdateSynchronizationMainStatusVO);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> addNotes(BaseOperationDto baseOperationDto) {
        DrugMainEntity drugMainEntity = this.queryById(baseOperationDto.getMainId());
        if (drugMainEntity == null) {
            return BaseResponse.error((String)"\u6b64\u5904\u65b9\u4e0d\u5b58\u5728");
        }
        this.addRemark(baseOperationDto.getMainId(), baseOperationDto.getContent(), baseOperationDto.getOprationUser(), RemarkTypeEnum.REMARK.getValue());
        return BaseResponse.success((Object)"\u5907\u6ce8\u6dfb\u52a0\u6210\u529f");
    }

    public BaseResponse<PageResult<ManageListResultDTO>> pagingManage(PageResult<ManageListResDTO> param) {
        log.info("=======>\u7ba1\u7406\u7aef\u5904\u65b9\u5217\u8868\u53c2\u6570----->{}", (Object)JSON.toJSONString(param));
        PageResult result = new PageResult();
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        String orderBy = StringUtils.isBlank((String)param.getOrderBy()) ? "x_create_time" : param.getOrderBy();
        param.setOrderBy(orderBy);
        this.queryCode(param);
        List list = this.mosDrugMainMapper.pageQueryManageApp(param);
        for (ManageListResultDTO entity : list) {
            entity.setRemarkUser(this.returnDoctorName(entity.getRemarkType(), entity.getRemarkUser()));
            entity.setPresDoctorName("99999");
            boolean flag = this.validOrder(entity.getItemStatus(), Long.valueOf(entity.getFailureTime().getTime()), entity.getxId());
            if (flag) {
                entity.setItemStatus(DrugMainStatusEnum.USELESS.getValue());
            }
            entity.setMainStatus(DrugMainStatusEnum.getDesc((Integer)entity.getItemStatus()));
            if (DrugMainStatusEnum.DEPLOY_BACK.getValue().equals(entity.getItemStatus())) {
                entity.setMainStatus("\u5df2\u9000\u6b3e");
                continue;
            }
            if (!DrugMainStatusEnum.DEPLOYING.getValue().equals(entity.getItemStatus())) continue;
            entity.setMainStatus(DrugMainStatusEnum.DEPLOYING.getDesc());
        }
        int count = this.mosDrugMainMapper.countManage(param);
        int totalPage = PageUtil.getTotalPage((int)count, (int)param.getPageSize());
        result.setOrderBy(orderBy);
        result.setPageNum(param.getPageNum());
        result.setPageSize(param.getPageSize());
        result.setTotalPages(totalPage);
        result.setTotal(count);
        result.setContent(list);
        return BaseResponse.success((Object)result);
    }

    public String returnDoctorName(Integer remarkType, String remarkUser) {
        if (Objects.isNull(remarkType) || StringUtils.isEmpty((String)remarkUser)) {
            return "";
        }
        if (RemarkTypeEnum.ADD_PRES.getValue().equals(remarkType) || RemarkTypeEnum.VERIFIER.getValue().equals(remarkType)) {
            return "99999";
        }
        return remarkUser;
    }

    public BaseResponse<ManageDescResVo> getDesc(ManageDescReqVo vo) {
        log.info("=======>\u7ba1\u7406\u7aef\u5904\u65b9\u5217\u8868\u63cf\u8ff0----->{}", (Object)JSON.toJSONString((Object)vo));
        this.queryCode(vo);
        ManageDescResVo resVo = this.mosDrugMainMapper.getDescCountApp(vo);
        String receivedAmount = this.mosDrugMainMapper.getReceivedAmountApp(vo);
        resVo.setPayAmount(StringUtils.isEmpty((String)resVo.getPayAmount()) ? "0" : new BigDecimal(resVo.getPayAmount()).setScale(2, 4).toString());
        resVo.setReceivedAmount(StringUtils.isEmpty((String)receivedAmount) ? "0" : new BigDecimal(receivedAmount).setScale(2, 4).toString());
        log.info("=======>\u7ba1\u7406\u7aef\u5904\u65b9\u5217\u8868\u63cf\u8ff0\u8fd4\u56de----->{}", (Object)JSON.toJSONString((Object)resVo));
        return BaseResponse.success((Object)resVo);
    }

    public BaseResponse<PageResult<QueryPharmacistMainDto>> liveryList(Integer patientNoType, String organCode, Integer type, String startTime, String endTime, Integer pageIndex, Integer pageSize, Integer status, String search, Integer userType, String appCode, String doctorId) {
        if (StringUtils.isEmpty((String)appCode)) {
            appCode = organCode;
        }
        ArrayList<Integer> listStatus = new ArrayList<Integer>();
        if (StringUtil.isNotEmpty((String)startTime)) {
            startTime = startTime + " 00:00:00";
        }
        if (StringUtil.isNotEmpty((String)endTime)) {
            endTime = endTime + " 23:59:59";
        }
        ArrayList storeIdList = new ArrayList();
        if (1 == userType) {
            this.getDrugMainStatus(listStatus);
        } else {
            for (DrugMainStatusEnum drugMainStatusEnum : DrugMainStatusEnum.values()) {
                listStatus.add(drugMainStatusEnum.getValue());
            }
        }
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List mainDtoList = this.mosDrugMainMapper.getCommonDrugMainList(patientNoType, appCode, listStatus, status, search, type, startTime, endTime, storeIdList);
        PageInfo pageInfo = new PageInfo(mainDtoList);
        PageResult pageResult = new PageResult(pageIndex.intValue(), pageSize.intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setContent(mainDtoList);
        return BaseResponse.success((Object)pageResult);
    }

    private void getDrugMainStatus(List<Integer> listStatus) {
        listStatus.add(DrugMainStatusEnum.DEPLOYING.getValue());
        listStatus.add(DrugMainStatusEnum.DEPLOY_BACK.getValue());
        listStatus.add(DrugMainStatusEnum.TO_SEND.getValue());
        listStatus.add(DrugMainStatusEnum.SENT.getValue());
        listStatus.add(DrugMainStatusEnum.TO_TAKE.getValue());
        listStatus.add(DrugMainStatusEnum.GET_MEDICINE.getValue());
        listStatus.add(DrugMainStatusEnum.SIGN_IN.getValue());
        listStatus.add(DrugMainStatusEnum.FINISH.getValue());
        listStatus.add(DrugMainStatusEnum.TO_TRANSPORT.getValue());
        listStatus.add(DrugMainStatusEnum.TO_DELIVERY.getValue());
        listStatus.add(DrugMainStatusEnum.OFFLINE_CONFIRM.getValue());
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> completeDeployment(ComplateOrBackDtoReq complateOrBackDtoReq) {
        log.info("=======>\u5b8c\u6210\u8c03\u914d\u9000\u56de\u53c2\u6570-->{}", (Object)JSON.toJSONString((Object)complateOrBackDtoReq));
        DrugMainEntity drugMainEntity = this.queryById(complateOrBackDtoReq.getMainId());
        if (!Integer.valueOf(3).equals(drugMainEntity.getPatientNoType())) {
            DrugOrderEntity orderEntity = this.mosDrugOrderService.queryByMainId(complateOrBackDtoReq.getMainId());
            if (orderEntity == null) {
                return BaseResponse.error((String)"\u6b64\u5904\u65b9\u4e0d\u5b58\u5728\uff01");
            }
            if (orderEntity.getOrderType() == null) {
                DrugMainEntity drugMainInfo = this.mosDrugMainMapper.queryById(complateOrBackDtoReq.getMainId());
                orderEntity.setOrderType(drugMainInfo.getOrderType());
            }
            if (OrderStatusEnum.REFUNDED.getValue().equals(orderEntity.getStatus()) || OrderStatusEnum.REFUNDING.getValue().equals(orderEntity.getStatus())) {
                return BaseResponse.error((String)"\u6b64\u5904\u65b9\u7684\u8ba2\u5355\u5df2\u7ecf\u9000\u6b3e\u6216\u662f\u6b63\u5728\u9000\u6b3e\uff0c\u4e0d\u53ef\u8fdb\u884c\u8c03\u914d\u64cd\u4f5c\uff01");
            }
        }
        Integer mainStatus = 0;
        if (BaseStatusEnum.NORMAL.getValue().equals(complateOrBackDtoReq.getOperation())) {
            DrugOrderEntity drugOrderEntity;
            if (drugMainEntity.getOrderType() == null && (drugOrderEntity = this.mosDrugOrderService.queryByMainIdAndOrderStatus(complateOrBackDtoReq.getMainId(), OrderStatusEnum.PAID.getValue())) != null) {
                drugMainEntity.setOrderType(drugOrderEntity.getOrderType());
            }
            mainStatus = drugMainEntity.getOrderType().equals(OrderTypeEnum.COURIER_ORDER.getValue()) ? DrugMainStatusEnum.TO_SEND.getValue() : DrugMainStatusEnum.TO_TAKE.getValue();
        } else {
            mainStatus = DrugMainStatusEnum.DEPLOY_BACK.getValue();
        }
        DrugExtendEntity drugExtendEntity = this.drugExtendService.getByMainId(complateOrBackDtoReq.getMainId());
        if (drugExtendEntity == null) {
            drugExtendEntity = new DrugExtendEntity();
            drugExtendEntity.setDeployer(complateOrBackDtoReq.getOprationUser());
            drugExtendEntity.setDeployRemark(complateOrBackDtoReq.getContent());
            drugExtendEntity.setDeployTime(DateUtils.getThisDateTime((Date)new Date()));
            drugExtendEntity.setMainId(drugMainEntity.getxId());
            drugExtendEntity.setxId(GenSeqUtils.getUniqueNo());
            drugExtendEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugExtendEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugExtendEntity.setAuditStatus(AuditStatusEnum.PASS_STATUS.getValue());
            this.drugExtendService.insert(drugExtendEntity);
        } else {
            drugExtendEntity.setDeployer(complateOrBackDtoReq.getOprationUser());
            drugExtendEntity.setDeployRemark(complateOrBackDtoReq.getContent());
            drugExtendEntity.setDeployTime(DateUtils.getThisDateTime((Date)new Date()));
            this.drugExtendService.updateById(drugExtendEntity);
        }
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
        drugRemarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugRemarkEntity.setRemarkContent(complateOrBackDtoReq.getContent());
        drugRemarkEntity.setMainId(complateOrBackDtoReq.getMainId());
        drugRemarkEntity.setRemarkType(RemarkTypeEnum.DEPLOYMENT.getValue());
        drugRemarkEntity.setRemarkUser(complateOrBackDtoReq.getOprationUser());
        drugRemarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.mosDrugRemarkMapper.insert(drugRemarkEntity);
        drugMainEntity.setItemStatus(mainStatus);
        this.update(drugMainEntity);
        if (DrugMainStatusEnum.DEPLOY_BACK.getValue().equals(mainStatus)) {
            this.automaticRefund(complateOrBackDtoReq.getMainId(), "\u8c03\u914d\u7f3a\u8d27\u9000\u6b3e", complateOrBackDtoReq.getOprationUser());
        }
        try {
            this.prescriptionPdfService.setPresPdf(complateOrBackDtoReq.getMainId(), null);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return BaseResponse.success((Object)"\u8c03\u914d\u5b8c\u6210");
    }

    public void addRemark(String mainId, String content, String operationUser, Integer remardType) {
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
        drugRemarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugRemarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugRemarkEntity.setMainId(mainId);
        drugRemarkEntity.setRemarkContent(content);
        drugRemarkEntity.setRemarkUser(operationUser);
        drugRemarkEntity.setRemarkType(remardType);
        this.remarkMapper.insert(drugRemarkEntity);
    }

    public void automaticRefund(String mainId, String remark, String remarkUser) {
        BaseOperationDto baseOperationDto = new BaseOperationDto();
        baseOperationDto.setMainId(mainId);
        baseOperationDto.setOprationUser(remarkUser);
        baseOperationDto.setContent(remark);
        BaseResponse stringBaseResponse = this.orderPayManage.applyRefund(baseOperationDto);
        if (ReturnCodeEnum.FAILURE.getValue().equalsIgnoreCase(stringBaseResponse.getCode())) {
            log.info("\u9000\u6b3e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u662f:{}", (Object)stringBaseResponse.getMsg());
            throw new RuntimeException("\u9000\u6b3e\u5f02\u5e38!!");
        }
    }

    private boolean validOrder(Integer itemStatus, Long expireTime, String mainId) {
        boolean flag = false;
        if (DrugMainStatusEnum.UNPAID.getValue().equals(itemStatus)) {
            Long nowTime = System.currentTimeMillis();
            if (expireTime < nowTime) {
                DrugMainEntity drugMainEntity = new DrugMainEntity();
                drugMainEntity.setxId(mainId);
                drugMainEntity.setItemStatus(DrugMainStatusEnum.USELESS.getValue());
                this.mosDrugMainMapper.updateByPrimaryKeySelective(drugMainEntity);
                flag = true;
            }
        }
        return flag;
    }

    private void queryCode(PageResult<ManageListResDTO> param) {
        if (((ManageListResDTO)param.getContent().get(0)).getItemStatus() != null && DrugMainStatusEnum.NOTWRITTEROff.getValue().equals(((ManageListResDTO)param.getContent().get(0)).getItemStatus())) {
            ((ManageListResDTO)param.getContent().get(0)).setItemStatusList(new Integer[]{DrugMainStatusEnum.ZRYH_UNPAID.getValue(), DrugMainStatusEnum.OFFLINE_CONFIRM.getValue(), DrugMainStatusEnum.DEPLOYING.getValue(), DrugMainStatusEnum.TO_TAKE.getValue(), DrugMainStatusEnum.TO_SEND.getValue()});
            ((ManageListResDTO)param.getContent().get(0)).setItemStatus(null);
        }
        if (((ManageListResDTO)param.getContent().get(0)).getItemStatus() != null && DrugMainStatusEnum.WRITTEROff.getValue().equals(((ManageListResDTO)param.getContent().get(0)).getItemStatus())) {
            ((ManageListResDTO)param.getContent().get(0)).setItemStatusList(new Integer[]{DrugMainStatusEnum.FINISH.getValue(), DrugMainStatusEnum.SENT.getValue()});
            ((ManageListResDTO)param.getContent().get(0)).setItemStatus(null);
        }
        if (((ManageListResDTO)param.getContent().get(0)).getItemStatus() != null && DrugMainStatusEnum.EXPIRED.getValue().equals(((ManageListResDTO)param.getContent().get(0)).getItemStatus())) {
            ((ManageListResDTO)param.getContent().get(0)).setItemStatusList(new Integer[]{DrugMainStatusEnum.USELESS.getValue(), DrugMainStatusEnum.DEPLOY_BACK.getValue(), DrugMainStatusEnum.UNPAID_TIME_OUT.getValue()});
            ((ManageListResDTO)param.getContent().get(0)).setItemStatus(null);
        }
    }

    private void queryCode(ManageDescReqVo vo) {
        if (vo.getItemStatus() != null && DrugMainStatusEnum.NOTWRITTEROff.getValue().equals(vo.getItemStatus())) {
            vo.setItemStatusList(new Integer[]{DrugMainStatusEnum.ZRYH_UNPAID.getValue(), DrugMainStatusEnum.OFFLINE_CONFIRM.getValue(), DrugMainStatusEnum.DEPLOYING.getValue(), DrugMainStatusEnum.TO_TAKE.getValue(), DrugMainStatusEnum.TO_SEND.getValue()});
            vo.setItemStatus(null);
        }
        if (vo.getItemStatus() != null && DrugMainStatusEnum.WRITTEROff.getValue().equals(vo.getItemStatus())) {
            vo.setItemStatusList(new Integer[]{DrugMainStatusEnum.FINISH.getValue(), DrugMainStatusEnum.SENT.getValue()});
            vo.setItemStatus(null);
        }
        if (vo.getItemStatus() != null && DrugMainStatusEnum.EXPIRED.getValue().equals(vo.getItemStatus())) {
            vo.setItemStatusList(new Integer[]{DrugMainStatusEnum.USELESS.getValue(), DrugMainStatusEnum.UNPAID_TIME_OUT.getValue(), DrugMainStatusEnum.DEPLOY_BACK.getValue()});
            vo.setItemStatus(null);
        }
    }
}

