/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.OrderSourceEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.manage.PatientManage;
import com.ebaiyihui.circulation.mapper.MosDrugDetailMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugStoreMapper;
import com.ebaiyihui.circulation.pojo.bo.DrugDetailEntityBO;
import com.ebaiyihui.circulation.pojo.dto.order.CommerceAppletOrderDetailDto;
import com.ebaiyihui.circulation.pojo.dto.order.CommerceAppletOrderDrugListDto;
import com.ebaiyihui.circulation.pojo.dto.order.CommerceAppletOrderListDto;
import com.ebaiyihui.circulation.pojo.dto.order.CommerceNextBuyCalendarDetailBODto;
import com.ebaiyihui.circulation.pojo.dto.order.CommerceNextBuyCalendarDetailDto;
import com.ebaiyihui.circulation.pojo.dto.order.CommerceNextBuyCalendarDto;
import com.ebaiyihui.circulation.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugStoreEntity;
import com.ebaiyihui.circulation.pojo.qo.CommerceAppletNextBuyRequestQO;
import com.ebaiyihui.circulation.pojo.vo.order.CommerceAppletNextBuyRequestVO;
import com.ebaiyihui.circulation.pojo.vo.order.CommerceAppletOrderRequestVO;
import com.ebaiyihui.circulation.service.MosDrugOrderService;
import com.ebaiyihui.circulation.utils.BigDecimalUtil;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.circulation.utils.drugutil.DesensitizationUtil;
import com.ebaiyihui.medicalcloud.pojo.vo.ReconciliationVO;
import com.ebaiyihui.three.patient.vo.RequestUpdatePatientVO;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MosDrugOrderServiceImpl
implements MosDrugOrderService {
    private static final Logger log = LoggerFactory.getLogger(MosDrugOrderServiceImpl.class);
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private MosDrugDetailMapper mosDrugDetailMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugStoreMapper mosDrugStoreMapper;
    @Autowired
    private PatientManage patientManage;

    public DrugOrderEntity queryById(String xId) {
        return this.mosDrugOrderMapper.queryById(xId);
    }

    public DrugOrderEntity insert(DrugOrderEntity mosDrugOrder) {
        this.mosDrugOrderMapper.insert(mosDrugOrder);
        return mosDrugOrder;
    }

    public DrugOrderEntity update(DrugOrderEntity mosDrugOrder) {
        this.mosDrugOrderMapper.updateByPrimaryKeySelective(mosDrugOrder);
        return this.queryById(mosDrugOrder.getxId());
    }

    public DrugOrderEntity queryByMainIdAndOrderStatus(String mainId, Integer status) {
        return this.mosDrugOrderMapper.queryByMainIdAndOrderStatus(mainId, status);
    }

    public DrugOrderEntity queryByOrderSeq(String orderSeq) {
        return this.mosDrugOrderMapper.queryByOrderSeq(orderSeq);
    }

    public List<ReconciliationVO> queryReconciliationData(String date, String organCode) {
        String dateStr = DateUtils.formatDate((Date)DateUtils.parseYMDDate((String)date), (Object[])new Object[]{"yyyy-MM-dd"});
        String startTime = new StringBuffer(dateStr).append(" 00:00:00").toString();
        String endTime = new StringBuffer(dateStr).append(" 23:59:59").toString();
        return this.mosDrugOrderMapper.queryReconciliationData(startTime, endTime, organCode.toUpperCase());
    }

    public DrugOrderEntity queryByBankTradeNo(String bankTradeNo) {
        return this.mosDrugOrderMapper.queryByBankTradeNo(bankTradeNo);
    }

    public DrugOrderEntity queryByDealSeq(String dealSeq) {
        return this.mosDrugOrderMapper.queryByDealSeq(dealSeq);
    }

    public DrugOrderEntity queryByMainId(String mainId) {
        return this.mosDrugOrderMapper.queryByMainId(mainId);
    }

    @Async
    public void syncPatientStore(String mainId) {
        log.info("\u5f00\u59cb\u540c\u6b65");
        DrugOrderEntity orderEntity = this.mosDrugOrderMapper.queryByMainId(mainId);
        if (Objects.isNull(orderEntity)) {
            log.error("\u8ba2\u5355\u4e3a\u7a7a");
            return;
        }
        if (!OrderSourceEnum.COURIER_ORDER.getValue().equals(orderEntity.getOrderSource())) {
            log.error("\u4e0d\u4e3a\u7535\u5546\u8ba2\u5355\uff0c\u8df3\u51fa");
            return;
        }
        DrugMainEntity mainEntity = this.mosDrugMainMapper.queryById(orderEntity.getMainId());
        DrugStoreEntity storeEntity = this.mosDrugStoreMapper.queryById(mainEntity.getStoreId());
        RequestUpdatePatientVO vo = new RequestUpdatePatientVO();
        vo.setPatientNewStoreCode(storeEntity.getThreeMlCode());
        vo.setPatientInfoId(mainEntity.getPatientId());
        this.patientManage.syncPatientStore(vo);
        log.info("\u540c\u6b65\u5b8c\u6210");
    }

    public PageInfo<CommerceAppletOrderListDto> getCommerceAppletOrderList(CommerceAppletOrderRequestVO orderRequestVO) {
        List mainIds;
        if (Objects.isNull(orderRequestVO) || Objects.isNull(orderRequestVO.getPageIndex()) || Objects.isNull(orderRequestVO.getPageSize())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u5206\u9875\u53c2\u6570");
        }
        if (StringUtils.isBlank((String)orderRequestVO.getUserId())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u7528\u6237");
        }
        PageHelper.startPage((int)orderRequestVO.getPageIndex(), (int)orderRequestVO.getPageSize());
        List commerceAppletOrderListDtos = this.mosDrugOrderMapper.getCommerceAppletOrderList(orderRequestVO);
        PageInfo pageInfo = new PageInfo(commerceAppletOrderListDtos);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList()) && CollectionUtils.isNotEmpty(mainIds = pageInfo.getList().parallelStream().map(CommerceAppletOrderListDto::getMainId).collect(Collectors.toList()))) {
            List drugDetailEntities = this.mosDrugDetailMapper.queryBOByMainIds(mainIds);
            Map<String, List<DrugDetailEntityBO>> drugDetailMap = drugDetailEntities.parallelStream().collect(Collectors.groupingBy(DrugDetailEntity::getMainId));
            for (CommerceAppletOrderListDto commerceAppletOrderListDto : pageInfo.getList()) {
                commerceAppletOrderListDto.setOrderAmount(BigDecimalUtil.getPriceByString((String)commerceAppletOrderListDto.getOrderAmount(), (int)2));
                List<DrugDetailEntityBO> mainDrugDetailEntities = drugDetailMap.get(commerceAppletOrderListDto.getMainId());
                List drugListDtos = this.setOrderDrugList(mainDrugDetailEntities);
                commerceAppletOrderListDto.setDrugListDtos(drugListDtos);
            }
        }
        return pageInfo;
    }

    public CommerceAppletOrderDetailDto getCommerceAppletOrderDetail(CommerceAppletOrderRequestVO orderRequestVO) {
        if (Objects.isNull(orderRequestVO) || StringUtils.isBlank((String)orderRequestVO.getOrderId())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u8ba2\u5355id");
        }
        CommerceAppletOrderDetailDto commerceAppletOrderDetailDto = this.mosDrugOrderMapper.getCommerceAppletOrderDetailDto(orderRequestVO);
        if (Objects.isNull(commerceAppletOrderDetailDto)) {
            throw new BusinessException("\u5f53\u524d\u8ba2\u5355\u627e\u4e0d\u5230\u4e86\uff01");
        }
        if (DrugMainStatusEnum.DEPLOY_BACK.getValue().equals(commerceAppletOrderDetailDto.getOrderStatus())) {
            commerceAppletOrderDetailDto.setRefundAmount(commerceAppletOrderDetailDto.getPayAmount());
        }
        List drugDetailEntities = this.mosDrugDetailMapper.queryBOByMainIds(Collections.singletonList(commerceAppletOrderDetailDto.getMainId()));
        List drugListDtos = this.setOrderDrugList(drugDetailEntities);
        commerceAppletOrderDetailDto.setDrugListDtos(drugListDtos);
        if (Objects.nonNull(commerceAppletOrderDetailDto.getOrderLogisticsDto()) && StringUtils.isNotBlank((String)commerceAppletOrderDetailDto.getOrderLogisticsDto().getDestPhone())) {
            commerceAppletOrderDetailDto.getOrderLogisticsDto().setDestPhone(DesensitizationUtil.desensitizedPhoneNumber((String)commerceAppletOrderDetailDto.getOrderLogisticsDto().getDestPhone()));
        }
        return commerceAppletOrderDetailDto;
    }

    public CommerceNextBuyCalendarDto getCommerceNextBuyCalendar(CommerceAppletNextBuyRequestVO buyRequestVO) {
        log.info("\u8c03\u7528\u4e86\u67e5\u770b\u8d2d\u836f\u65e5\u5386\uff0c\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)buyRequestVO));
        if (Objects.isNull(buyRequestVO)) {
            buyRequestVO = new CommerceAppletNextBuyRequestVO();
        }
        if (StringUtils.isBlank((String)buyRequestVO.getParamDay())) {
            buyRequestVO.setParamDay(DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy-MM"}));
        }
        Date paramDate = null;
        try {
            paramDate = DateUtils.parseDate((String)buyRequestVO.getParamDay(), (String)"yyyy-MM");
        }
        catch (ParseException e) {
            throw new BusinessException("\u4f20\u5165\u5e74\u6708\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        int days = DateUtils.getDaysOfMonth((Date)paramDate);
        String currentDate = DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy-MM-dd"});
        String firstDate = buyRequestVO.getParamDay() + "-01";
        String endDate = buyRequestVO.getParamDay() + "-" + days;
        try {
            endDate = DateUtils.formatDate((Date)DateUtils.addDay((Date)DateUtils.parseDate((String)endDate, (String)"yyyy-MM-dd"), (int)1), (Object[])new Object[]{"yyyy-MM-dd"});
            if (StringUtils.isBlank((String)endDate)) {
                throw new BusinessException("\u8f6c\u6362\u65e5\u671f\u51fa\u73b0\u9519\u8bef");
            }
        }
        catch (ParseException e) {
            throw new BusinessException("\u8f6c\u6362\u65e5\u671f\u51fa\u73b0\u9519\u8bef");
        }
        List allDays = DateUtils.dayReport((Date)paramDate);
        boolean isCompare = false;
        Map<String, String> buyBODtoMap = null;
        Map<String, String> planBODtoMap = null;
        if (StringUtils.isNotBlank((String)buyRequestVO.getPatientId())) {
            CommerceAppletNextBuyRequestQO qo = new CommerceAppletNextBuyRequestQO();
            qo.setStartDay(firstDate);
            qo.setEndDay(endDate);
            qo.setPatientId(buyRequestVO.getPatientId());
            List boDtos = this.mosDrugMainMapper.getCommerceNextBuyCalendar(qo);
            buyBODtoMap = boDtos.parallelStream().collect(Collectors.toMap(CommerceNextBuyCalendarDetailBODto::getDateDay, CommerceNextBuyCalendarDetailBODto::getDrugNames));
            List buyDtos = this.mosDrugOrderMapper.getCommerceParamMonthNextBuyDates(qo);
            planBODtoMap = buyDtos.parallelStream().collect(Collectors.toMap(CommerceNextBuyCalendarDetailBODto::getDateDay, CommerceNextBuyCalendarDetailBODto::getDrugNames));
            isCompare = true;
        }
        CommerceNextBuyCalendarDto buyCalendarDto = new CommerceNextBuyCalendarDto();
        ArrayList<CommerceNextBuyCalendarDetailDto> detailDtos = new ArrayList<CommerceNextBuyCalendarDetailDto>();
        for (int i = 1; i <= allDays.size(); ++i) {
            CommerceNextBuyCalendarDetailDto detailDto = new CommerceNextBuyCalendarDetailDto();
            detailDto.setDay(String.valueOf(i));
            if (isCompare) {
                detailDto.setIsBuy(Integer.valueOf(buyBODtoMap.containsKey(allDays.get(i - 1)) ? 2 : (planBODtoMap.containsKey(allDays.get(i - 1)) ? 1 : 0)));
                detailDto.setDrugNames(Integer.valueOf(2).equals(detailDto.getIsBuy()) ? buyBODtoMap.get(allDays.get(i - 1)) : (Integer.valueOf(1).equals(detailDto.getIsBuy()) ? planBODtoMap.get(allDays.get(i - 1)) : ""));
            }
            detailDto.setIsCurrent(Integer.valueOf(currentDate.equalsIgnoreCase((String)allDays.get(i - 1)) ? 1 : 0));
            detailDtos.add(detailDto);
        }
        buyCalendarDto.setDetailDtos(detailDtos);
        return buyCalendarDto;
    }

    private List<CommerceAppletOrderDrugListDto> setOrderDrugList(List<DrugDetailEntityBO> mainDrugDetailEntities) {
        ArrayList<CommerceAppletOrderDrugListDto> drugListDtos = new ArrayList<CommerceAppletOrderDrugListDto>();
        for (DrugDetailEntityBO mainDrugDetailEntity : mainDrugDetailEntities) {
            String[] pictures;
            CommerceAppletOrderDrugListDto appletOrderDrugListDto = new CommerceAppletOrderDrugListDto();
            appletOrderDrugListDto.setOrderDrugId(mainDrugDetailEntity.getxId());
            appletOrderDrugListDto.setDrugId(mainDrugDetailEntity.getDrugId());
            appletOrderDrugListDto.setDrugName(mainDrugDetailEntity.getDrugName());
            appletOrderDrugListDto.setDrugQty(Integer.valueOf(Objects.isNull(mainDrugDetailEntity.getAmount()) ? 0 : mainDrugDetailEntity.getAmount().intValue()));
            appletOrderDrugListDto.setDrugSpec(mainDrugDetailEntity.getDrugSpec());
            appletOrderDrugListDto.setManufacturer(mainDrugDetailEntity.getManufacturer());
            if (StringUtils.isNotBlank((String)mainDrugDetailEntity.getDrugPicture()) && StringUtils.isNotBlank((String)(pictures = mainDrugDetailEntity.getDrugPicture().split(","))[0])) {
                appletOrderDrugListDto.setDrugImage(pictures[0]);
            }
            appletOrderDrugListDto.setTotalPrice(BigDecimalUtil.getPriceByDecimal((BigDecimal)mainDrugDetailEntity.getTotalPrice(), (int)2));
            drugListDtos.add(appletOrderDrugListDto);
        }
        return drugListDtos;
    }
}

