/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctor.basedata.api.vo.DepartmentDetailVo;
import com.doctoruser.api.pojo.vo.OrganBasicInfoRespVO;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.circulation.abstracts.DynamicInvokePlatformServer;
import com.ebaiyihui.circulation.common.enums.AuditStatusEnum;
import com.ebaiyihui.circulation.common.enums.DoctorTypeEnum;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.DrugTypeEnum;
import com.ebaiyihui.circulation.common.enums.DynamicMethodTypeEnum;
import com.ebaiyihui.circulation.common.enums.DynamicServerTypeEnum;
import com.ebaiyihui.circulation.common.enums.GranularityTypeEnum;
import com.ebaiyihui.circulation.common.enums.GyhhStatusEnum;
import com.ebaiyihui.circulation.common.enums.LogisticsStatusEnum;
import com.ebaiyihui.circulation.common.enums.LogisticsTypeEnum;
import com.ebaiyihui.circulation.common.enums.MLDrugMainOptionEnum;
import com.ebaiyihui.circulation.common.enums.OrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.OrderTypeEnum;
import com.ebaiyihui.circulation.common.enums.PayTypeEnum;
import com.ebaiyihui.circulation.common.enums.PrescriptionSourceEnum;
import com.ebaiyihui.circulation.common.enums.PushWeChatMessageActionTypeEnum;
import com.ebaiyihui.circulation.common.enums.RemarkTypeEnum;
import com.ebaiyihui.circulation.common.enums.TJAuditStatusEnum;
import com.ebaiyihui.circulation.common.enums.VerifyStatusEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.manage.DoctorRetmoteManage;
import com.ebaiyihui.circulation.manage.DrugMainManage;
import com.ebaiyihui.circulation.manage.PatientInfoRemoteManage;
import com.ebaiyihui.circulation.manage.PushManage;
import com.ebaiyihui.circulation.mapper.MosDrugDetailMapper;
import com.ebaiyihui.circulation.mapper.MosDrugExtendMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsRouteMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.circulation.mapper.MosDrugRemarkMapper;
import com.ebaiyihui.circulation.mapper.MosDrugStoreMapper;
import com.ebaiyihui.circulation.mapper.PharmaceuticalCompanyMapper;
import com.ebaiyihui.circulation.mapper.UserAddressMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugExtendEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugLogisticsOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugStoreEntity;
import com.ebaiyihui.circulation.pojo.entity.MosDrugLogisticsRouteEntity;
import com.ebaiyihui.circulation.pojo.entity.PharmaceuticalCompanyEntity;
import com.ebaiyihui.circulation.pojo.entity.UserAddressEntity;
import com.ebaiyihui.circulation.pojo.vo.PatientListResDTO;
import com.ebaiyihui.circulation.service.MosDrugPrescriptionService;
import com.ebaiyihui.circulation.service.MosDrugStoreService;
import com.ebaiyihui.circulation.service.impl.MosDrugPrescriptionServiceImpl;
import com.ebaiyihui.circulation.utils.BigDecimalUtil;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import com.ebaiyihui.circulation.utils.StringUtil;
import com.ebaiyihui.circulation.utils.medicalcloud.AppCodeUtil;
import com.ebaiyihui.circulation.utils.medicalcloud.PageUtil;
import com.ebaiyihui.circulation.utils.medicalcloud.RabbitMqUtils;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.AskFeeData;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.DistributionFeeData;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.DoctorListResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.DoctorListResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.DrugDetailData;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.DrugRemarkData;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.OtherFeeData;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PatientListResVO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PatientListResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PresDetailResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PresDetailResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.QueryPresStatusResultDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.ConfireResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.ConfirmMedicineReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.FromOutlineVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PatientInfoRespVO;
import com.ebaiyihui.medicalcloud.pojo.vo.board.PrescriptionDataEChartReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.board.PrescriptionDataEChartResCommonVO;
import com.ebaiyihui.medicalcloud.pojo.vo.board.PrescriptionDataEChartResDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.board.PrescriptionDataEChartResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.board.PrescriptionDataReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.board.PrescriptionDataResCommonPercentVO;
import com.ebaiyihui.medicalcloud.pojo.vo.board.PrescriptionDataResCommonVO;
import com.ebaiyihui.medicalcloud.pojo.vo.board.PrescriptionDataResVO;
import com.ebaiyihui.ml.pojo.vo.MLUpdateSynchronizationMainStatusVO;
import com.ebaiyihui.three.push.vo.WeChatPushDoctorRemindVO;
import com.github.pagehelper.PageHelper;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="mosDrugPrescriptionService")
public class MosDrugPrescriptionServiceImpl
implements MosDrugPrescriptionService {
    private static final Logger log = LoggerFactory.getLogger(MosDrugPrescriptionServiceImpl.class);
    public static final String INTER_ORDER = "\u65b0\u589e\u8ba2\u5355";
    public static final String PAYMENT_ORDER = "\u5b9e\u9645\u652f\u4ed8\u8ba2\u5355";
    public static final String REFUND_ORDER = "\u9000\u6b3e\u8ba2\u5355";
    public static final String INVALID_ORDER = "\u5931\u6548\u8ba2\u5355";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String ACTUAL_ORDER = "\u5b9e\u9645\u652f\u4ed8\u8ba2\u5355\u91d1\u989d";
    public static final String REFUND_ORDER_AMOUNT = "\u9000\u6b3e\u8ba2\u5355\u91d1\u989d";
    public static final String INVALID_ORDER_AMOUNT = "\u5931\u6548\u8ba2\u5355\u91d1\u989d";
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugDetailMapper mosDrugDetailMapper;
    @Autowired
    private MosDrugStoreMapper mosDrugStoreMapper;
    @Autowired
    private MosDrugPrescriptionMapper mosDrugPrescriptionMapper;
    @Autowired
    private UserAddressMapper userAddressMapper;
    @Autowired
    private DynamicInvokePlatformServer dynamicInvokePlatformServer;
    @Autowired
    private DrugMainManage drugMainManage;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private PatientInfoRemoteManage patientInfoRemoteManage;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private MosDrugStoreService mosDrugStoreService;
    @Autowired
    private MosDrugRemarkMapper mosDrugRemarkMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private MosDrugLogisticsRouteMapper mosDrugLogisticsRouteMapper;
    @Autowired
    private PharmaceuticalCompanyMapper pharmaceuticalCompanyMapper;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private MosDrugExtendMapper drugExtendMapper;
    public static final int FIVE = 5;
    public static final int NINTY_TWO = 92;
    public static final int THIRTY_ONE = 31;
    public static final String YI_YAO_YUN = "yyy";
    public static final String ONE_STR = "1";
    public static final int THIRD = 3;
    public static final int ZERO = 0;
    public static final int ONE = 1;
    public static final int FOUR = 4;
    public static final int TWO = 2;
    public static final String MYSQL_FORMAT_REG_DAY = "%Y-%m-%d";
    public static final String MYSQL_FORMAT_REG_WEEK = "%Y-%u";
    public static final String MYSQL_FORMAT_REG_MONTH = "%Y-%m";
    private static List<String> unitList = new ArrayList();
    public static final int SEVENTY_TWO_HOURS = 259200;

    public DrugPrescriptionEntity insert(DrugPrescriptionEntity drugPrescriptionEntity) {
        this.mosDrugPrescriptionMapper.insert(drugPrescriptionEntity);
        return this.mosDrugPrescriptionMapper.selectByPrimaryKey(drugPrescriptionEntity.getxId());
    }

    public DrugPrescriptionEntity queryById(String xId) {
        return this.mosDrugPrescriptionMapper.queryById(xId);
    }

    public BaseResponse<PageResult<PatientListResultDTO>> pagingPatient(PageResult<PatientListResDTO> param) {
        log.info("=======>\u60a3\u8005\u7aef\u5904\u65b9\u5217\u8868\u53c2\u6570----->{}", (Object)JSON.toJSONString(param));
        ((PatientListResDTO)param.getContent().get(0)).setOrganCode(AppCodeUtil.tranCode((String)((PatientListResDTO)param.getContent().get(0)).getOrganCode()));
        PageResult result = new PageResult();
        List list = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)((PatientListResDTO)param.getContent().get(0)).getPatientIdList())) {
            PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
            list = this.mosDrugMainMapper.queryByPatient(((PatientListResDTO)param.getContent().get(0)).getPatientIdList(), ((PatientListResDTO)param.getContent().get(0)).getOrganCode(), ((PatientListResDTO)param.getContent().get(0)).getKeyword());
        }
        this.extracted(((PatientListResDTO)param.getContent().get(0)).getOrganCode(), null, list, ((PatientListResDTO)param.getContent().get(0)).getVersion());
        result.setOrderBy("x_create_time");
        result.setPageNum(param.getPageNum());
        result.setPageSize(param.getPageSize());
        result.setContent(list);
        return BaseResponse.success((Object)result);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<PresDetailResultDTO> presDetail(PresDetailResDTO dto) {
        List outLineList;
        String id = dto.getMainId();
        log.info("=======>\u5904\u65b9\u8be6\u60c5 - \u533b\u5631ID - mainId:{}", (Object)id);
        PresDetailResultDTO reqDTO = this.mosDrugMainMapper.queryPresDetail(id);
        if (reqDTO == null) {
            return BaseResponse.success();
        }
        reqDTO.setPresDoctorPhone("");
        reqDTO.setVerifierPhone("");
        reqDTO.setPresDoctorName("99999");
        reqDTO.setPresDoctorCode("99999");
        reqDTO.setVerifierCode("99999");
        reqDTO.setVerifier("99999");
        if (reqDTO.getExpressFlag() == null) {
            reqDTO.setExpressFlag(Integer.valueOf(1));
        }
        if (StringUtils.isNotEmpty((String)reqDTO.getWarningLevelTJ())) {
            reqDTO.setWarningShowTJ(TJAuditStatusEnum.getStatus((String)reqDTO.getWarningLevelTJ()).getInfo());
            reqDTO.setWarningShowUserNameTJ("\u5408\u7406\u7528\u836f\u7cfb\u7edf\u5ba1\u6838");
        }
        reqDTO.setNowTime(Long.valueOf(System.currentTimeMillis()));
        this.setDrugRemarkData(reqDTO);
        this.setDrugDetaillData(reqDTO);
        this.setPresDetailData(reqDTO, dto.getType(), dto.getPrescriptionSource());
        if (StringUtils.isNotEmpty((String)reqDTO.getOrderId()) && StringUtils.isNotEmpty((String)reqDTO.getAdmissionId())) {
            FromOutlineVO fromOutlineVO;
            if (StringUtils.isEmpty((String)dto.getType())) {
                String medicalOpinion = this.drugMainManage.getMedicalOpinion(reqDTO.getAdmissionId(), reqDTO.getPresOrgan());
                reqDTO.setMedicalOpinion(StringUtils.isEmpty((String)medicalOpinion) ? "" : medicalOpinion);
            }
            if ((StringUtils.isEmpty((String)reqDTO.getServCode()) || StringUtils.isEmpty((String)reqDTO.getServCodeName())) && (fromOutlineVO = this.drugMainManage.getOutLineInfo(reqDTO.getOrderId(), reqDTO.getAdmissionId(), reqDTO.getPresOrgan())) != null) {
                reqDTO.setServCode(StringUtils.isEmpty((String)fromOutlineVO.getServCode()) ? "" : fromOutlineVO.getServCode());
                reqDTO.setServCodeName(StringUtils.isEmpty((String)fromOutlineVO.getServCodeName()) ? "" : fromOutlineVO.getServCodeName());
            }
        }
        if (StringUtils.isNotEmpty((String)dto.getType()) && DoctorTypeEnum.SYSTEM.getValue().equals(dto.getType()) && StringUtils.isNotEmpty((String)reqDTO.getPatientId()) && CollectionUtils.isNotEmpty((Collection)(outLineList = this.drugMainManage.getOutLineList(reqDTO.getPatientId(), reqDTO.getPresOrgan())))) {
            reqDTO.setOutList(outLineList);
        }
        this.extracted(reqDTO);
        reqDTO.setExpireTimeFortyEightHours(reqDTO.getExpireTime());
        this.setLogisticsOrder(reqDTO, dto);
        reqDTO.setWriteOffStatus(reqDTO.getItemStatus() != null ? this.replacementWriteOffCode(reqDTO.getItemStatus()) : reqDTO.getItemStatus());
        log.info("=======\u8fd4\u56de\u4fe1\u606f" + JSONObject.toJSONString((Object)reqDTO));
        return BaseResponse.success((Object)reqDTO);
    }

    private void extracted(PresDetailResultDTO reqDTO) {
        DoctorEntityInfoVO verifierVO;
        DoctorEntityInfoVO doctorVo;
        if (StringUtils.isEmpty((String)reqDTO.getPatientCredNo())) {
            PatientInfoRespVO patientInfoRespVO = this.patientInfoRemoteManage.getPatientInfoById(Long.valueOf(Long.parseLong(reqDTO.getPatientId().trim())), reqDTO.getPresOrgan(), this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(reqDTO.getPresDoctorId().trim()))).getOrganId().toString());
            reqDTO.setPatientCredNo(patientInfoRespVO != null && StringUtils.isNotEmpty((String)patientInfoRespVO.getCredNo()) ? patientInfoRespVO.getCredNo() : "");
        }
        if (StringUtils.isNotBlank((String)reqDTO.getPresDoctorId()) && (doctorVo = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(reqDTO.getPresDoctorId())))) != null) {
            reqDTO.setPresDoctorAvatar(doctorVo.getHeadPortrait());
            reqDTO.setHospitalDeptId(doctorVo.getHospitalDeptId());
            reqDTO.setOrganId(doctorVo.getOrganId());
            OrganBasicInfoRespVO organBasicInfoRespVO = this.doctorRetmoteManage.queryOrganization(doctorVo.getOrganId());
            reqDTO.setLogo(organBasicInfoRespVO != null && StringUtils.isNotEmpty((String)organBasicInfoRespVO.getLogo()) ? organBasicInfoRespVO.getLogo() : "");
        }
        if (StringUtils.isNotEmpty((String)reqDTO.getVerifierCode()) && StringUtils.isEmpty((String)reqDTO.getVerifierDeptName()) && (verifierVO = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(reqDTO.getVerifierCode())))) != null) {
            reqDTO.setVerifierDeptName(verifierVO.getHospitalDeptName());
            QueryOrganDetailVO organDetailVO = this.doctorRetmoteManage.queryOrganDetail(verifierVO.getOrganId());
            reqDTO.setVerifierOrganName(organDetailVO != null && StringUtils.isNotEmpty((String)organDetailVO.getOrganName()) ? organDetailVO.getOrganName() : "");
            reqDTO.setVerifierPhone(StringUtils.isEmpty((String)verifierVO.getContactMobile()) ? "" : verifierVO.getContactMobile());
        }
        if (StringUtils.isEmpty((String)reqDTO.getStdFirstDeptName()) && StringUtils.isEmpty((String)reqDTO.getStdSecondDeptName()) && StringUtils.isNotBlank((String)reqDTO.getPresDeptCode())) {
            DepartmentDetailVo departmentDetailVo = this.doctorRetmoteManage.queryDeptByDeptCode(reqDTO.getPresDeptCode());
            if (departmentDetailVo != null) {
                reqDTO.setDoctorDeptName(departmentDetailVo.getStdFirstDeptName() + "/" + departmentDetailVo.getStdSecondDeptName());
            }
        } else {
            reqDTO.setDoctorDeptName(reqDTO.getStdFirstDeptName() + "/" + reqDTO.getStdSecondDeptName());
        }
    }

    private void setLogisticsOrder(PresDetailResultDTO reqDTO, PresDetailResDTO dto) {
        DrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByMainId(dto.getMainId());
        log.info("======\u67e5\u8be2\u5230\u7684\u7269\u6d41\u4fe1\u606f" + JSONObject.toJSONString((Object)mosDrugLogisticsOrderEntity));
        if (Objects.nonNull(mosDrugLogisticsOrderEntity)) {
            reqDTO.setLogisticsBankTradeNo(mosDrugLogisticsOrderEntity.getBankTradeNo());
            reqDTO.setLogisticsOrderId(mosDrugLogisticsOrderEntity.getId());
            reqDTO.setLogisticsMainNo(mosDrugLogisticsOrderEntity.getMainNo());
            if (mosDrugLogisticsOrderEntity.getPayAmount() != null && OrderTypeEnum.COURIER_ORDER.getValue().equals(reqDTO.getOrderType())) {
                reqDTO.setLogisticsPayAmount(mosDrugLogisticsOrderEntity.getPayAmount().setScale(2, 4).toString());
            }
            reqDTO.setLogisticsPayMethod(mosDrugLogisticsOrderEntity.getPayMethod());
            reqDTO.setLogisticsOrderSeq(mosDrugLogisticsOrderEntity.getOrderSeq());
            reqDTO.setLogisticsRemark(mosDrugLogisticsOrderEntity.getRemark());
            reqDTO.setLogisticsOrderPayMethod(mosDrugLogisticsOrderEntity.getLogisticsPayMethod());
            reqDTO.setLogisticsOrderStatus(mosDrugLogisticsOrderEntity.getOrderStatus());
            reqDTO.setSendType(mosDrugLogisticsOrderEntity.getSendType());
            reqDTO.setDistributor(mosDrugLogisticsOrderEntity.getDistributor());
            reqDTO.setDistributorPhone(mosDrugLogisticsOrderEntity.getDistributorPhone());
            if (StringUtils.isNotBlank((String)mosDrugLogisticsOrderEntity.getPayMethod())) {
                if (PayTypeEnum.WECHAT_PAY.getValue().equals(mosDrugLogisticsOrderEntity.getPayMethod())) {
                    reqDTO.setLogisticsPayMethodDesc(PayTypeEnum.WECHAT_PAY.getDesc());
                } else if (PayTypeEnum.ALI_PAY.getValue().equals(mosDrugLogisticsOrderEntity.getPayMethod())) {
                    reqDTO.setLogisticsPayMethodDesc(PayTypeEnum.ALI_PAY.getDesc());
                } else {
                    reqDTO.setLogisticsPayMethodDesc(PayTypeEnum.NCEFY_OFFLINE_MEDICAL_INS_PAY.getDesc());
                }
            }
            reqDTO.setLogisticsPayTime(DateUtils.formatDate((Date)mosDrugLogisticsOrderEntity.getPayTime(), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
            reqDTO.setLogisticsDestAddress(mosDrugLogisticsOrderEntity.getDestAddress());
            reqDTO.setDestName(mosDrugLogisticsOrderEntity.getDestName());
            reqDTO.setDestPhone(mosDrugLogisticsOrderEntity.getDestPhone());
            reqDTO.setLogisticsDestAddress(mosDrugLogisticsOrderEntity.getDestAddress());
            reqDTO.setDistributionType(mosDrugLogisticsOrderEntity.getDistributionType());
            reqDTO.setSrcName(mosDrugLogisticsOrderEntity.getSrcName());
            reqDTO.setSrcPhone(mosDrugLogisticsOrderEntity.getSrcPhone());
            reqDTO.setSrcAddress(mosDrugLogisticsOrderEntity.getSrcAddress());
            reqDTO.setDeliveryStoreId(mosDrugLogisticsOrderEntity.getDeliveryStoreId());
            DrugStoreEntity drugstoreEntity = this.mosDrugStoreService.queryById(mosDrugLogisticsOrderEntity.getDeliveryStoreId());
            if (drugstoreEntity != null) {
                reqDTO.setBusinessTime(drugstoreEntity.getBusinessTime());
            }
            if (LogisticsTypeEnum.SF_KD.getValue().equals(mosDrugLogisticsOrderEntity.getLogisticsName())) {
                reqDTO.setLogisticsName(LogisticsTypeEnum.SF_KD.getValue());
            } else if (LogisticsTypeEnum.GYHH_KD.getValue().equals(mosDrugLogisticsOrderEntity.getLogisticsName())) {
                reqDTO.setLogisticsName(LogisticsTypeEnum.GYHH_KD.getDesc());
            } else {
                reqDTO.setLogisticsName(mosDrugLogisticsOrderEntity.getLogisticsName());
            }
            if (Objects.nonNull(mosDrugLogisticsOrderEntity.getDestDeliveryDistance())) {
                if (new BigDecimal(mosDrugLogisticsOrderEntity.getDestDeliveryDistance()).compareTo(new BigDecimal(100000)) < 0) {
                    reqDTO.setIsFlag(Integer.valueOf(1));
                } else {
                    reqDTO.setIsFlag(Integer.valueOf(2));
                }
            }
            List mosDrugLogisticsRouteEntityList = this.mosDrugLogisticsRouteMapper.selectListByLogisticsOrderId(mosDrugLogisticsOrderEntity.getId());
            log.info("=======\u7269\u6d41\u8bf4\u660e" + JSONObject.toJSONString((Object)mosDrugLogisticsRouteEntityList));
            if (!CollectionUtils.isEmpty((Collection)mosDrugLogisticsRouteEntityList)) {
                mosDrugLogisticsRouteEntityList.stream().forEach(mosDrugLogisticsRouteEntity -> {
                    if (mosDrugLogisticsRouteEntity.getOpCode().equals(LogisticsStatusEnum.FORTY_FOUR.getValue())) {
                        reqDTO.setDeliveryName(mosDrugLogisticsRouteEntity.getDeliveryName());
                        reqDTO.setDeliveryPhone(mosDrugLogisticsRouteEntity.getDeliveryPhone());
                    } else if (mosDrugLogisticsRouteEntity.getOpCode().equals(GyhhStatusEnum.TO_DELIVERY.getValue()) || mosDrugLogisticsRouteEntity.getOpCode().equals(GyhhStatusEnum.SIGN_IN.getValue()) || mosDrugLogisticsRouteEntity.getOpCode().equals(GyhhStatusEnum.SENT.getValue())) {
                        reqDTO.setDeliveryName(mosDrugLogisticsRouteEntity.getDeliveryName());
                        reqDTO.setDeliveryPhone(mosDrugLogisticsRouteEntity.getDeliveryPhone());
                    }
                    reqDTO.setAcceptTotalTime(mosDrugLogisticsRouteEntity.getAcceptTotalTime());
                });
                MosDrugLogisticsRouteEntity mosDrugLogisticsRouteEntity2 = (MosDrugLogisticsRouteEntity)mosDrugLogisticsRouteEntityList.get(mosDrugLogisticsRouteEntityList.size() - 1);
                reqDTO.setLogisticsInfo(mosDrugLogisticsRouteEntity2.getRemark());
            }
        }
    }

    void setPresDetailData(PresDetailResultDTO reqDTO, String type, Integer prescriptionSource) {
        UserAddressEntity userAddressEntity;
        boolean flag;
        Object map = null;
        boolean remarkFlag = false;
        int itemStatus = reqDTO.getItemStatus();
        if (itemStatus == 41) {
            itemStatus = 40;
        }
        if (itemStatus > DrugMainStatusEnum.PHARMACIST_BACK.getValue()) {
            reqDTO.setVerifyStatus(VerifyStatusEnum.VERIFY.getDesc());
        } else if (itemStatus == DrugMainStatusEnum.PHARMACIST_BACK.getValue()) {
            String remarkContent = ((DrugRemarkData)reqDTO.getDrugRemarkData().get(0)).getRemarkContent();
            if (StringUtils.isNotEmpty((String)remarkContent) && remarkContent.equals("\u5ba1\u6838\u4e0d\u901a\u8fc7\u9000\u6b3e")) {
                remarkFlag = true;
            }
            reqDTO.setVerifyStatus(VerifyStatusEnum.NO_VERIFY.getDesc());
        } else if (itemStatus == DrugMainStatusEnum.APPROVING.getValue()) {
            reqDTO.setVerifyStatus(VerifyStatusEnum.VERIFY_ING.getDesc());
        } else {
            reqDTO.setVerifyStatus(reqDTO.getAuditStatus() == null ? "" : VerifyStatusEnum.getDesc((Integer)reqDTO.getAuditStatus()));
        }
        reqDTO.setPayMethod(StringUtils.isEmpty((String)reqDTO.getPayMethod()) ? "" : PayTypeEnum.getDesc((String)reqDTO.getPayMethod()));
        reqDTO.setPresTypeMsg(DrugTypeEnum.getDesc((Integer)reqDTO.getPresType()));
        reqDTO.setOrderTypeMsg(OrderTypeEnum.getDesc((Integer)reqDTO.getOrderType()));
        reqDTO.setOrderStatusMsg(OrderStatusEnum.getDesc((Integer)reqDTO.getOrderStatus()));
        if (StringUtils.isEmpty((String)reqDTO.getRecipeDate())) {
            reqDTO.setRecipeDate(DateUtils.getDateString((Long)reqDTO.getCreateTime()));
        }
        if (flag = this.validOrder(Integer.valueOf(itemStatus), Long.valueOf(reqDTO.getExpireTime() * 1000L), reqDTO.getMainId())) {
            itemStatus = DrugMainStatusEnum.USELESS.getValue();
            reqDTO.setItemStatus(Integer.valueOf(itemStatus));
        }
        reqDTO.setMainStatus(DrugMainStatusEnum.getDesc((Integer)itemStatus));
        String remark = this.getPatientRemark(Integer.valueOf(itemStatus), remarkFlag, reqDTO.getPresOrgan(), type);
        reqDTO.setPatientRemark(remark);
        if (StringUtils.isNotEmpty((String)type) && DoctorTypeEnum.DOCTOR.getValue().equals(type) && (itemStatus > DrugMainStatusEnum.PHARMACIST_BACK.getValue() || DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(itemStatus))) {
            reqDTO.setMainStatus("\u5df2\u901a\u8fc7");
        }
        if (StringUtils.isNotEmpty((String)type) && DoctorTypeEnum.PHARMACEUTIST.getValue().equals(type)) {
            if (itemStatus > DrugMainStatusEnum.PHARMACIST_BACK.getValue() || DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(itemStatus)) {
                reqDTO.setMainStatus("\u5408\u7406");
            }
            if (DrugMainStatusEnum.PHARMACIST_BACK.getValue().equals(itemStatus)) {
                reqDTO.setMainStatus("\u4e0d\u5408\u7406");
            }
        }
        if (StringUtils.isNotEmpty((String)type) && (DoctorTypeEnum.PATIENT.getValue().equals(type) || DoctorTypeEnum.SYSTEM.getValue().equals(type))) {
            if (DrugMainStatusEnum.DEPLOYING.getValue().equals(itemStatus)) {
                reqDTO.setMainStatus("\u5df2\u652f\u4ed8");
            }
            if (DrugMainStatusEnum.DEPLOY_BACK.getValue().equals(itemStatus)) {
                reqDTO.setMainStatus("\u5df2\u9000\u6b3e");
            }
        }
        if (prescriptionSource != null && prescriptionSource == 1 && DrugMainStatusEnum.APPROVING.getValue().equals(itemStatus)) {
            reqDTO.setMainStatus("\u5f85\u836f\u5e08\u5ba1\u6838");
        }
        if ((userAddressEntity = this.userAddressMapper.queryByMainId(reqDTO.getMainId())) != null) {
            reqDTO.setAreaInfo(userAddressEntity.getAreaInfo());
            reqDTO.setDetailAddress(userAddressEntity.getDetailAddress());
            reqDTO.setAddress(userAddressEntity.getAreaInfo() + userAddressEntity.getDetailAddress());
        }
        this.setFeeData(reqDTO);
    }

    public DrugPrescriptionEntity queryByMainId(String mainId) {
        return this.mosDrugPrescriptionMapper.queryByMainId(mainId);
    }

    public DrugPrescriptionEntity update(DrugPrescriptionEntity mosDrugPrescription) {
        this.mosDrugPrescriptionMapper.updateByPrimaryKeySelective(mosDrugPrescription);
        return this.queryById(mosDrugPrescription.getxId());
    }

    void setDrugDetaillData(PresDetailResultDTO reqDTO) {
        PharmaceuticalCompanyEntity pharmaceuticalCompanyEntity;
        DrugStoreEntity drugstoreEntity;
        DrugDetailEntity drugDetailEntity = new DrugDetailEntity();
        ArrayList<DrugDetailData> list = new ArrayList<DrugDetailData>();
        drugDetailEntity.setMainId(reqDTO.getMainId());
        List drugDetailList = this.mosDrugDetailMapper.query(drugDetailEntity);
        String storeId = reqDTO.getStoreId();
        if (StringUtils.isNotBlank((String)storeId)) {
            drugstoreEntity = this.mosDrugStoreMapper.queryById(storeId);
            if (Objects.nonNull(drugstoreEntity)) {
                drugstoreEntity.setStoreAddress(drugstoreEntity.getDetailAddress());
            }
            reqDTO.setDrugstore(drugstoreEntity);
        } else if (CollectionUtils.isNotEmpty((Collection)drugDetailList)) {
            drugstoreEntity = this.mosDrugStoreMapper.queryStoreByCode(((DrugDetailEntity)drugDetailList.get(0)).getOrganCode(), ((DrugDetailEntity)drugDetailList.get(0)).getStoreId());
            if (Objects.nonNull(drugstoreEntity)) {
                drugstoreEntity.setStoreAddress(drugstoreEntity.getDetailAddress());
            }
            reqDTO.setDrugstore(drugstoreEntity);
        }
        if (Objects.nonNull(reqDTO.getDrugstore()) && Objects.nonNull(pharmaceuticalCompanyEntity = this.pharmaceuticalCompanyMapper.selectPharmacistById(reqDTO.getDrugstore().getPharmaceuticalCompanyId()))) {
            reqDTO.getDrugstore().setPharmaceuticalCompanyName(pharmaceuticalCompanyEntity.getPharmaceuticalCompanyName());
        }
        reqDTO.setDrugKind(Integer.valueOf(drugDetailList.size()));
        for (DrugDetailEntity entity : drugDetailList) {
            DrugDetailData drugDetailData = new DrugDetailData();
            drugDetailData.setPresDetailId(entity.getxId());
            drugDetailData.setDrugName(entity.getDrugName());
            drugDetailData.setDrugSpec(entity.getDrugSpec());
            drugDetailData.setDuration(entity.getDuration());
            drugDetailData.setManufacturer(entity.getManufacturer());
            if (entity.getSingleDose() != null && StringUtils.isNotEmpty((String)entity.getMeasureUnit()) && StringUtils.isNotEmpty((String)entity.getUsageDesc()) && entity.getDuration() != null) {
                drugDetailData.setDosage("\u6bcf\u6b21" + StringUtil.getNoZeros((String)entity.getSingleDose().toString()) + entity.getMeasureUnit() + "," + entity.getUsageDesc() + "," + entity.getFrequencyDesc());
            }
            if (entity.getAmount() != null) {
                drugDetailData.setAmount(new BigDecimal(StringUtil.getNoZeros((String)entity.getAmount().toString())));
            }
            drugDetailData.setMeasureUnit(entity.getMeasureUnit());
            drugDetailData.setSingleDose(entity.getSingleDose());
            drugDetailData.setFrequencyId(entity.getFrequencyId());
            drugDetailData.setReasonId(entity.getReasonId());
            drugDetailData.setUsageId(entity.getUsageId());
            drugDetailData.setUnitPrice(entity.getUnitPrice().setScale(2, 4).toString());
            drugDetailData.setTotalPrice(entity.getTotalPrice().setScale(2, 4).toString());
            drugDetailData.setReasonDesc(entity.getReasonDesc());
            drugDetailData.setDocRemark(entity.getDocRemark());
            drugDetailData.setVerifyRemark(entity.getVerifyRemark());
            if (StringUtils.isBlank((String)entity.getAmountUnit())) {
                drugDetailData.setAmountUnit(entity.getWholePackingUnit());
            } else {
                drugDetailData.setAmountUnit(entity.getAmountUnit());
            }
            if (DrugTypeEnum.CM.getValue().equals(reqDTO.getPresType())) {
                drugDetailData.setDosage("");
                drugDetailData.setAmountUnit("g");
                if ("HYT".equals(reqDTO.getPresOrgan())) {
                    drugDetailData.setDosage(entity.getUsageDesc() + "," + entity.getFrequencyDesc());
                }
            }
            list.add(drugDetailData);
        }
        if (list.size() == 1) {
            reqDTO.setDrugKindSpec("\u542b" + ((DrugDetailData)list.get(0)).getDrugName() + "\u5171" + list.size() + "\u79cd\u836f\u54c1");
        } else {
            reqDTO.setDrugKindSpec("\u542b" + ((DrugDetailData)list.get(0)).getDrugName() + "...\u7b49\u5171" + list.size() + "\u79cd\u836f\u54c1");
        }
        reqDTO.setDrugDetailData(list);
    }

    void setDrugRemarkData(PresDetailResultDTO reqDTO) {
        ArrayList<DrugRemarkData> list = new ArrayList<DrugRemarkData>();
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setMainId(reqDTO.getMainId());
        List drugRemarkEntityList = this.mosDrugRemarkMapper.query(drugRemarkEntity);
        for (DrugRemarkEntity entity : drugRemarkEntityList) {
            DrugRemarkData data = new DrugRemarkData();
            data.setRemarkUser(entity.getRemarkUser());
            data.setRemarkContent(entity.getRemarkContent());
            data.setRemarkType(entity.getRemarkType());
            data.setRemarkTypeMsg(RemarkTypeEnum.getDesc((Integer)entity.getRemarkType()));
            data.setRemarkTime(Long.valueOf(entity.getxCreateTime().getTime() / 1000L));
            if (RemarkTypeEnum.REFUND.getValue().equals(entity.getRemarkType())) {
                reqDTO.setRefundReason(entity.getRemarkContent());
            }
            list.add(data);
        }
        reqDTO.setDrugRemarkData(list);
    }

    public BaseResponse<PageResult<PatientListResultDTO>> pagingPatientList(PatientListResVO resVO) {
        log.info("=======>\u60a3\u8005\u7aef\u5904\u65b9\u5217\u8868\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)resVO));
        resVO.setOrganCode(AppCodeUtil.tranCode((String)resVO.getOrganCode()));
        PageResult result = new PageResult();
        result.setOrderBy("x_create_time");
        result.setPageNum(resVO.getPageNum());
        result.setPageSize(resVO.getPageSize());
        List list = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)resVO.getPatientIdList())) {
            PageHelper.startPage((int)resVO.getPageNum(), (int)resVO.getPageSize());
            list = this.mosDrugMainMapper.queryByPatientList(resVO);
        }
        this.extracted(resVO.getOrganCode(), resVO.getMainType(), list, null);
        result.setContent(list);
        return BaseResponse.success((Object)result);
    }

    private void extracted(String organCode, Integer mainType, List<PatientListResultDTO> list, String version) {
        Iterator<PatientListResultDTO> iterator = list.iterator();
        while (iterator.hasNext()) {
            DrugDetailEntity drugDetailEntity;
            int drugCount = 0;
            String drugName = "";
            PatientListResultDTO dto = iterator.next();
            boolean remarkFlag = false;
            boolean flag = this.validOrder(dto.getItemStatus(), Long.valueOf(dto.getExpireTime().getTime()), dto.getMainId());
            if (flag) {
                dto.setItemStatus(DrugMainStatusEnum.USELESS.getValue());
            }
            if ((DrugTypeEnum.WM.getValue().equals(dto.getPresType()) || DrugTypeEnum.CTM.getValue().equals(dto.getPresType())) && StringUtils.isNotEmpty((String)version) && "0508".equals(version)) {
                dto.setPresType(DrugTypeEnum.WCTM.getValue());
            }
            dto.setMainStatus(DrugMainStatusEnum.getDesc((Integer)dto.getItemStatus()));
            dto.setOrderTypeMsg(OrderTypeEnum.getDesc((Integer)dto.getOrderType()));
            dto.setPayStatusMsg(OrderStatusEnum.getDesc((Integer)dto.getPayStatus()));
            if (DrugMainStatusEnum.PHARMACIST_BACK.getValue().equals(dto.getItemStatus())) {
                DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
                drugRemarkEntity.setMainId(dto.getMainId());
                List drugRemarkEntityList = this.mosDrugRemarkMapper.query(drugRemarkEntity);
                String remarkContent = ((DrugRemarkEntity)drugRemarkEntityList.get(0)).getRemarkContent();
                if (StringUtils.isNotEmpty((String)remarkContent) && remarkContent.equals("\u5ba1\u6838\u4e0d\u901a\u8fc7\u9000\u6b3e")) {
                    remarkFlag = true;
                }
            }
            String remark = this.getPatientRemark(dto.getItemStatus(), remarkFlag, organCode, null);
            dto.setPatientRemark(remark);
            if (OrderTypeEnum.DRUG_ORDER.getValue().equals(dto.getOrderType())) {
                drugDetailEntity = new DrugDetailEntity();
                drugDetailEntity.setMainId(dto.getMainId());
                List detailList = this.mosDrugDetailMapper.query(drugDetailEntity);
                if (detailList.size() > 0) {
                    DrugStoreEntity drugstoreEntity = this.mosDrugStoreMapper.queryStoreByCode(((DrugDetailEntity)detailList.get(0)).getOrganCode(), ((DrugDetailEntity)detailList.get(0)).getStoreId());
                    dto.setDrugstore(drugstoreEntity);
                }
            }
            if (dto.getDrugSpeciesNum() == 0) {
                drugDetailEntity = new DrugDetailEntity();
                drugDetailEntity.setMainId(dto.getMainId());
                List drugDetailList = this.mosDrugDetailMapper.query(drugDetailEntity);
                if (CollectionUtils.isNotEmpty((Collection)drugDetailList)) {
                    drugCount = drugDetailList.size();
                    drugName = ((DrugDetailEntity)drugDetailList.get(0)).getDrugName();
                }
            } else {
                drugCount = dto.getDrugSpeciesNum();
                drugName = dto.getDrugName();
            }
            if (drugCount == 1) {
                dto.setDrugDesc("\u542b" + drugName + "\u5171" + drugCount + "\u79cd\u836f\u54c1");
            } else {
                dto.setDrugDesc("\u542b" + drugName + "...\u7b49\u5171" + drugCount + "\u79cd\u836f\u54c1");
            }
            dto.setPresTypeMsg(DrugTypeEnum.getDesc((Integer)dto.getPresType()));
            if (DrugMainStatusEnum.DEPLOYING.getValue().equals(dto.getItemStatus())) {
                dto.setMainStatus(DrugMainStatusEnum.DEPLOYING.getDesc());
            }
            if (DrugMainStatusEnum.DEPLOY_BACK.getValue().equals(dto.getItemStatus())) {
                dto.setMainStatus("\u5df2\u9000\u6b3e");
            }
            if (dto.getItemStatus().equals(DrugMainStatusEnum.APPROVING.getValue())) {
                iterator.remove();
            }
            if (dto.getItemStatus().equals(DrugMainStatusEnum.UNPAID.getValue())) {
                iterator.remove();
            }
            try {
                dto.setCreateTime(DateUtils.formatDate((Date)DateUtils.parseDate((String)dto.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss.SSS"), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
            }
            catch (ParseException e) {
                log.info("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
            if (!Objects.nonNull(organCode)) continue;
            dto.setMainType(Integer.valueOf(!Objects.isNull(dto.getMainType()) ? dto.getMainType() : (Integer.valueOf(0).equals(mainType) ? 0 : 1)));
        }
    }

    public BaseResponse<PageResult<DoctorListResultDTO>> pagingDoctor(PageResult<DoctorListResDTO> param) {
        log.info("=======>\u533b\u751f\u7aef\u5904\u65b9\u5217\u8868\u53c2\u6570----->{}", (Object)JSON.toJSONString(param));
        if (StringUtils.isEmpty((String)((DoctorListResDTO)param.getContent().get(0)).getAppCode())) {
            ((DoctorListResDTO)param.getContent().get(0)).setOrganCode(AppCodeUtil.tranCode((String)((DoctorListResDTO)param.getContent().get(0)).getOrganCode()));
        }
        PageResult result = new PageResult();
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List list = this.mosDrugMainMapper.pageQueryDoctor(param);
        log.info("\u533b\u751f\u7aef\u5904\u65b9\u5217\u8868\u67e5\u8be2\u6570\u636e\u5e93\u7ed3\u679clist:{}", (Object)JSON.toJSONString((Object)list));
        list.stream().forEach(dto -> {
            if (dto.getItemStatus() == 41) {
                dto.setItemStatus(Integer.valueOf(40));
            }
            dto.setPresType(DrugTypeEnum.WCTM.getValue());
            int drugCount = 0;
            String drugName = "";
            boolean flag = this.validOrder(dto.getItemStatus(), Long.valueOf(dto.getFailureTime().getTime()), dto.getxId());
            if (flag) {
                dto.setItemStatus(DrugMainStatusEnum.USELESS.getValue());
            }
            if (dto.getDrugSpeciesNum() == 0) {
                DrugDetailEntity drugDetailEntity = new DrugDetailEntity();
                drugDetailEntity.setMainId(dto.getxId());
                List drugDetailList = this.mosDrugDetailMapper.query(drugDetailEntity);
                if (CollectionUtils.isNotEmpty((Collection)drugDetailList)) {
                    drugCount = drugDetailList.size();
                    drugName = ((DrugDetailEntity)drugDetailList.get(0)).getDrugName();
                }
            } else {
                drugCount = dto.getDrugSpeciesNum();
                drugName = dto.getDrugName();
            }
            if (drugCount == 1) {
                dto.setDrugDesc("\u542b" + drugName + "\u5171" + drugCount + "\u79cd\u836f\u54c1");
            } else {
                dto.setDrugDesc("\u542b" + drugName + "...\u7b49\u5171" + drugCount + "\u79cd\u836f\u54c1");
            }
            dto.setPresTypeMsg(DrugTypeEnum.getDesc((Integer)dto.getPresType()));
            dto.setMainStatus(DrugMainStatusEnum.getDesc((Integer)dto.getItemStatus()));
            if (dto.getItemStatus() > 60 || dto.getItemStatus() == 55 || dto.getItemStatus() == 20) {
                dto.setMainStatus("\u5df2\u901a\u8fc7");
            }
        });
        int count = this.mosDrugMainMapper.countDoctor(param);
        int totalPage = PageUtil.getTotalPage((int)count, (int)param.getPageSize());
        result.setPageNum(param.getPageNum());
        result.setPageSize(param.getPageSize());
        result.setTotalPages(totalPage);
        result.setTotal(count);
        result.setContent(list);
        log.info("\u533b\u751f\u7aef\u5904\u65b9\u5217\u8868result:{}", (Object)JSON.toJSONString((Object)result));
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<QueryPresStatusResultDTO> queryPresStatus(String mainId) {
        if (StringUtil.isEmpty((String)mainId)) {
            return BaseResponse.error((String)"\u53c2\u6570\u7f3a\u5931");
        }
        log.info("=======>\u67e5\u8be2\u5904\u65b9\u533b\u5631\u72b6\u6001 - \u533b\u5631ID - mainId:{}", (Object)mainId);
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mainId);
        if (drugMainEntity == null) {
            return BaseResponse.error((String)"\u533b\u5631\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        QueryPresStatusResultDTO resultDTO = new QueryPresStatusResultDTO();
        resultDTO.setItemStatus(drugMainEntity.getItemStatus());
        resultDTO.setMainStatus(DrugMainStatusEnum.getDesc((Integer)drugMainEntity.getItemStatus()));
        return BaseResponse.success((Object)resultDTO);
    }

    public BaseResponse<Object> confirmDelivery(ConfireResVO vo) {
        log.info("=======>\u786e\u8ba4\u53d1\u8d27\u4f20\u53c2----->{}", (Object)JSON.toJSONString((Object)vo));
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(vo.getMainId());
        if (vo.getSendType() == null || vo.getSendType() == 0) {
            return BaseResponse.success((Object)"\u8bf7\u9009\u62e9\u53d1\u8d27\u65b9\u5f0f");
        }
        DrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByMainId(drugMainEntity.getxId());
        mosDrugLogisticsOrderEntity.setSendType(vo.getSendType());
        if (vo.getSendType() == 1) {
            mosDrugLogisticsOrderEntity.setLogisticsName(vo.getLogisticsName());
            mosDrugLogisticsOrderEntity.setMainNo(vo.getMainNo());
        } else {
            mosDrugLogisticsOrderEntity.setDistributor(vo.getDistributor());
            mosDrugLogisticsOrderEntity.setDistributorPhone(vo.getDistributorPhone());
        }
        mosDrugLogisticsOrderEntity.setRemark(vo.getSendRemark());
        this.mosDrugLogisticsOrderMapper.updateByPrimaryKey(mosDrugLogisticsOrderEntity);
        ArrayList<String> mainList = new ArrayList<String>();
        mainList.add(vo.getMainId());
        mainList.stream().forEach(mainId -> {
            DrugExtendEntity drugExtendEntity = this.drugExtendMapper.getByMainId(mainId);
            if (drugExtendEntity == null) {
                drugExtendEntity = new DrugExtendEntity();
                drugExtendEntity.setDeployTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setMainId(drugMainEntity.getxId());
                drugExtendEntity.setxId(GenSeqUtils.getUniqueNo());
                drugExtendEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setAuditStatus(AuditStatusEnum.PASS_STATUS.getValue());
                drugExtendEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setSender(vo.getSender());
                drugExtendEntity.setSendTime(new Date());
                drugExtendEntity.setSendRemark(vo.getSendRemark());
                this.drugExtendMapper.insert(drugExtendEntity);
            } else {
                drugExtendEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setSender(vo.getSender());
                drugExtendEntity.setSendTime(new Date());
                drugExtendEntity.setSendRemark(vo.getSendRemark());
                this.drugExtendMapper.updateByPrimaryKey(drugExtendEntity);
            }
            DrugRemarkEntity remarkEntity = new DrugRemarkEntity();
            remarkEntity.setRemarkType(RemarkTypeEnum.CONFIRMSHIPMENT.getValue());
            remarkEntity.setMainId(mainId);
            remarkEntity.setRemarkUser(vo.getSender());
            remarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            remarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            remarkEntity.setxId(GenSeqUtils.getUniqueNo());
            this.mosDrugRemarkMapper.insert(remarkEntity);
            drugMainEntity.setItemStatus(DrugMainStatusEnum.SENT.getValue());
            drugMainEntity.setxUpdateTime(new Date());
            drugMainEntity.setFailureTime(DateTimeUtil.addDay((Date)new Date(), (int)3));
            RabbitMqUtils.senderDelayedLogisticsOrder((RabbitTemplate)this.rabbitTemplate, (String)mosDrugLogisticsOrderEntity.getOrderSeq(), (Integer)259200);
            this.mosDrugMainMapper.updateByPrimaryKeySelective(drugMainEntity);
        });
        if (!PrescriptionSourceEnum.E_COMMERCE.getValue().equals(drugMainEntity.getPrescriptionSource()) && !PrescriptionSourceEnum.PATIENT_COMMERCE.getValue().equals(drugMainEntity.getPrescriptionSource())) {
            this.dynamicInvokePlatformServer.adapterConfig(DynamicServerTypeEnum.DOCKING_WE_CHAT_PUSH, Integer.valueOf(drugMainEntity.getOrganId()), (Object)new WeChatPushDoctorRemindVO(drugMainEntity.getxId(), PushWeChatMessageActionTypeEnum.MAIN_LOGISTICS_ORDER_SEND_SUCCESS.name()));
        }
        return BaseResponse.success((Object)"\u53d1\u8d27\u4fe1\u606f\u586b\u5199\u6210\u529f");
    }

    public BaseResponse<Object> confirmMedicine(ConfirmMedicineReqVO vo) {
        log.info("=======>\u786e\u8ba4\u53d6\u836f - \u533b\u5631ID - mainId:{}", (Object)vo.getMainId());
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(vo.getMainId());
        if (drugMainEntity == null) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u533b\u5631\u8bb0\u5f55");
        }
        if (!DrugMainStatusEnum.TO_TAKE.getValue().equals(drugMainEntity.getItemStatus())) {
            return BaseResponse.error((String)"\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u652f\u6301\u53d6\u836f");
        }
        if (StringUtils.isEmpty((String)vo.getFetchMedicalCode())) {
            return BaseResponse.error((String)"\u8bf7\u586b\u5199\u53d6\u836f\u7801");
        }
        if (!vo.getFetchMedicalCode().equals(drugMainEntity.getFetchMedicalCode())) {
            return BaseResponse.error((String)"\u53d6\u8d27\u7801\u9519\u8bef\uff0c\u60a3\u8005\u8ba4\u8bc1\u5931\u8d25");
        }
        drugMainEntity.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
        drugMainEntity.setFailureTime(DateTimeUtil.addDay((Date)new Date(), (int)3));
        DrugRemarkEntity remarkEntity = new DrugRemarkEntity();
        remarkEntity.setRemarkType(RemarkTypeEnum.TAKE_MEDICAL.getValue());
        remarkEntity.setMainId(vo.getMainId());
        remarkEntity.setRemarkUser(drugMainEntity.getPatientName());
        remarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        remarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        remarkEntity.setxId(GenSeqUtils.getUniqueNo());
        this.mosDrugRemarkMapper.insert(remarkEntity);
        this.mosDrugMainMapper.updateByPrimaryKeySelective(drugMainEntity);
        if (!PrescriptionSourceEnum.PATIENT_COMMERCE.getValue().equals(drugMainEntity.getPrescriptionType()) && !PrescriptionSourceEnum.E_COMMERCE.getValue().equals(drugMainEntity.getPrescriptionType())) {
            MLUpdateSynchronizationMainStatusVO mlUpdateSynchronizationMainStatusVO = new MLUpdateSynchronizationMainStatusVO();
            mlUpdateSynchronizationMainStatusVO.setStatus(MLDrugMainOptionEnum.ML_MAIN_SUCCESS.getValue().toString());
            mlUpdateSynchronizationMainStatusVO.setMainId(drugMainEntity.getxId());
            this.dynamicInvokePlatformServer.adapterConfig(DynamicMethodTypeEnum.DRUG_STORE_UPDATE_MAIN_STATUS.name(), Integer.valueOf(drugMainEntity.getOrganId()), (Object)mlUpdateSynchronizationMainStatusVO);
        }
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("doctorName", drugMainEntity.getPresDoctorName());
                this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy-hzdyyqy", drugMainEntity.getPatientPhone(), hashMap);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new BusinessException(e.getMessage());
            }
        });
        return BaseResponse.success((Object)"\u53d6\u8d27\u7801\u6b63\u786e\uff0c\u60a3\u8005\u8ba4\u8bc1\u6210\u529f");
    }

    public BaseResponse<PrescriptionDataResVO> getDataBoard(PrescriptionDataReqVO prescriptionDataReqVO) {
        String appCode = prescriptionDataReqVO.getAppCode();
        String organId = prescriptionDataReqVO.getOrganId();
        String startTime = prescriptionDataReqVO.getStartTime();
        String endTime = prescriptionDataReqVO.getEndTime();
        if (StringUtil.isNotEmpty((String)startTime)) {
            startTime = startTime + " 00:00:00";
        }
        if (StringUtil.isNotEmpty((String)endTime)) {
            endTime = endTime + " 23:59:59";
        }
        PrescriptionDataResVO prescriptionDataResVO = new PrescriptionDataResVO();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        PrescriptionDataResCommonVO newData = this.mosDrugMainMapper.getDataBoard(0, appCode, organId, startTime, endTime);
        newData.setFee(numberFormat.format(newData.getFeeFloat()));
        PrescriptionDataResCommonVO payData = this.mosDrugMainMapper.getDataBoard(1, appCode, organId, startTime, endTime);
        payData.setFee(numberFormat.format(payData.getFeeFloat()));
        PrescriptionDataResCommonVO refundData = this.mosDrugMainMapper.getDataBoard(2, appCode, organId, startTime, endTime);
        refundData.setFee(numberFormat.format(refundData.getFeeFloat()));
        PrescriptionDataResCommonVO uselessData = this.mosDrugMainMapper.getDataBoard(3, appCode, organId, startTime, endTime);
        uselessData.setFee(numberFormat.format(uselessData.getFeeFloat()));
        uselessData.setUnlessCount(this.mosDrugMainMapper.getUnPayCount(appCode, organId, startTime, endTime));
        prescriptionDataResVO.setNewData(newData);
        prescriptionDataResVO.setPayData(payData);
        prescriptionDataResVO.setRefundData(refundData);
        prescriptionDataResVO.setUselessData(uselessData);
        PrescriptionDataResCommonPercentVO countPercent = new PrescriptionDataResCommonPercentVO();
        if (newData.getCount() != 0) {
            countPercent.setPay(numberFormat.format((float)payData.getCount().intValue() * 100.0f / (float)newData.getCount().intValue()) + "%");
            countPercent.setRefund(numberFormat.format((float)refundData.getCount().intValue() * 100.0f / (float)newData.getCount().intValue()) + "%");
            countPercent.setUnless(numberFormat.format((float)uselessData.getCount().intValue() * 100.0f / (float)newData.getCount().intValue()) + "%");
        } else {
            countPercent.setPay("-");
            countPercent.setRefund("-");
            countPercent.setUnless("-");
        }
        prescriptionDataResVO.setCountPercent(countPercent);
        PrescriptionDataResCommonPercentVO feePercent = new PrescriptionDataResCommonPercentVO();
        if (newData.getFeeFloat() != 0.0f) {
            feePercent.setPay(numberFormat.format(payData.getFeeFloat() * 100.0f / newData.getFeeFloat()) + "%");
            feePercent.setRefund(numberFormat.format(refundData.getFeeFloat() * 100.0f / newData.getFeeFloat()) + "%");
            feePercent.setUnless(numberFormat.format(uselessData.getFeeFloat() * 100.0f / newData.getFeeFloat()) + "%");
        } else {
            feePercent.setPay("-");
            feePercent.setRefund("-");
            feePercent.setUnless("-");
        }
        prescriptionDataResVO.setFeePercent(feePercent);
        log.info("\u8fd4\u56de\u7684\u770b\u677f\u6570\u636e:{}", (Object)JSON.toJSONString((Object)prescriptionDataResVO));
        return BaseResponse.success((Object)prescriptionDataResVO);
    }

    public BaseResponse<PrescriptionDataEChartResVO> getDataBoardEChart(PrescriptionDataEChartReqVO prescriptionDataEChartReqVO) {
        Date startDate;
        String appCode = prescriptionDataEChartReqVO.getAppCode();
        String organId = prescriptionDataEChartReqVO.getOrganId();
        String startTime = prescriptionDataEChartReqVO.getStartTime();
        String endTime = prescriptionDataEChartReqVO.getEndTime();
        Integer granularityType = prescriptionDataEChartReqVO.getGranularityType();
        String mysqlFormatReg = MYSQL_FORMAT_REG_DAY;
        if (GranularityTypeEnum.WEEKS.getValue().equals(granularityType)) {
            mysqlFormatReg = MYSQL_FORMAT_REG_WEEK;
            startDate = DateUtils.getDayByDateInBoundary((Date)DateUtils.parseY_M_DDate((String)startTime), (TemporalAdjuster)DayOfWeek.MONDAY);
            startTime = DateUtils.formatDate((Date)startDate, (Object[])new Object[0]);
            if (DateUtils.getWeekDay((Date)DateUtils.parseY_M_DDate((String)endTime)) != 0) {
                Date lastWeedDate = DateUtils.addDay((Date)DateUtils.parseY_M_DDate((String)endTime), (int)-7);
                Date endDate = DateUtils.getDayByDateInBoundary((Date)lastWeedDate, (TemporalAdjuster)DayOfWeek.SUNDAY);
                endTime = DateUtils.formatDate((Date)endDate, (Object[])new Object[0]);
            }
        } else if (GranularityTypeEnum.MONTHS.getValue().equals(granularityType)) {
            mysqlFormatReg = MYSQL_FORMAT_REG_MONTH;
            startDate = DateUtils.getDayByDateInBoundary((Date)DateUtils.parseY_M_DDate((String)startTime), (TemporalAdjuster)TemporalAdjusters.firstDayOfMonth());
            startTime = DateUtils.formatDate((Date)startDate, (Object[])new Object[0]);
            Date endDate = DateUtils.getDayByDateInBoundary((Date)DateUtils.parseY_M_DDate((String)endTime), (TemporalAdjuster)TemporalAdjusters.lastDayOfMonth());
            if (!DateUtils.parseY_M_DDate((String)endTime).equals(endDate)) {
                Calendar rightNow = Calendar.getInstance();
                rightNow.setTime(DateUtils.parseY_M_DDate((String)endTime));
                rightNow.add(2, -1);
                endTime = DateUtils.formatDate((Date)DateUtils.getDayByDateInBoundary((Date)rightNow.getTime(), (TemporalAdjuster)TemporalAdjusters.lastDayOfMonth()), (Object[])new Object[0]);
            }
        }
        PrescriptionDataEChartResVO prescriptionDataEChartResVO = new PrescriptionDataEChartResVO();
        prescriptionDataEChartResVO.setStartTime(startTime);
        prescriptionDataEChartResVO.setEndTime(endTime);
        String[] typeNameArray = new String[]{INTER_ORDER, PAYMENT_ORDER, REFUND_ORDER, INVALID_ORDER};
        prescriptionDataEChartResVO.setTypeName(Arrays.asList(typeNameArray));
        if (StringUtil.isNotEmpty((String)startTime)) {
            startTime = startTime + " 00:00:00";
        }
        if (StringUtil.isNotEmpty((String)endTime)) {
            endTime = endTime + " 23:59:59";
        }
        List newData = this.mosDrugMainMapper.getDataBoardEChart(0, mysqlFormatReg, appCode, organId, startTime, endTime);
        List payData = this.mosDrugMainMapper.getDataBoardEChart(1, mysqlFormatReg, appCode, organId, startTime, endTime);
        List refundData = this.mosDrugMainMapper.getDataBoardEChart(2, mysqlFormatReg, appCode, organId, startTime, endTime);
        List uselessData = this.mosDrugMainMapper.getDataBoardEChart(3, mysqlFormatReg, appCode, organId, startTime, endTime);
        ArrayList<String> xAxis = new ArrayList<String>();
        ArrayList<String> xAxisParams = new ArrayList<String>();
        Date start = DateUtils.parseFullFormatDate((String)startTime);
        Date trueEnd = DateUtils.parseFullFormatDate((String)endTime);
        Calendar rightNow = Calendar.getInstance();
        while (start.before(trueEnd)) {
            String timeParam;
            String time;
            Date end;
            rightNow.setTime(start);
            if (GranularityTypeEnum.DAYS.getValue().equals(granularityType)) {
                end = start;
                time = DateUtils.formatDate((Date)start, (Object[])new Object[]{YYYY_MM_DD});
                timeParam = DateUtils.formatDate((Date)start, (Object[])new Object[0]);
            } else if (GranularityTypeEnum.WEEKS.getValue().equals(granularityType)) {
                rightNow.add(7, 6);
                end = rightNow.getTime();
                StringBuffer timeBuffer = new StringBuffer();
                time = timeBuffer.append(DateUtils.formatDate((Date)start, (Object[])new Object[]{YYYY_MM_DD})).append(" \u81f3 ").append(DateUtils.formatDate((Date)end, (Object[])new Object[]{YYYY_MM_DD})).toString();
                StringBuffer timeParamBuffer = new StringBuffer();
                Integer weekOfYear = DateUtils.getWeekOfYearByDate((Date)start);
                String weekOfYearStr = weekOfYear + "";
                if (weekOfYear < 10) {
                    weekOfYearStr = "0" + weekOfYear;
                }
                timeParam = timeParamBuffer.append(DateUtils.formatDate((Date)start, (Object[])new Object[]{"yyyy"})).append("-").append(weekOfYearStr).toString();
            } else {
                rightNow.add(2, 1);
                rightNow.add(7, -1);
                end = rightNow.getTime();
                time = DateUtils.formatDate((Date)start, (Object[])new Object[]{"yyyy-MM"});
                timeParam = DateUtils.formatDate((Date)start, (Object[])new Object[]{"yyyy-MM"});
            }
            rightNow.setTime(end);
            rightNow.add(7, 1);
            start = rightNow.getTime();
            xAxis.add(time);
            xAxisParams.add(timeParam);
        }
        prescriptionDataEChartResVO.setXAxis(xAxis);
        ArrayList<PrescriptionDataEChartResCommonVO> series = new ArrayList<PrescriptionDataEChartResCommonVO>();
        series.add(this.organizeEChartData(INTER_ORDER, xAxisParams, newData));
        series.add(this.organizeEChartData(PAYMENT_ORDER, xAxisParams, payData));
        series.add(this.organizeEChartData(REFUND_ORDER, xAxisParams, refundData));
        series.add(this.organizeEChartData(INVALID_ORDER, xAxisParams, uselessData));
        prescriptionDataEChartResVO.setSeries(series);
        log.info("\u8fd4\u56de\u7684\u770b\u677f\u56fe\u8868\u6570\u636e:{}", (Object)JSON.toJSONString((Object)prescriptionDataEChartResVO));
        return BaseResponse.success((Object)prescriptionDataEChartResVO);
    }

    private PrescriptionDataEChartResCommonVO organizeEChartData(String name, List<String> xAxis, List<PrescriptionDataEChartResDTO> data) {
        for (int i = 1; i < data.size(); ++i) {
            PrescriptionDataEChartResDTO pd = data.get(i);
            if (!pd.getTime().endsWith("-00")) continue;
            PrescriptionDataEChartResDTO lastWeedPd = data.get(i - 1);
            lastWeedPd.setValue(lastWeedPd.getValue() + pd.getValue());
        }
        PrescriptionDataEChartResCommonVO dataResult = new PrescriptionDataEChartResCommonVO();
        dataResult.setName(name);
        ArrayList<Double> dataList = new ArrayList<Double>();
        Map<String, Double> dataMap = data.stream().collect(Collectors.toMap(PrescriptionDataEChartResDTO::getTime, PrescriptionDataEChartResDTO::getValue));
        for (String time : xAxis) {
            Double currValue = dataMap.get(time);
            if (Objects.isNull(currValue)) {
                dataList.add(0.0);
                continue;
            }
            dataList.add(currValue);
        }
        dataResult.setData(dataList);
        return dataResult;
    }

    public void exportExcelDataBoard(PrescriptionDataEChartReqVO prescriptionDataEChartReqVO, HttpServletResponse response) {
        String appCode = prescriptionDataEChartReqVO.getAppCode();
        String organId = prescriptionDataEChartReqVO.getOrganId();
        String startTime = prescriptionDataEChartReqVO.getStartTime();
        String endTime = prescriptionDataEChartReqVO.getEndTime();
        Integer granularityType = prescriptionDataEChartReqVO.getGranularityType();
        PrescriptionDataReqVO pParam = new PrescriptionDataReqVO();
        pParam.setAppCode(appCode);
        pParam.setOrganId(organId);
        pParam.setStartTime(startTime);
        pParam.setEndTime(endTime);
        BaseResponse db = this.getDataBoard(pParam);
        PrescriptionDataResVO bData = (PrescriptionDataResVO)db.getData();
        BaseResponse b = this.getDataBoardEChart(prescriptionDataEChartReqVO);
        PrescriptionDataEChartResVO bEChartData = (PrescriptionDataEChartResVO)b.getData();
        try {
            String granularityTypeStr;
            XSSFWorkbook workbook = new XSSFWorkbook();
            Sheet sheet1 = workbook.createSheet();
            sheet1.setColumnWidth(0, 4000);
            sheet1.setColumnWidth(1, 7000);
            workbook.setSheetName(0, "\u6307\u6807\u6570\u636e");
            Row rowHeader = sheet1.createRow(0);
            rowHeader.createCell(0).setCellValue("\u65f6\u95f4\u8303\u56f4\uff1a");
            rowHeader.createCell(1).setCellValue(startTime + " \u81f3 " + endTime);
            rowHeader = sheet1.createRow(1);
            rowHeader.createCell(0).setCellValue("\u8868\u683c\u5185\u5bb9");
            rowHeader.createCell(1).setCellValue("\u6307\u6807\u6570\u636e");
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            CellRangeAddress region = new CellRangeAddress(3, 6, 0, 0);
            sheet1.addMergedRegion(region);
            rowHeader = sheet1.createRow(3);
            Cell cell = rowHeader.createCell(0);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(INTER_ORDER);
            rowHeader.createCell(1).setCellValue("\u65b0\u589e\u8ba2\u5355\u6570");
            rowHeader = sheet1.createRow(4);
            rowHeader.createCell(1).setCellValue(bData.getNewData().getCount() + "");
            rowHeader = sheet1.createRow(5);
            rowHeader.createCell(1).setCellValue("\u65b0\u589e\u8ba2\u5355\u91d1\u989d");
            rowHeader = sheet1.createRow(6);
            rowHeader.createCell(1).setCellValue(bData.getNewData().getFee());
            region = new CellRangeAddress(9, 12, 0, 0);
            sheet1.addMergedRegion(region);
            rowHeader = sheet1.createRow(9);
            cell = rowHeader.createCell(0);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(PAYMENT_ORDER);
            rowHeader.createCell(1).setCellValue("\u5b9e\u9645\u652f\u4ed8\u8ba2\u5355\u6570");
            rowHeader = sheet1.createRow(10);
            rowHeader.createCell(1).setCellValue(bData.getPayData().getCount() + "");
            rowHeader = sheet1.createRow(11);
            rowHeader.createCell(1).setCellValue(ACTUAL_ORDER);
            rowHeader = sheet1.createRow(12);
            rowHeader.createCell(1).setCellValue(bData.getPayData().getFee());
            region = new CellRangeAddress(15, 18, 0, 0);
            sheet1.addMergedRegion(region);
            rowHeader = sheet1.createRow(15);
            cell = rowHeader.createCell(0);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(REFUND_ORDER);
            rowHeader.createCell(1).setCellValue("\u9000\u6b3e\u8ba2\u5355\u6570");
            rowHeader = sheet1.createRow(16);
            rowHeader.createCell(1).setCellValue(bData.getRefundData().getCount() + "");
            rowHeader = sheet1.createRow(17);
            rowHeader.createCell(1).setCellValue(REFUND_ORDER_AMOUNT);
            rowHeader = sheet1.createRow(18);
            rowHeader.createCell(1).setCellValue(bData.getRefundData().getFee());
            region = new CellRangeAddress(21, 24, 0, 0);
            sheet1.addMergedRegion(region);
            rowHeader = sheet1.createRow(21);
            cell = rowHeader.createCell(0);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(INVALID_ORDER);
            rowHeader.createCell(1).setCellValue("\u5931\u6548\u8ba2\u5355\u6570");
            rowHeader = sheet1.createRow(22);
            rowHeader.createCell(1).setCellValue(bData.getUselessData().getCount() + "");
            rowHeader = sheet1.createRow(23);
            rowHeader.createCell(1).setCellValue(INVALID_ORDER_AMOUNT);
            rowHeader = sheet1.createRow(24);
            rowHeader.createCell(1).setCellValue(bData.getUselessData().getFee());
            rowHeader = sheet1.createRow(27);
            rowHeader.createCell(0).setCellValue("\u8ba2\u5355\u6570\u91cf");
            rowHeader.createCell(1).setCellValue("\u5360\u6bd4");
            rowHeader = sheet1.createRow(28);
            rowHeader.createCell(0).setCellValue("\u5b9e\u9645\u652f\u4ed8\u8ba2\u5355\u6570\u91cf");
            rowHeader.createCell(1).setCellValue(bData.getCountPercent().getPay());
            rowHeader = sheet1.createRow(29);
            rowHeader.createCell(0).setCellValue("\u9000\u6b3e\u8ba2\u5355\u6570\u91cf");
            rowHeader.createCell(1).setCellValue(bData.getCountPercent().getRefund());
            rowHeader = sheet1.createRow(30);
            rowHeader.createCell(0).setCellValue("\u5931\u6548\u8ba2\u5355\u6570\u91cf");
            rowHeader.createCell(1).setCellValue(bData.getCountPercent().getUnless());
            rowHeader = sheet1.createRow(32);
            rowHeader.createCell(0).setCellValue("\u8ba2\u5355\u91d1\u989d");
            rowHeader.createCell(1).setCellValue("\u5360\u6bd4");
            rowHeader = sheet1.createRow(33);
            rowHeader.createCell(0).setCellValue(ACTUAL_ORDER);
            rowHeader.createCell(1).setCellValue(bData.getFeePercent().getPay());
            rowHeader = sheet1.createRow(34);
            rowHeader.createCell(0).setCellValue(REFUND_ORDER_AMOUNT);
            rowHeader.createCell(1).setCellValue(bData.getFeePercent().getRefund());
            rowHeader = sheet1.createRow(35);
            rowHeader.createCell(0).setCellValue(INVALID_ORDER_AMOUNT);
            rowHeader.createCell(1).setCellValue(bData.getFeePercent().getUnless());
            Sheet sheet2 = workbook.createSheet();
            sheet2.setColumnWidth(0, 7000);
            sheet2.setColumnWidth(1, 7000);
            sheet2.setColumnWidth(2, 7000);
            sheet2.setColumnWidth(3, 7000);
            sheet2.setColumnWidth(4, 7000);
            workbook.setSheetName(1, "\u6307\u6807\u5bf9\u6bd4");
            rowHeader = sheet2.createRow(0);
            rowHeader.createCell(0).setCellValue("\u65f6\u95f4\u8303\u56f4\uff1a");
            rowHeader.createCell(1).setCellValue(bEChartData.getStartTime() + " \u81f3 " + bEChartData.getEndTime());
            switch (granularityType) {
                case 0: {
                    granularityTypeStr = "\u65e5\u7c92\u5ea6";
                    break;
                }
                case 1: {
                    granularityTypeStr = "\u5468\u7c92\u5ea6";
                    break;
                }
                default: {
                    granularityTypeStr = "\u6708\u7c92\u5ea6";
                }
            }
            rowHeader.createCell(2).setCellValue(granularityTypeStr);
            rowHeader = sheet2.createRow(1);
            rowHeader.createCell(0).setCellValue("\u8868\u683c\u5185\u5bb9");
            rowHeader.createCell(1).setCellValue("\u6307\u6807\u5bf9\u6bd4");
            rowHeader = sheet2.createRow(4);
            rowHeader.createCell(0).setCellValue("\u65f6\u95f4");
            rowHeader.createCell(1).setCellValue("\u65b0\u589e\u8ba2\u5355\u91d1\u989d");
            rowHeader.createCell(2).setCellValue(ACTUAL_ORDER);
            rowHeader.createCell(3).setCellValue(REFUND_ORDER_AMOUNT);
            rowHeader.createCell(4).setCellValue(INVALID_ORDER_AMOUNT);
            for (int i = 0; i < bEChartData.getXAxis().size(); ++i) {
                rowHeader = sheet2.createRow(5 + i);
                rowHeader.createCell(0).setCellValue((String)bEChartData.getXAxis().get(i));
                rowHeader.createCell(1).setCellValue(((PrescriptionDataEChartResCommonVO)bEChartData.getSeries().get(0)).getData().get(i) + "");
                rowHeader.createCell(2).setCellValue(((PrescriptionDataEChartResCommonVO)bEChartData.getSeries().get(1)).getData().get(i) + "");
                rowHeader.createCell(3).setCellValue(((PrescriptionDataEChartResCommonVO)bEChartData.getSeries().get(2)).getData().get(i) + "");
                rowHeader.createCell(4).setCellValue(((PrescriptionDataEChartResCommonVO)bEChartData.getSeries().get(3)).getData().get(i) + "");
            }
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u533b\u836f\u4e91\u6570\u636e\u62a5\u8868.xlsx", "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u62a5\u8868\u5bfc\u51faexcel\u6587\u4ef6\u5f02\u5e38{}", (Throwable)e);
        }
    }

    void setFeeData(PresDetailResultDTO reqDTO) {
        BigDecimal totalPrice = new BigDecimal("0.0");
        BigDecimal totalAmount = new BigDecimal("0.0");
        BigDecimal otherAmount = new BigDecimal("0.0");
        ArrayList<OtherFeeData> askFeeDataList = new ArrayList<OtherFeeData>();
        ArrayList<OtherFeeData> distributionFeeDataList = new ArrayList<OtherFeeData>();
        OtherFeeData serviceData = null;
        OtherFeeData courierData = null;
        String courierPrice = "0";
        String serviceFee = "0";
        if (reqDTO.getDrugstore() != null) {
            courierPrice = reqDTO.getDrugstore().getExpressFee();
            serviceFee = reqDTO.getDrugstore().getServiceFee();
        }
        serviceData = new OtherFeeData("\u836f\u5e08\u670d\u52a1\u8d39\u53ca\u4fdd\u9669\u8d39", BigDecimalUtil.getPriceByString((String)serviceFee), 1);
        courierData = new OtherFeeData("\u914d\u9001\u8d39", BigDecimalUtil.getPriceByString((String)courierPrice), 1);
        AskFeeData askFeeData = new AskFeeData();
        totalAmount = totalPrice = totalPrice.add(reqDTO.getPrice()).add(BigDecimalUtil.getPriceByString((String)serviceFee));
        askFeeData.setTotalPrice(totalPrice);
        askFeeData.setTotalAmount(totalAmount);
        askFeeDataList.add(serviceData);
        askFeeData.setOtherFeeData(askFeeDataList);
        reqDTO.setAskFee(askFeeData);
        DistributionFeeData distributionFeeData = new DistributionFeeData();
        totalAmount = totalPrice = totalPrice.add(BigDecimalUtil.getPriceByString((String)courierPrice));
        distributionFeeData.setTotalPrice(totalPrice);
        distributionFeeData.setTotalAmount(totalAmount);
        distributionFeeDataList.add(serviceData);
        distributionFeeDataList.add(courierData);
        distributionFeeData.setOtherFeeData(distributionFeeDataList);
        reqDTO.setDistributionFee(distributionFeeData);
        if (reqDTO.getOrderType() != null) {
            otherAmount = reqDTO.getOrderType() == 1 ? otherAmount.add(BigDecimalUtil.getPriceByString((String)serviceFee)) : otherAmount.add(BigDecimalUtil.getPriceByString((String)serviceFee)).add(BigDecimalUtil.getPriceByString((String)courierPrice));
            reqDTO.setOtherAmount(otherAmount);
        }
    }

    private String getPatientRemark(Integer itemStatus, boolean remarkFlag, String appCode, String type) {
        DrugMainStatusEnum statusEnum = DrugMainStatusEnum.getEnum((Integer)itemStatus);
        String remark = null;
        switch (1.$SwitchMap$com$ebaiyihui$circulation$common$enums$DrugMainStatusEnum[statusEnum.ordinal()]) {
            case 1: {
                remark = "\u56e0\u836f\u623f\u7f3a\u8d27,\u6b3e\u9879\u5df2\u6210\u529f\u9000\u56de";
                break;
            }
            case 2: {
                remark = "\u5904\u65b9\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u8be5\u5904\u65b9\u5df2\u9000\u56de";
                if (!StringUtils.isNotEmpty((String)type) || !DoctorTypeEnum.PHARMACEUTIST.getValue().equals(type)) break;
                remark = "\u5904\u65b9\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u5df2\u9000\u56de\u7ed9\u533b\u751f";
                break;
            }
            case 3: {
                remark = "";
                break;
            }
            case 4: {
                remark = "\u672a\u5728\u6709\u6548\u671f\u6210\u529f\u7f34\u8d39";
                break;
            }
            case 5: {
                if (StringUtils.isNotEmpty((String)type) && DoctorTypeEnum.PHARMACEUTIST.getValue().equals(type)) {
                    remark = "\u8bf7\u5c3d\u5feb\u5ba1\u6838\u5904\u65b9";
                    break;
                }
                remark = "\u7b49\u5f85\u836f\u5e08\u5ba1\u6838";
                break;
            }
            case 6: {
                remark = "\u7b49\u5f85\u836f\u5e08\u914d\u836f";
                break;
            }
            case 7: {
                remark = "\u836f\u5e08\u914d\u836f\u5b8c\u6210\uff0c\u7b49\u5f85\u53d6\u836f";
                break;
            }
            case 8: {
                remark = "\u53d6\u836f\u5b8c\u6210";
                break;
            }
            case 9: {
                remark = "\u7b49\u5f85\u7269\u6d41\u63fd\u4ef6";
                break;
            }
            case 10: {
                remark = "\u5feb\u9012\u5df2\u53d1\u51fa,\u8bf7\u6ce8\u610f\u67e5\u6536";
                break;
            }
            case 11: {
                remark = "\u5feb\u9012\u5df2\u7b7e\u6536";
                break;
            }
        }
        if (itemStatus > 60 || itemStatus == 55) {
            remark = StringUtils.isNotEmpty((String)type) && DoctorTypeEnum.PHARMACEUTIST.getValue().equals(type) ? "\u5904\u65b9\u5ba1\u6838\u5df2\u901a\u8fc7\uff0c\u5df2\u53d1\u9001\u5411\u60a3\u8005" : "\u5904\u65b9\u5ba1\u6838\u5df2\u901a\u8fc7\uff0c\u8be5\u5904\u65b9\u5df2\u53d1\u9001\u60a3\u8005";
        }
        return remark;
    }

    private boolean validOrder(Integer itemStatus, Long expireTime, String mainId) {
        boolean flag = false;
        if (DrugMainStatusEnum.UNPAID.getValue().equals(itemStatus)) {
            Long nowTime = System.currentTimeMillis();
            if (expireTime < nowTime) {
                DrugMainEntity drugMainEntity = new DrugMainEntity();
                drugMainEntity.setxId(mainId);
                drugMainEntity.setItemStatus(DrugMainStatusEnum.USELESS.getValue());
                this.mosDrugMainMapper.updateByPrimaryKeySelective(drugMainEntity);
                flag = true;
            }
        }
        return flag;
    }

    private Integer replacementWriteOffCode(Integer Status) {
        if (Status.equals(DrugMainStatusEnum.ZRYH_UNPAID.getValue()) || Status.equals(DrugMainStatusEnum.OFFLINE_CONFIRM.getValue()) || Status.equals(DrugMainStatusEnum.DEPLOYING.getValue()) || Status.equals(DrugMainStatusEnum.TO_TAKE.getValue()) || Status.equals(DrugMainStatusEnum.TO_SEND.getValue())) {
            return DrugMainStatusEnum.NOTWRITTEROff.getValue();
        }
        if (Status.equals(DrugMainStatusEnum.FINISH.getValue()) || Status.equals(DrugMainStatusEnum.SENT.getValue())) {
            return DrugMainStatusEnum.WRITTEROff.getValue();
        }
        if (Status.equals(DrugMainStatusEnum.USELESS.getValue()) || Status.equals(DrugMainStatusEnum.UNPAID_TIME_OUT.getValue()) || Status.equals(DrugMainStatusEnum.DEPLOY_BACK.getValue())) {
            return DrugMainStatusEnum.EXPIRED.getValue();
        }
        return Status;
    }

    static {
        unitList.add("\u888b");
        unitList.add("\u6761");
    }
}

