/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.AccountInfoMapper;
import com.ebaiyihui.circulation.mapper.MosDrugDetailMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugStoreMapper;
import com.ebaiyihui.circulation.mapper.MosHospitalStoreRegMapper;
import com.ebaiyihui.circulation.pojo.dto.GetStoreVODTO;
import com.ebaiyihui.circulation.pojo.dto.load.StoreExcelDTO;
import com.ebaiyihui.circulation.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugStoreEntity;
import com.ebaiyihui.circulation.pojo.entity.HospitalStoreRegEntity;
import com.ebaiyihui.circulation.pojo.vo.circulation.OrderPagingListReqVO;
import com.ebaiyihui.circulation.pojo.vo.item.ShoppingDrugDetailVO;
import com.ebaiyihui.circulation.pojo.vo.store.AccountResVO;
import com.ebaiyihui.circulation.pojo.vo.store.DeleteDrugstoreReqVO;
import com.ebaiyihui.circulation.pojo.vo.store.DoctorListReqVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugStoreListReqVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugStoreListResVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugStoreReqVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugStoreResVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugstoreInfoResVO;
import com.ebaiyihui.circulation.pojo.vo.store.DrugstoreSaveReqVO;
import com.ebaiyihui.circulation.pojo.vo.store.GetStoreVO;
import com.ebaiyihui.circulation.pojo.vo.store.OnlineStatusReqVO;
import com.ebaiyihui.circulation.service.IDataAuthService;
import com.ebaiyihui.circulation.service.IHospitalStoreRegService;
import com.ebaiyihui.circulation.service.MosDrugStoreService;
import com.ebaiyihui.circulation.utils.BigDecimalUtil;
import com.ebaiyihui.circulation.utils.ExcelUtils;
import com.ebaiyihui.circulation.utils.drugutil.DrugHandling;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.medicalcloud.pojo.dto.store.DrugStoreListResDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.PatientChooseDrugStoreReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.PatientChooseDrugStoreResVo;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.SearchPharmacyVo;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.SearchStoreByMl;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.page.DrugStoreManageListReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.page.DrugStoreManageListResVO;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class MosDrugStoreServiceImpl
implements MosDrugStoreService {
    private static final Logger log = LoggerFactory.getLogger(MosDrugStoreServiceImpl.class);
    public static final int ONETHOUSAND = 1000;
    @Autowired
    private MosDrugStoreMapper mosDrugStoreMapper;
    @Autowired
    private IHospitalStoreRegService insterHospitalStoreReg;
    @Autowired
    private MosDrugDetailMapper mosDrugDetailMapper;
    @Autowired
    private MosHospitalStoreRegMapper mosHospitalStoreRegMapper;
    @Autowired
    private IDataAuthService iDataAuthService;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private AccountInfoMapper accountInfoMapper;
    public static final Integer INVALID_STATUS = 0;
    public static final Integer STATUS = 1;
    public static final int ONE = 1;
    public static final int ZERO = 0;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> saveDrugStore(DrugstoreSaveReqVO drugstoreSaveReqVO) {
        log.info("\u8c03\u7528\u4e86\u4fdd\u5b58\u836f\u623f\u7684\u63a5\u53e3");
        if (drugstoreSaveReqVO.getHospitalIds() == null) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u533b\u9662id");
        }
        int count = 0;
        DrugStoreEntity entity = new DrugStoreEntity();
        BeanUtils.copyProperties((Object)drugstoreSaveReqVO, (Object)entity);
        entity.setStoreAddress(drugstoreSaveReqVO.getDetailAddress());
        entity.setDetailAddress(drugstoreSaveReqVO.getDetailAddress());
        String drugstoreId = drugstoreSaveReqVO.getId();
        if (StringUtils.isNotEmpty((String)drugstoreId)) {
            log.info("=====\u4fee\u6539\u836f\u623f\u4fe1\u606f====");
            DrugStoreEntity storeEntity = this.mosDrugStoreMapper.queryById(drugstoreId);
            if (storeEntity == null) {
                throw new BusinessException("\u836f\u623f\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            entity.setUpdateTime(new Date());
            entity.setxId(storeEntity.getxId());
            count = this.mosDrugStoreMapper.updateById(entity);
            log.info("\u4fee\u6539\u836f\u623f\u4fe1\u606f\u6210\u529f\uff0c\u6761\u6570\u4e3a:{}", (Object)count);
            if (!storeEntity.getPharmaceuticalCompanyId().equals(entity.getPharmaceuticalCompanyId())) {
                count = this.iDataAuthService.deleteUserDataAuthByStoreAndPharmacyId(storeEntity.getPharmaceuticalCompanyId(), drugstoreId);
                log.info("\u836f\u623f\u6240\u5c5e\u836f\u5546\u53d1\u751f\u53d8\u5316\uff0c\u5220\u9664\u76f8\u5173\u836f\u5546\u836f\u623f\u6743\u9650\u6570\u636e\u4fe1\u606f\u6210\u529f\uff0c\u6761\u6570\u4e3a:{}", (Object)count);
            }
        } else {
            entity.setStatus(STATUS);
            entity.setExpressFee("0");
            entity.setServiceFee("0");
            entity.setDistributionType(Integer.valueOf(1));
            entity.setDistributionStatus(Integer.valueOf(BigDecimal.ZERO.intValue()));
            entity.setBusinessDay("1,2,3,4,5,6,7");
            String uuid = UUIDUtils.getUUID();
            entity.setxId(uuid);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            entity.setOnlineStatus(STATUS);
            count = this.mosDrugStoreMapper.insert(entity);
            drugstoreSaveReqVO.setId(uuid);
            log.info("\u6dfb\u52a0\u836f\u623f\u6210\u529f,\u6761\u6570:{}", (Object)count);
        }
        HospitalStoreRegEntity hospitalStoreReg = new HospitalStoreRegEntity();
        hospitalStoreReg.setStoreId(entity.getxId());
        hospitalStoreReg.setUpdateTime(new Date());
        count = this.mosHospitalStoreRegMapper.updateIdSbystoreId(hospitalStoreReg);
        log.info("\u5220\u9664\u836f\u623f\u533b\u9662\u5173\u8054\u5173\u7cfb\u6210\u529f,\u5220\u9664\u6761\u6570:{}", (Object)count);
        this.insterHospitalStoreReg.insterHospitalStoreReg(drugstoreSaveReqVO);
        return BaseResponse.success((Object)entity.getxId());
    }

    public BaseResponse<List<AccountResVO>> selectDoctor(DoctorListReqVO doctorListReqVO) {
        List accountResVOS = this.accountInfoMapper.selectByAppCode(doctorListReqVO.getAppCode());
        log.info("\u67e5\u8be2\u8d26\u6237\u4e3a:{}", (Object)JSON.toJSONString((Object)accountResVOS));
        return BaseResponse.success((Object)accountResVOS);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> deleteDrugStore(DeleteDrugstoreReqVO deleteDrugstoreReqVO) {
        log.info("\u8c03\u7528\u4e86\u5220\u9664\u836f\u623f\u7684\u63a5\u53e3");
        if (Objects.isNull(deleteDrugstoreReqVO) || Objects.isNull(deleteDrugstoreReqVO.getDrugstoreId())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u5220\u9664\u836f\u623f\u7684id");
        }
        OrderPagingListReqVO orderPagingListReqVO = new OrderPagingListReqVO();
        orderPagingListReqVO.setIsNotEnd(Integer.valueOf(1));
        orderPagingListReqVO.setStoreId(deleteDrugstoreReqVO.getDrugstoreId());
        int mainCount = this.mosDrugMainMapper.queryMainCount(orderPagingListReqVO);
        if (mainCount >= 1) {
            throw new BusinessException("\u5f53\u524d\u836f\u623f\u4e0b\u9762\u8fd8\u6709\u8fdb\u884c\u4e2d\u7684\u8ba2\u5355,\u4e0d\u80fd\u5220\u9664");
        }
        int count = 0;
        DrugStoreEntity drugStoreEntity = new DrugStoreEntity();
        drugStoreEntity.setxId(deleteDrugstoreReqVO.getDrugstoreId());
        drugStoreEntity.setUpdateTime(new Date());
        drugStoreEntity.setStatus(INVALID_STATUS);
        count = this.mosDrugStoreMapper.updateById(drugStoreEntity);
        log.info("\u5220\u9664\u836f\u623f\u6210\u529f,\u6761\u6570\u4e3a:{}", (Object)count);
        HospitalStoreRegEntity hospitalStoreReg = new HospitalStoreRegEntity();
        hospitalStoreReg.setStoreId(deleteDrugstoreReqVO.getDrugstoreId());
        hospitalStoreReg.setUpdateTime(new Date());
        count = this.mosHospitalStoreRegMapper.updateIdSbystoreId(hospitalStoreReg);
        log.info("\u5220\u9664\u836f\u623f\u533b\u9662\u5173\u8054\u5173\u7cfb\u6210\u529f,\u5220\u9664\u6761\u6570:{}", (Object)count);
        count = this.iDataAuthService.deleteUserDataAuthByStore(deleteDrugstoreReqVO.getDrugstoreId());
        log.info("\u5220\u9664\u836f\u623f\u76f8\u5173\u6743\u9650\u6570\u636e\u6210\u529f\uff0c\u6761\u6570\u4e3a:{}", (Object)count);
        return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
    }

    public BaseResponse<PageResult<DrugStoreResVO>> drugStoreList(PageRequest<DrugStoreReqVO> drugStoreReqVO) {
        if (Objects.isNull(drugStoreReqVO)) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u5bf9\u5e94\u53c2\u6570");
        }
        ((DrugStoreReqVO)drugStoreReqVO.getQuery()).setAppCode(null);
        PageHelper.startPage((int)drugStoreReqVO.getPageNum(), (int)drugStoreReqVO.getPageSize());
        Page page = this.mosDrugStoreMapper.selectDrugStoreByParam((DrugStoreReqVO)drugStoreReqVO.getQuery());
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Long.valueOf(page.getTotal()).intValue());
        pageResult.setContent(page.getResult());
        log.info("pageResult:{}" + JSONObject.toJSONString((Object)pageResult));
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<String> updateOnlineStatus(OnlineStatusReqVO onlineStatusReqVO) {
        int count = this.mosDrugStoreMapper.updateOnlineStatus(onlineStatusReqVO.getIds(), onlineStatusReqVO.getOnlineStatus());
        log.info("\u66f4\u65b0\u4e0a\u4e0b\u7ebf\u72b6\u6001\u6210\u529f,\u6761\u6570\u4e3a:{}", (Object)count);
        return BaseResponse.success((Object)"\u66f4\u65b0\u6210\u529f");
    }

    public BaseResponse<DrugstoreInfoResVO> selectDrugStore(DeleteDrugstoreReqVO deleteDrugstoreReqVO) {
        DrugStoreEntity drugStoreEntity = this.mosDrugStoreMapper.selectById(deleteDrugstoreReqVO.getDrugstoreId());
        if (Objects.isNull(drugStoreEntity)) {
            throw new BusinessException("\u5f53\u524d\u836f\u623f\u627e\u4e0d\u5230\u4e86");
        }
        log.info("drugStoreEntity:{}", (Object)JSON.toJSONString((Object)drugStoreEntity));
        DrugstoreInfoResVO drugstoreInfoResVO = new DrugstoreInfoResVO();
        BeanUtils.copyProperties((Object)drugStoreEntity, (Object)drugstoreInfoResVO);
        List hospitalids = this.mosHospitalStoreRegMapper.selectHospitalByStore(deleteDrugstoreReqVO.getDrugstoreId());
        drugstoreInfoResVO.setHospitalIds(hospitalids);
        return BaseResponse.success((Object)drugstoreInfoResVO);
    }

    public BaseResponse<List<DrugStoreListResVO>> paginglist(DrugStoreListReqVO drugStoreListReqVO) {
        List list = this.mosDrugStoreMapper.selectDrugStoreList(drugStoreListReqVO);
        log.info("pageResult:{}" + JSONObject.toJSONString((Object)list));
        return BaseResponse.success((Object)list);
    }

    public BaseResponse<PageResult<DrugStoreListResVO>> pagingListByPage(PageRequest<DrugStoreListReqVO> drugStoreListReqVO) {
        if (Objects.isNull(drugStoreListReqVO) || Objects.isNull(drugStoreListReqVO.getQuery())) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u5bf9\u5e94\u53c2\u6570");
        }
        PageHelper.startPage((int)drugStoreListReqVO.getPageNum(), (int)drugStoreListReqVO.getPageSize());
        List list = this.mosDrugStoreMapper.selectDrugStoreList((DrugStoreListReqVO)drugStoreListReqVO.getQuery());
        PageResult pageResult = new PageResult();
        PageInfo info = new PageInfo(list);
        pageResult.setContent(list);
        pageResult.setPageSize(drugStoreListReqVO.getPageSize());
        pageResult.setPageNum(drugStoreListReqVO.getPageNum());
        pageResult.setTotal(new Long(info.getTotal()).intValue());
        pageResult.setTotalPages(info.getPages());
        return BaseResponse.success((Object)pageResult);
    }

    public DrugStoreEntity queryById(String xId) {
        return this.mosDrugStoreMapper.queryById(xId);
    }

    public BaseResponse<PageInfo<DrugStoreListResDTO>> list(DrugStoreListResDTO param) {
        log.info("=======>\u60a3\u8005\u7aef\u836f\u623f\u5217\u8868\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)param));
        ArrayList hash = new ArrayList();
        if (param.getMainId() != null) {
            List drugDetailList = this.mosDrugDetailMapper.getByMainId(param.getMainId());
            for (DrugDetailEntity drugDetailEntity : drugDetailList) {
                HashMap<String, Object> detailMap = new HashMap<String, Object>();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(drugDetailEntity.getDrugName());
                detailMap.put("drugSpec", drugDetailEntity.getDrugSpec());
                if (drugDetailEntity.getDrugName().contains(drugDetailEntity.getDrugSpec())) {
                    int index = drugDetailEntity.getDrugName().indexOf(drugDetailEntity.getDrugSpec());
                    if (index > 0) {
                        arrayList.add(drugDetailEntity.getDrugName().substring(0, index - 1));
                    }
                    arrayList.add(drugDetailEntity.getDrugName().substring(0, index));
                }
                List drugHandling = DrugHandling.getDrugHandling((String)drugDetailEntity.getDrugName());
                arrayList.addAll(drugHandling);
                detailMap.put("arrayList", arrayList);
                hash.add(detailMap);
            }
            param.setDrugCodes(drugDetailList.stream().map(DrugDetailEntity::getArcimCode).collect(Collectors.toList()));
            param.setDrugDetailEntities(hash);
            param.setDrugCount(Integer.valueOf(drugDetailList.size()));
        }
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List list = this.mosDrugStoreMapper.queryPatient(param);
        for (DrugStoreListResDTO dto : list) {
            if (dto.getDistance() != null && !"".equals(dto.getDistance())) {
                dto.setDistance(this.distanceConversion(dto.getDistance()));
            } else {
                dto.setDistance("");
            }
            if (Objects.nonNull(dto.getDistributionStatus()) && Integer.valueOf(1).equals(dto.getDistributionStatus()) && StringUtils.isNotBlank((String)dto.getExpressFee())) {
                dto.setExpressFee(BigDecimalUtil.getPriceByString((String)dto.getExpressFee(), (int)2));
            } else {
                dto.setExpressFee("0.00");
            }
            dto.setPharmaceuticalCompanyId(dto.getxId());
        }
        PageInfo info = new PageInfo(list);
        return BaseResponse.success((Object)info);
    }

    public BaseResponse<PageResult<DrugStoreManageListResVO>> managePagingList(DrugStoreManageListReqVO vo) {
        List list;
        log.info("=======>\u5206\u9875\u836f\u623f\u5217\u8868\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)vo));
        PageResult result = new PageResult();
        List statusList = vo.getOnlineStatus();
        if (CollectionUtils.isNotEmpty((Collection)statusList)) {
            PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
            list = this.mosDrugStoreMapper.managePageQuery(vo, statusList);
        } else {
            list = new ArrayList();
        }
        PageInfo info = new PageInfo(list);
        result.setPageNum(info.getPageNum());
        result.setPageSize(info.getPageSize());
        result.setTotalPages(info.getPages());
        result.setTotal(new Long(info.getTotal()).intValue());
        result.setContent(list);
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<List<PatientChooseDrugStoreResVo>> patientChoose(PatientChooseDrugStoreReqVo vo) {
        String lastChooseStoreId = "";
        ArrayList<PatientChooseDrugStoreResVo> resVoList = new ArrayList<PatientChooseDrugStoreResVo>();
        List drugMainList = this.mosDrugMainMapper.queryByPatientId(vo.getPatientId(), vo.getMainId());
        if (CollectionUtils.isNotEmpty((Collection)drugMainList)) {
            lastChooseStoreId = ((DrugMainEntity)drugMainList.get(0)).getStoreId();
        }
        DrugStoreEntity queryDrugstoreEntity = new DrugStoreEntity();
        queryDrugstoreEntity.setAppCode(vo.getAppCode());
        queryDrugstoreEntity.setOnlineStatus(Integer.valueOf(1));
        List drugstoreList = this.mosDrugStoreMapper.query(queryDrugstoreEntity);
        if (CollectionUtils.isNotEmpty((Collection)drugstoreList)) {
            List drugDetailList = this.mosDrugDetailMapper.getByMainId(vo.getMainId());
            long drugCount = drugDetailList.stream().map(s -> s.getDrugName() + s.getDrugSpec()).distinct().count();
            if (CollectionUtils.isNotEmpty((Collection)drugDetailList)) {
                for (DrugStoreEntity item : drugstoreList) {
                    List drugItemList = this.mosDrugStoreMapper.queryByDrugDetailAndStoreId(drugDetailList, item.getPharmaceuticalCompanyId(), item.getxId());
                    long drugStoreCount = drugItemList.stream().map(s -> s.getCommonName() + s.getDrugSpec()).distinct().count();
                    if (!CollectionUtils.isNotEmpty((Collection)drugItemList) || drugStoreCount != drugCount) continue;
                    PatientChooseDrugStoreResVo resVo = new PatientChooseDrugStoreResVo();
                    ArrayList patientChooseDrugList = new ArrayList();
                    resVo.setLastChooseFlag(false);
                    resVo.setStoreId(item.getxId());
                    BeanUtils.copyProperties((Object)item, (Object)resVo);
                    if (StringUtils.isNotEmpty((String)lastChooseStoreId) && lastChooseStoreId.equals(item.getxId())) {
                        resVo.setLastChooseFlag(true);
                    }
                    resVo.setDrugItemList(patientChooseDrugList);
                    resVo.setPrice(resVo.getDrugItemList().stream().map(v -> new BigDecimal(v.getTotalPrice())).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4).toString());
                    resVoList.add(resVo);
                }
            }
        }
        return BaseResponse.success(resVoList);
    }

    public SearchPharmacyVo selectStoreByThreeMlCode(SearchStoreByMl searchStoreByMl) {
        if (searchStoreByMl == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)searchStoreByMl.getThreeMlCode())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u836f\u623f\u7f16\u7801");
        }
        return this.mosDrugStoreMapper.selectStoreByThreeMlCode(searchStoreByMl.getThreeMlCode());
    }

    private String distanceConversion(String distance) {
        Long distancelong = Long.valueOf(distance);
        if (distancelong < 1000L) {
            return distancelong + "m";
        }
        double distancekm = (double)Long.valueOf(distance.substring(0, distance.length() - 2)).longValue() / 10.0;
        return distancekm + "km";
    }

    public void insterStoreByExcel(String url) {
        if (StringUtils.isEmpty((String)url)) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u5730\u5740");
        }
        log.info("\u836f\u623f\u5bfc\u5165,\u8bfb\u53d6\u6587\u4ef6\uff1a" + url);
        List storeExcels = new ArrayList();
        try {
            storeExcels = ExcelUtils.importExcel((String)url, (Integer)0, (Integer)1, StoreExcelDTO.class);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u836f\u623f\u8bfb\u53d6\u9519\u8bef{}", (Object)e.toString());
        }
        log.info("\u8bfb\u53d6\u5b8c\u6210\uff0c\u8bfb\u53d6\u5230{}\u6761\u6570\u636e", (Object)storeExcels.size());
        if (storeExcels.size() == 0) {
            return;
        }
        ArrayList<DrugStoreEntity> drugStoreList = new ArrayList<DrugStoreEntity>();
        for (StoreExcelDTO storeExcelDTO : storeExcels) {
            DrugStoreEntity entity = new DrugStoreEntity();
            BeanUtils.copyProperties((Object)storeExcelDTO, (Object)entity);
            entity.setAppCode("NCZK");
            entity.setStoreAddress(storeExcelDTO.getDetailAddress());
            entity.setDetailAddress(storeExcelDTO.getDetailAddress());
            entity.setStatus(STATUS);
            entity.setExpressFee("0");
            entity.setServiceFee("0");
            entity.setDistributionType(Integer.valueOf(1));
            entity.setDistributionStatus(Integer.valueOf(BigDecimal.ZERO.intValue()));
            entity.setBusinessDay("1,2,3,4,5,6,7");
            entity.setxId(UUIDUtils.getUUID());
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            entity.setOnlineStatus(Integer.valueOf(1));
            drugStoreList.add(entity);
        }
        log.info("\u5f85\u589e\u52a0\uff1a" + ((Object)drugStoreList).toString());
        int count = this.mosDrugStoreMapper.insertArrarList(drugStoreList);
        log.info("\u6dfb\u52a0\u836f\u623f\u6210\u529f,\u6761\u6570:{}", (Object)count);
    }

    public BaseResponse<PageInfo<GetStoreVODTO>> getStore(GetStoreVO vo) {
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        List list = this.mosDrugStoreMapper.getStore(vo);
        return BaseResponse.success((Object)new PageInfo(list));
    }

    public PageInfo<DrugStoreListResDTO> shoppingDrugStoreList(ShoppingDrugDetailVO shoppingDrugDetailVO) {
        log.info("\u67e5\u8be2\u836f\u623f\u4f20\u53c2:{}", (Object)JSON.toJSONString((Object)shoppingDrugDetailVO));
        if (ObjectUtils.isEmpty((Object)shoppingDrugDetailVO) || StringUtils.isEmpty((String)shoppingDrugDetailVO.getDrugItemId()) || StringUtils.isEmpty((String)shoppingDrugDetailVO.getAppCode()) || StringUtils.isEmpty((String)shoppingDrugDetailVO.getLatitude()) || StringUtils.isEmpty((String)shoppingDrugDetailVO.getLongitude()) || Objects.isNull(shoppingDrugDetailVO.getPageNum()) || Objects.isNull(shoppingDrugDetailVO.getPageSize())) {
            throw new BusinessException("\u53c2\u6570\u7a7a");
        }
        PageHelper.startPage((int)shoppingDrugDetailVO.getPageNum(), (int)shoppingDrugDetailVO.getPageSize());
        List list = this.mosDrugStoreMapper.queryShoppingPatient(shoppingDrugDetailVO);
        return new PageInfo(list);
    }
}

