/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.circulation.abstracts.DynamicInvokePlatformServer;
import com.ebaiyihui.circulation.common.enums.BaseStatusEnum;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.DrugTypeEnum;
import com.ebaiyihui.circulation.common.enums.HospitalHISPushMainEnum;
import com.ebaiyihui.circulation.common.enums.MainSourceTypeEnum;
import com.ebaiyihui.circulation.common.enums.MainTypeEnum;
import com.ebaiyihui.circulation.common.enums.OrderResourceTypeEnum;
import com.ebaiyihui.circulation.common.enums.OrderSourceEnum;
import com.ebaiyihui.circulation.common.enums.OrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.OrderTypeEnum;
import com.ebaiyihui.circulation.common.enums.PayChannelEnum;
import com.ebaiyihui.circulation.common.enums.PayMethodEnum;
import com.ebaiyihui.circulation.common.enums.PayStatusEnum;
import com.ebaiyihui.circulation.common.enums.PayTypeEnum;
import com.ebaiyihui.circulation.common.enums.PrescriptionSourceEnum;
import com.ebaiyihui.circulation.common.enums.RemarkTypeEnum;
import com.ebaiyihui.circulation.common.enums.SexEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.manage.DoctorRetmoteManage;
import com.ebaiyihui.circulation.manage.PushManage;
import com.ebaiyihui.circulation.mapper.DrugTJAuditMapper;
import com.ebaiyihui.circulation.mapper.MerchantConfigMapper;
import com.ebaiyihui.circulation.mapper.MosDiagnosticMapper;
import com.ebaiyihui.circulation.mapper.MosDrugDetailMapper;
import com.ebaiyihui.circulation.mapper.MosDrugExtendMapper;
import com.ebaiyihui.circulation.mapper.MosDrugItemMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.circulation.mapper.MosDrugRemarkMapper;
import com.ebaiyihui.circulation.mapper.MosDrugStoreMapper;
import com.ebaiyihui.circulation.mapper.MosMainPushRecordMapper;
import com.ebaiyihui.circulation.mapper.MosOutpatientMainRelMapper;
import com.ebaiyihui.circulation.pojo.bo.DrugItemBO;
import com.ebaiyihui.circulation.pojo.entity.DiagnosticEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugExtendEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugItemEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugLogisticsOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugLogisticsOrderRegEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugStoreEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugTJAuditEntity;
import com.ebaiyihui.circulation.pojo.entity.MerchantConfigEntity;
import com.ebaiyihui.circulation.pojo.entity.MosMainPushRecordEntity;
import com.ebaiyihui.circulation.pojo.entity.MosOutpatientMainRelEntity;
import com.ebaiyihui.circulation.pojo.vo.cart.AfterPaymentVO;
import com.ebaiyihui.circulation.pojo.vo.main.CommerceCreateMainDrugListVO;
import com.ebaiyihui.circulation.pojo.vo.ncefy.OrganizationResDTO;
import com.ebaiyihui.circulation.service.DrugDetailService;
import com.ebaiyihui.circulation.service.MosDrugMainService;
import com.ebaiyihui.circulation.service.MosDrugOrderService;
import com.ebaiyihui.circulation.service.MosDrugPrescriptionService;
import com.ebaiyihui.circulation.service.NcefyPrescriptionService;
import com.ebaiyihui.circulation.service.PrescriptionPdfService;
import com.ebaiyihui.circulation.service.impl.ShoppingCartServiceImpl;
import com.ebaiyihui.circulation.utils.BeanMapperUtil;
import com.ebaiyihui.circulation.utils.BigDecimalUtil;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import com.ebaiyihui.circulation.utils.HanyuPinyinUtil;
import com.ebaiyihui.circulation.utils.RedisUtil;
import com.ebaiyihui.circulation.utils.medicalcloud.BeanHelper;
import com.ebaiyihui.circulation.utils.medicalcloud.RabbitMqUtils;
import com.ebaiyihui.circulation.utils.medicalcloud.excel.DrugDetailExcel;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import com.ebaiyihui.medicalcloud.pojo.dto.QueryDrugDetailDto;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.ConfirmPayDtoReq;
import com.ebaiyihui.medicalcloud.pojo.vo.UpdateOrdersStateReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.UpdatePresPriceReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.SearchPharmacyVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.DrugPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DrugDetailEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.MedicalMoveMainUpVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.MedicalMoveMainVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.RevokeMainVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NcefyPrescriptionServiceImpl
implements NcefyPrescriptionService {
    private static final Logger log = LoggerFactory.getLogger(NcefyPrescriptionServiceImpl.class);
    public static final int FOUR = 4;
    @Autowired
    private DrugDetailService detailService;
    @Autowired
    private MosDrugMainService mosDrugMainService;
    @Autowired
    private MosDrugOrderService mosDrugOrderService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DrugTJAuditMapper drugTJAuditMapper;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosMainPushRecordMapper mosMainPushRecordMapper;
    @Autowired
    private DynamicInvokePlatformServer dynamicInvokePlatformServer;
    @Autowired
    private MosDrugItemMapper mosDrugItemMapper;
    @Autowired
    private MosDiagnosticMapper mosDiagnosticMapper;
    @Autowired
    private MosDrugExtendMapper mosDrugExtendMapper;
    @Autowired
    private MosDrugDetailMapper mosDrugDetailMapper;
    @Autowired
    private MosDrugPrescriptionMapper mosDrugPrescriptionMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper mosDrugLogisticsOrderRegMapper;
    @Autowired
    private ShoppingCartServiceImpl shoppingCartService;
    @Autowired
    private MosOutpatientMainRelMapper mosOutpatientMainRelMapper;
    @Autowired
    private MosDrugRemarkMapper mosDrugRemarkMapper;
    @Autowired
    private MosDrugPrescriptionService mosDrugPrescriptionService;
    @Autowired
    private PrescriptionPdfService prescriptionPdfService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private MerchantConfigMapper merchantConfigMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private MosDrugStoreMapper mosDrugStoreMapper;
    public static final int F = 2;
    private static final Integer TWENTY_FOUR_HOURS = 86400;
    public static final String NCEFY = "NCEFY";
    public static final int ZERO = 0;
    public static final int TWO = 2;
    public static final String STOP_STATUS = "D";
    public static final String REVOKE_STATUS = "C";
    public static final int SEVENTY_TWO_HOURS = 259200;

    @Transactional(rollbackFor={Exception.class})
    public void threeHisUpdateMain(MedicalMoveMainVO medicalMoveMainVO) {
        log.info("\u6267\u884c\u4e86\u5916\u90e8HIS\u4fee\u6539\u5904\u65b9\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)medicalMoveMainVO);
        if (Objects.isNull(medicalMoveMainVO) || Objects.isNull(medicalMoveMainVO.getDrugMainEntity()) || StringUtils.isEmpty((String)medicalMoveMainVO.getDrugPrescriptionEntity().getHisRecipeNo())) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        if (CollectionUtils.isEmpty((Collection)medicalMoveMainVO.getDrugDetailEntity())) {
            throw new BusinessException("\u6ca1\u6709\u836f\u54c1\u4fe1\u606f\uff0c\u9000\u51fa");
        }
        Date date = new Date();
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.getByHisRecipeNo(medicalMoveMainVO.getDrugPrescriptionEntity().getHisRecipeNo());
        if (Objects.isNull(drugMainEntity)) {
            log.info("\u8981\u4fee\u6539\u7684\u5904\u65b9\u627e\u4e0d\u5230\u4e86\uff01\u5f00\u59cb\u63a8\u9001\u8be5\u5904\u65b9");
            this.threeHisPushMain(medicalMoveMainVO);
            return;
        }
        if (!DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(drugMainEntity.getItemStatus())) {
            throw new BusinessException("\u5f53\u524d\u5904\u65b9\u5df2\u5728\u4e92\u533b\u7cfb\u7edf\u652f\u4ed8\uff0c\u4e0d\u53ef\u4fee\u6539\uff01\u8bf7\u53e6\u5916\u91cd\u65b0\u5f00\u5177\u5904\u65b9");
        }
        BeanMapperUtil.copyPropertiesFilterNull((Object)medicalMoveMainVO.getDrugMainEntity(), (Object)drugMainEntity);
        drugMainEntity.setxUpdateTime(date);
        this.mosDrugMainMapper.updateByPrimaryKeySelective(drugMainEntity);
        DrugPrescriptionEntity drugPrescriptionEntity = this.mosDrugPrescriptionService.queryByMainId(drugMainEntity.getxId());
        BeanMapperUtil.copyPropertiesFilterNull((Object)medicalMoveMainVO.getDrugPrescriptionEntity(), (Object)drugPrescriptionEntity);
        drugPrescriptionEntity.setxUpdateTime(date);
        this.mosDrugPrescriptionMapper.updateByPrimaryKeySelective(drugPrescriptionEntity);
        DiagnosticEntity diagnosticEntity = this.mosDiagnosticMapper.selectByPrimaryKey(drugPrescriptionEntity.getAdmId());
        BeanMapperUtil.copyPropertiesFilterNull((Object)medicalMoveMainVO.getDiagnosticEntity(), (Object)diagnosticEntity);
        diagnosticEntity.setxUpdateTime(date);
        this.mosDiagnosticMapper.updateByPrimaryKey(diagnosticEntity);
        medicalMoveMainVO.getDrugRemarkEntity().setMainId(drugMainEntity.getxId());
        medicalMoveMainVO.getDrugRemarkEntity().setxId(GenSeqUtils.getUniqueNo());
        this.mosDrugRemarkMapper.insert((DrugRemarkEntity)medicalMoveMainVO.getDrugRemarkEntity());
        List drugDetailEntities = this.mosDrugDetailMapper.queryByMainId(drugMainEntity.getxId());
        if (CollectionUtils.isNotEmpty((Collection)drugDetailEntities) && CollectionUtils.isNotEmpty((Collection)medicalMoveMainVO.getDrugDetailEntity())) {
            this.mosDrugDetailMapper.deleteDetailsByMainId(drugMainEntity.getxId(), drugPrescriptionEntity.getxId());
        }
        for (DrugDetailEntityPushVO drugDetailEntityPushVO : medicalMoveMainVO.getDrugDetailEntity()) {
            drugDetailEntityPushVO.setxId(GenSeqUtils.getUniqueNo());
            drugDetailEntityPushVO.setMainId(drugMainEntity.getxId());
            drugDetailEntityPushVO.setPresId(drugPrescriptionEntity.getxId());
            drugDetailEntityPushVO.setTotalPrice(new BigDecimal("0"));
            drugDetailEntityPushVO.setUnitPrice(new BigDecimal("0"));
            this.mosDrugDetailMapper.insert((DrugDetailEntity)drugDetailEntityPushVO);
        }
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                this.prescriptionPdfService.setPresPdf(drugMainEntity.getxId(), null);
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u5904\u65b9\u7b3a\u5931\u8d25,\u539f\u56e0:", (Throwable)e);
            }
        });
        log.info("\u4fee\u6539\u5b8c\u6bd5");
    }

    @Transactional(rollbackFor={Exception.class})
    public void threeHisPushMain(MedicalMoveMainVO medicalMoveMainVO) {
        log.info("\u6267\u884c\u4e86\u5916\u90e8HIS\u63a8\u9001\u5904\u65b9\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)medicalMoveMainVO);
        if (Objects.isNull(medicalMoveMainVO) || Objects.isNull(medicalMoveMainVO.getDrugMainEntity())) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        if (CollectionUtils.isEmpty((Collection)medicalMoveMainVO.getDrugDetailEntity())) {
            throw new BusinessException("\u6ca1\u6709\u836f\u54c1\u4fe1\u606f\uff0c\u9000\u51fa");
        }
        String hospitalSourceType = HospitalHISPushMainEnum.getDesc((Integer)medicalMoveMainVO.getHospitalSourceType());
        if (StringUtils.isEmpty((String)hospitalSourceType)) {
            throw new BusinessException("\u63a8\u9001\u7c7b\u578b\u9519\u8bef\uff0c\u9000\u51fa");
        }
        log.info(hospitalSourceType + "\u7ebf\u4e0b\u63a8\u9001\u5904\u65b9");
        OrganizationResDTO organizationResDTO = this.doctorRetmoteManage.getByHospitalName(hospitalSourceType);
        if (Objects.isNull(organizationResDTO)) {
            throw new BusinessException("\u63a8\u9001\u7c7b\u578b\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u533b\u9662");
        }
        medicalMoveMainVO.getDrugMainEntity().setPrescriptionType(Objects.isNull(medicalMoveMainVO.getPrescriptionType()) ? MainTypeEnum.MEDICAL_INSURANCE_OPEN_MAIN.getValue() : medicalMoveMainVO.getPrescriptionType());
        medicalMoveMainVO.getDrugMainEntity().setOrganId(organizationResDTO.getId().toString());
        medicalMoveMainVO.getDrugMainEntity().setPresOrganName(organizationResDTO.getOrganName());
        medicalMoveMainVO.getDrugMainEntity().setHospitalNameFirstLetter(HanyuPinyinUtil.getFirstLetters((String)hospitalSourceType, (HanyuPinyinCaseType)HanyuPinyinCaseType.UPPERCASE));
        String mainId = GenSeqUtils.getUniqueNo();
        medicalMoveMainVO.getDrugMainEntity().setxId(mainId);
        log.info("\u51c6\u5907\u53c2\u6570\uff0c\u52a0\u5165mq\u961f\u5217");
        medicalMoveMainVO.getDrugMainEntity().setFailureTime(DateTimeUtil.addDay((Date)new Date(), (int)3));
        this.mosDrugMainMapper.insert((DrugMainEntity)medicalMoveMainVO.getDrugMainEntity());
        medicalMoveMainVO.getDiagnosticEntity().setAdmId(medicalMoveMainVO.getDrugPrescriptionEntity().getxId());
        medicalMoveMainVO.getDiagnosticEntity().setxId(GenSeqUtils.getUniqueNo());
        this.mosDiagnosticMapper.insert((DiagnosticEntity)medicalMoveMainVO.getDiagnosticEntity());
        medicalMoveMainVO.getDrugPrescriptionEntity().setMainId(mainId);
        medicalMoveMainVO.getDrugPrescriptionEntity().setAdmId(medicalMoveMainVO.getDiagnosticEntity().getxId());
        medicalMoveMainVO.getDrugPrescriptionEntity().setxId(GenSeqUtils.getUniqueNo());
        this.mosDrugPrescriptionMapper.insert((DrugPrescriptionEntity)medicalMoveMainVO.getDrugPrescriptionEntity());
        medicalMoveMainVO.getDrugExtendEntity().setMainId(mainId);
        medicalMoveMainVO.getDrugExtendEntity().setxId(GenSeqUtils.getUniqueNo());
        this.mosDrugExtendMapper.insert((DrugExtendEntity)medicalMoveMainVO.getDrugExtendEntity());
        medicalMoveMainVO.getDrugRemarkEntity().setMainId(mainId);
        medicalMoveMainVO.getDrugRemarkEntity().setxId(GenSeqUtils.getUniqueNo());
        this.mosDrugRemarkMapper.insert((DrugRemarkEntity)medicalMoveMainVO.getDrugRemarkEntity());
        for (DrugDetailEntityPushVO drugDetailEntityPushVO : medicalMoveMainVO.getDrugDetailEntity()) {
            drugDetailEntityPushVO.setxId(GenSeqUtils.getUniqueNo());
            drugDetailEntityPushVO.setMainId(mainId);
            drugDetailEntityPushVO.setPresId(medicalMoveMainVO.getDrugPrescriptionEntity().getxId());
            drugDetailEntityPushVO.setTotalPrice(new BigDecimal("0"));
            drugDetailEntityPushVO.setUnitPrice(new BigDecimal("0"));
            this.mosDrugDetailMapper.insert((DrugDetailEntity)drugDetailEntityPushVO);
        }
        MosMainPushRecordEntity mosMainPushRecordEntity = new MosMainPushRecordEntity();
        mosMainPushRecordEntity.setMainId(mainId);
        mosMainPushRecordEntity.setCallBackUrl(medicalMoveMainVO.getCallBackUrl());
        mosMainPushRecordEntity.setIsNeedCallBack(medicalMoveMainVO.getIsCallBack());
        mosMainPushRecordEntity.setStatus(Integer.valueOf(1));
        mosMainPushRecordEntity.setCreateTime(new Date());
        mosMainPushRecordEntity.setIsHaveAudit(medicalMoveMainVO.getIsHaveAudit());
        mosMainPushRecordEntity.setRequestBody(JSON.toJSONString((Object)medicalMoveMainVO));
        mosMainPushRecordEntity.setSourceType(medicalMoveMainVO.getSourceType());
        mosMainPushRecordEntity.setCreateTime(new Date());
        mosMainPushRecordEntity.setUpdateTime(new Date());
        this.mosMainPushRecordMapper.insert(mosMainPushRecordEntity);
        RabbitMqUtils.addMainNoPay((RabbitTemplate)this.rabbitTemplate, (String)medicalMoveMainVO.getDrugMainEntity().getxId(), (Integer)259200);
        log.info("\u65b0\u589e\u5904\u65b9\u6570\u636e\u6210\u529f");
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                throw new BusinessException("\u751f\u6210\u5904\u65b9\u7b3a\u5931\u8d25");
            }
            try {
                this.prescriptionPdfService.setPresPdf(mainId, null);
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u5904\u65b9\u7b3a\u5931\u8d25,\u539f\u56e0:", (Throwable)e);
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void threeHisInvalidMain(MedicalMoveMainVO medicalMoveMainVO) {
        log.info("\u6267\u884c\u4e86\u5916\u90e8HIS\u4f5c\u5e9f/\u5220\u9664\u5904\u65b9\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)medicalMoveMainVO);
        if (Objects.isNull(medicalMoveMainVO) || Objects.isNull(medicalMoveMainVO.getOperateType()) || StringUtils.isEmpty((String)medicalMoveMainVO.getDrugPrescriptionEntity().getHisRecipeNo())) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        Date date = new Date();
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.getByHisRecipeNo(medicalMoveMainVO.getDrugPrescriptionEntity().getHisRecipeNo());
        if (Objects.isNull(drugMainEntity)) {
            log.info("\u8981\u4f5c\u5e9f/\u5220\u9664\u7684\u5904\u65b9\u627e\u4e0d\u5230\u4e86");
            return;
        }
        if (DrugMainStatusEnum.USELESS.getValue().equals(drugMainEntity.getItemStatus())) {
            throw new BusinessException("\u5f53\u524d\u5904\u65b9\u5df2\u5931\u6548");
        }
        if (!DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(drugMainEntity.getItemStatus())) {
            throw new BusinessException("\u5f53\u524d\u5904\u65b9\u5df2\u5728\u4e92\u533b\u7cfb\u7edf\u652f\u4ed8\uff0c\u4e0d\u53ef\u4f5c\u5e9f/\u5220\u9664\uff01\u8bf7\u53e6\u5916\u91cd\u65b0\u5f00\u5177\u5904\u65b9");
        }
        DrugMainEntity newMainEntity = new DrugMainEntity();
        if (medicalMoveMainVO.getOperateType() == 4) {
            newMainEntity.setStatus(Integer.valueOf(0));
        }
        newMainEntity.setItemStatus(DrugMainStatusEnum.USELESS.getValue());
        newMainEntity.setxUpdateTime(date);
        newMainEntity.setxId(drugMainEntity.getxId());
        this.mosDrugMainMapper.updateByPrimaryKeySelective(newMainEntity);
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
        drugRemarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        if (medicalMoveMainVO.getOperateType() == 4) {
            drugRemarkEntity.setRemarkContent(drugMainEntity.getPresOrganName() + "HIS \u5220\u9664 ");
        } else {
            drugRemarkEntity.setRemarkContent(drugMainEntity.getPresOrganName() + "HIS \u4f5c\u5e9f");
        }
        drugRemarkEntity.setMainId(drugMainEntity.getxId());
        drugRemarkEntity.setRemarkType(RemarkTypeEnum.REVOKE.getValue());
        drugRemarkEntity.setRemarkUser("HIS");
        drugRemarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.mosDrugRemarkMapper.insert(drugRemarkEntity);
        log.info("\u4f5c\u5e9f/\u5220\u9664\u5904\u7406\u5b8c\u6bd5");
    }

    @Transactional(rollbackFor={Exception.class})
    public void storePushMain(MedicalMoveMainVO medicalMoveMainVO) {
        log.info("\u6267\u884c\u4e86\u836f\u5e97\u63a8\u65b9\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)medicalMoveMainVO));
        if (Objects.isNull(medicalMoveMainVO) || Objects.isNull(medicalMoveMainVO.getDrugMainEntity()) || StringUtils.isEmpty((String)medicalMoveMainVO.getDrugMainEntity().getxId()) || Objects.isNull(medicalMoveMainVO.getDrugPrescriptionEntity()) || Objects.isNull(medicalMoveMainVO.getDiagnosticEntity())) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        if (CollectionUtils.isEmpty((Collection)medicalMoveMainVO.getDrugDetailEntity())) {
            throw new BusinessException("\u6ca1\u6709\u836f\u54c1");
        }
        if (Objects.isNull(medicalMoveMainVO.getPrescriptionType()) || !MainTypeEnum.STORE_OPEN_DRUG_MAIN.getValue().equals(medicalMoveMainVO.getPrescriptionType())) {
            throw new BusinessException("\u5904\u65b9\u7c7b\u578b\u9519\u8bef");
        }
        if (StringUtils.isBlank((String)medicalMoveMainVO.getDrugMainEntity().getStoreId())) {
            throw new BusinessException("\u5904\u65b9\u6240\u5c5e\u836f\u5e97\u4e3a\u7a7a");
        }
        DrugMainEntity mainEntity = this.mosDrugMainMapper.queryById(medicalMoveMainVO.getDrugMainEntity().getxId());
        if (Objects.nonNull(mainEntity)) {
            log.error("\u5df2\u7ecf\u5b58\u5728\u8be5\u5904\u65b9");
            return;
        }
        medicalMoveMainVO.getDrugMainEntity().setPrescriptionType(medicalMoveMainVO.getPrescriptionType());
        medicalMoveMainVO.getDrugMainEntity().setFailureTime(DateTimeUtil.addDay((Date)new Date(), (int)3));
        medicalMoveMainVO.getDrugMainEntity().setxRowid(null);
        medicalMoveMainVO.getDrugMainEntity().setPrescriptionSource(MainSourceTypeEnum.MEDICAL_APP.getValue());
        medicalMoveMainVO.getDrugMainEntity().setItemStatus(DrugMainStatusEnum.FINISH.getValue());
        medicalMoveMainVO.getDrugMainEntity().setDrugSpeciesNum(Integer.valueOf(medicalMoveMainVO.getDrugDetailEntity().size()));
        this.mosDrugMainMapper.insert((DrugMainEntity)medicalMoveMainVO.getDrugMainEntity());
        BigDecimal totalPrice = BigDecimal.ZERO;
        for (DrugDetailEntityPushVO drugDetailEntityPushVO : medicalMoveMainVO.getDrugDetailEntity()) {
            if (StringUtils.isBlank((String)drugDetailEntityPushVO.getDrugId())) {
                throw new BusinessException("\u5904\u65b9\u8be6\u60c5\u836f\u54c1id\u4e3a\u7a7a");
            }
            if (Objects.isNull(drugDetailEntityPushVO.getAmount())) {
                throw new BusinessException(drugDetailEntityPushVO.getDrugName() + "\u836f\u54c1\u6570\u91cf\u4e3a\u7a7a");
            }
            DrugItemBO drugItemBO = this.mosDrugItemMapper.selectDrugBOByDrugIdANDCompanyId(drugDetailEntityPushVO.getDrugId(), null, medicalMoveMainVO.getDrugMainEntity().getStoreId(), medicalMoveMainVO.getDrugMainEntity().getPresOrgan());
            if (Objects.isNull(drugItemBO)) {
                throw new BusinessException("\u8d2d\u4e70\u7684\u836f\u54c1\u4e0d\u5b58\u5728,\u4ea7\u54c1\u7f16\u7801\uff1a" + drugDetailEntityPushVO.getDrugId());
            }
            drugDetailEntityPushVO.setDrugId(drugItemBO.getId());
            drugDetailEntityPushVO.setUnitPrice(new BigDecimal(drugItemBO.getPrice()));
            drugDetailEntityPushVO.setDrugCommonCode(drugItemBO.getCommonCode());
            drugDetailEntityPushVO.setManufacturer(drugItemBO.getManufacturer());
            drugDetailEntityPushVO.setDrugSpec(drugItemBO.getDrugSpec());
            drugDetailEntityPushVO.setWholePackingUnit(drugItemBO.getWholePackingUnitName());
            drugDetailEntityPushVO.setTotalPrice(drugDetailEntityPushVO.getUnitPrice().multiply(drugDetailEntityPushVO.getAmount()));
            drugDetailEntityPushVO.setxRowid(null);
            totalPrice = totalPrice.add(drugDetailEntityPushVO.getTotalPrice());
            this.mosDrugDetailMapper.insert((DrugDetailEntity)drugDetailEntityPushVO);
        }
        medicalMoveMainVO.getDrugPrescriptionEntity().setStorePrice(totalPrice);
        medicalMoveMainVO.getDrugPrescriptionEntity().setPrice(totalPrice);
        medicalMoveMainVO.getDrugPrescriptionEntity().setxRowid(null);
        this.mosDrugPrescriptionMapper.insert((DrugPrescriptionEntity)medicalMoveMainVO.getDrugPrescriptionEntity());
        if (Objects.nonNull(medicalMoveMainVO.getDrugExtendEntity())) {
            medicalMoveMainVO.getDrugExtendEntity().setxRowid(null);
            this.mosDrugExtendMapper.insert((DrugExtendEntity)medicalMoveMainVO.getDrugExtendEntity());
        }
        medicalMoveMainVO.getDiagnosticEntity().setxRowid(null);
        this.mosDiagnosticMapper.insert((DiagnosticEntity)medicalMoveMainVO.getDiagnosticEntity());
        if (Objects.nonNull(medicalMoveMainVO.getMosOutpatientMainRelEntity())) {
            this.mosOutpatientMainRelMapper.insert((MosOutpatientMainRelEntity)medicalMoveMainVO.getMosOutpatientMainRelEntity());
        }
        if (Objects.nonNull(medicalMoveMainVO.getDrugRemarkEntity())) {
            medicalMoveMainVO.getDrugRemarkEntity().setxRowid(null);
            this.mosDrugRemarkMapper.insert((DrugRemarkEntity)medicalMoveMainVO.getDrugRemarkEntity());
        }
        DrugOrderEntity orderEntity = new DrugOrderEntity();
        orderEntity.setxId(GenSeqUtils.getUniqueNo());
        orderEntity.setOrderType(OrderTypeEnum.DRUG_ORDER.getValue());
        orderEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        orderEntity.setMainId(medicalMoveMainVO.getDrugMainEntity().getxId());
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigMapper.queryByOrganCodeAndMerchantTypeAndStoreId(Integer.valueOf(1), medicalMoveMainVO.getDrugMainEntity().getStoreId());
        if (Objects.nonNull(merchantConfigEntity)) {
            orderEntity.setMerchantId(merchantConfigEntity.getMerchantSeq());
            orderEntity.setBizSysSeq(merchantConfigEntity.getBizSysSeq());
        }
        orderEntity.setPayTime(new Date());
        orderEntity.setOrderSeq(GenSeqUtils.genOrderSeq((String)""));
        orderEntity.setOrderAmount(totalPrice);
        orderEntity.setPayAmount(totalPrice);
        orderEntity.setSelfAmount(totalPrice);
        orderEntity.setTotalDrugAmount(totalPrice);
        orderEntity.setOrganCode(medicalMoveMainVO.getDrugMainEntity().getPresOrgan());
        orderEntity.setStatus(OrderStatusEnum.PAID.getValue());
        orderEntity.setPayMethod(PayMethodEnum.NCEFY_OFFLINE_MEDICAL_INS_PAY.getValue());
        orderEntity.setChannelCode(PayChannelEnum.NCEFY_OFFLINE_MEDICAL_INS.getValue());
        this.mosDrugOrderMapper.insert(orderEntity);
        MosMainPushRecordEntity mosMainPushRecordEntity = new MosMainPushRecordEntity();
        mosMainPushRecordEntity.setMainId(medicalMoveMainVO.getDrugMainEntity().getxId());
        mosMainPushRecordEntity.setCallBackUrl(medicalMoveMainVO.getCallBackUrl());
        mosMainPushRecordEntity.setIsNeedCallBack(medicalMoveMainVO.getIsCallBack());
        mosMainPushRecordEntity.setStatus(Integer.valueOf(1));
        mosMainPushRecordEntity.setCreateTime(new Date());
        mosMainPushRecordEntity.setIsHaveAudit(medicalMoveMainVO.getIsHaveAudit());
        mosMainPushRecordEntity.setRequestBody(JSON.toJSONString((Object)medicalMoveMainVO));
        mosMainPushRecordEntity.setSourceType(medicalMoveMainVO.getSourceType());
        mosMainPushRecordEntity.setCreateTime(new Date());
        mosMainPushRecordEntity.setUpdateTime(new Date());
        this.mosMainPushRecordMapper.insert(mosMainPushRecordEntity);
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setMainId(medicalMoveMainVO.getDrugMainEntity().getxId());
        drugRemarkEntity.setxRemark("\u6781\u901f\u8d2d\u836f\uff0c\u81ea\u52a8\u5b8c\u6210\u8ba2\u5355");
        drugRemarkEntity.setRemarkType(RemarkTypeEnum.REMARK.getValue());
        drugRemarkEntity.setxCreateTime(new Date());
        drugRemarkEntity.setxUpdateTime(new Date());
        drugRemarkEntity.setRemarkContent(drugRemarkEntity.getxRemark());
        drugRemarkEntity.setRemarkUser("ADMIN");
        drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
        this.mosDrugRemarkMapper.insert(drugRemarkEntity);
        log.info("\u836f\u5e97\u5f00\u65b9\u5b8c\u6210\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public void patientPushMain(MedicalMoveMainUpVO medicalMoveMainVO) {
        if (Objects.isNull(medicalMoveMainVO) || Objects.isNull(medicalMoveMainVO.getDrugMainEntity()) || StringUtils.isEmpty((String)medicalMoveMainVO.getDrugMainEntity().getxId()) || Objects.isNull(medicalMoveMainVO.getDrugPrescriptionEntity()) || Objects.isNull(medicalMoveMainVO.getDiagnosticEntity())) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        if (CollectionUtils.isEmpty((Collection)medicalMoveMainVO.getDrugDetailEntity())) {
            throw new BusinessException("\u6ca1\u6709\u836f\u54c1");
        }
        if (StringUtils.isBlank((String)medicalMoveMainVO.getDrugMainEntity().getStoreId())) {
            throw new BusinessException("\u5904\u65b9\u6240\u5c5e\u836f\u5e97\u4e3a\u7a7a");
        }
        String orderSeq = GenSeqUtils.genOrderSeq((String)"");
        DrugMainEntity mainEntity = this.mosDrugMainMapper.queryById(medicalMoveMainVO.getDrugMainEntity().getxId());
        if (Objects.nonNull(mainEntity)) {
            log.error("\u5df2\u7ecf\u5b58\u5728\u8be5\u5904\u65b9");
            return;
        }
        SearchPharmacyVo searchPharmacyVo = this.mosDrugStoreMapper.selectStoreByThreeMlCode(medicalMoveMainVO.getDrugMainEntity().getStoreId());
        DrugStoreEntity drugStoreEntity = null;
        if (Objects.nonNull(searchPharmacyVo)) {
            drugStoreEntity = this.mosDrugStoreMapper.queryById(searchPharmacyVo.getStoreId());
        }
        if (Integer.valueOf(1).equals(medicalMoveMainVO.getLogisticsType())) {
            medicalMoveMainVO.getDrugMainEntity().setFetchMedicalCode(orderSeq.substring(orderSeq.length() - 6));
            medicalMoveMainVO.getDrugMainEntity().setItemStatus(DrugMainStatusEnum.TO_TAKE.getValue());
        } else {
            medicalMoveMainVO.getDrugMainEntity().setItemStatus(DrugMainStatusEnum.TO_SEND.getValue());
        }
        if (Objects.nonNull(drugStoreEntity)) {
            medicalMoveMainVO.getDrugMainEntity().setStoreId(drugStoreEntity.getxId());
        }
        medicalMoveMainVO.getDrugMainEntity().setxRowid(null);
        medicalMoveMainVO.getDrugPrescriptionEntity().setxId(GenSeqUtils.getUniqueNo());
        this.mosDrugMainMapper.insert((DrugMainEntity)medicalMoveMainVO.getDrugMainEntity());
        for (DrugDetailEntityPushVO drugDetailEntityPushVO : medicalMoveMainVO.getDrugDetailEntity()) {
            drugDetailEntityPushVO.setPresDetailsHisId(medicalMoveMainVO.getDrugPrescriptionEntity().getxId());
            drugDetailEntityPushVO.setMainId(medicalMoveMainVO.getDrugMainEntity().getxId());
            this.mosDrugDetailMapper.insert((DrugDetailEntity)drugDetailEntityPushVO);
        }
        medicalMoveMainVO.getDiagnosticEntity().setxId(GenSeqUtils.getUniqueNo());
        medicalMoveMainVO.getDrugPrescriptionEntity().setMainId(medicalMoveMainVO.getDrugMainEntity().getxId());
        medicalMoveMainVO.getDrugPrescriptionEntity().setxRowid(null);
        medicalMoveMainVO.getDrugPrescriptionEntity().setAdmId(medicalMoveMainVO.getDiagnosticEntity().getxId());
        medicalMoveMainVO.getDrugPrescriptionEntity().setxId(GenSeqUtils.getUniqueNo());
        this.mosDrugPrescriptionMapper.insert((DrugPrescriptionEntity)medicalMoveMainVO.getDrugPrescriptionEntity());
        medicalMoveMainVO.getDiagnosticEntity().setxRowid(null);
        medicalMoveMainVO.getDiagnosticEntity().setAdmId(medicalMoveMainVO.getDrugPrescriptionEntity().getxId());
        this.mosDiagnosticMapper.insert((DiagnosticEntity)medicalMoveMainVO.getDiagnosticEntity());
        DrugOrderEntity orderEntity = new DrugOrderEntity();
        orderEntity.setxId(GenSeqUtils.getUniqueNo());
        orderEntity.setOrderType(medicalMoveMainVO.getLogisticsType());
        orderEntity.setOrderSource(OrderSourceEnum.PATIENT_ORDER.getValue());
        orderEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        orderEntity.setxUpdateTime(orderEntity.getxCreateTime());
        orderEntity.setMainId(medicalMoveMainVO.getDrugMainEntity().getxId());
        orderEntity.setPayTime(medicalMoveMainVO.getDrugMainEntity().getxCreateTime());
        orderEntity.setOrderSeq(orderSeq);
        orderEntity.setOrderAmount(medicalMoveMainVO.getDrugPrescriptionEntity().getPrice());
        orderEntity.setPayAmount(medicalMoveMainVO.getDrugPrescriptionEntity().getPrice());
        orderEntity.setSelfAmount(medicalMoveMainVO.getDrugPrescriptionEntity().getPrice());
        orderEntity.setTotalDrugAmount(medicalMoveMainVO.getDrugPrescriptionEntity().getPrice());
        orderEntity.setOrganCode(medicalMoveMainVO.getDrugMainEntity().getPresOrgan());
        orderEntity.setStatus(OrderStatusEnum.PAID.getValue());
        orderEntity.setPayMethod(PayMethodEnum.NCEFY_OFFLINE_MEDICAL_INS_PAY.getValue());
        orderEntity.setChannelCode(PayChannelEnum.NCEFY_OFFLINE_MEDICAL_INS.getValue());
        this.mosDrugOrderMapper.insert(orderEntity);
        if (Integer.valueOf(2).equals(medicalMoveMainVO.getLogisticsType())) {
            DrugLogisticsOrderEntity logisticsOrderEntity = new DrugLogisticsOrderEntity();
            String logisticsOrderSeq = GenSeqUtils.genOrderSeq((String)"");
            logisticsOrderEntity.setPayMethod(orderEntity.getPayMethod());
            logisticsOrderEntity.setPayAmount(BigDecimal.ZERO);
            logisticsOrderEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            logisticsOrderEntity.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            logisticsOrderEntity.setOrderSeq(logisticsOrderSeq);
            logisticsOrderEntity.setDestProvince(medicalMoveMainVO.getDestProvince());
            logisticsOrderEntity.setDestCity(medicalMoveMainVO.getDestCity());
            logisticsOrderEntity.setDestDistrict(medicalMoveMainVO.getDestDistrict());
            logisticsOrderEntity.setDestDetailAddress(medicalMoveMainVO.getDestDetailAddress());
            logisticsOrderEntity.setDestAddress(medicalMoveMainVO.getDestProvince() + medicalMoveMainVO.getDestCity() + medicalMoveMainVO.getDestDistrict() + medicalMoveMainVO.getDestDetailAddress());
            logisticsOrderEntity.setDestName(medicalMoveMainVO.getDestName());
            logisticsOrderEntity.setDestPhone(medicalMoveMainVO.getDestPhone());
            logisticsOrderEntity.setAppCode(medicalMoveMainVO.getDrugMainEntity().getPresOrgan());
            logisticsOrderEntity.setDepositumInfo("\u836f\u54c1");
            if (Objects.nonNull(drugStoreEntity)) {
                logisticsOrderEntity.setSrcAddress(drugStoreEntity.getDetailAddress());
                logisticsOrderEntity.setSrcPhone(drugStoreEntity.getStoreTelephone());
                logisticsOrderEntity.setSrcName(drugStoreEntity.getStoreName());
                logisticsOrderEntity.setDeliveryStoreId(drugStoreEntity.getxId());
            }
            if (DrugTypeEnum.CM.getValue().equals(medicalMoveMainVO.getDrugMainEntity().getPresType())) {
                logisticsOrderEntity.setProductCode("CHINESE_HERBAL");
            } else {
                logisticsOrderEntity.setProductCode("OTHER");
            }
            logisticsOrderEntity.setLogisticsName(medicalMoveMainVO.getLogisticsType().toString());
            logisticsOrderEntity.setOrderStatus(OrderStatusEnum.TOPAY.getValue());
            logisticsOrderEntity.setRemark("\u60a3\u8005\u59d3\u540d\uff1a" + medicalMoveMainVO.getDrugMainEntity().getPatientName());
            this.mosDrugLogisticsOrderMapper.insert(logisticsOrderEntity);
            Long id = logisticsOrderEntity.getId();
            log.info("============\u7269\u6d41\u7684\u8ba2\u5355id{}:", (Object)id);
            DrugLogisticsOrderRegEntity logisticsOrderRegEntity = new DrugLogisticsOrderRegEntity();
            logisticsOrderRegEntity.setMainId(medicalMoveMainVO.getDrugMainEntity().getxId());
            logisticsOrderRegEntity.setLogisticsOrderId(String.valueOf(id));
            logisticsOrderRegEntity.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            logisticsOrderRegEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            this.mosDrugLogisticsOrderRegMapper.insert(logisticsOrderRegEntity);
        }
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setMainId(medicalMoveMainVO.getDrugMainEntity().getxId());
        drugRemarkEntity.setxRemark("\u6167\u800c\u5eb7\uff0c\u540c\u6b65\u5904\u65b9");
        drugRemarkEntity.setRemarkType(RemarkTypeEnum.ADD_PRES.getValue());
        drugRemarkEntity.setxCreateTime(new Date());
        drugRemarkEntity.setxUpdateTime(new Date());
        drugRemarkEntity.setRemarkContent(drugRemarkEntity.getxRemark());
        drugRemarkEntity.setRemarkUser("ADMIN");
        drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
        this.mosDrugRemarkMapper.insert(drugRemarkEntity);
        log.info("\u60e0\u800c\u5eb7\u63a8\u9001\u5904\u65b9\u5b8c\u6210\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public String commerceCreateMain(DrugPayReqVO drugPayReqVO) {
        if (Objects.isNull(drugPayReqVO) || Objects.isNull(drugPayReqVO.getCommerceCreateMainVO()) || CollectionUtils.isEmpty((Collection)drugPayReqVO.getCommerceCreateMainVO().getPrescriptionImageUrls()) && StringUtils.isBlank((String)drugPayReqVO.getCommerceCreateMainVO().getOrganId())) {
            throw new BusinessException("\u8bf7\u4e0a\u4f20\u5904\u65b9\u56fe\u7247\u6216\u8005\u9009\u62e9\u5f00\u65b9\u533b\u9662");
        }
        if (CollectionUtils.isEmpty((Collection)drugPayReqVO.getCommerceCreateMainVO().getDrugListVOS())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u836f\u54c1");
        }
        if (StringUtils.isBlank((String)drugPayReqVO.getStoreId())) {
            drugPayReqVO.setStoreId(drugPayReqVO.getLogisticsPayReqVO().getDeliveryStoreId());
        }
        DrugMainEntity drugMainEntity = new DrugMainEntity();
        drugMainEntity.setxId(GenSeqUtils.getUniqueNo());
        drugMainEntity.setxCreateTime(new Date());
        drugMainEntity.setxUpdateTime(new Date());
        drugMainEntity.setRemark("\u7535\u5546\u5c0f\u7a0b\u5e8f\u751f\u6210");
        drugMainEntity.setItemStatus(DrugMainStatusEnum.ZRYH_UNPAID.getValue());
        drugMainEntity.setAppCode(drugPayReqVO.getAppCode());
        drugMainEntity.setPresOrgan(drugPayReqVO.getAppCode());
        drugMainEntity.setPresOrganName(drugPayReqVO.getCommerceCreateMainVO().getOrganName());
        drugMainEntity.setOrganId(drugPayReqVO.getCommerceCreateMainVO().getOrganId());
        drugMainEntity.setPatientUserId(drugPayReqVO.getPatientUserId());
        drugMainEntity.setPatientId(drugPayReqVO.getCommerceCreateMainVO().getPatientId());
        drugMainEntity.setPatientName(drugPayReqVO.getCommerceCreateMainVO().getPatientName());
        drugMainEntity.setPatientPhone(drugPayReqVO.getCommerceCreateMainVO().getPatientPhone());
        drugMainEntity.setPatientAge(drugPayReqVO.getCommerceCreateMainVO().getPatientAge());
        drugMainEntity.setPatientGender(drugPayReqVO.getCommerceCreateMainVO().getPatientSex());
        drugMainEntity.setStatus(BaseStatusEnum.NORMAL.getValue());
        drugMainEntity.setFailureTime(DateUtils.addDay((Date)new Date(), (int)3));
        drugMainEntity.setPresType(Integer.valueOf(4));
        drugMainEntity.setPrescriptionSource(PrescriptionSourceEnum.E_COMMERCE.getValue());
        drugMainEntity.setPrescriptionType(MainTypeEnum.E_COMMERCE_STORE_DRUG_MAIN.getValue());
        this.mosDrugMainMapper.insert(drugMainEntity);
        DrugPrescriptionEntity drugPrescriptionEntity = new DrugPrescriptionEntity();
        drugPrescriptionEntity.setxId(GenSeqUtils.getUniqueNo());
        BigDecimal totalPrice = BigDecimal.ZERO;
        for (CommerceCreateMainDrugListVO drugListVO : drugPayReqVO.getCommerceCreateMainVO().getDrugListVOS()) {
            if (StringUtils.isBlank((String)drugListVO.getDrugId())) {
                throw new BusinessException("\u5904\u65b9\u8be6\u60c5\u836f\u54c1id\u4e3a\u7a7a");
            }
            if (Objects.isNull(drugListVO.getBuyQty())) {
                throw new BusinessException("\u836f\u54c1\u6570\u91cf\u4e3a\u7a7a");
            }
            DrugItemBO drugItemBO = this.mosDrugItemMapper.selectDrugBOByDrugIdANDCompanyId(null, drugListVO.getDrugId(), drugPayReqVO.getStoreId(), drugPayReqVO.getAppCode());
            if (Objects.isNull(drugItemBO)) {
                throw new BusinessException("\u8d2d\u4e70\u7684\u836f\u54c1\u4e0d\u5b58\u5728\u6216\u5df2\u4e0b\u67b6");
            }
            DrugDetailEntity drugDetailEntity = new DrugDetailEntity();
            drugDetailEntity.setxId(GenSeqUtils.getUniqueNo());
            drugDetailEntity.setxCreateTime(new Date());
            drugDetailEntity.setxUpdateTime(new Date());
            drugDetailEntity.setMainId(drugMainEntity.getxId());
            drugDetailEntity.setOrganCode(drugMainEntity.getPresOrgan());
            drugDetailEntity.setAmountUnit(drugItemBO.getWholePackingUnitName());
            drugDetailEntity.setWholePackingUnit(drugItemBO.getWholePackingUnitId());
            drugDetailEntity.setMinBillPackingUnit(drugItemBO.getMinBillPackingUnitName());
            drugDetailEntity.setMinBillPackingNum(drugItemBO.getMeasureNum());
            drugDetailEntity.setMeasureNum(drugItemBO.getMeasureNum());
            drugDetailEntity.setMeasureUnit(drugItemBO.getMeasureUnitName());
            drugDetailEntity.setPresId(drugPrescriptionEntity.getxId());
            drugDetailEntity.setDrugId(drugItemBO.getId());
            drugDetailEntity.setDrugName(drugItemBO.getCommonName());
            drugDetailEntity.setUnitPrice(new BigDecimal(drugItemBO.getPrice()));
            drugDetailEntity.setDrugCommonCode(drugItemBO.getCommonCode());
            drugDetailEntity.setManufacturer(drugItemBO.getManufacturer());
            drugDetailEntity.setDrugSpec(drugItemBO.getDrugSpec());
            drugDetailEntity.setWholePackingUnit(drugItemBO.getWholePackingUnitName());
            drugDetailEntity.setAmount(new BigDecimal(drugListVO.getBuyQty()));
            drugDetailEntity.setTotalPrice(drugDetailEntity.getUnitPrice().multiply(drugDetailEntity.getAmount()));
            totalPrice = totalPrice.add(drugDetailEntity.getTotalPrice());
            this.mosDrugDetailMapper.insert(drugDetailEntity);
        }
        drugPrescriptionEntity.setxCreateTime(new Date());
        drugPrescriptionEntity.setxUpdateTime(new Date());
        drugPrescriptionEntity.setMainId(drugMainEntity.getxId());
        drugPrescriptionEntity.setPresType(Integer.valueOf(4));
        drugPrescriptionEntity.setStorePrice(totalPrice);
        drugPrescriptionEntity.setPrice(totalPrice);
        drugPrescriptionEntity.setMainImageUrls(JSON.toJSONString((Object)drugPayReqVO.getCommerceCreateMainVO().getPrescriptionImageUrls()));
        drugPrescriptionEntity.setRecipeDate(DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
        this.mosDrugPrescriptionMapper.insert(drugPrescriptionEntity);
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setMainId(drugMainEntity.getxId());
        drugRemarkEntity.setxRemark("\u7535\u5546\u4e0b\u5355\uff0c\u5f00\u5177\u5904\u65b9");
        drugRemarkEntity.setRemarkType(RemarkTypeEnum.ADD_PRES.getValue());
        drugRemarkEntity.setxCreateTime(new Date());
        drugRemarkEntity.setxUpdateTime(new Date());
        drugRemarkEntity.setRemarkContent(drugRemarkEntity.getxRemark());
        drugRemarkEntity.setRemarkUser("ADMIN");
        drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
        this.mosDrugRemarkMapper.insert(drugRemarkEntity);
        log.info("\u7535\u5546\u5f00\u65b9\u5b8c\u6210");
        return drugMainEntity.getxId();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Transactional(rollbackFor={Exception.class})
    public void medicalPushMain(MedicalMoveMainVO medicalMoveMainVO) {
        MosOutpatientMainRelEntity mosOutpatientMainRelEntityOld;
        log.info("\u6267\u884c\u4e86\u533b\u836f\u4e91\u63a8\u9001\u5904\u65b9\u63a5\u53e3");
        if (Objects.isNull(medicalMoveMainVO) || Objects.isNull(medicalMoveMainVO.getDrugMainEntity()) || StringUtils.isEmpty((String)medicalMoveMainVO.getDrugMainEntity().getxId())) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        if (!DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(medicalMoveMainVO.getDrugMainEntity().getItemStatus())) {
            log.error("\u63a8\u8fc7\u6765\u7684\u5904\u65b9\u5df2\u7ecf\u652f\u4ed8\u4e0d\u80fd\u4fee\u6539");
            return;
        }
        DrugMainEntity mainEntity = this.mosDrugMainMapper.queryById(medicalMoveMainVO.getDrugMainEntity().getxId());
        DrugMainEntity mainEntityNew = new DrugMainEntity();
        BeanUtils.copyProperties((Object)medicalMoveMainVO.getDrugMainEntity(), (Object)mainEntityNew);
        mainEntityNew.setPrescriptionType(MainTypeEnum.NORMAL.getValue());
        DrugPrescriptionEntity drugPrescriptionEntity = new DrugPrescriptionEntity();
        BeanUtils.copyProperties((Object)medicalMoveMainVO.getDrugPrescriptionEntity(), (Object)drugPrescriptionEntity);
        DiagnosticEntity diagnosticEntity = new DiagnosticEntity();
        BeanUtils.copyProperties((Object)medicalMoveMainVO.getDiagnosticEntity(), (Object)diagnosticEntity);
        if (Objects.nonNull(mainEntity)) {
            log.info("\u63a8\u9001\u7684\u5904\u65b9\uff0c\u5f53\u524d\u5e93\u4e2d\u5df2\u7ecf\u5b58\u5728");
            if (!DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(mainEntity.getItemStatus())) {
                log.error("\u5904\u65b9\u72b6\u6001\u5f02\u5e38\uff0c{}", (Object)mainEntity.getItemStatus());
                return;
            }
            this.mosDrugMainMapper.updateByPrimaryKeySelective(mainEntityNew);
            this.mosDrugPrescriptionMapper.updateByPrimaryKeySelective(drugPrescriptionEntity);
            this.mosDiagnosticMapper.updateByPrimaryKey(diagnosticEntity);
        } else {
            mainEntityNew.setxRowid(null);
            drugPrescriptionEntity.setxRowid(null);
            diagnosticEntity.setxRowid(null);
            this.mosDrugMainMapper.insert(mainEntityNew);
            drugPrescriptionEntity.setxRowid(null);
            this.mosDrugPrescriptionMapper.insert(drugPrescriptionEntity);
            diagnosticEntity.setxRowid(null);
            this.mosDiagnosticMapper.insert(diagnosticEntity);
        }
        if (Objects.nonNull(medicalMoveMainVO.getDrugExtendEntity()) && StringUtils.isNotBlank((String)medicalMoveMainVO.getDrugExtendEntity().getxId())) {
            this.mosDrugExtendMapper.deleteByPrimaryKey(medicalMoveMainVO.getDrugExtendEntity().getxId());
            DrugExtendEntity drugExtendEntity = new DrugExtendEntity();
            BeanUtils.copyProperties((Object)medicalMoveMainVO.getDrugExtendEntity(), (Object)drugExtendEntity);
            drugExtendEntity.setxRowid(null);
            this.mosDrugExtendMapper.insert(drugExtendEntity);
        }
        this.mosDrugDetailMapper.deleteDetailsByMainId(mainEntityNew.getxId(), null);
        for (DrugDetailEntityPushVO drugDetailEntityPushVO : medicalMoveMainVO.getDrugDetailEntity()) {
            DrugDetailEntity drugDetailEntity = new DrugDetailEntity();
            BeanUtils.copyProperties((Object)drugDetailEntityPushVO, (Object)drugDetailEntity);
            drugDetailEntity.setxRowid(null);
            this.mosDrugDetailMapper.insert(drugDetailEntity);
        }
        if (Integer.valueOf(1).equals(medicalMoveMainVO.getIsHaveAudit())) {
            DrugTJAuditEntity drugTJAuditEntity = new DrugTJAuditEntity();
            BeanUtils.copyProperties((Object)medicalMoveMainVO.getDrugTJAuditEntity(), (Object)drugTJAuditEntity);
            this.drugTJAuditMapper.insert(drugTJAuditEntity);
        }
        if (Objects.nonNull(medicalMoveMainVO.getMosOutpatientMainRelEntity()) && Objects.isNull(mosOutpatientMainRelEntityOld = this.mosOutpatientMainRelMapper.getByMainId(mainEntityNew.getxId()))) {
            MosOutpatientMainRelEntity mosOutpatientMainRelEntity = new MosOutpatientMainRelEntity();
            BeanUtils.copyProperties((Object)medicalMoveMainVO.getMosOutpatientMainRelEntity(), (Object)mosOutpatientMainRelEntity);
            this.mosOutpatientMainRelMapper.insert(mosOutpatientMainRelEntity);
        }
        if (Objects.nonNull(medicalMoveMainVO.getDrugRemarkEntity())) {
            DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
            BeanUtils.copyProperties((Object)medicalMoveMainVO.getDrugRemarkEntity(), (Object)drugRemarkEntity);
            drugRemarkEntity.setxRowid(null);
            this.mosDrugRemarkMapper.insert(drugRemarkEntity);
        }
        this.mosMainPushRecordMapper.updateStatus(Integer.valueOf(0), mainEntityNew.getxId());
        MosMainPushRecordEntity mosMainPushRecordEntity = new MosMainPushRecordEntity();
        mosMainPushRecordEntity.setMainId(mainEntityNew.getxId());
        mosMainPushRecordEntity.setCallBackUrl(medicalMoveMainVO.getCallBackUrl());
        mosMainPushRecordEntity.setIsNeedCallBack(medicalMoveMainVO.getIsCallBack());
        mosMainPushRecordEntity.setStatus(Integer.valueOf(1));
        mosMainPushRecordEntity.setCreateTime(new Date());
        mosMainPushRecordEntity.setIsHaveAudit(medicalMoveMainVO.getIsHaveAudit());
        mosMainPushRecordEntity.setRequestBody(JSON.toJSONString((Object)medicalMoveMainVO));
        mosMainPushRecordEntity.setSourceType(medicalMoveMainVO.getSourceType());
        mosMainPushRecordEntity.setCreateTime(new Date());
        mosMainPushRecordEntity.setUpdateTime(new Date());
        this.mosMainPushRecordMapper.insert(mosMainPushRecordEntity);
        if (Objects.isNull(mainEntity)) {
            log.info("\u51c6\u5907\u53c2\u6570\uff0c\u52a0\u5165mq\u961f\u5217");
            if (MainSourceTypeEnum.MEDICAL_HIS.getValue().equals(medicalMoveMainVO.getSourceType())) {
                RabbitMqUtils.addMainNoPay((RabbitTemplate)this.rabbitTemplate, (String)medicalMoveMainVO.getDrugMainEntity().getxId(), (Integer)259200);
                mainEntityNew.setFailureTime(DateTimeUtil.addDay((Date)new Date(), (int)3));
            } else {
                RabbitMqUtils.addMainNoPay((RabbitTemplate)this.rabbitTemplate, (String)medicalMoveMainVO.getDrugMainEntity().getxId(), (Integer)TWENTY_FOUR_HOURS);
                mainEntityNew.setFailureTime(DateTimeUtil.addDay((Date)new Date(), (int)1));
            }
        }
        mainEntityNew.setxId(medicalMoveMainVO.getDrugPrescriptionEntity().getMainId());
        this.mosDrugMainMapper.updateByPrimaryKeySelective(mainEntityNew);
    }

    public List<DrugDetailExcel> exportDrugDetailExcel(List<String> mainIds) {
        List queryDrugDetailDtoList = this.mosDrugMainMapper.exportDrugDetailExcel(mainIds);
        ArrayList<DrugDetailExcel> result = new ArrayList<DrugDetailExcel>();
        int index = 1;
        for (QueryDrugDetailDto queryDrugDetailDto : queryDrugDetailDtoList) {
            String itemStatusStr;
            DrugDetailExcel drugDetailExcel = new DrugDetailExcel();
            drugDetailExcel.setId(String.valueOf(index++));
            drugDetailExcel.setPresCode(queryDrugDetailDto.getPresCode());
            switch (queryDrugDetailDto.getItemStatus()) {
                case 80: {
                    itemStatusStr = "\u5df2\u9000\u6b3e";
                    break;
                }
                case 100: {
                    itemStatusStr = "\u5f85\u7b7e\u6536";
                    break;
                }
                default: {
                    itemStatusStr = DrugMainStatusEnum.getDesc((Integer)queryDrugDetailDto.getItemStatus());
                }
            }
            drugDetailExcel.setItemStatus(itemStatusStr);
            drugDetailExcel.setPatientName(queryDrugDetailDto.getPatientName());
            drugDetailExcel.setPatientGender(queryDrugDetailDto.getPatientGender().equals(Short.valueOf(SexEnum.MALE.getValue() + "")) ? "\u7537" : "\u5973");
            drugDetailExcel.setPatientAge(queryDrugDetailDto.getPatientAge());
            drugDetailExcel.setPatientNo(queryDrugDetailDto.getPatientNo());
            drugDetailExcel.setPatientPhone(queryDrugDetailDto.getPatientPhone());
            drugDetailExcel.setPatientCredNo(queryDrugDetailDto.getPatientCredNo());
            drugDetailExcel.setPresDoctorName(queryDrugDetailDto.getPresDoctorName());
            drugDetailExcel.setPresDoctorCode(queryDrugDetailDto.getPresDoctorCode());
            drugDetailExcel.setPresDoctorPhone(queryDrugDetailDto.getPresDoctorPhone());
            drugDetailExcel.setPresOrganName(queryDrugDetailDto.getPresOrganName());
            drugDetailExcel.setPresDeptName(queryDrugDetailDto.getPresDeptName());
            drugDetailExcel.setRecipeDate(DateUtils.formatDateTime((Date)queryDrugDetailDto.getXCreateTime()));
            drugDetailExcel.setStoreName(queryDrugDetailDto.getStoreName());
            drugDetailExcel.setPharmaceuticalCompanyName(queryDrugDetailDto.getPharmaceuticalCompanyName());
            drugDetailExcel.setDrugName(queryDrugDetailDto.getDrugName());
            drugDetailExcel.setDrugSpec(queryDrugDetailDto.getDrugSpec());
            drugDetailExcel.setManufacturer(queryDrugDetailDto.getManufacturer());
            drugDetailExcel.setDrugUsage("\u6bcf\u6b21" + String.valueOf(queryDrugDetailDto.getSingleDose() == null ? BigDecimal.ZERO : queryDrugDetailDto.getSingleDose()) + queryDrugDetailDto.getMeasureUnit() + "," + queryDrugDetailDto.getUsageDesc() + "," + queryDrugDetailDto.getFrequencyDesc());
            drugDetailExcel.setAmount(queryDrugDetailDto.getAmount() != null ? String.valueOf(queryDrugDetailDto.getAmount().doubleValue()) : "0");
            drugDetailExcel.setUnitPrice(String.valueOf(queryDrugDetailDto.getUnitPrice()));
            drugDetailExcel.setTotalPrice(String.valueOf(queryDrugDetailDto.getTotalPrice()));
            drugDetailExcel.setBankTradeNo(queryDrugDetailDto.getBankTradeNo());
            BeanHelper.nullToEmpty((Object)drugDetailExcel);
            result.add(drugDetailExcel);
        }
        return result;
    }

    public BaseResponse updatePresPrice(UpdatePresPriceReqVo updatePresPriceReqVo) {
        DrugDetailEntity drugDetailEntity = this.detailService.getById(updatePresPriceReqVo.getPresDetailId());
        BigDecimal price = new BigDecimal(updatePresPriceReqVo.getDrugPrice());
        if (Objects.nonNull(updatePresPriceReqVo.getDrugId())) {
            DrugItemEntity itemEntity = this.mosDrugItemMapper.selectById(updatePresPriceReqVo.getDrugId());
            drugDetailEntity.setDrugCommonCode(itemEntity.getCommonCode());
            drugDetailEntity.setManufacturer(itemEntity.getManufacturer());
        }
        drugDetailEntity.setUnitPrice(price);
        drugDetailEntity.setDrugId(updatePresPriceReqVo.getDrugId());
        drugDetailEntity.setTotalPrice(price.multiply(drugDetailEntity.getAmount()));
        drugDetailEntity.setAmountUnit(updatePresPriceReqVo.getWholePackingUnitName());
        drugDetailEntity.setWholePackingUnit(updatePresPriceReqVo.getWholePackingUnitName());
        this.detailService.updateById(drugDetailEntity);
        List drugDetailEntityList = this.detailService.listByMainId(drugDetailEntity.getMainId());
        double totalCostDouble = drugDetailEntityList.stream().mapToDouble(drugPrescriptionEntity -> drugPrescriptionEntity.getTotalPrice().doubleValue()).sum();
        BigDecimal totalCost = BigDecimal.valueOf(totalCostDouble);
        DrugPrescriptionEntity drugPrescriptionEntity2 = this.mosDrugPrescriptionService.queryByMainId(drugDetailEntity.getMainId());
        drugPrescriptionEntity2.setStorePrice(totalCost.setScale(2, 4));
        drugPrescriptionEntity2.setPrice(totalCost.setScale(2, 4));
        this.mosDrugPrescriptionService.update(drugPrescriptionEntity2);
        return BaseResponse.success();
    }

    public BaseResponse confirmPay(ConfirmPayDtoReq confirmPayDtoReq) {
        BigDecimal payAmount;
        log.info("======>>\u836f\u623f\u786e\u8ba4\u652f\u4ed8,\u4fe1\u606f\u662f:{}", (Object)JSONObject.toJSONString((Object)confirmPayDtoReq));
        try {
            payAmount = BigDecimalUtil.getPriceByString((String)confirmPayDtoReq.getPayAmount());
            if (Objects.isNull(payAmount)) {
                throw new BusinessException("\u5b9e\u6536\u91d1\u989d\u683c\u5f0f\u9519\u8bef\uff01");
            }
        }
        catch (NumberFormatException e) {
            throw new BusinessException("\u5b9e\u6536\u91d1\u989d\u683c\u5f0f\u9519\u8bef\uff01");
        }
        String payAmountString = BigDecimalUtil.getNoZeros((BigDecimal)payAmount);
        if (payAmountString.contains(".") && payAmountString.substring(payAmountString.lastIndexOf(".") + 1).length() > 2) {
            throw new BusinessException("\u5b9e\u6536\u91d1\u989d\u683c\u5f0f\u53ea\u80fd\u4e3a\u5c0f\u6570\u70b9\u540e\u4e24\u4f4d\uff01");
        }
        String mainId = confirmPayDtoReq.getMainId();
        DrugMainEntity drugMainEntity = this.mosDrugMainService.queryById(mainId);
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderService.queryByMainId(mainId);
        if (drugOrderEntity == null || drugMainEntity == null) {
            throw new BusinessException("\u786e\u8ba4\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u6216\u533b\u5631\u65f6\u53d1\u751f\u5f02\u5e38\uff01");
        }
        if (!DrugMainStatusEnum.OFFLINE_CONFIRM.getValue().equals(drugMainEntity.getItemStatus())) {
            throw new BusinessException("\u6b64\u72b6\u6001\u4e0d\u652f\u6301\u5230\u5e97\u652f\u4ed8\uff01");
        }
        if (payAmount.compareTo(new BigDecimal("0")) < 0 || payAmount.compareTo(drugOrderEntity.getTotalDrugAmount()) > 0) {
            throw new BusinessException("\u5b9e\u6536\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u6216\u5927\u4e8e\u8ba2\u5355\u91d1\u989d\uff01");
        }
        if (OrderResourceTypeEnum.E_COMMERCE_STORE_ORDER.getValue().equals(drugOrderEntity.getOrderSource())) {
            List drugListVOS;
            Object value = this.redisUtil.get("CFLZ:ORDER:COMMERCE_SHOPPING_CART_" + drugMainEntity.getxId() + drugOrderEntity.getxId());
            if (Objects.nonNull(value) && StringUtils.isNotBlank((String)value.toString()) && CollectionUtils.isNotEmpty((Collection)(drugListVOS = JSON.parseArray((String)value.toString(), CommerceCreateMainDrugListVO.class)))) {
                this.shoppingCartService.afterPayment(new AfterPaymentVO(drugMainEntity.getPatientLoginPhone(), drugMainEntity.getStoreId(), drugListVOS.parallelStream().map(CommerceCreateMainDrugListVO::getDrugId).collect(Collectors.toList())));
                this.redisUtil.del(new String[]{"CFLZ:ORDER:COMMERCE_SHOPPING_CART_" + drugMainEntity.getxId() + drugOrderEntity.getxId()});
            }
            if (Objects.nonNull(drugOrderEntity.getNextBuyTime())) {
                try {
                    long time = (drugOrderEntity.getNextBuyTime().getTime() - new Date().getTime()) / 1000L;
                    if (time > 0L) {
                        RabbitMqUtils.commerceNextPayRemind((RabbitTemplate)this.rabbitTemplate, (String)drugOrderEntity.getxId(), (Long)time);
                    }
                }
                catch (Exception exception) {
                    log.error("\u590d\u8d2d\u65f6\u95f4\u6709\u5f02\u5e38,{}", (Object)drugOrderEntity.getxId());
                }
            }
            this.mosDrugOrderService.syncPatientStore(drugMainEntity.getxId());
        }
        if (OrderTypeEnum.DRUG_ORDER.getValue().equals(drugMainEntity.getOrderType())) {
            drugOrderEntity = this.getPayNotifyDrugOrderEntity(drugOrderEntity);
            drugOrderEntity.setPayAmount(BigDecimalUtil.getPriceByString((String)confirmPayDtoReq.getPayAmount()));
            drugOrderEntity.setSelfAmount(drugOrderEntity.getPayAmount());
            this.mosDrugOrderService.update(drugOrderEntity);
            drugMainEntity.setOrderType(OrderTypeEnum.DRUG_ORDER.getValue());
            drugMainEntity.setItemStatus(DrugMainStatusEnum.TO_TAKE.getValue());
            this.mosDrugMainService.update(drugMainEntity);
            RabbitMqUtils.senderDelayedPrescriptionOrder((RabbitTemplate)this.rabbitTemplate, (String)drugMainEntity.getxId(), (Integer)259200);
            return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
        }
        drugOrderEntity = this.getPayNotifyDrugOrderEntity(drugOrderEntity);
        this.mosDrugOrderService.update(drugOrderEntity);
        drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOYING.getValue());
        drugMainEntity.setOrderType(OrderTypeEnum.COURIER_ORDER.getValue());
        this.mosDrugMainService.update(drugMainEntity);
        DrugLogisticsOrderRegEntity mosDrugLogisticsOrderRegEntity = this.mosDrugLogisticsOrderRegMapper.getByMainId1(drugMainEntity.getxId());
        DrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByPrimaryKey(mosDrugLogisticsOrderRegEntity.getLogisticsOrderId());
        log.info("\u7269\u6d41\u8ba2\u5355\u4fe1\u606f->{}", (Object)Objects.toString(mosDrugLogisticsOrderEntity, null));
        if (mosDrugLogisticsOrderEntity == null) {
            return BaseResponse.success();
        }
        if (OrderStatusEnum.PAID.getValue().equals(mosDrugLogisticsOrderEntity.getOrderStatus())) {
            return BaseResponse.success();
        }
        mosDrugLogisticsOrderEntity.setOrderStatus(OrderStatusEnum.PAID.getValue());
        mosDrugLogisticsOrderEntity.setPayTime(new Date());
        mosDrugLogisticsOrderEntity.setPayMethod(PayTypeEnum.NCEFY_OFFLINE_MEDICAL_INS_PAY.getValue());
        this.mosDrugLogisticsOrderMapper.updateByPrimaryKeySelective(mosDrugLogisticsOrderEntity);
        return BaseResponse.success();
    }

    public void updateOrdersState(UpdateOrdersStateReqVo updateOrdersStateReqVo) {
        log.info("\u6267\u884c\u4e86HIS\u64a4\u9500\u5904\u65b9\u7684\u63a5\u53e3");
        OrganizationResDTO organizationResDTO = this.doctorRetmoteManage.getByHospitalName("\u5357\u660c\u5927\u5b66\u7b2c\u4e8c\u9644\u5c5e\u533b\u9662");
        updateOrdersStateReqVo.getUpdateOEORIInfoList().stream().forEach(updateOEORIInfo -> {
            DrugMainEntity drugMainEntity;
            Integer status = 1;
            if (STOP_STATUS.equalsIgnoreCase(updateOEORIInfo.getOeoriStatusCode()) || REVOKE_STATUS.equalsIgnoreCase(updateOEORIInfo.getOeoriStatusCode())) {
                status = 0;
                log.info("\u72b6\u6001\u4e3a\u64a4\u9500");
            } else {
                log.info("\u72b6\u6001\u4e3a\u4e0d\u64a4\u9500");
            }
            if (status == 0 && Objects.nonNull(drugMainEntity = this.mosDrugMainMapper.getByPresDetailHisIdAndHospitalId(updateOEORIInfo.getOeoriOrderItemID(), organizationResDTO.getId().toString())) && DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(drugMainEntity.getItemStatus())) {
                log.info("\u5f53\u524d\u5904\u65b9\u64a4\u9500,mainId:{},\u72b6\u6001:{}", (Object)drugMainEntity.getxId(), (Object)drugMainEntity.getItemStatus());
                this.mosDrugMainMapper.updateStatusByPresDetailHisIdAndHospitalId(status, updateOEORIInfo.getOeoriOrderItemID(), organizationResDTO.getId().toString());
            }
        });
        log.info("\u64a4\u9500\u5b8c\u6bd5");
    }

    @Transactional
    public void revokeMain(RevokeMainVO revokeMainVO) {
        log.info("\u533b\u836f\u4e91--\u64a4\u9500\u5904\u65b9\u63a5\u53e3\u88ab\u8c03\u7528,\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)revokeMainVO));
        DrugMainEntity oldHisDrugMainEntity = this.mosDrugMainMapper.getByHisRecipeNo(revokeMainVO.getPresNo());
        if (Objects.isNull(oldHisDrugMainEntity)) {
            log.error("\u5f53\u524d\u5904\u65b9\u627e\u4e0d\u5230\u4e86~");
            throw new BusinessException("500", "\u5f53\u524d\u5904\u65b9\u627e\u4e0d\u5230\u4e86~");
        }
        if (oldHisDrugMainEntity.getItemStatus() > DrugMainStatusEnum.ZRYH_UNPAID.getValue()) {
            log.error("\u5f53\u524d\u5904\u65b9\u5df2\u7ecf\u652f\u4ed8\uff0c\u4e0d\u80fd\u64a4\u9500");
            throw new BusinessException("500", "\u5f53\u524d\u5904\u65b9\u5df2\u7ecf\u652f\u4ed8\uff0c\u4e0d\u80fd\u64a4\u9500");
        }
        DrugMainEntity newDrugMainEntity = new DrugMainEntity();
        newDrugMainEntity.setItemStatus(DrugMainStatusEnum.USELESS.getValue());
        newDrugMainEntity.setxRemark("HIS\u64a4\u9500\u4e86\u5904\u65b9\uff0c\u64a4\u9500\u65f6\u95f4\uff1a" + DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
        newDrugMainEntity.setxId(oldHisDrugMainEntity.getxId());
        this.mosDrugMainMapper.updateByPrimaryKeySelective(newDrugMainEntity);
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setMainId(newDrugMainEntity.getxId());
        drugRemarkEntity.setxRemark(newDrugMainEntity.getxRemark().replace("HIS", revokeMainVO.getCancelDoctorName()) + "\uff0c\u64a4\u9500\u7406\u7531\uff1a" + revokeMainVO.getCancelReason());
        drugRemarkEntity.setRemarkType(RemarkTypeEnum.REVOKE.getValue());
        drugRemarkEntity.setxCreateTime(new Date());
        drugRemarkEntity.setxUpdateTime(new Date());
        drugRemarkEntity.setRemarkContent(drugRemarkEntity.getxRemark());
        drugRemarkEntity.setRemarkUser(revokeMainVO.getCancelDoctorName());
        drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
        this.mosDrugRemarkMapper.insert(drugRemarkEntity);
        log.info("\u533b\u836f\u4e91--\u64a4\u9500\u5904\u65b9\u63a5\u53e3\u8c03\u7528\u6210\u529f");
    }

    private DrugOrderEntity getPayNotifyDrugOrderEntity(DrugOrderEntity drugOrderEntity) {
        drugOrderEntity.setStatus(OrderStatusEnum.PAID.getValue());
        drugOrderEntity.setPayTime(new Date());
        drugOrderEntity.setMchId("");
        return drugOrderEntity;
    }
}

