/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.ebaiyihui.circulation.abstracts.DynamicInvokePlatformServer;
import com.ebaiyihui.circulation.common.enums.DistributionTypeEnum;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.DrugTypeEnum;
import com.ebaiyihui.circulation.common.enums.DynamicServerTypeEnum;
import com.ebaiyihui.circulation.common.enums.MerchantTypeEnum;
import com.ebaiyihui.circulation.common.enums.OrderResourceTypeEnum;
import com.ebaiyihui.circulation.common.enums.OrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.OrderTypeEnum;
import com.ebaiyihui.circulation.common.enums.PayBillOrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.PayChannelEnum;
import com.ebaiyihui.circulation.common.enums.PayMethodEnum;
import com.ebaiyihui.circulation.common.enums.PayStatusEnum;
import com.ebaiyihui.circulation.common.enums.PayTypeEnum;
import com.ebaiyihui.circulation.common.enums.PrescriptionSourceEnum;
import com.ebaiyihui.circulation.common.enums.PushWeChatMessageActionTypeEnum;
import com.ebaiyihui.circulation.common.enums.RemarkTypeEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.factory.PresRoamProcessStrategyFactory;
import com.ebaiyihui.circulation.manage.OrderPayManage;
import com.ebaiyihui.circulation.manage.PushManage;
import com.ebaiyihui.circulation.mapper.HospitalConfigMapper;
import com.ebaiyihui.circulation.mapper.MerchantConfigMapper;
import com.ebaiyihui.circulation.mapper.MosDrugDetailMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.circulation.mapper.MosDrugRemarkMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugLogisticsOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugLogisticsOrderRegEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.circulation.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.circulation.pojo.entity.MerchantConfigEntity;
import com.ebaiyihui.circulation.pojo.entity.ServicePayBillEntity;
import com.ebaiyihui.circulation.pojo.vo.order.CancelOrderRequestVO;
import com.ebaiyihui.circulation.pojo.vo.pay.FeeItemVO;
import com.ebaiyihui.circulation.pojo.vo.pay.PriceInfoFeeItem;
import com.ebaiyihui.circulation.pojo.vo.pay.QueryPrescriptionResVO;
import com.ebaiyihui.circulation.service.IMLPushMainService;
import com.ebaiyihui.circulation.service.MosDrugRemarkService;
import com.ebaiyihui.circulation.service.NcefyPrescriptionService;
import com.ebaiyihui.circulation.service.OrderPayService;
import com.ebaiyihui.circulation.service.PresRoamProcessRegService;
import com.ebaiyihui.circulation.service.PresRoamProcessService;
import com.ebaiyihui.circulation.service.ServicePayBillService;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import com.ebaiyihui.circulation.utils.HanyuPinyinUtil;
import com.ebaiyihui.circulation.utils.medicalcloud.DistanceUtil;
import com.ebaiyihui.circulation.utils.medicalcloud.SignUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.DownStorePayVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.DrugPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.LogisticsPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.LogisticsRefundReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayNotifyReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundCallBackReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundResVo;
import com.ebaiyihui.three.push.vo.WeChatPushDoctorRemindVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderPayServiceImpl
implements OrderPayService {
    private static final Logger log = LoggerFactory.getLogger(OrderPayServiceImpl.class);
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private MosDrugOrderMapper drugOrderMapper;
    @Autowired
    private NcefyPrescriptionService ncefyPrescriptionService;
    @Autowired
    private MerchantConfigMapper merchantConfigMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper drugLogisticsOrderMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper drugLogisticsOrderRegMapper;
    @Autowired
    private IMLPushMainService imlPushMainService;
    @Autowired
    private DynamicInvokePlatformServer dynamicInvokePlatformServer;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugRemarkMapper mosDrugRemarkMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private MosDrugDetailMapper drugDetailMapper;
    @Autowired
    private MosDrugPrescriptionMapper drugPrescriptionMapper;
    @Autowired
    private PresRoamProcessRegService presRoamProcessRegService;
    @Autowired
    private ServicePayBillService servicePayBillService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private MosDrugRemarkService mosDrugRemarkService;
    private static final String REPEAT_DRUG_ORDER_PAY_PREFIX = "DRUG_MAIN_ORDER_PAY";

    public boolean cancelOrder(CancelOrderRequestVO cancelOrderRequestVO) {
        log.info("\u8c03\u7528\u4e86\u7535\u5546\u53d6\u6d88\u8ba2\u5355\u63a5\u53e3");
        if (Objects.isNull(cancelOrderRequestVO) || StringUtils.isBlank((String)cancelOrderRequestVO.getOrderId())) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        DrugOrderEntity orderEntity = this.drugOrderMapper.queryById(cancelOrderRequestVO.getOrderId());
        if (Objects.isNull(orderEntity)) {
            throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (OrderStatusEnum.TOPAY.getValue() < orderEntity.getStatus()) {
            throw new BusinessException("\u53ea\u6709\u672a\u652f\u4ed8\u7684\u8ba2\u5355\u624d\u53ef\u4ee5\u53d6\u6d88");
        }
        if (StringUtils.isNotBlank((String)orderEntity.getMainId())) {
            DrugMainEntity mainEntity = this.mosDrugMainMapper.queryById(orderEntity.getMainId());
            if (Objects.nonNull(mainEntity) && DrugMainStatusEnum.OFFLINE_CONFIRM.getValue().equals(mainEntity.getItemStatus()) && Integer.valueOf(1).equals(cancelOrderRequestVO.getIsMq())) {
                log.info("\u4e0d\u81ea\u52a8\u53d6\u6d88\u5f85\u5230\u5e97\u652f\u4ed8\u8ba2\u5355");
                return false;
            }
            this.mosDrugMainMapper.updateItemStatusById(DrugMainStatusEnum.UNPAID_TIME_OUT.getValue(), orderEntity.getMainId());
            DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
            drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
            drugRemarkEntity.setxUpdateTime(new Date());
            drugRemarkEntity.setRemarkContent("\u8d85\u65f6\u672a\u652f\u4ed8");
            drugRemarkEntity.setMainId(orderEntity.getMainId());
            drugRemarkEntity.setRemarkType(RemarkTypeEnum.UNPAY_MAIN_TIME_OUT.getValue());
            drugRemarkEntity.setRemarkUser("ADMIN");
            drugRemarkEntity.setxCreateTime(new Date());
            this.mosDrugRemarkService.insert(drugRemarkEntity);
            log.info("\u6dfb\u52a0\u8d85\u65f6\u672a\u652f\u4ed8\u5904\u65b9\u5907\u6ce8\uff0c\u5b8c\u6210\u66f4\u6539\uff01");
        }
        DrugOrderEntity drugOrderEntityNew = new DrugOrderEntity();
        drugOrderEntityNew.setxId(orderEntity.getxId());
        drugOrderEntityNew.setStatus(OrderStatusEnum.CANCEL.getValue());
        drugOrderEntityNew.setInvalidTime(new Date());
        drugOrderEntityNew.setxUpdateTime(new Date());
        this.drugOrderMapper.updateByPrimaryKeySelective(drugOrderEntityNew);
        log.info("\u5b8c\u6210\u4fee\u6539\u8ba2\u5355\u4e3a\u5df2\u53d6\u6d88!");
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean createDownStoreDrug(DownStorePayVO downStorePayVO) {
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(downStorePayVO.getMainId());
        if (Objects.isNull(drugMainEntity)) {
            throw new BusinessException("\u8be5\u5904\u65b9\u627e\u4e0d\u5230\u4e86~");
        }
        if (!DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(drugMainEntity.getItemStatus())) {
            throw new BusinessException("\u53ea\u6709\u672a\u652f\u4ed8\u7684\u5904\u65b9\u53ef\u4ee5\u63a8\u9001");
        }
        DrugPayReqVO payReqVO = new DrugPayReqVO();
        BeanUtils.copyProperties((Object)downStorePayVO, (Object)payReqVO);
        payReqVO.setOrderType(OrderTypeEnum.DRUG_ORDER.getValue());
        payReqVO.setPayChannel(PayChannelEnum.NCEFY_OFFLINE_MEDICAL_INS.getValue());
        payReqVO.setPayMethod(PayMethodEnum.NCEFY_OFFLINE_MEDICAL_INS_PAY.getValue());
        this.createTradeDrug(payReqVO);
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
        drugRemarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugRemarkEntity.setRemarkContent(downStorePayVO.getOptionRemark());
        drugRemarkEntity.setMainId(downStorePayVO.getMainId());
        drugRemarkEntity.setRemarkType(RemarkTypeEnum.DOWN_STORE_NO_PAY.getValue());
        drugRemarkEntity.setRemarkUser(downStorePayVO.getOptionUser());
        drugRemarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.mosDrugRemarkMapper.insert(drugRemarkEntity);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse createTradeDrug(DrugPayReqVO vo) {
        if (Objects.isNull(vo)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        boolean isCreate = false;
        if (OrderResourceTypeEnum.E_COMMERCE_STORE_ORDER.getValue().equals(vo.getOrderSource()) && StringUtils.isBlank((String)vo.getOrderId())) {
            String mainId = this.ncefyPrescriptionService.commerceCreateMain(vo);
            vo.setMainId(mainId);
            isCreate = true;
        }
        if (!OrderResourceTypeEnum.E_COMMERCE_STORE_ORDER.getValue().equals(vo.getOrderSource()) || isCreate) {
            if (StringUtils.isBlank((String)vo.getPayChannel()) || StringUtils.isBlank((String)vo.getPayMethod())) {
                throw new BusinessException("\u652f\u4ed8\u65b9\u5f0f\u6216\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            }
            DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(vo.getMainId());
            if (!DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(drugMainEntity.getItemStatus())) {
                throw new BusinessException("\u53ea\u6709\u672a\u652f\u4ed8\u7684\u8ba2\u5355\u53ef\u4ee5\u8fdb\u884c\u652f\u4ed8\uff01");
            }
            String processCode = this.presRoamProcessRegService.getProcessCodeByAppCodeOrHospitalNameFirstLetter(drugMainEntity.getPresOrgan(), drugMainEntity.getHospitalNameFirstLetter());
            PresRoamProcessService presRoamProcessService = PresRoamProcessStrategyFactory.getPresRoamProcessStrategy((String)processCode);
            BaseResponse baseResponse = presRoamProcessService.createTradeOrder(vo);
            if (!baseResponse.isSuccess()) {
                return baseResponse;
            }
        }
        DrugOrderEntity drugOrderEntity = null;
        drugOrderEntity = OrderResourceTypeEnum.E_COMMERCE_STORE_ORDER.getValue().equals(vo.getOrderSource()) && StringUtils.isNotBlank((String)vo.getOrderId()) ? this.mosDrugOrderMapper.queryById(vo.getOrderId()) : this.mosDrugOrderMapper.queryByMainId(vo.getMainId());
        if (Objects.isNull(drugOrderEntity)) {
            throw new BusinessException("\u8ba2\u5355\u4e1a\u52a1\u5f02\u5e38!");
        }
        PayReqVO payReqVO = new PayReqVO();
        payReqVO.setMerchantId(drugOrderEntity.getMerchantId());
        payReqVO.setBizSysSeq(drugOrderEntity.getBizSysSeq());
        if (!PayTypeEnum.WECHAT_PAY.getValue().equals(drugOrderEntity.getPayMethod()) && !PayTypeEnum.ALI_PAY.getValue().equals(drugOrderEntity.getPayMethod())) {
            log.info("=====\u7ebf\u4e0b\u652f\u4ed8=====");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("orderId", (Object)drugOrderEntity.getxId());
            jsonObject.put("mainId", (Object)drugOrderEntity.getMainId());
            return BaseResponse.success((Object)jsonObject);
        }
        payReqVO.setPayAmount(drugOrderEntity.getOrderAmount());
        payReqVO.setPayChannel(drugOrderEntity.getChannelCode());
        payReqVO.setPayMethod(drugOrderEntity.getPayMethod());
        payReqVO.setOpenId(StringUtils.isEmpty((String)vo.getOpenId()) ? "" : vo.getOpenId());
        payReqVO.setOrderSeq(drugOrderEntity.getOrderSeq());
        payReqVO.setMerchantType(MerchantTypeEnum.DRUG.getValue());
        payReqVO.setMainId(drugOrderEntity.getMainId());
        payReqVO.setProductInfo("\u4e92\u8054\u7f51\u533b\u7597-\u95e8\u8bca\u7f34\u8d39");
        BaseResponse response = this.orderPayManage.createTradeServer(payReqVO);
        if (Objects.nonNull(response) && Objects.nonNull(response.getData())) {
            ((JSONObject)response.getData()).put("orderId", (Object)drugOrderEntity.getxId());
            ((JSONObject)response.getData()).put("mainId", (Object)drugOrderEntity.getMainId());
        }
        return response;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse createTradeLogistics(LogisticsPayReqVO vo) {
        if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(vo.getPayChannel()) && StringUtils.isEmpty((String)vo.getOpenId())) {
            return BaseResponse.error((String)"\u5fae\u4fe1\u5c0f\u7a0b\u5e8fopenId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HospitalConfigEntity configEntity = this.hospitalConfigMapper.selectByAppcode(vo.getAppCode());
        if (configEntity == null) {
            return BaseResponse.error((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u533b\u9662\u4fe1\u606f");
        }
        if (vo.getDistributionType() == null) {
            vo.setDistributionType(DistributionTypeEnum.CITY_EXPRESS.getValue());
        }
        DrugLogisticsOrderEntity orderEntity = null;
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById((String)vo.getMainIds().get(0));
        if (StringUtils.isNotEmpty((String)vo.getOrderId())) {
            orderEntity = this.drugLogisticsOrderMapper.selectByPrimaryKey(vo.getOrderId());
            log.info(JSON.toJSONString((Object)orderEntity));
        }
        PayReqVO payReqVO = new PayReqVO();
        String orderSeq = "";
        if (orderEntity != null) {
            if (OrderStatusEnum.PAID.getValue().equals(orderEntity.getOrderStatus())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u652f\u4ed8,\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            }
            if (orderEntity.getOrderStatus().equals(OrderStatusEnum.EXPIRED.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u8fc7\u671f");
            }
            if (orderEntity.getOrderStatus().equals(OrderStatusEnum.TOPAY.getValue())) {
                log.info("======>\u7269\u6d41\u652f\u4ed8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)orderEntity));
                orderSeq = orderEntity.getOrderSeq();
                if (!vo.getExtra().equals(orderEntity.getPayAmount())) {
                    orderSeq = GenSeqUtils.genOrderSeq((String)"");
                    orderEntity.setOrderSeq(orderSeq);
                }
                orderEntity.setPayAmount(vo.getExtra());
                orderEntity.setChannelCode(vo.getPayChannel());
                orderEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                orderEntity.setLogisticsBasisAmount(vo.getExtra().subtract(configEntity.getOverweightAmount()).subtract(configEntity.getPackStandardMoney()));
                orderEntity.setOverweightAmount(configEntity.getOverweightAmount());
                orderEntity.setPackageAmout(configEntity.getPackStandardMoney());
                orderEntity.setInvoiceNum(vo.getInvoiceNum());
                orderEntity.setInvoiceTitle(vo.getInvoiceTitle());
                orderEntity.setDestProvince(vo.getDestProvince());
                orderEntity.setDestCity(vo.getDestCity());
                orderEntity.setDestDistrict(vo.getDestDistrict());
                orderEntity.setDestDetailAddress(vo.getDestAddress());
                orderEntity.setDestAddress(vo.getDestProvince() + vo.getDestCity() + vo.getDestDistrict() + vo.getDestAddress());
                orderEntity.setDestAddressId(vo.getDestAddressId());
                orderEntity.setDestLatitude(vo.getLatitude());
                orderEntity.setDestLongitude(vo.getLongitude());
                orderEntity.setDestName(vo.getDestName());
                orderEntity.setDestPhone(vo.getDestPhone());
                orderEntity.setAppCode(vo.getAppCode());
                orderEntity.setLogisticsPayMethod(Integer.valueOf(vo.getLogisticsPayeMthod()));
                orderEntity.setDepositumInfo("\u836f\u54c1");
                orderEntity.setPackStandardMoney("3");
                orderEntity.setMonthlyCard(configEntity.getMonthlyCard());
                orderEntity.setSrcProvince(configEntity.getProvince());
                orderEntity.setSrcCity(configEntity.getCity());
                orderEntity.setSrcDistrict(configEntity.getDistrict());
                orderEntity.setSrcDetailAddress(configEntity.getDetailAddress());
                orderEntity.setSrcAddress(configEntity.getProvince() + configEntity.getCity() + configEntity.getDistrict() + configEntity.getDetailAddress());
                orderEntity.setSrcName(configEntity.getName());
                orderEntity.setSrcPhone(configEntity.getPhone());
                Double deliveryDistance = DistanceUtil.distance((double)Double.parseDouble(configEntity.getLatitude()), (double)Double.parseDouble(configEntity.getLongitude()), (double)Double.parseDouble(vo.getLatitude()), (double)Double.parseDouble(vo.getLongitude()));
                orderEntity.setDestDeliveryDistance(deliveryDistance.toString());
                if (DrugTypeEnum.CM.getValue().equals(vo.getPresType())) {
                    orderEntity.setProductCode("CHINESE_HERBAL");
                } else {
                    orderEntity.setProductCode("OTHER");
                }
                orderEntity.setExpressType(Integer.valueOf(vo.getExpressType() == null ? 1 : vo.getExpressType()));
                orderEntity.setLogisticsName(vo.getLogisticsType());
                orderEntity.setRemark("\u60a3\u8005\u59d3\u540d\uff1a" + drugMainEntity.getPatientName());
                this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(orderEntity);
                log.info("======>\u7269\u6d41\u652f\u4ed8\u66f4\u65b0\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)orderEntity));
            }
        } else {
            MerchantConfigEntity merchantConfigEntity = this.merchantConfigMapper.queryByOrganCodeAndMerchantTypeAndStoreId(Integer.valueOf(2), drugMainEntity.getStoreId());
            orderEntity = new DrugLogisticsOrderEntity();
            orderSeq = GenSeqUtils.genOrderSeq((String)"");
            orderEntity.setPayMethod(vo.getPayMethod());
            orderEntity.setPayAmount(vo.getExtra());
            orderEntity.setChannelCode(vo.getPayChannel());
            orderEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            orderEntity.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            orderEntity.setOrderSeq(orderSeq);
            orderEntity.setMchId(merchantConfigEntity.getMerchantSeq());
            orderEntity.setLogisticsBasisAmount(vo.getExtra().subtract(configEntity.getOverweightAmount()).subtract(configEntity.getPackStandardMoney()));
            orderEntity.setOverweightAmount(configEntity.getOverweightAmount());
            orderEntity.setPackageAmout(configEntity.getPackStandardMoney());
            orderEntity.setInvoiceNum(vo.getInvoiceNum());
            orderEntity.setInvoiceTitle(vo.getInvoiceTitle());
            orderEntity.setDestProvince(vo.getDestProvince());
            orderEntity.setDestCity(vo.getDestCity());
            orderEntity.setDestDistrict(vo.getDestDistrict());
            orderEntity.setDestDetailAddress(vo.getDestAddress());
            orderEntity.setDestAddress(vo.getDestProvince() + vo.getDestCity() + vo.getDestDistrict() + vo.getDestAddress());
            orderEntity.setDestAddressId(vo.getDestAddressId());
            orderEntity.setDestLatitude(vo.getLatitude());
            orderEntity.setDestLongitude(vo.getLongitude());
            orderEntity.setDestName(vo.getDestName());
            orderEntity.setDestPhone(vo.getDestPhone());
            orderEntity.setAppCode(vo.getAppCode());
            orderEntity.setLogisticsPayMethod(Integer.valueOf(vo.getLogisticsPayeMthod()));
            orderEntity.setDepositumInfo("\u836f\u54c1");
            orderEntity.setPackStandardMoney("3");
            orderEntity.setMonthlyCard(configEntity.getMonthlyCard());
            orderEntity.setSrcProvince(configEntity.getProvince());
            orderEntity.setSrcCity(configEntity.getCity());
            orderEntity.setSrcDistrict(configEntity.getDistrict());
            orderEntity.setSrcDetailAddress(configEntity.getDetailAddress());
            orderEntity.setSrcAddress(configEntity.getProvince() + configEntity.getCity() + configEntity.getDistrict() + configEntity.getDetailAddress());
            orderEntity.setSrcName(configEntity.getName());
            orderEntity.setSrcPhone(configEntity.getPhone());
            Double deliveryDistance = DistanceUtil.distance((double)Double.parseDouble(configEntity.getLatitude()), (double)Double.parseDouble(configEntity.getLongitude()), (double)Double.parseDouble(vo.getLatitude()), (double)Double.parseDouble(vo.getLongitude()));
            orderEntity.setDestDeliveryDistance(deliveryDistance.toString());
            if (DrugTypeEnum.CM.getValue().equals(vo.getPresType())) {
                orderEntity.setProductCode("CHINESE_HERBAL");
            } else {
                orderEntity.setProductCode("OTHER");
            }
            orderEntity.setExpressType(Integer.valueOf(vo.getExpressType() == null ? 1 : vo.getExpressType()));
            orderEntity.setLogisticsName(vo.getLogisticsType());
            orderEntity.setHospitalId(drugMainEntity.getOrganId());
            orderEntity.setHospitalName(drugMainEntity.getPresOrganName());
            orderEntity.setBizSysSeq(merchantConfigEntity.getBizSysSeq());
            orderEntity.setOrderStatus(OrderStatusEnum.TOPAY.getValue());
            orderEntity.setRemark("\u60a3\u8005\u59d3\u540d\uff1a" + drugMainEntity.getPatientName());
            this.drugLogisticsOrderMapper.insert(orderEntity);
            Long id = orderEntity.getId();
            log.info("============\u7269\u6d41\u7684\u8ba2\u5355id{}:", (Object)id);
            vo.getMainIds().stream().forEach(item -> {
                this.drugLogisticsOrderRegMapper.deleteByMainId(item);
                DrugLogisticsOrderRegEntity logisticsOrderRegEntity = new DrugLogisticsOrderRegEntity();
                logisticsOrderRegEntity.setMainId(item);
                logisticsOrderRegEntity.setLogisticsOrderId(String.valueOf(id));
                logisticsOrderRegEntity.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                logisticsOrderRegEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                this.drugLogisticsOrderRegMapper.insert(logisticsOrderRegEntity);
            });
        }
        payReqVO.setMerchantId(orderEntity.getMchId());
        payReqVO.setBizSysSeq(orderEntity.getBizSysSeq());
        payReqVO.setPayAmount(orderEntity.getPayAmount());
        payReqVO.setPayChannel(vo.getPayChannel());
        payReqVO.setPayMethod(vo.getPayMethod());
        payReqVO.setOpenId(StringUtils.isEmpty((String)vo.getOpenId()) ? "" : vo.getOpenId());
        payReqVO.setOrderSeq(orderSeq);
        payReqVO.setMainId(drugMainEntity.getxId());
        payReqVO.setProductInfo("\u7269\u6d41\u914d\u9001\u8d39");
        payReqVO.setMerchantType(MerchantTypeEnum.LOGISTICS.getValue());
        return this.orderPayManage.createTradeServer(payReqVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse refundLogistics(RefundCallBackReqVo refundCallBackReqVo) {
        if (!this.checkApplyKey(refundCallBackReqVo)) {
            return BaseResponse.error((String)"\u9a8c\u7b7e\u672a\u901a\u8fc7");
        }
        log.info("======>\u7269\u6d41\u9000\u6b3e\u56de\u8c03---\u53c2\u6570{}", (Object)refundCallBackReqVo.toString());
        DrugLogisticsOrderEntity orderEntity = this.drugLogisticsOrderMapper.selectByOrderSeq(refundCallBackReqVo.getOutTradeNo());
        log.info("======>\u7269\u6d41\u9000\u6b3e\u56de\u8c03---\u8ba2\u5355\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)orderEntity));
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(orderEntity.getOrderSeq(), PayBillOrderStatusEnum.REFUNDING.getValue());
        if (PayStatusEnum.SUCCESS.getValue().equalsIgnoreCase(refundCallBackReqVo.getReturnCode())) {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDED.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.SUCCESS.getValue());
        } else {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDED_FAIL.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.FAIL.getValue());
        }
        servicePayBillEntity.setRefundNo(refundCallBackReqVo.getRefundNo());
        servicePayBillEntity.setRefundTime(refundCallBackReqVo.getRefundTime());
        servicePayBillEntity.setRefundAmount(refundCallBackReqVo.getRefundMoney());
        servicePayBillEntity.setOutRefundNo(refundCallBackReqVo.getOutTradeNo());
        log.info("\u7269\u6d41\u9000\u6b3e\u56de\u8c03\u63a5\u53e3\u66f4\u65b0\u8d26\u5355\u4fe1\u606f\u8ba2\u5355\u72b6\u6001:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.update(servicePayBillEntity);
        if (orderEntity != null) {
            orderEntity.setOrderStatus(OrderStatusEnum.REFUNDED.getValue());
            orderEntity.setRefundTime(refundCallBackReqVo.getRefundTime());
            this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(orderEntity);
            List list = this.drugLogisticsOrderRegMapper.getByLogisticsOrderId(orderEntity.getId());
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(((DrugLogisticsOrderRegEntity)list.get(0)).getMainId());
                this.threadPoolTaskExecutor.execute(() -> {
                    try {
                        UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                        String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                        this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy_ddtk", drugMainEntity.getPatientPhone(), new HashMap());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        throw new BusinessException(e.getMessage());
                    }
                });
            }
        }
        return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
    }

    private boolean checkApplyKey(RefundCallBackReqVo refundNotifyReqVO) {
        String applyKey = this.merchantConfigMapper.queryApplyKeyByApplyId(refundNotifyReqVO.getApplyId());
        Map keyAndValue = SignUtil.getKeyAndValue((Object)refundNotifyReqVO);
        return SignUtil.checkSign((Map)keyAndValue, (String)applyKey);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse logisticsPayCall(PayNotifyReqVO payNotifyReqVO) {
        log.info("\u7269\u6d41\u652f\u4ed8\u56de\u8c03\u4fe1\u606f->{}", (Object)JSONObject.toJSONString((Object)payNotifyReqVO));
        if ("SUCCESS".equals(payNotifyReqVO.getResultCode())) {
            DrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.drugLogisticsOrderMapper.selectByOrderSeq(payNotifyReqVO.getOutTradeNo());
            log.info("\u7269\u6d41\u8ba2\u5355\u4fe1\u606f->{}", (Object)Objects.toString(mosDrugLogisticsOrderEntity, null));
            if (mosDrugLogisticsOrderEntity == null) {
                return BaseResponse.success((Object)"SUCCESS");
            }
            if (OrderStatusEnum.PAID.getValue().equals(mosDrugLogisticsOrderEntity.getOrderStatus())) {
                return BaseResponse.success((Object)"SUCCESS");
            }
            List list = this.drugLogisticsOrderRegMapper.getByLogisticsOrderId(mosDrugLogisticsOrderEntity.getId());
            DrugMainEntity drugMainEntityStore = this.mosDrugMainMapper.queryById(((DrugLogisticsOrderRegEntity)list.get(0)).getMainId());
            this.saveLogisticsPayBill(payNotifyReqVO, mosDrugLogisticsOrderEntity, drugMainEntityStore);
            list.forEach(entity -> {
                DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(entity.getMainId());
                drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOYING.getValue());
                drugMainEntity.setOrderType(OrderTypeEnum.COURIER_ORDER.getValue());
                this.mosDrugMainMapper.updateByPrimaryKeySelective(drugMainEntity);
                this.dynamicInvokePlatformServer.adapterConfig(DynamicServerTypeEnum.DOCKING_WE_CHAT_PUSH, Integer.valueOf(drugMainEntity.getOrganId()), (Object)new WeChatPushDoctorRemindVO(drugMainEntity.getxId(), PushWeChatMessageActionTypeEnum.MAIN_LOGISTICS_ORDER_PAY_SUCCESS.name()));
            });
            mosDrugLogisticsOrderEntity.setBankTradeNo(payNotifyReqVO.getTradeNo());
            mosDrugLogisticsOrderEntity.setOrderStatus(OrderStatusEnum.PAID.getValue());
            mosDrugLogisticsOrderEntity.setDealSeq(payNotifyReqVO.getDealTradeNo());
            mosDrugLogisticsOrderEntity.setBizSysSeq(payNotifyReqVO.getServiceCode());
            mosDrugLogisticsOrderEntity.setPayTime(payNotifyReqVO.getPayTime());
            mosDrugLogisticsOrderEntity.setPayMethod(payNotifyReqVO.getPayChannel());
            this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(mosDrugLogisticsOrderEntity);
        }
        return BaseResponse.success((Object)"SUCCESS");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> applyRefundSecond(BaseOperationDto dto) {
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(dto.getMainId());
        if (drugMainEntity == null) {
            return BaseResponse.error((String)"\u7535\u5b50\u5904\u65b9\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (DrugMainStatusEnum.DEPLOY_BACK.getValue().equals(drugMainEntity.getItemStatus())) {
            return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u7ecf\u9000\u6b3e");
        }
        if (PrescriptionSourceEnum.PATIENT_COMMERCE.getValue().equals(drugMainEntity.getPrescriptionSource())) {
            throw new BusinessException("\u6167\u800c\u5eb7\u8ba2\u5355\u4e0d\u652f\u6301\u9000\u6b3e");
        }
        String processCode = this.presRoamProcessRegService.getProcessCodeByAppCodeOrHospitalNameFirstLetter(drugMainEntity.getPresOrgan(), drugMainEntity.getHospitalNameFirstLetter());
        PresRoamProcessService presRoamProcessService = PresRoamProcessStrategyFactory.getPresRoamProcessStrategy((String)processCode);
        DrugOrderEntity drugOrderEntity = this.drugOrderMapper.queryByMainId(drugMainEntity.getxId());
        if (!PayTypeEnum.WECHAT_PAY.getValue().equals(drugOrderEntity.getPayMethod()) && !PayTypeEnum.ALI_PAY.getValue().equals(drugOrderEntity.getPayMethod())) {
            if (OrderStatusEnum.REFUNDING.getValue().equals(drugOrderEntity.getStatus()) || OrderStatusEnum.REFUNDED.getValue().equals(drugOrderEntity.getStatus())) {
                return BaseResponse.success((Object)"\u6b64\u8ba2\u5355\u6b63\u5728\u9000\u6b3e\u4e2d\u6216\u5df2\u9000\u6b3e\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            log.info("=====\u7ebf\u4e0b\u652f\u4ed8 \u4e0d\u8c03\u7528\u9000\u6b3e=====");
            drugOrderEntity.setStatus(OrderStatusEnum.REFUNDED.getValue());
            this.drugOrderMapper.updateByPrimaryKeySelective(drugOrderEntity);
            DrugLogisticsOrderEntity logisticsOrderEntity = this.drugLogisticsOrderMapper.selectByMainIdAndStatus(dto.getMainId(), OrderStatusEnum.PAID.getValue());
            if (Objects.nonNull(logisticsOrderEntity)) {
                logisticsOrderEntity.setOrderStatus(OrderStatusEnum.REFUNDED.getValue());
                this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(logisticsOrderEntity);
            }
            drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOY_BACK.getValue());
            this.mosDrugMainMapper.updateByPrimaryKeySelective(drugMainEntity);
            DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
            drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
            drugRemarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugRemarkEntity.setRemarkContent(dto.getContent());
            drugRemarkEntity.setMainId(dto.getMainId());
            drugRemarkEntity.setRemarkType(RemarkTypeEnum.REFUND.getValue());
            drugRemarkEntity.setRemarkUser(dto.getOperationUser());
            drugRemarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            this.mosDrugRemarkMapper.insert(drugRemarkEntity);
            return BaseResponse.success();
        }
        return presRoamProcessService.applyRefundSecond(dto, drugMainEntity);
    }

    private PriceInfoFeeItem getPriceInfoFeeItem(FeeItemVO feeItemVO) {
        PriceInfoFeeItem priceInfoFeeItem = new PriceInfoFeeItem();
        priceInfoFeeItem.setCenteritemGrade(feeItemVO.getCenteritemgrade());
        priceInfoFeeItem.setComBo(feeItemVO.getComBo());
        priceInfoFeeItem.setCost(feeItemVO.getCost());
        priceInfoFeeItem.setDoctName(feeItemVO.getDoctName());
        priceInfoFeeItem.setDoseOnce(feeItemVO.getDoseNoce());
        priceInfoFeeItem.setDoseUnit(feeItemVO.getDoseUnit());
        priceInfoFeeItem.setDrugFlag(feeItemVO.getDrugFlag());
        priceInfoFeeItem.setExecDept(feeItemVO.getExecDept());
        priceInfoFeeItem.setFeeDate(feeItemVO.getFeeDate());
        priceInfoFeeItem.setFeeName(feeItemVO.getFeeName());
        priceInfoFeeItem.setItemCode(feeItemVO.getItemCode());
        priceInfoFeeItem.setItemName(feeItemVO.getItemName());
        priceInfoFeeItem.setMoOrder(feeItemVO.getMoOrder());
        priceInfoFeeItem.setPrice(feeItemVO.getPrice());
        priceInfoFeeItem.setPriceUnit(feeItemVO.getPriceUnit());
        priceInfoFeeItem.setQty(feeItemVO.getQty());
        priceInfoFeeItem.setRecipeNO(feeItemVO.getRecipeNO());
        priceInfoFeeItem.setSeqNO(feeItemVO.getSeqNO());
        priceInfoFeeItem.setSpecs(feeItemVO.getSpecs());
        priceInfoFeeItem.setStockDept(feeItemVO.getStockDept());
        return priceInfoFeeItem;
    }

    private boolean presWhetherSame(List<QueryPrescriptionResVO> queryPrescriptionResVOList) {
        for (QueryPrescriptionResVO prescriptionResVO : queryPrescriptionResVOList) {
            log.info("=====his\u67e5\u8be2\u7684\u5904\u65b9\u4fe1\u606f" + JSON.toJSONString((Object)prescriptionResVO));
            List feeItemList = prescriptionResVO.getFeeItem().getFeeItemList();
            DrugPrescriptionEntity drugPrescriptionEntity = this.drugPrescriptionMapper.getByHisRecipeNo(prescriptionResVO.getRecipeNO());
            List detailEntityList = this.drugDetailMapper.getByPresId(drugPrescriptionEntity.getxId());
            log.info("========\u67e5\u8be2\u51fa\u7684\u836f\u54c1\u4fe1\u606f" + JSONObject.toJSONString((Object)detailEntityList));
            if (feeItemList.size() != detailEntityList.size()) {
                log.info("=========his\u836f\u54c1\u7684\u6570\u91cf\u4e0d\u76f8\u540c");
                return true;
            }
            Map<String, DrugDetailEntity> drugMainEntityMap = detailEntityList.stream().collect(Collectors.toMap(DrugDetailEntity::getDrugCommonCode, drugDetailEntity -> drugDetailEntity));
            for (FeeItemVO feeItemVO : feeItemList) {
                DrugDetailEntity drugDetailEntity2 = drugMainEntityMap.get(feeItemVO.getItemCode());
                if (feeItemVO.getDays().equals(drugDetailEntity2.getDuration().toString()) && new BigDecimal(feeItemVO.getDoseNoce()).setScale(4, RoundingMode.HALF_UP).equals(drugDetailEntity2.getSingleDose().setScale(4, RoundingMode.HALF_UP)) && feeItemVO.getDoseUnit().equals(drugDetailEntity2.getMeasureUnit()) && new BigDecimal(feeItemVO.getPrice()).setScale(4, RoundingMode.HALF_UP).equals(drugDetailEntity2.getUnitPrice().setScale(4, RoundingMode.HALF_UP)) && new BigDecimal(feeItemVO.getQty()).setScale(4, RoundingMode.HALF_UP).equals(drugDetailEntity2.getAmount().setScale(4, RoundingMode.HALF_UP)) && new BigDecimal(feeItemVO.getCost()).setScale(4, RoundingMode.HALF_UP).equals(drugDetailEntity2.getTotalPrice().setScale(4, RoundingMode.HALF_UP)) && feeItemVO.getSpecs().equals(drugDetailEntity2.getDrugSpec()) && feeItemVO.getUseName().equals(drugDetailEntity2.getUsageDesc()) && feeItemVO.getFreqName().equals(drugDetailEntity2.getFrequencyDesc())) continue;
                log.info("=========his\u836f\u54c1\u7684\u4fe1\u606f\u4e0d\u76f8\u540c->{}", (Object)drugDetailEntity2.toString());
                return true;
            }
        }
        return false;
    }

    public BaseResponse applyRefundLogistics(LogisticsRefundReqVO vo) {
        log.info("======>\u7533\u8bf7\u7269\u6d41\u9000\u6b3e - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        DrugLogisticsOrderEntity logisticsOrderEntity = this.drugLogisticsOrderMapper.selectByPrimaryKey(vo.getLogisticsId());
        if (logisticsOrderEntity == null) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u7269\u6d41\u8ba2\u5355");
        }
        if (OrderStatusEnum.REFUNDING.getValue().equals(logisticsOrderEntity.getOrderStatus()) || OrderStatusEnum.REFUNDED.getValue().equals(logisticsOrderEntity.getOrderStatus())) {
            return BaseResponse.error((String)"\u7269\u6d41\u8d39\u7528\u6b63\u5728\u9000\u6b3e\u4e2d\u6216\u5df2\u9000\u6b3e\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
        }
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(logisticsOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.PAID.getValue());
        servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDING.getValue());
        servicePayBillEntity.setId(null);
        servicePayBillEntity.setWorkServiceCode("yyy");
        log.info("\u7533\u8bf7\u7269\u6d41\u9000\u6b3e\u63a5\u53e3\u4fdd\u5b58\u9000\u6b3e\u4e2d\u8d26\u5355:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.save(servicePayBillEntity);
        RefundReqVO logisticsRefundReqVO = new RefundReqVO();
        logisticsRefundReqVO.setOrderSeq(logisticsOrderEntity.getOrderSeq());
        logisticsRefundReqVO.setDealSeq(logisticsOrderEntity.getDealSeq());
        logisticsRefundReqVO.setMerchantId(logisticsOrderEntity.getMchId());
        logisticsRefundReqVO.setPayMethod(logisticsOrderEntity.getPayMethod());
        logisticsRefundReqVO.setPayAmount(logisticsOrderEntity.getPayAmount());
        logisticsRefundReqVO.setMerchantType(MerchantTypeEnum.LOGISTICS.getValue());
        RefundResVo logisticsRefundResVo = this.orderPayManage.applyRefundServer(logisticsRefundReqVO);
        if (!logisticsRefundResVo.isFlag()) {
            return BaseResponse.error((String)("\u7269\u6d41\u9000\u6b3e\uff1a" + logisticsRefundResVo.getMsg()));
        }
        logisticsOrderEntity.setOrderStatus(OrderStatusEnum.REFUNDING.getValue());
        this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(logisticsOrderEntity);
        List regList = this.drugLogisticsOrderRegMapper.getByLogisticsOrderId(logisticsOrderEntity.getId());
        return BaseResponse.success();
    }

    private void saveLogisticsPayBill(PayNotifyReqVO payNotifyReqVO, DrugLogisticsOrderEntity logisticsOrderEntity, DrugMainEntity drugMainEntity) {
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setAppCode(logisticsOrderEntity.getAppCode());
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigMapper.queryByOrganCodeAndMerchantTypeAndStoreId(MerchantTypeEnum.LOGISTICS.getValue(), drugMainEntity.getStoreId());
        if (Objects.nonNull(merchantConfigEntity)) {
            servicePayBillEntity.setApplyCode(merchantConfigEntity.getMerchantSeq());
        }
        servicePayBillEntity.setDealAmount(payNotifyReqVO.getTotalAmount());
        servicePayBillEntity.setDealTradeNo(payNotifyReqVO.getDealTradeNo());
        servicePayBillEntity.setGoodsInfo("\u4e92\u8054\u7f51\u8bca\u7597-\u7269\u6d41\u8d39");
        servicePayBillEntity.setOrderAmount(payNotifyReqVO.getTotalAmount());
        servicePayBillEntity.setOrganId(logisticsOrderEntity.getHospitalId());
        servicePayBillEntity.setOutTradeNo(logisticsOrderEntity.getOrderSeq());
        servicePayBillEntity.setPayChannel(payNotifyReqVO.getPayChannel());
        servicePayBillEntity.setOrganName(HanyuPinyinUtil.getFirstLettersUp((String)logisticsOrderEntity.getHospitalName()));
        servicePayBillEntity.setServiceCode(logisticsOrderEntity.getAppCode() + "_" + HanyuPinyinUtil.getFirstLettersUp((String)logisticsOrderEntity.getHospitalName()) + "_" + "yyy");
        if (payNotifyReqVO.getReturnCode().equalsIgnoreCase(PayStatusEnum.SUCCESS.getValue())) {
            servicePayBillEntity.setTradeStatus(PayStatusEnum.SUCCESS.getValue());
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.PAID.getValue());
        } else {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.PAID_FAIL.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.FAIL.getValue());
        }
        servicePayBillEntity.setTradeNo(payNotifyReqVO.getTradeNo());
        servicePayBillEntity.setTradeTime(payNotifyReqVO.getPayTime());
        servicePayBillEntity.setWorkServiceCode("yyy");
        log.info("\u7269\u6d41\u652f\u4ed8\u56de\u8c03\u63a5\u53e3\u4fdd\u5b58\u8d26\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.save(servicePayBillEntity);
    }
}

