/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.config.NodeConfig;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.HospitalConfigMapper;
import com.ebaiyihui.circulation.mapper.MosDrugStoreMapper;
import com.ebaiyihui.circulation.mapper.MosHospitalStoreRegMapper;
import com.ebaiyihui.circulation.mapper.PharmaceuticalCompanyHospitalRegMapper;
import com.ebaiyihui.circulation.mapper.PharmaceuticalCompanyMapper;
import com.ebaiyihui.circulation.pojo.bo.PharmaceuticalCompanyEntityBO;
import com.ebaiyihui.circulation.pojo.dto.PharmaceuticalCompanyDTO;
import com.ebaiyihui.circulation.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.circulation.pojo.entity.PharmaceuticalCompanyEntity;
import com.ebaiyihui.circulation.pojo.entity.PharmaceuticalCompanyHospitalRegEntity;
import com.ebaiyihui.circulation.pojo.vo.company.DeletePharmaceuticalCompanyReqVO;
import com.ebaiyihui.circulation.pojo.vo.company.HosptialDataVO;
import com.ebaiyihui.circulation.pojo.vo.company.PharmaceuticalCompanyListReqVO;
import com.ebaiyihui.circulation.pojo.vo.company.PharmaceuticalCompanyListResVO;
import com.ebaiyihui.circulation.pojo.vo.company.PharmaceuticalCompanyReqVO;
import com.ebaiyihui.circulation.pojo.vo.company.PharmaceuticalCompanyResVO;
import com.ebaiyihui.circulation.pojo.vo.company.PharmaceuticalCompanyVO;
import com.ebaiyihui.circulation.service.IDataAuthService;
import com.ebaiyihui.circulation.service.PharmaceuticalCompanyService;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.dto.PharmaceuticalCompanyBO;
import com.ebaiyihui.medicalcloud.pojo.vo.SearchHospitals;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PharmaceuticalCompanyServiceImpl
implements PharmaceuticalCompanyService {
    private static final Logger log = LoggerFactory.getLogger(PharmaceuticalCompanyServiceImpl.class);
    @Autowired
    private IDataAuthService iDataAuthService;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private PharmaceuticalCompanyMapper pharmaceuticalCompanyMapper;
    @Autowired
    private HospitalConfigMapper mosHospitalConfigMapper;
    @Autowired
    private PharmaceuticalCompanyHospitalRegMapper pharmaceuticalCompanyHospitalRegMapper;
    @Autowired
    private MosDrugStoreMapper mosDrugStoreMapper;
    @Autowired
    private MosHospitalStoreRegMapper mosHospitalStoreRegMapper;
    public static final Integer INVALID_STATUS = 0;
    public static final Integer STATUS = 1;

    public BaseResponse<PageResult<PharmaceuticalCompanyResVO>> pharmacistList(PageRequest<PharmaceuticalCompanyReqVO> pharmaceuticalCompanyReqVO) {
        log.info("\u8c03\u7528\u4e86\u67e5\u8be2\u836f\u5546\u5217\u8868\u63a5\u53e3");
        PharmaceuticalCompanyReqVO pharmaceuticalCompanyQuery = (PharmaceuticalCompanyReqVO)pharmaceuticalCompanyReqVO.getQuery();
        PharmaceuticalCompanyDTO pharmaceuticalCompanyDTO = new PharmaceuticalCompanyDTO();
        BeanUtils.copyProperties((Object)pharmaceuticalCompanyQuery, (Object)pharmaceuticalCompanyDTO);
        PageHelper.startPage((int)pharmaceuticalCompanyReqVO.getPageNum(), (int)pharmaceuticalCompanyReqVO.getPageSize());
        Page pharmaceuticalCompanyList = this.pharmaceuticalCompanyMapper.pharmacistList(pharmaceuticalCompanyDTO);
        PageResult pageResult = new PageResult();
        pageResult.setContent(new ArrayList());
        for (PharmaceuticalCompanyEntityBO pharmaceuticalCompanyEntityBO : pharmaceuticalCompanyList) {
            PharmaceuticalCompanyResVO pharmaceuticalCompanyResVO = new PharmaceuticalCompanyResVO();
            BeanUtils.copyProperties((Object)pharmaceuticalCompanyEntityBO, (Object)pharmaceuticalCompanyResVO);
            pharmaceuticalCompanyResVO.setPharmaceuticalCompanyId(pharmaceuticalCompanyEntityBO.getId());
            pageResult.getContent().add(pharmaceuticalCompanyResVO);
        }
        pageResult.setPageSize(pharmaceuticalCompanyReqVO.getPageSize());
        pageResult.setPageNum(pharmaceuticalCompanyReqVO.getPageNum());
        pageResult.setTotal(Long.valueOf(pharmaceuticalCompanyList.getTotal()).intValue());
        return BaseResponse.success((Object)pageResult);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> addPharmacist(PharmaceuticalCompanyVO pharmaceuticalCompanyVO) {
        log.info("\u6267\u884c\u4e86\u65b0\u589e\u836f\u5546\u63a5\u53e3");
        if (Objects.isNull(pharmaceuticalCompanyVO) || StringUtils.isEmpty((String)pharmaceuticalCompanyVO.getPharmaceuticalCode())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u53c2\u6570");
        }
        PharmaceuticalCompanyListReqVO companyListReqVO = new PharmaceuticalCompanyListReqVO();
        companyListReqVO.setPharmaceuticalCode(pharmaceuticalCompanyVO.getPharmaceuticalCode());
        int codeCount = this.pharmaceuticalCompanyMapper.selectCountByQO(companyListReqVO);
        if (codeCount >= 1) {
            throw new BusinessException("\u836f\u5546\u7f16\u7801\u91cd\u590d");
        }
        PharmaceuticalCompanyEntity pharmaceuticalCompanyEntity = new PharmaceuticalCompanyEntity();
        pharmaceuticalCompanyEntity.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        pharmaceuticalCompanyEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        pharmaceuticalCompanyEntity.setStatus(STATUS);
        pharmaceuticalCompanyEntity.setPharmaceuticalCode(pharmaceuticalCompanyVO.getPharmaceuticalCode());
        pharmaceuticalCompanyEntity.setPharmaceuticalCompanyName(pharmaceuticalCompanyVO.getPharmaceuticalCompanyName());
        pharmaceuticalCompanyEntity.setId(GenSeqUtils.getUniqueNo());
        int count = this.pharmaceuticalCompanyMapper.insert(pharmaceuticalCompanyEntity);
        if (count <= 0) {
            throw new BusinessException("\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        this.insertPharmaceuticalCompanyRel(pharmaceuticalCompanyVO, pharmaceuticalCompanyEntity.getId(), pharmaceuticalCompanyEntity.getPharmaceuticalCompanyName());
        return BaseResponse.success((Object)pharmaceuticalCompanyEntity.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> deletePharmacist(DeletePharmaceuticalCompanyReqVO deletePharmaceuticalCompanyReqVO) {
        log.info("\u6267\u884c\u4e86\u5220\u9664\u836f\u5546\u63a5\u53e3");
        if (Objects.isNull(deletePharmaceuticalCompanyReqVO) || StringUtils.isEmpty((String)deletePharmaceuticalCompanyReqVO.getPharmaceuticalCompanyId())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u53c2\u6570");
        }
        PharmaceuticalCompanyEntity pharmaceuticalCompanyEntity = new PharmaceuticalCompanyEntity();
        pharmaceuticalCompanyEntity.setId(deletePharmaceuticalCompanyReqVO.getPharmaceuticalCompanyId());
        pharmaceuticalCompanyEntity.setStatus(INVALID_STATUS);
        List drugStoreEntities = this.mosDrugStoreMapper.selectByCompanyId(deletePharmaceuticalCompanyReqVO.getPharmaceuticalCompanyId());
        if (CollectionUtils.isNotEmpty((Collection)drugStoreEntities)) {
            throw new BusinessException("\u8be5\u836f\u5546\u4e0b\u5b58\u5728\u672a\u5220\u9664\u7684\u836f\u623f\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        int count = this.pharmaceuticalCompanyMapper.updateById(pharmaceuticalCompanyEntity);
        log.info("\u5220\u9664\u836f\u5546\u6210\u529f,\u6210\u529f\u6570\u4e3a:{}", (Object)count);
        count = this.pharmaceuticalCompanyHospitalRegMapper.updateBatchByPharmaceuticalCompanyId(deletePharmaceuticalCompanyReqVO.getPharmaceuticalCompanyId());
        log.info("\u5220\u9664\u836f\u5546\u533b\u9662\u5173\u8054\u5173\u7cfb\u6210\u529f,\u5220\u9664\u6761\u6570:{}", (Object)count);
        count = this.iDataAuthService.deleteUserDataAuthByPharmacyId(deletePharmaceuticalCompanyReqVO.getPharmaceuticalCompanyId());
        log.info("\u5220\u9664\u836f\u5546\u76f8\u5173\u6743\u9650\u6570\u636e\u6210\u529f\uff0c\u6761\u6570\u4e3a:{}", (Object)count);
        return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> updatePharmacist(PharmaceuticalCompanyVO pharmaceuticalCompanyVO) {
        if (StringUtils.isEmpty((String)pharmaceuticalCompanyVO.getPharmaceuticalCompanyId())) {
            throw new BusinessException("\u836f\u5546id\u4e3a\u7a7a");
        }
        List oldHospitalList = this.pharmaceuticalCompanyHospitalRegMapper.selectByPharmaceuticalCompanyId(pharmaceuticalCompanyVO.getPharmaceuticalCompanyId());
        List newHospitalList = pharmaceuticalCompanyVO.getHosptialDataVo();
        List delOldHospitalList = oldHospitalList.stream().filter(item -> !newHospitalList.stream().map(HosptialDataVO::getOrganId).collect(Collectors.toList()).contains(item.getOrganId())).collect(Collectors.toList());
        if (delOldHospitalList.size() > 0) {
            List storesList = this.mosHospitalStoreRegMapper.selectStoreByHospital(delOldHospitalList, pharmaceuticalCompanyVO.getPharmaceuticalCompanyId());
            if (storesList.size() > 0) {
                throw new BusinessException("\u53bb\u9664\u7684\u533b\u9662\u5df2\u88ab\u90e8\u5206\u836f\u623f\u5173\u8054\u81f3\u672c\u836f\u5546\u6240\u5c5e\u533b\u9662\uff0c\u8bf7\u5148\u89e3\u7ed1\u836f\u623f\u540e\u64cd\u4f5c");
            }
            log.info("\u836f\u5546:{},\u6240\u5c5e\u533b\u9662\u53d1\u751f\u53d8\u5316\uff0c\u5220\u9664\u7684\u533b\u9662:{}", (Object)pharmaceuticalCompanyVO.getPharmaceuticalCompanyId(), delOldHospitalList);
            int i = this.mosHospitalStoreRegMapper.updateStartOrganIdAndHospitalList(delOldHospitalList, pharmaceuticalCompanyVO.getPharmaceuticalCompanyId(), DateUtils.getDateTime());
            log.info("\u836f\u5546\u533b\u9662\u53d1\u751f\u53d8\u52a8\u5220\u9664\u76f8\u5173\u836f\u623f\u5173\u8054\u6b64\u836f\u5546\u5173\u8054\u8be5\u533b\u9662\u6570\u636e\uff1a" + i);
        }
        PharmaceuticalCompanyEntity entity = new PharmaceuticalCompanyEntity();
        entity.setId(pharmaceuticalCompanyVO.getPharmaceuticalCompanyId());
        entity.setPharmaceuticalCode(pharmaceuticalCompanyVO.getPharmaceuticalCode());
        entity.setPharmaceuticalCompanyName(pharmaceuticalCompanyVO.getPharmaceuticalCompanyName());
        entity.setUpdateTime(new Date());
        int count = this.pharmaceuticalCompanyMapper.updateById(entity);
        log.info("\u4fee\u6539\u836f\u5546\u6210\u529f,\u6210\u529f\u6570\u4e3a:{}", (Object)count);
        count = this.pharmaceuticalCompanyHospitalRegMapper.updateBatchByPharmaceuticalCompanyId(pharmaceuticalCompanyVO.getPharmaceuticalCompanyId());
        log.info("\u5220\u9664\u836f\u5546\u533b\u9662\u5173\u8054\u5173\u7cfb\u6210\u529f,\u5220\u9664\u6761\u6570:{}", (Object)count);
        this.insertPharmaceuticalCompanyRel(pharmaceuticalCompanyVO, pharmaceuticalCompanyVO.getPharmaceuticalCompanyId(), pharmaceuticalCompanyVO.getPharmaceuticalCompanyName());
        return BaseResponse.success((Object)"\u66f4\u65b0\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.SUPPORTS)
    public void insertPharmaceuticalCompanyRel(PharmaceuticalCompanyVO pharmaceuticalCompanyVO, String pharmaceuticalCompanyId, String pharmaceuticalCompanyName) {
        if (CollectionUtils.isNotEmpty((Collection)pharmaceuticalCompanyVO.getHosptialDataVo())) {
            ArrayList<PharmaceuticalCompanyHospitalRegEntity> regEntities = new ArrayList<PharmaceuticalCompanyHospitalRegEntity>();
            List hospitalList = pharmaceuticalCompanyVO.getHosptialDataVo();
            for (HosptialDataVO vo : hospitalList) {
                PharmaceuticalCompanyHospitalRegEntity companyHospitalRegEntity = new PharmaceuticalCompanyHospitalRegEntity();
                companyHospitalRegEntity.setStatus(STATUS);
                companyHospitalRegEntity.setCreateTime(new Date());
                companyHospitalRegEntity.setUpdateTime(new Date());
                companyHospitalRegEntity.setHospitalName(vo.getHospitalName());
                companyHospitalRegEntity.setOrganId(vo.getOrganId());
                companyHospitalRegEntity.setPharmaceuticalCompanyId(pharmaceuticalCompanyId);
                companyHospitalRegEntity.setPharmaceuticalCompanyName(pharmaceuticalCompanyName);
                companyHospitalRegEntity.setId(GenSeqUtils.getUniqueNo());
                regEntities.add(companyHospitalRegEntity);
            }
            log.info("regEntities:{}", (Object)JSON.toJSONString(regEntities));
            int count = this.pharmaceuticalCompanyHospitalRegMapper.insertBatch(regEntities);
            if (count <= 0) {
                throw new BusinessException("\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            log.info("======>\u6dfb\u52a0\u836f\u5546\u533b\u9662\u5bf9\u7167\u5173\u7cfb - \u6dfb\u52a0\u6570\u91cf:{},\u6210\u529f\u6570\u91cf:{}", (Object)regEntities.size(), (Object)count);
        }
    }

    public BaseResponse<PharmaceuticalCompanyVO> selectPharmacistById(DeletePharmaceuticalCompanyReqVO deletePharmaceuticalCompanyReqVO) {
        log.info("\u8c03\u7528\u4e86\u67e5\u8be2\u836f\u5546\u8be6\u60c5\u63a5\u53e3");
        if (StringUtils.isEmpty((String)deletePharmaceuticalCompanyReqVO.getPharmaceuticalCompanyId())) {
            throw new BusinessException("\u836f\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PharmaceuticalCompanyVO pharmaceuticalCompanyVO = new PharmaceuticalCompanyVO();
        PharmaceuticalCompanyEntity pharmaceuticalCompanyEntity = this.pharmaceuticalCompanyMapper.selectPharmacistById(deletePharmaceuticalCompanyReqVO.getPharmaceuticalCompanyId());
        log.info("pharmaceuticalCompanyEntity:{}", (Object)JSON.toJSONString((Object)pharmaceuticalCompanyEntity));
        pharmaceuticalCompanyVO.setPharmaceuticalCompanyId(pharmaceuticalCompanyEntity.getId());
        pharmaceuticalCompanyVO.setPharmaceuticalCode(pharmaceuticalCompanyEntity.getPharmaceuticalCode());
        pharmaceuticalCompanyVO.setPharmaceuticalCompanyName(pharmaceuticalCompanyEntity.getPharmaceuticalCompanyName());
        SearchHospitals searchHospitals = new SearchHospitals();
        searchHospitals.setPharmaceuticalCompanyId(pharmaceuticalCompanyEntity.getId());
        searchHospitals.setUserId(deletePharmaceuticalCompanyReqVO.getUserId());
        List list = this.pharmaceuticalCompanyHospitalRegMapper.selectByPharmaceuticalCompanyIdToUser(searchHospitals);
        log.info("list:{}", (Object)JSON.toJSONString((Object)pharmaceuticalCompanyVO));
        pharmaceuticalCompanyVO.setHosptialDataVo(list);
        return BaseResponse.success((Object)pharmaceuticalCompanyVO);
    }

    public BaseResponse<List<HospitalConfigEntity>> selectHospitalList(String appCode) {
        HospitalConfigEntity entities = this.mosHospitalConfigMapper.selectByAppcode(appCode);
        ArrayList<HospitalConfigEntity> entityList = new ArrayList<HospitalConfigEntity>();
        entityList.add(entities);
        log.info("entities:{}", (Object)JSON.toJSONString((Object)entities));
        return BaseResponse.success(entityList);
    }

    public BaseResponse<List<PharmaceuticalCompanyListResVO>> paginglist(PharmaceuticalCompanyListReqVO pharmaceuticalCompanyListReqVO) {
        List list = this.pharmaceuticalCompanyMapper.selectList(pharmaceuticalCompanyListReqVO);
        if (StringUtils.isEmpty((String)pharmaceuticalCompanyListReqVO.getHospitalNameFirstLetter())) {
            list = list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PharmaceuticalCompanyListResVO>(Comparator.comparing(PharmaceuticalCompanyListResVO::getPharmaceuticalCompanyId))), ArrayList::new));
        }
        log.info("\u836f\u5546\u5217\u8868\u4e3a:{}", (Object)JSON.toJSONString((Object)list));
        return BaseResponse.success((Object)list);
    }

    public BaseResponse<List<PharmaceuticalCompanyBO>> list() {
        PharmaceuticalCompanyDTO dto = new PharmaceuticalCompanyDTO();
        dto.setAppCode(this.nodeConfig.getAppCode());
        Page pharmaceuticalCompanyList = this.pharmaceuticalCompanyMapper.pharmacistList(dto);
        ArrayList<PharmaceuticalCompanyBO> boList = new ArrayList<PharmaceuticalCompanyBO>();
        for (PharmaceuticalCompanyEntityBO pharmaceuticalCompanyEntityBO : pharmaceuticalCompanyList) {
            PharmaceuticalCompanyBO bo = new PharmaceuticalCompanyBO();
            BeanUtils.copyProperties((Object)pharmaceuticalCompanyEntityBO, (Object)bo);
            boList.add(bo);
        }
        return BaseResponse.success(boList);
    }

    public BaseResponse<List<HosptialDataVO>> selectPharmacistAffiliatedHospitals(SearchHospitals searchHospitals) {
        if (StringUtils.isEmpty((String)searchHospitals.getPharmaceuticalCompanyId())) {
            throw new BusinessException("\u836f\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List hospitalDataVOS = this.pharmaceuticalCompanyHospitalRegMapper.selectByPharmaceuticalCompanyIdToUser(searchHospitals);
        return BaseResponse.success((Object)hospitalDataVOS);
    }
}

