/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.ebaiyihui.circulation.abstracts.DynamicInvokePlatformServer;
import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.common.enums.DistributionTypeEnum;
import com.ebaiyihui.circulation.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.circulation.common.enums.DrugTypeEnum;
import com.ebaiyihui.circulation.common.enums.DynamicServerTypeEnum;
import com.ebaiyihui.circulation.common.enums.HospitalNamePinYinEnum;
import com.ebaiyihui.circulation.common.enums.MerchantTypeEnum;
import com.ebaiyihui.circulation.common.enums.OrderResourceTypeEnum;
import com.ebaiyihui.circulation.common.enums.OrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.OrderTypeEnum;
import com.ebaiyihui.circulation.common.enums.PayBillOrderStatusEnum;
import com.ebaiyihui.circulation.common.enums.PayChannelEnum;
import com.ebaiyihui.circulation.common.enums.PayStatusEnum;
import com.ebaiyihui.circulation.common.enums.PushWeChatMessageActionTypeEnum;
import com.ebaiyihui.circulation.common.enums.RemarkTypeEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.manage.OrderPayManage;
import com.ebaiyihui.circulation.manage.PushManage;
import com.ebaiyihui.circulation.mapper.HospitalConfigMapper;
import com.ebaiyihui.circulation.mapper.MerchantConfigMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugRemarkMapper;
import com.ebaiyihui.circulation.mapper.MosDrugStoreMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugLogisticsOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugLogisticsOrderRegEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugStoreEntity;
import com.ebaiyihui.circulation.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.circulation.pojo.entity.MerchantConfigEntity;
import com.ebaiyihui.circulation.pojo.entity.ServicePayBillEntity;
import com.ebaiyihui.circulation.pojo.vo.cart.AfterPaymentVO;
import com.ebaiyihui.circulation.pojo.vo.main.CommerceCreateMainDrugListVO;
import com.ebaiyihui.circulation.service.IZKWareHouseMainService;
import com.ebaiyihui.circulation.service.LogisticService;
import com.ebaiyihui.circulation.service.MosDrugMainService;
import com.ebaiyihui.circulation.service.MosDrugOrderService;
import com.ebaiyihui.circulation.service.MosDrugStoreService;
import com.ebaiyihui.circulation.service.PresRoamProcessService;
import com.ebaiyihui.circulation.service.PrescriptionPdfService;
import com.ebaiyihui.circulation.service.ServicePayBillService;
import com.ebaiyihui.circulation.service.impl.ShoppingCartServiceImpl;
import com.ebaiyihui.circulation.utils.BigDecimalUtil;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import com.ebaiyihui.circulation.utils.RedisUtil;
import com.ebaiyihui.circulation.utils.medicalcloud.DistanceUtil;
import com.ebaiyihui.circulation.utils.medicalcloud.RabbitMqUtils;
import com.ebaiyihui.circulation.utils.medicalcloud.RandomUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugOrderDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.DrugPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayNotifyReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundCallBackReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundResVo;
import com.ebaiyihui.three.push.vo.WeChatPushDoctorRemindVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
@PresRoamProcessCode(value="COMMON_PROCESS")
public class PresRoamCommonProcessServiceImpl
implements PresRoamProcessService {
    private static final Logger log = LoggerFactory.getLogger(PresRoamCommonProcessServiceImpl.class);
    @Autowired
    private PushManage pushManage;
    @Autowired
    private MosDrugOrderMapper drugOrderMapper;
    @Autowired
    private LogisticService logisticService;
    @Autowired
    private MerchantConfigMapper merchantConfigMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper drugLogisticsOrderMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper drugLogisticsOrderRegMapper;
    @Autowired
    private ServicePayBillService servicePayBillService;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private IZKWareHouseMainService izkWareHouseMainService;
    @Autowired
    private MosDrugRemarkMapper drugRemarkMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;
    @Autowired
    private DynamicInvokePlatformServer dynamicInvokePlatformServer;
    @Autowired
    private MosDrugOrderService drugOrderService;
    @Autowired
    private MosDrugMainService drugMainService;
    @Autowired
    private MosDrugLogisticsOrderRegMapper mosDrugLogisticsOrderRegMapper;
    @Autowired
    private PrescriptionPdfService prescriptionPdfService;
    @Autowired
    private MosDrugStoreService drugstoreService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolExecutor;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ShoppingCartServiceImpl shoppingCartService;
    public static final String RETURNCODE = "SUCCESS";
    @Autowired
    private MosDrugStoreMapper mosDrugstoreMapper;
    public static final int SEVENTY_TWO_HOURS = 259200;
    public static final int COMMERCE_ORDER_NO_PAY_TIME = 1800;
    public static final int THIRD = 3;

    public BaseResponse createTradeOrder(DrugPayReqVO drugPayReqVO) {
        if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(drugPayReqVO.getPayChannel()) && StringUtils.isEmpty((String)drugPayReqVO.getOpenId())) {
            return BaseResponse.error((String)"\u5fae\u4fe1\u5c0f\u7a0b\u5e8fopenId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(drugPayReqVO.getMainId());
        DrugOrderDTO drugOrderDTO = this.drugOrderMapper.queryOrderByMainId(drugPayReqVO.getMainId());
        log.info("======>\u836f\u54c1\u652f\u4ed8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)drugOrderDTO));
        if (drugOrderDTO == null) {
            return BaseResponse.error((String)"\u7535\u5b50\u5904\u65b9\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (BigDecimal.ZERO.equals(drugOrderDTO.getPrice())) {
            return BaseResponse.error((String)"\u836f\u54c1\u8d39\u7528\u4e0d\u80fd\u4e3a0\u5143");
        }
        if (drugOrderDTO.getOrderStatus() != null) {
            if (drugOrderDTO.getOrderStatus().equals(OrderStatusEnum.PAID.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u652f\u4ed8,\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            }
            if (drugOrderDTO.getOrderStatus().equals(OrderStatusEnum.PAYING.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u652f\u4ed8\u5904\u7406\u4e2d,\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            }
            if (drugOrderDTO.getOrderStatus().equals(OrderStatusEnum.EXPIRED.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u8fc7\u671f");
            }
        }
        DrugOrderEntity drugOrderEntity = this.drugOrderMapper.queryByMainId(drugPayReqVO.getMainId());
        drugOrderDTO.setDrugTotalAmount(drugOrderDTO.getPrice());
        if (OrderTypeEnum.COURIER_ORDER.getValue().equals(drugPayReqVO.getOrderType())) {
            HospitalConfigEntity configEntity;
            drugPayReqVO.setStoreId(drugPayReqVO.getLogisticsPayReqVO().getDeliveryStoreId());
            DrugStoreEntity storeEntity = this.mosDrugstoreMapper.selectById(drugPayReqVO.getLogisticsPayReqVO().getDeliveryStoreId());
            if (Objects.isNull(storeEntity)) {
                throw new BusinessException("\u5f53\u524d\u836f\u623f\u627e\u4e0d\u5230\u4e86");
            }
            if (Objects.nonNull(storeEntity.getDistributionStatus()) && Integer.valueOf(1).equals(storeEntity.getDistributionStatus())) {
                BigDecimal expressFee = BigDecimalUtil.getPriceByString((String)storeEntity.getExpressFee());
                drugOrderDTO.setPrice(drugOrderDTO.getPrice().add(expressFee));
                drugPayReqVO.getLogisticsPayReqVO().setExtra(expressFee);
            }
            if ((configEntity = this.hospitalConfigMapper.selectByAppcode(drugPayReqVO.getAppCode())) == null) {
                return BaseResponse.error((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u533b\u9662\u4fe1\u606f");
            }
            if (Objects.isNull(drugOrderEntity)) {
                drugOrderEntity = this.insertDrugOrderInfo(drugPayReqVO, drugOrderDTO);
            } else {
                this.updateDrugOrderEntity(drugPayReqVO, drugOrderEntity, drugMainEntity, drugOrderDTO);
            }
            DrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.drugLogisticsOrderMapper.selectByMainId(drugPayReqVO.getMainId());
            if (Objects.isNull(mosDrugLogisticsOrderEntity)) {
                this.insertLogisticsOrderInfo(drugPayReqVO, configEntity);
            } else {
                this.updateLogisticsOrderInfo(drugPayReqVO, configEntity);
            }
        } else if (Objects.nonNull(drugOrderEntity)) {
            this.updateDrugOrderEntity(drugPayReqVO, drugOrderEntity, drugMainEntity, drugOrderDTO);
        } else {
            drugOrderEntity = this.insertDrugOrderInfo(drugPayReqVO, drugOrderDTO);
        }
        drugMainEntity.setOrderType(drugPayReqVO.getOrderType());
        if (OrderTypeEnum.DRUG_ORDER.getValue().equals(drugPayReqVO.getOrderType())) {
            drugMainEntity.setStoreId(drugPayReqVO.getStoreId());
            String code = RandomUtils.generateRandom((int)6);
            drugMainEntity.setFetchMedicalCode(code);
        } else {
            drugMainEntity.setStoreId(drugPayReqVO.getLogisticsPayReqVO().getDeliveryStoreId());
        }
        drugMainEntity.setPatientLoginPhone(drugPayReqVO.getPatientLoginPhone());
        drugMainEntity.setPatientUserId(drugPayReqVO.getPatientUserId());
        this.drugMainService.update(drugMainEntity);
        if (!OrderResourceTypeEnum.E_COMMERCE_STORE_ORDER.getValue().equals(drugPayReqVO.getOrderSource())) {
            try {
                this.prescriptionPdfService.setPresPdf(drugMainEntity.getxId(), null);
            }
            catch (Exception e) {
                log.error("=============\u751f\u6210\u5904\u65b9\u7b3a\u5931\u8d25================" + e.getMessage());
            }
        } else {
            List drugListVOS;
            if (Objects.nonNull(drugPayReqVO.getCommerceCreateMainVO()) && CollectionUtils.isNotEmpty((Collection)drugPayReqVO.getCommerceCreateMainVO().getDrugListVOS()) && Integer.valueOf(1).equals(drugPayReqVO.getCommerceCreateMainVO().getIsShoppingCart()) && CollectionUtils.isNotEmpty((Collection)(drugListVOS = drugPayReqVO.getCommerceCreateMainVO().getDrugListVOS()))) {
                this.redisUtil.set("CFLZ:ORDER:COMMERCE_SHOPPING_CART_" + drugMainEntity.getxId() + drugOrderEntity.getxId(), (Object)JSON.toJSONString((Object)drugListVOS), 1800L);
            }
            RabbitMqUtils.commerceNoPay((RabbitTemplate)this.rabbitTemplate, (String)drugOrderEntity.getxId(), (Integer)1800);
        }
        return BaseResponse.success();
    }

    private void insertLogisticsOrderInfo(DrugPayReqVO vo, HospitalConfigEntity configEntity) {
        if (vo.getLogisticsPayReqVO().getDistributionType() == null) {
            vo.getLogisticsPayReqVO().setDistributionType(DistributionTypeEnum.CITY_EXPRESS.getValue());
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(vo.getMainId());
        MerchantConfigEntity merchantEntity = this.merchantConfigMapper.queryByOrganCodeAndMerchantTypeAndStoreId(Integer.valueOf(1), vo.getStoreId());
        DrugLogisticsOrderEntity orderEntityOne = new DrugLogisticsOrderEntity();
        String orderSeq = GenSeqUtils.genOrderSeq((String)"");
        orderEntityOne.setPayMethod(vo.getLogisticsPayReqVO().getPayMethod());
        orderEntityOne.setPayAmount(vo.getLogisticsPayReqVO().getExtra());
        orderEntityOne.setChannelCode(vo.getLogisticsPayReqVO().getPayChannel());
        orderEntityOne.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        orderEntityOne.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        orderEntityOne.setOrderSeq(orderSeq);
        orderEntityOne.setMchId(merchantEntity.getMerchantSeq());
        if (StringUtils.isBlank((String)vo.getLogisticsPayReqVO().getDeliveryStoreId())) {
            orderEntityOne.setLogisticsBasisAmount(vo.getLogisticsPayReqVO().getExtra().subtract(configEntity.getOverweightAmount()).subtract(configEntity.getPackStandardMoney()));
            orderEntityOne.setOverweightAmount(configEntity.getOverweightAmount());
            orderEntityOne.setPackageAmout(configEntity.getPackStandardMoney());
        }
        orderEntityOne.setInvoiceNum(vo.getLogisticsPayReqVO().getInvoiceNum());
        orderEntityOne.setInvoiceTitle(vo.getLogisticsPayReqVO().getInvoiceTitle());
        orderEntityOne.setDestProvince(vo.getLogisticsPayReqVO().getDestProvince());
        orderEntityOne.setDestCity(vo.getLogisticsPayReqVO().getDestCity());
        orderEntityOne.setDestDistrict(vo.getLogisticsPayReqVO().getDestDistrict());
        orderEntityOne.setDestDetailAddress(vo.getLogisticsPayReqVO().getDestAddress());
        orderEntityOne.setDestAddress(vo.getLogisticsPayReqVO().getDestProvince() + vo.getLogisticsPayReqVO().getDestCity() + vo.getLogisticsPayReqVO().getDestDistrict() + vo.getLogisticsPayReqVO().getDestAddress());
        orderEntityOne.setDestAddressId(vo.getLogisticsPayReqVO().getDestAddressId());
        orderEntityOne.setDestLatitude(vo.getLogisticsPayReqVO().getLatitude());
        orderEntityOne.setDestLongitude(vo.getLogisticsPayReqVO().getLongitude());
        orderEntityOne.setDestName(vo.getLogisticsPayReqVO().getDestName());
        orderEntityOne.setDestPhone(vo.getLogisticsPayReqVO().getDestPhone());
        orderEntityOne.setAppCode(vo.getLogisticsPayReqVO().getAppCode());
        orderEntityOne.setDepositumInfo("\u836f\u54c1");
        if (StringUtils.isBlank((String)vo.getLogisticsPayReqVO().getDeliveryStoreId())) {
            orderEntityOne.setExpressType(Integer.valueOf(vo.getLogisticsPayReqVO().getExpressType() == null ? 1 : vo.getLogisticsPayReqVO().getExpressType()));
            orderEntityOne.setLogisticsPayMethod(Integer.valueOf(vo.getLogisticsPayReqVO().getLogisticsPayeMthod()));
            orderEntityOne.setPackStandardMoney(configEntity.getPackStandardMoney().toString());
            orderEntityOne.setMonthlyCard(configEntity.getMonthlyCard());
            orderEntityOne.setSrcProvince(configEntity.getProvince());
            orderEntityOne.setSrcCity(configEntity.getCity());
            orderEntityOne.setSrcDistrict(configEntity.getDistrict());
            orderEntityOne.setSrcDetailAddress(configEntity.getDetailAddress());
            orderEntityOne.setSrcAddress(configEntity.getProvince() + configEntity.getCity() + configEntity.getDistrict() + configEntity.getDetailAddress());
            orderEntityOne.setSrcName(configEntity.getName());
            orderEntityOne.setSrcPhone(configEntity.getPhone());
            Double deliveryDistance = DistanceUtil.distance((double)Double.parseDouble(configEntity.getLatitude()), (double)Double.parseDouble(configEntity.getLongitude()), (double)Double.parseDouble(vo.getLogisticsPayReqVO().getLatitude()), (double)Double.parseDouble(vo.getLogisticsPayReqVO().getLongitude()));
            orderEntityOne.setDestDeliveryDistance(deliveryDistance.toString());
        } else {
            String deliveryStoreId = vo.getLogisticsPayReqVO().getDeliveryStoreId();
            if (StringUtils.isNotBlank((String)deliveryStoreId)) {
                DrugStoreEntity drugstoreEntity = this.drugstoreService.queryById(deliveryStoreId);
                orderEntityOne.setSrcAddress(drugstoreEntity.getDetailAddress());
                orderEntityOne.setSrcPhone(drugstoreEntity.getStoreTelephone());
                orderEntityOne.setSrcName(drugstoreEntity.getStoreName());
                orderEntityOne.setDeliveryStoreId(deliveryStoreId);
            }
        }
        if (DrugTypeEnum.CM.getValue().equals(vo.getLogisticsPayReqVO().getPresType())) {
            orderEntityOne.setProductCode("CHINESE_HERBAL");
        } else {
            orderEntityOne.setProductCode("OTHER");
        }
        orderEntityOne.setLogisticsName(vo.getLogisticsPayReqVO().getLogisticsType());
        orderEntityOne.setHospitalId(drugMainEntity.getOrganId());
        orderEntityOne.setHospitalName(drugMainEntity.getPresOrganName());
        orderEntityOne.setBizSysSeq(merchantEntity.getBizSysSeq());
        orderEntityOne.setOrderStatus(OrderStatusEnum.TOPAY.getValue());
        orderEntityOne.setRemark("\u60a3\u8005\u59d3\u540d\uff1a" + drugMainEntity.getPatientName());
        this.drugLogisticsOrderMapper.insert(orderEntityOne);
        Long id = orderEntityOne.getId();
        log.info("============\u7269\u6d41\u7684\u8ba2\u5355id{}:", (Object)id);
        DrugLogisticsOrderRegEntity logisticsOrderRegEntity = new DrugLogisticsOrderRegEntity();
        logisticsOrderRegEntity.setMainId(drugMainEntity.getxId());
        logisticsOrderRegEntity.setLogisticsOrderId(String.valueOf(id));
        logisticsOrderRegEntity.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        logisticsOrderRegEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.drugLogisticsOrderRegMapper.insert(logisticsOrderRegEntity);
    }

    private DrugOrderEntity insertDrugOrderInfo(DrugPayReqVO vo, DrugOrderDTO drugOrderDTO) {
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigMapper.queryByOrganCodeAndMerchantTypeAndStoreId(Integer.valueOf(1), vo.getStoreId());
        if (merchantConfigEntity == null) {
            log.error("\u5546\u6237\u53f7\u4fe1\u606f\u8868\u3010mos_merchant_config\u3011\u4e2d\u6ca1\u6709\u836f\u623fid\u3010drug_store_id\u3011\u4e3a\u3010" + vo.getStoreId() + "\u3011\u7684\u914d\u7f6e\u6570\u636e\uff0c\u8bf7\u5148\u914d\u7f6e\uff01");
            throw new BusinessException("\u672a\u914d\u7f6e\u836f\u623f\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        }
        String orderSeq = GenSeqUtils.genOrderSeq((String)"");
        DrugOrderEntity orderEntity = new DrugOrderEntity();
        orderEntity.setxId(GenSeqUtils.getUniqueNo());
        orderEntity.setOrderType(vo.getOrderType());
        orderEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        orderEntity.setMainId(drugOrderDTO.getMainId());
        orderEntity.setMerchantId(merchantConfigEntity.getMerchantSeq());
        orderEntity.setOrderSeq(orderSeq);
        orderEntity.setOrderAmount(drugOrderDTO.getPrice());
        orderEntity.setTotalDrugAmount(drugOrderDTO.getDrugTotalAmount());
        orderEntity.setBizSysSeq(merchantConfigEntity.getBizSysSeq());
        orderEntity.setOrganCode(drugOrderDTO.getPresOrgan());
        orderEntity.setStatus(OrderStatusEnum.TOPAY.getValue());
        orderEntity.setPayMethod(vo.getPayMethod());
        orderEntity.setChannelCode(vo.getPayChannel());
        orderEntity.setOrderSource(vo.getOrderSource());
        orderEntity.setUserId(vo.getPatientUserId());
        if (Objects.nonNull(vo.getCommerceCreateMainVO()) && StringUtils.isNotBlank((String)vo.getCommerceCreateMainVO().getNextBuyTimeString())) {
            Date nextBuy = null;
            try {
                nextBuy = DateUtils.parseDate((String)vo.getCommerceCreateMainVO().getNextBuyTimeString(), (String)"yyyy-MM-dd");
                if (nextBuy.before(new Date())) {
                    throw new BusinessException("\u590d\u8d2d\u65e5\u671f\u683c\u5f0f\u6709\u8bef");
                }
                nextBuy = DateUtils.addHours((Date)nextBuy, (int)9);
            }
            catch (ParseException e) {
                throw new BusinessException("\u590d\u8d2d\u65e5\u671f\u683c\u5f0f\u6709\u8bef");
            }
            orderEntity.setNextBuyTime(nextBuy);
        }
        orderEntity.setInvalidTime(DateUtils.addMinutes((Date)new Date(), (int)30));
        this.drugOrderMapper.insert(orderEntity);
        return orderEntity;
    }

    private void updateDrugOrderEntity(DrugPayReqVO drugPayReqVO, DrugOrderEntity drugOrderEntity, DrugMainEntity drugMainEntity, DrugOrderDTO drugOrderDTO) {
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigMapper.queryByOrganCodeAndMerchantTypeAndStoreId(Integer.valueOf(1), drugPayReqVO.getStoreId());
        drugOrderEntity.setOrderSeq(GenSeqUtils.genOrderSeq((String)""));
        drugOrderEntity.setMerchantId(merchantConfigEntity.getMerchantSeq());
        drugOrderEntity.setBizSysSeq(merchantConfigEntity.getBizSysSeq());
        drugOrderEntity.setPayMethod(drugPayReqVO.getPayMethod());
        drugOrderEntity.setTotalDrugAmount(drugOrderDTO.getDrugTotalAmount());
        drugOrderEntity.setOrderAmount(drugOrderDTO.getPrice());
        drugOrderEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugOrderEntity.setOrderType(drugPayReqVO.getOrderType());
        drugOrderEntity.setChannelCode(drugPayReqVO.getPayChannel());
        drugOrderEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugOrderEntity.setUserId(drugPayReqVO.getPatientUserId());
        this.drugOrderMapper.updateByPrimaryKeySelective(drugOrderEntity);
    }

    private void updateLogisticsOrderInfo(DrugPayReqVO vo, HospitalConfigEntity configEntity) {
        DrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.drugLogisticsOrderMapper.selectByMainId(vo.getMainId());
        if (vo.getLogisticsPayReqVO().getDistributionType() == null) {
            vo.getLogisticsPayReqVO().setDistributionType(DistributionTypeEnum.CITY_EXPRESS.getValue());
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(vo.getMainId());
        mosDrugLogisticsOrderEntity.setPayAmount(vo.getLogisticsPayReqVO().getExtra());
        mosDrugLogisticsOrderEntity.setChannelCode(vo.getPayChannel());
        mosDrugLogisticsOrderEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        if (StringUtils.isBlank((String)vo.getLogisticsPayReqVO().getDeliveryStoreId())) {
            mosDrugLogisticsOrderEntity.setLogisticsBasisAmount(vo.getLogisticsPayReqVO().getExtra().subtract(configEntity.getOverweightAmount()).subtract(configEntity.getPackStandardMoney()));
            mosDrugLogisticsOrderEntity.setOverweightAmount(configEntity.getOverweightAmount());
            mosDrugLogisticsOrderEntity.setPackageAmout(configEntity.getPackStandardMoney());
        }
        mosDrugLogisticsOrderEntity.setInvoiceNum(vo.getLogisticsPayReqVO().getInvoiceNum());
        mosDrugLogisticsOrderEntity.setInvoiceTitle(vo.getLogisticsPayReqVO().getInvoiceTitle());
        mosDrugLogisticsOrderEntity.setDestProvince(vo.getLogisticsPayReqVO().getDestProvince());
        mosDrugLogisticsOrderEntity.setDestCity(vo.getLogisticsPayReqVO().getDestCity());
        mosDrugLogisticsOrderEntity.setDestDistrict(vo.getLogisticsPayReqVO().getDestDistrict());
        mosDrugLogisticsOrderEntity.setDestDetailAddress(vo.getLogisticsPayReqVO().getDestAddress());
        mosDrugLogisticsOrderEntity.setDestAddress(vo.getLogisticsPayReqVO().getDestProvince() + vo.getLogisticsPayReqVO().getDestCity() + vo.getLogisticsPayReqVO().getDestDistrict() + vo.getLogisticsPayReqVO().getDestAddress());
        mosDrugLogisticsOrderEntity.setDestAddressId(vo.getLogisticsPayReqVO().getDestAddressId());
        mosDrugLogisticsOrderEntity.setDestLatitude(vo.getLogisticsPayReqVO().getLatitude());
        mosDrugLogisticsOrderEntity.setDestLongitude(vo.getLogisticsPayReqVO().getLongitude());
        mosDrugLogisticsOrderEntity.setDestName(vo.getLogisticsPayReqVO().getDestName());
        mosDrugLogisticsOrderEntity.setDestPhone(vo.getLogisticsPayReqVO().getDestPhone());
        mosDrugLogisticsOrderEntity.setAppCode(vo.getAppCode());
        mosDrugLogisticsOrderEntity.setDepositumInfo("\u836f\u54c1");
        if (StringUtils.isBlank((String)vo.getLogisticsPayReqVO().getDeliveryStoreId())) {
            mosDrugLogisticsOrderEntity.setExpressType(Integer.valueOf(vo.getLogisticsPayReqVO().getExpressType() == null ? 1 : vo.getLogisticsPayReqVO().getExpressType()));
            mosDrugLogisticsOrderEntity.setLogisticsPayMethod(Integer.valueOf(vo.getLogisticsPayReqVO().getLogisticsPayeMthod()));
            mosDrugLogisticsOrderEntity.setPackStandardMoney(configEntity.getPackStandardMoney().toString());
            mosDrugLogisticsOrderEntity.setMonthlyCard(configEntity.getMonthlyCard());
            mosDrugLogisticsOrderEntity.setSrcProvince(configEntity.getProvince());
            mosDrugLogisticsOrderEntity.setSrcCity(configEntity.getCity());
            mosDrugLogisticsOrderEntity.setSrcDistrict(configEntity.getDistrict());
            mosDrugLogisticsOrderEntity.setSrcDetailAddress(configEntity.getDetailAddress());
            mosDrugLogisticsOrderEntity.setSrcAddress(configEntity.getProvince() + configEntity.getCity() + configEntity.getDistrict() + configEntity.getDetailAddress());
            mosDrugLogisticsOrderEntity.setSrcName(configEntity.getName());
            mosDrugLogisticsOrderEntity.setSrcPhone(configEntity.getPhone());
            Double deliveryDistance = DistanceUtil.distance((double)Double.parseDouble(configEntity.getLatitude()), (double)Double.parseDouble(configEntity.getLongitude()), (double)Double.parseDouble(vo.getLogisticsPayReqVO().getLatitude()), (double)Double.parseDouble(vo.getLogisticsPayReqVO().getLongitude()));
            mosDrugLogisticsOrderEntity.setDestDeliveryDistance(deliveryDistance.toString());
        } else {
            String deliveryStoreId = vo.getLogisticsPayReqVO().getDeliveryStoreId();
            if (StringUtils.isNotBlank((String)deliveryStoreId)) {
                DrugStoreEntity drugstoreEntity = this.drugstoreService.queryById(deliveryStoreId);
                mosDrugLogisticsOrderEntity.setSrcAddress(drugstoreEntity.getDetailAddress());
                mosDrugLogisticsOrderEntity.setSrcPhone(drugstoreEntity.getStoreTelephone());
                mosDrugLogisticsOrderEntity.setSrcName(drugstoreEntity.getStoreName());
                mosDrugLogisticsOrderEntity.setDeliveryStoreId(deliveryStoreId);
            }
        }
        if (DrugTypeEnum.CM.getValue().equals(vo.getLogisticsPayReqVO().getPresType())) {
            mosDrugLogisticsOrderEntity.setProductCode("CHINESE_HERBAL");
        } else {
            mosDrugLogisticsOrderEntity.setProductCode("OTHER");
        }
        mosDrugLogisticsOrderEntity.setLogisticsName(vo.getLogisticsPayReqVO().getLogisticsType());
        mosDrugLogisticsOrderEntity.setRemark("\u60a3\u8005\u59d3\u540d\uff1a" + drugMainEntity.getPatientName());
        log.info("======>\u7269\u6d41\u652f\u4ed8\u66f4\u65b0\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)mosDrugLogisticsOrderEntity));
        this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(mosDrugLogisticsOrderEntity);
    }

    public BaseResponse<String> orderNotify(PayNotifyReqVO payNotifyReqVO, DrugOrderEntity drugOrderEntity, DrugMainEntity drugMainEntity) {
        if (OrderResourceTypeEnum.E_COMMERCE_STORE_ORDER.getValue().equals(drugOrderEntity.getOrderSource())) {
            List drugListVOS;
            Object value = this.redisUtil.get("CFLZ:ORDER:COMMERCE_SHOPPING_CART_" + drugMainEntity.getxId() + drugOrderEntity.getxId());
            if (Objects.nonNull(value) && StringUtils.isNotBlank((String)value.toString()) && CollectionUtils.isNotEmpty((Collection)(drugListVOS = JSON.parseArray((String)value.toString(), CommerceCreateMainDrugListVO.class)))) {
                this.shoppingCartService.afterPayment(new AfterPaymentVO(drugMainEntity.getPatientLoginPhone(), drugMainEntity.getStoreId(), drugListVOS.parallelStream().map(CommerceCreateMainDrugListVO::getDrugId).collect(Collectors.toList())));
                this.redisUtil.del(new String[]{"CFLZ:ORDER:COMMERCE_SHOPPING_CART_" + drugMainEntity.getxId() + drugOrderEntity.getxId()});
            }
            if (Objects.nonNull(drugOrderEntity.getNextBuyTime())) {
                try {
                    long time = (drugOrderEntity.getNextBuyTime().getTime() - new Date().getTime()) / 1000L;
                    if (time > 0L) {
                        RabbitMqUtils.commerceNextPayRemind((RabbitTemplate)this.rabbitTemplate, (String)drugOrderEntity.getxId(), (Long)time);
                    }
                }
                catch (Exception exception) {
                    log.error("\u590d\u8d2d\u65f6\u95f4\u6709\u5f02\u5e38,{}", (Object)drugOrderEntity.getxId());
                }
            }
        }
        if (OrderTypeEnum.DRUG_ORDER.getValue().equals(drugMainEntity.getOrderType())) {
            drugOrderEntity = this.getPayNotifyDrugOrderEntity(drugOrderEntity, payNotifyReqVO);
            this.drugOrderService.update(drugOrderEntity);
            drugMainEntity.setOrderType(OrderTypeEnum.DRUG_ORDER.getValue());
            drugMainEntity.setItemStatus(DrugMainStatusEnum.TO_TAKE.getValue());
            this.drugMainService.update(drugMainEntity);
            this.threadPoolExecutor.execute(() -> {
                if (HospitalNamePinYinEnum.NCDXDEFSYY.getValue().equals(drugMainEntity.getHospitalNameFirstLetter())) {
                    DrugStoreEntity drugstoreEntity = this.mosDrugstoreMapper.queryById(drugMainEntity.getStoreId());
                    UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                    String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                    HashMap<String, String> patientMap = new HashMap<String, String>(3);
                    patientMap.put("fetchMedicalCode", drugMainEntity.getFetchMedicalCode());
                    patientMap.put("storeName", drugstoreEntity.getStoreName());
                    patientMap.put("phone", "400-631-9377");
                    this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "ndefy-qym", drugMainEntity.getPatientPhone(), patientMap);
                    this.sendNewOrderGoEasy(drugMainEntity);
                }
            });
            return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
        }
        drugOrderEntity = this.getPayNotifyDrugOrderEntity(drugOrderEntity, payNotifyReqVO);
        this.drugOrderService.update(drugOrderEntity);
        drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOYING.getValue());
        drugMainEntity.setOrderType(OrderTypeEnum.COURIER_ORDER.getValue());
        this.drugMainService.update(drugMainEntity);
        DrugLogisticsOrderRegEntity mosDrugLogisticsOrderRegEntity = this.mosDrugLogisticsOrderRegMapper.getByMainId1(drugMainEntity.getxId());
        DrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.drugLogisticsOrderMapper.selectByPrimaryKey(mosDrugLogisticsOrderRegEntity.getLogisticsOrderId());
        log.info("\u7269\u6d41\u8ba2\u5355\u4fe1\u606f->{}", (Object)Objects.toString(mosDrugLogisticsOrderEntity, null));
        if (mosDrugLogisticsOrderEntity == null) {
            return BaseResponse.success((Object)RETURNCODE);
        }
        if (OrderStatusEnum.PAID.getValue().equals(mosDrugLogisticsOrderEntity.getOrderStatus())) {
            return BaseResponse.success((Object)RETURNCODE);
        }
        this.dynamicInvokePlatformServer.adapterConfig(DynamicServerTypeEnum.DOCKING_WE_CHAT_PUSH, Integer.valueOf(drugMainEntity.getOrganId()), (Object)new WeChatPushDoctorRemindVO(drugMainEntity.getxId(), PushWeChatMessageActionTypeEnum.MAIN_LOGISTICS_ORDER_PAY_SUCCESS.name()));
        this.threadPoolExecutor.execute(() -> this.sendNewOrderGoEasy(drugMainEntity));
        mosDrugLogisticsOrderEntity.setBankTradeNo(payNotifyReqVO.getTradeNo());
        mosDrugLogisticsOrderEntity.setOrderStatus(OrderStatusEnum.PAID.getValue());
        mosDrugLogisticsOrderEntity.setDealSeq(payNotifyReqVO.getDealTradeNo());
        mosDrugLogisticsOrderEntity.setBizSysSeq(payNotifyReqVO.getServiceCode());
        mosDrugLogisticsOrderEntity.setPayTime(payNotifyReqVO.getPayTime());
        mosDrugLogisticsOrderEntity.setPayMethod(payNotifyReqVO.getPayChannel());
        this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(mosDrugLogisticsOrderEntity);
        return BaseResponse.success((Object)RETURNCODE);
    }

    private void sendNewOrderGoEasy(DrugMainEntity drugMainEntity) {
        if (Objects.isNull(drugMainEntity)) {
            return;
        }
    }

    private DrugOrderEntity getPayNotifyDrugOrderEntity(DrugOrderEntity drugOrderEntity, PayNotifyReqVO payNotifyReqVO) {
        drugOrderEntity.setStatus(OrderStatusEnum.PAID.getValue());
        drugOrderEntity.setPayTime(payNotifyReqVO.getPayTime());
        drugOrderEntity.setDealSeq(payNotifyReqVO.getDealTradeNo());
        drugOrderEntity.setBankTradeNo(payNotifyReqVO.getTradeNo());
        drugOrderEntity.setMchId("");
        drugOrderEntity.setPayAmount(payNotifyReqVO.getTotalAmount());
        drugOrderEntity.setSelfAmount(drugOrderEntity.getPayAmount());
        drugOrderEntity.setWxAmount(drugOrderEntity.getPayAmount());
        return drugOrderEntity;
    }

    public BaseResponse<String> applyRefundSecond(BaseOperationDto dto, DrugMainEntity drugMainEntity) {
        DrugOrderEntity drugOrderEntity = this.drugOrderMapper.queryByMainIdAndOrderStatus(dto.getMainId(), OrderStatusEnum.PAID.getValue());
        if (drugOrderEntity != null) {
            if (OrderStatusEnum.REFUNDING.getValue().equals(drugOrderEntity.getStatus()) || OrderStatusEnum.REFUNDED.getValue().equals(drugOrderEntity.getStatus())) {
                return BaseResponse.success((Object)"\u6b64\u8ba2\u5355\u6b63\u5728\u9000\u6b3e\u4e2d\u6216\u5df2\u9000\u6b3e\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            DrugLogisticsOrderEntity logisticsOrderEntity = this.drugLogisticsOrderMapper.selectByMainIdAndStatus(dto.getMainId(), OrderStatusEnum.PAID.getValue());
            RefundReqVO refundReqVO = new RefundReqVO();
            refundReqVO.setOrderSeq(drugOrderEntity.getOrderSeq());
            refundReqVO.setDealSeq(drugOrderEntity.getDealSeq());
            refundReqVO.setMerchantId(drugOrderEntity.getMerchantId());
            refundReqVO.setPayMethod(drugOrderEntity.getPayMethod());
            refundReqVO.setPayAmount(drugOrderEntity.getPayAmount());
            refundReqVO.setMerchantType(MerchantTypeEnum.DRUG.getValue());
            RefundResVo refundResVo = this.orderPayManage.applyRefundServer(refundReqVO);
            if (!refundResVo.isFlag()) {
                return BaseResponse.error((String)("\u836f\u54c1\u9000\u6b3e" + refundResVo.getMsg()));
            }
            drugOrderEntity.setStatus(OrderStatusEnum.REFUNDING.getValue());
            this.drugOrderMapper.updateByPrimaryKeySelective(drugOrderEntity);
            ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(drugOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.PAID.getValue());
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDING.getValue());
            servicePayBillEntity.setId(null);
            servicePayBillEntity.setWorkServiceCode("yyy");
            log.info("\u7533\u8bf7\u9000\u6b3e\u4fdd\u5b58\u8d26\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
            this.servicePayBillService.save(servicePayBillEntity);
            if (Objects.nonNull(logisticsOrderEntity)) {
                logisticsOrderEntity.setOrderStatus(OrderStatusEnum.REFUNDING.getValue());
                this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(logisticsOrderEntity);
            }
            DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
            drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
            drugRemarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugRemarkEntity.setRemarkContent(dto.getContent());
            drugRemarkEntity.setMainId(dto.getMainId());
            drugRemarkEntity.setRemarkType(RemarkTypeEnum.REFUND.getValue());
            drugRemarkEntity.setRemarkUser(dto.getOperationUser());
            drugRemarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            this.drugRemarkMapper.insert(drugRemarkEntity);
        }
        this.dynamicInvokePlatformServer.adapterConfig(DynamicServerTypeEnum.DOCKING_WE_CHAT_PUSH, Integer.valueOf(drugMainEntity.getOrganId()), (Object)new WeChatPushDoctorRemindVO(drugMainEntity.getxId(), PushWeChatMessageActionTypeEnum.MAIN_LOGISTICS_ORDER_REFUND_SUCCESS.name()));
        this.threadPoolExecutor.execute(() -> {
            try {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("doctorName", drugMainEntity.getPresDoctorName());
                UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy-hzsqtk", drugMainEntity.getPatientPhone(), param);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new BusinessException(e.getMessage());
            }
        });
        return BaseResponse.success();
    }

    public void refundNotify(DrugMainEntity drugMainEntity, RefundCallBackReqVo refundNotifyReqVO) {
        log.info("=======\u8fdb\u53bb\u901a\u7528\u7248\u7269\u6d41\u56de\u8c03");
        DrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.drugLogisticsOrderMapper.selectByMainId(drugMainEntity.getxId());
        log.info("======>\u7269\u6d41\u9000\u6b3e\u56de\u8c03---\u8ba2\u5355\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)mosDrugLogisticsOrderEntity));
        if (mosDrugLogisticsOrderEntity != null) {
            mosDrugLogisticsOrderEntity.setOrderStatus(OrderStatusEnum.REFUNDED.getValue());
            mosDrugLogisticsOrderEntity.setRefundTime(refundNotifyReqVO.getRefundTime());
            this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(mosDrugLogisticsOrderEntity);
        }
    }
}

