/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.common.enums.BaseStatusEnum;
import com.ebaiyihui.circulation.common.enums.ErrorEnum;
import com.ebaiyihui.circulation.common.enums.RoleDefaultEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.AccountInfoMapper;
import com.ebaiyihui.circulation.mapper.RoleAuthRegMapper;
import com.ebaiyihui.circulation.mapper.RoleInfoMapper;
import com.ebaiyihui.circulation.mapper.UserRoleRegMapper;
import com.ebaiyihui.circulation.pojo.entity.AccountInfoEntity;
import com.ebaiyihui.circulation.pojo.entity.RoleAuthRegEntity;
import com.ebaiyihui.circulation.pojo.entity.RoleInfoEntity;
import com.ebaiyihui.circulation.pojo.vo.role.RoleDeleteReqVO;
import com.ebaiyihui.circulation.pojo.vo.role.RoleDetailReqVO;
import com.ebaiyihui.circulation.pojo.vo.role.RoleDetailRespVO;
import com.ebaiyihui.circulation.pojo.vo.role.RolePagingListReqVO;
import com.ebaiyihui.circulation.pojo.vo.role.RolePagingListRespVO;
import com.ebaiyihui.circulation.pojo.vo.role.RoleSaveReqVO;
import com.ebaiyihui.circulation.pojo.vo.role.RoleSaveRespVO;
import com.ebaiyihui.circulation.service.AccountService;
import com.ebaiyihui.circulation.service.AuthService;
import com.ebaiyihui.circulation.service.RoleService;
import com.ebaiyihui.framework.page.PageRequest;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class RoleServiceImpl
implements RoleService {
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Autowired
    private RoleInfoMapper roleInfoMapper;
    @Autowired
    private AccountInfoMapper accountInfoMapper;
    @Autowired
    private UserRoleRegMapper userRoleRegMapper;
    @Autowired
    private RoleAuthRegMapper roleAuthRegMapper;
    @Autowired
    private AuthService authService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private static final Integer ZERO = 0;

    public BaseResponse<PageResult<RolePagingListRespVO>> pagingList(PageRequest<RolePagingListReqVO> pageVo) {
        log.info("\u8bf7\u6c42\u4e86\u67e5\u8be2\u89d2\u8272\u5217\u8868\u7684\u63a5\u53e3");
        PageHelper.startPage((int)pageVo.getPageNum(), (int)pageVo.getPageSize());
        List list = this.roleInfoMapper.pagingList((RolePagingListReqVO)pageVo.getQuery());
        PageInfo info = new PageInfo(list);
        PageResult result = new PageResult();
        result.setContent(list);
        result.setPageSize(pageVo.getPageSize());
        result.setPageNum(pageVo.getPageNum());
        result.setTotal(new Long(info.getTotal()).intValue());
        result.setTotalPages(info.getPages());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<List<RolePagingListRespVO>> roleBySelf(RolePagingListReqVO pageVo) {
        log.info("\u8c03\u7528\u4e86\u67e5\u8be2\u5e73\u53f0\u65b0\u5efa\u6210\u5458\u7684\u89d2\u8272\u5217\u8868");
        if (ObjectUtils.isEmpty((Object)pageVo)) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u7528\u6237id");
        }
        ArrayList<RolePagingListRespVO> pagingListRespVOS = new ArrayList<RolePagingListRespVO>();
        List allRoleInfo = this.roleInfoMapper.getRoleListBySelfRole(pageVo);
        for (RoleInfoEntity roleInfoEntityBO : allRoleInfo) {
            RolePagingListRespVO rolePagingListRespVO = new RolePagingListRespVO();
            BeanUtils.copyProperties((Object)roleInfoEntityBO, (Object)rolePagingListRespVO);
            pagingListRespVOS.add(rolePagingListRespVO);
        }
        return BaseResponse.success(pagingListRespVOS);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> delete(RoleDeleteReqVO roleDeleteReqVO) {
        log.info("\u8c03\u7528\u4e86\u5220\u9664\u89d2\u8272\u7684\u63a5\u53e3");
        if (ObjectUtils.isEmpty((Object)roleDeleteReqVO) || StringUtils.isEmpty((String)roleDeleteReqVO.getRoleId())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u89d2\u8272id");
        }
        if (Objects.isNull(roleDeleteReqVO.getUserId())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u7528\u6237id");
        }
        AccountInfoEntity accountInfoEntity = this.accountInfoMapper.selectByPrimaryKey(roleDeleteReqVO.getUserId());
        if (Objects.isNull(accountInfoEntity) || !Integer.valueOf(1).equals(accountInfoEntity.getStatus())) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u5df2\u7981\u7528");
        }
        if (!Integer.valueOf(0).equals(accountInfoEntity.getAuthType())) {
            throw new BusinessException("\u53ea\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u6743\u9650\u624d\u53ef\u4ee5\u5220\u9664\u89d2\u8272!");
        }
        RoleInfoEntity entity = this.roleInfoMapper.selectByPrimaryKey(roleDeleteReqVO.getRoleId());
        if (entity == null || BaseStatusEnum.FORBIDDEN.getValue().equals(entity.getStatus())) {
            return BaseResponse.error((IError)ErrorEnum.DATA_INVALID);
        }
        if (Integer.valueOf(0).equals(entity.getStatus())) {
            return BaseResponse.success();
        }
        if (!RoleDefaultEnum.NORMAL_ADMINISTRATORS.getValue().equals(entity.getIsDefault())) {
            return BaseResponse.error((IError)ErrorEnum.DEFAULT_NOT_DELETE);
        }
        List userRoleRegEntities = this.userRoleRegMapper.getAccountListByRoleId(entity.getId());
        if (CollectionUtils.isNotEmpty((Collection)userRoleRegEntities)) {
            throw new BusinessException("\u8be5\u89d2\u8272\u4e0b\u8fd8\u6709\u7ed1\u5b9a\u7684\u7528\u6237\uff0c\u4e0d\u53ef\u4ee5\u5220\u9664\uff01");
        }
        RoleInfoEntity roleInfoEntity = new RoleInfoEntity();
        roleInfoEntity.setId(roleDeleteReqVO.getRoleId());
        roleInfoEntity.setStatus(BaseStatusEnum.FORBIDDEN.getValue());
        this.roleInfoMapper.updateByPrimaryKeySelective(roleInfoEntity);
        this.roleAuthRegMapper.updateStatusByRoleId(roleDeleteReqVO.getRoleId(), BaseStatusEnum.FORBIDDEN.getValue());
        return BaseResponse.success();
    }

    public BaseResponse<RoleDetailRespVO> detail(RoleDetailReqVO roleDetailReqVO) {
        log.info("\u8c03\u7528\u4e86\u67e5\u8be2\u89d2\u8272\u8be6\u60c5\u7684\u63a5\u53e3");
        RoleDetailRespVO roleDetailRespVO = new RoleDetailRespVO();
        RoleInfoEntity roleInfoEntity = this.roleInfoMapper.selectByPrimaryKey(roleDetailReqVO.getRoleId());
        if (roleInfoEntity == null || BaseStatusEnum.FORBIDDEN.getValue().equals(roleInfoEntity.getStatus())) {
            return BaseResponse.error((IError)ErrorEnum.DATA_INVALID);
        }
        roleDetailRespVO.setRoleName(roleInfoEntity.getRoleName());
        roleDetailRespVO.setDescription(roleInfoEntity.getDescription());
        roleDetailRespVO.setIsDefault(roleInfoEntity.getIsDefault());
        List leftList = this.authService.getAuthListByRoleId(roleDetailReqVO.getRoleId());
        if (CollectionUtils.isNotEmpty((Collection)leftList)) {
            roleDetailRespVO.setLeft(leftList);
        }
        return BaseResponse.success((Object)roleDetailRespVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<RoleSaveRespVO> save(RoleSaveReqVO roleSaveReqVO) {
        if (Objects.isNull(roleSaveReqVO) || Objects.isNull(roleSaveReqVO.getTotalType())) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        log.info("\u8c03\u7528\u4e86\u4fdd\u5b58\u89d2\u8272\u63a5\u53e3");
        RoleInfoEntity roleInfoEntity = new RoleInfoEntity();
        BeanUtils.copyProperties((Object)roleSaveReqVO, (Object)roleInfoEntity);
        if (StringUtils.isEmpty((String)roleSaveReqVO.getRoleId())) {
            roleInfoEntity.setId(UUIDUtils.getUUID());
            this.roleInfoMapper.insertSelective(roleInfoEntity);
        } else {
            RoleInfoEntity updateRoleInfoEntity = this.roleInfoMapper.selectByPrimaryKey(roleSaveReqVO.getRoleId());
            if (updateRoleInfoEntity == null) {
                return BaseResponse.error((IError)ErrorEnum.DATA_INVALID);
            }
            if (RoleDefaultEnum.SUPER_ADMINISTRATORS.getValue().equals(updateRoleInfoEntity.getIsDefault())) {
                return BaseResponse.error((IError)ErrorEnum.ROLE_DEFAULT_SUPER_ERROR);
            }
            roleInfoEntity.setId(roleSaveReqVO.getRoleId());
            this.roleInfoMapper.updateByPrimaryKeySelective(roleInfoEntity);
            this.roleAuthRegMapper.updateStatusByRoleId(roleSaveReqVO.getRoleId(), BaseStatusEnum.FORBIDDEN.getValue());
        }
        ArrayList regEntityList = new ArrayList();
        roleSaveReqVO.getAuthIds().stream().forEach(authId -> {
            RoleAuthRegEntity regEntity = new RoleAuthRegEntity();
            regEntity.setAuthId(authId);
            regEntity.setRoleId(roleInfoEntity.getId());
            regEntityList.add(regEntity);
        });
        this.roleAuthRegMapper.insertBatch(regEntityList);
        this.threadPoolTaskExecutor.execute(() -> {
            List userRoleRegEntities = this.userRoleRegMapper.getAccountListByRoleId(roleInfoEntity.getId());
            userRoleRegEntities.forEach(s -> this.accountService.deleteLoginCache(s.getAccountId()));
        });
        return BaseResponse.success((Object)new RoleSaveRespVO(roleInfoEntity.getId()));
    }
}

