/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.common.enums.PayBillOrderStatusEnum;
import com.ebaiyihui.circulation.mapper.ServicePayBillMapper;
import com.ebaiyihui.circulation.pojo.entity.ServicePayBillEntity;
import com.ebaiyihui.circulation.service.ServicePayBillService;
import com.ebaiyihui.medicalcloud.pojo.vo.bill.GetPayBillReqVo;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePayBillServiceImpl
implements ServicePayBillService {
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;

    public void save(ServicePayBillEntity servicePayBillEntity) {
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
    }

    public ServicePayBillEntity selectByOutTradeNoAndStatus(String outTradeNo, Integer status) {
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillMapper.selectByOutTradeNoAndStatus(outTradeNo, status);
        return servicePayBillEntity;
    }

    public List<ServicePayBillEntity> getPayBill(GetPayBillReqVo getPayBillReqVo) {
        List servicePayBillEntities = this.servicePayBillMapper.selectPayBill(getPayBillReqVo);
        List<ServicePayBillEntity> billEntityList = servicePayBillEntities.stream().filter(str -> str.getStatus().equals(PayBillOrderStatusEnum.PAID.getValue()) || str.getStatus().equals(PayBillOrderStatusEnum.REFUNDED.getValue())).collect(Collectors.toList());
        return billEntityList;
    }

    public void update(ServicePayBillEntity servicePayBillEntity) {
        this.servicePayBillMapper.updateByPrimaryKeySelective(servicePayBillEntity);
    }
}

