/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.mapper.ShoppingCartMapper;
import com.ebaiyihui.circulation.pojo.dto.ShoppingCartDTO;
import com.ebaiyihui.circulation.pojo.dto.ShoppingCartListDTO;
import com.ebaiyihui.circulation.pojo.entity.ShoppingCartEntity;
import com.ebaiyihui.circulation.pojo.vo.cart.AfterPaymentVO;
import com.ebaiyihui.circulation.pojo.vo.cart.DelAllItemVO;
import com.ebaiyihui.circulation.pojo.vo.cart.DelItemVO;
import com.ebaiyihui.circulation.pojo.vo.cart.GetItemVO;
import com.ebaiyihui.circulation.pojo.vo.cart.ShoppingCartVO;
import com.ebaiyihui.circulation.service.ShoppingCartService;
import com.ebaiyihui.framework.response.BaseResponse;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ShoppingCartServiceImpl
implements ShoppingCartService {
    private static final Logger log = LoggerFactory.getLogger(ShoppingCartServiceImpl.class);
    @Autowired
    private ShoppingCartMapper shoppingCartMapper;

    public BaseResponse<String> addItem(ShoppingCartVO vo) {
        ShoppingCartEntity shoppingCartEntity = this.shoppingCartMapper.selectItemById(vo);
        if (Objects.isNull(shoppingCartEntity)) {
            ShoppingCartEntity entity = new ShoppingCartEntity();
            BeanUtils.copyProperties((Object)vo, (Object)entity);
            entity.setItemNum(Long.valueOf(1L));
            this.shoppingCartMapper.insert(entity);
        } else {
            shoppingCartEntity.setItemNum(Long.valueOf(shoppingCartEntity.getItemNum() + 1L));
            this.shoppingCartMapper.updateById(shoppingCartEntity);
        }
        return BaseResponse.success();
    }

    public BaseResponse<ShoppingCartDTO> getItem(GetItemVO vo) {
        ShoppingCartDTO shoppingCartDTO = new ShoppingCartDTO();
        ShoppingCartVO shoppingCartVO = new ShoppingCartVO();
        shoppingCartVO.setAccountNo(vo.getAccountNo());
        shoppingCartVO.setStoreId(vo.getStoreId());
        List list = this.shoppingCartMapper.selectAccountCart(shoppingCartVO);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            shoppingCartDTO.setList(list);
            long allCount = 0L;
            BigDecimal oldPriceSum = new BigDecimal(0);
            for (ShoppingCartListDTO shoppingCartListDTO : list) {
                BigDecimal price = new BigDecimal(shoppingCartListDTO.getPrice());
                BigDecimal count = new BigDecimal(shoppingCartListDTO.getItemNum());
                BigDecimal multiply = price.multiply(count);
                oldPriceSum = oldPriceSum.add(multiply);
                allCount += shoppingCartListDTO.getItemNum().longValue();
            }
            shoppingCartDTO.setAllCount(Long.valueOf(allCount));
            shoppingCartDTO.setPriceSum(oldPriceSum.toString());
        }
        return BaseResponse.success((Object)shoppingCartDTO);
    }

    public BaseResponse<String> delItem(ShoppingCartVO vo) {
        ShoppingCartEntity shoppingCartEntity = this.shoppingCartMapper.selectItemById(vo);
        if (Objects.isNull(shoppingCartEntity) || 0L == shoppingCartEntity.getItemNum()) {
            return BaseResponse.error((String)"\u8d2d\u7269\u8f66\u5220\u9664\u5931\u8d25\uff01");
        }
        if (1L == shoppingCartEntity.getItemNum()) {
            DelItemVO delItemVO = new DelItemVO();
            delItemVO.setId(shoppingCartEntity.getId());
            this.shoppingCartMapper.delItem(delItemVO);
        } else {
            shoppingCartEntity.setItemNum(Long.valueOf(shoppingCartEntity.getItemNum() - 1L));
            this.shoppingCartMapper.updateById(shoppingCartEntity);
        }
        return BaseResponse.success();
    }

    public BaseResponse<String> delAllItem(DelAllItemVO vo) {
        this.shoppingCartMapper.delAllItem(vo);
        return BaseResponse.success();
    }

    @Async
    public void afterPayment(AfterPaymentVO vo) {
        log.info("\u5220\u9664\u8d2d\u7269\u8f66: {}", (Object)JSON.toJSONString((Object)vo));
        if (CollectionUtils.isNotEmpty((Collection)vo.getItemId())) {
            for (String itemId : vo.getItemId()) {
                this.shoppingCartMapper.afterPayment(vo.getAccountNo(), vo.getStoreId(), itemId);
            }
        }
    }
}

