/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.mapper.UserRoleRegMapper;
import com.ebaiyihui.circulation.pojo.entity.UserRoleRegEntity;
import com.ebaiyihui.circulation.pojo.vo.account.AccountSaveReqVO;
import com.ebaiyihui.circulation.service.UserRoleAuthRegService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserRoleAuthRegServiceImpl
implements UserRoleAuthRegService {
    private static final Logger log = LoggerFactory.getLogger(UserRoleAuthRegServiceImpl.class);
    @Autowired
    private UserRoleRegMapper userRoleRegMapper;

    public int updateRegStatusByAccountId(String accountId) {
        if (StringUtils.isEmpty((CharSequence)accountId)) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u8d26\u53f7\u3001\u72b6\u6001");
        }
        return this.userRoleRegMapper.updateRegStatusByAccountId(accountId);
    }

    public int insertUserRoleAuthReg(AccountSaveReqVO accountSaveReqVO, String accountId) {
        if (Objects.isNull(accountSaveReqVO) || StringUtils.isEmpty((CharSequence)accountSaveReqVO.getAccountId()) || CollectionUtils.isEmpty((Collection)accountSaveReqVO.getRoleIds()) || StringUtils.isEmpty((CharSequence)accountId)) {
            throw new BusinessException("\u672a\u4f20\u5165\u89d2\u8272\u6743\u9650\u5173\u8054\u76f8\u5173\u4fe1\u606f");
        }
        int count = this.userRoleRegMapper.updateRegStatusByAccountId(accountSaveReqVO.getAccountId());
        log.info("\u5220\u9664\u65e7\u89d2\u8272\u6743\u9650\u5173\u7cfb{}", (Object)count);
        ArrayList userRoleRegEntityList = new ArrayList();
        accountSaveReqVO.getRoleIds().forEach(item -> {
            UserRoleRegEntity userRoleRegEntity = new UserRoleRegEntity();
            userRoleRegEntity.setAccountId(accountId);
            userRoleRegEntity.setRoleId(item);
            userRoleRegEntityList.add(userRoleRegEntity);
        });
        return this.userRoleRegMapper.insertUserRoleAuthReg(userRoleRegEntityList);
    }
}

