/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.annotation.PresRoamProcessCode;
import com.ebaiyihui.circulation.common.enums.OrderTypeEnum;
import com.ebaiyihui.circulation.manage.NCZKPushMainManage;
import com.ebaiyihui.circulation.mapper.MosDrugDetailMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.pojo.bo.DrugDetailEntityBO;
import com.ebaiyihui.circulation.pojo.entity.DrugLogisticsOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugMainEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugStoreEntity;
import com.ebaiyihui.circulation.pojo.vo.circulation.PrescriptionDetailReqVO;
import com.ebaiyihui.circulation.pojo.vo.circulation.PrescriptionDetailRespVO;
import com.ebaiyihui.circulation.pojo.vo.dynamic.DynamicServerVO;
import com.ebaiyihui.circulation.service.IDynamicServerService;
import com.ebaiyihui.circulation.utils.BigDecimalUtil;
import com.ebaiyihui.circulation.utils.DateUtils;
import com.ebaiyihui.three.zkhouse.pojo.vo.ZKRequestPushSendMainDrugInfoVO;
import com.ebaiyihui.three.zkhouse.pojo.vo.ZKRequestPushSendMainVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@PresRoamProcessCode(value="LOGISTICS_ZK_PUSH_MAIN")
@Service(value="zKLogisticsWareHousePushMainServiceImpl")
public class ZKLogisticsWareHousePushMainServiceImpl
implements IDynamicServerService {
    private static final Logger log = LoggerFactory.getLogger(ZKLogisticsWareHousePushMainServiceImpl.class);
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugDetailMapper mosDrugDetailMapper;
    @Autowired
    private NCZKPushMainManage nczkPushMainManage;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;

    public <T> void invoke(DynamicServerVO dynamicServerVO, T param) {
        DrugLogisticsOrderEntity logisticsOrderEntity;
        log.info("\u5f53\u524d\u6267\u884c\u4e86\u63a8\u9001\u4f17\u5eb7\u5f85\u53d1\u8d27\u7684\u8ba2\u5355");
        DrugMainEntity drugMainEntity = dynamicServerVO.getDrugMainEntity();
        DrugStoreEntity storeEntity = dynamicServerVO.getDrugStoreEntity();
        DrugOrderEntity drugOrderEntity = dynamicServerVO.getDrugOrderEntity();
        PrescriptionDetailReqVO prescriptionDetailReqVO = new PrescriptionDetailReqVO();
        prescriptionDetailReqVO.setMainId(drugMainEntity.getxId());
        PrescriptionDetailRespVO respVo = this.mosDrugMainMapper.queryPresDetailBack(prescriptionDetailReqVO);
        ZKRequestPushSendMainVO zkRequestPushSendMainVO = new ZKRequestPushSendMainVO();
        zkRequestPushSendMainVO.setOrgCode("40001");
        zkRequestPushSendMainVO.setOrderNo(drugOrderEntity.getxId());
        zkRequestPushSendMainVO.setPrescriptionNo(drugMainEntity.getxId());
        zkRequestPushSendMainVO.setPatientName(drugMainEntity.getPatientName());
        zkRequestPushSendMainVO.setPatientPhone(drugMainEntity.getPatientPhone());
        zkRequestPushSendMainVO.setSex(Integer.valueOf(1).equals(drugMainEntity.getPatientGender()) ? "\u7537" : "\u5973");
        zkRequestPushSendMainVO.setIdCard(drugMainEntity.getPatientCredNo());
        zkRequestPushSendMainVO.setAdvice(drugMainEntity.getRemark());
        zkRequestPushSendMainVO.setThirdDoctorName(drugMainEntity.getPresDoctorName());
        zkRequestPushSendMainVO.setThirdDeptName(drugMainEntity.getPresDeptName());
        zkRequestPushSendMainVO.setPrescriptionTime(DateUtils.formatDate((Date)drugMainEntity.getxCreateTime(), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
        zkRequestPushSendMainVO.setDiagnosisName(respVo.getDiagnostic());
        zkRequestPushSendMainVO.setPrescriptionImg(respVo.getHtmlUrl());
        zkRequestPushSendMainVO.setTakeTypeCode(drugOrderEntity.getOrderType().toString());
        zkRequestPushSendMainVO.setOrderTakeSelfCode(drugMainEntity.getFetchMedicalCode());
        zkRequestPushSendMainVO.setShopCode(storeEntity.getxId());
        zkRequestPushSendMainVO.setShopName(storeEntity.getStoreName());
        zkRequestPushSendMainVO.setShopAddress(storeEntity.getProvince() + storeEntity.getCity() + storeEntity.getDistrict() + storeEntity.getDetailAddress());
        if (OrderTypeEnum.COURIER_ORDER.getValue().equals(drugOrderEntity.getOrderType()) && Objects.nonNull(logisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByMainId(drugMainEntity.getxId()))) {
            zkRequestPushSendMainVO.setBuyerName(logisticsOrderEntity.getDestName());
            zkRequestPushSendMainVO.setBuyerPhone(logisticsOrderEntity.getDestPhone());
            zkRequestPushSendMainVO.setProvinceName(logisticsOrderEntity.getDestProvince());
            zkRequestPushSendMainVO.setCityName(logisticsOrderEntity.getDestCity());
            zkRequestPushSendMainVO.setDistrictName(logisticsOrderEntity.getDestDistrict());
            zkRequestPushSendMainVO.setBuyerAddress(logisticsOrderEntity.getDestDetailAddress());
        }
        zkRequestPushSendMainVO.setPayMode("4");
        zkRequestPushSendMainVO.setPayType("1");
        zkRequestPushSendMainVO.setCostType("2");
        zkRequestPushSendMainVO.setPayDate(DateUtils.formatDate((Date)drugOrderEntity.getPayTime(), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
        zkRequestPushSendMainVO.setTransactNo(drugOrderEntity.getBankTradeNo());
        zkRequestPushSendMainVO.setMoney(String.valueOf(drugOrderEntity.getPayAmount()));
        zkRequestPushSendMainVO.setExpressMoney(respVo.getLogisticsPayAmount());
        zkRequestPushSendMainVO.setDrugList(new ArrayList());
        List drugDetailEntityList = this.mosDrugDetailMapper.getBOByMainId(drugMainEntity.getxId());
        for (DrugDetailEntityBO drugDetailEntity : drugDetailEntityList) {
            ZKRequestPushSendMainDrugInfoVO zkRequestPushSendMainDrugInfoVO = new ZKRequestPushSendMainDrugInfoVO();
            zkRequestPushSendMainDrugInfoVO.setDrugCode(drugDetailEntity.getDrugCommonCode());
            zkRequestPushSendMainDrugInfoVO.setDrugName(drugDetailEntity.getDrugName());
            zkRequestPushSendMainDrugInfoVO.setDrugPrice(BigDecimalUtil.getNoZeros((BigDecimal)drugDetailEntity.getUnitPrice()));
            zkRequestPushSendMainDrugInfoVO.setNationDrugCode(null);
            zkRequestPushSendMainDrugInfoVO.setSpecifications(drugDetailEntity.getDrugSpec());
            zkRequestPushSendMainDrugInfoVO.setManufacturer(drugDetailEntity.getManufacturer());
            zkRequestPushSendMainDrugInfoVO.setPackingCount(String.valueOf(drugDetailEntity.getAmount().intValue()));
            zkRequestPushSendMainDrugInfoVO.setPackingUnit(drugDetailEntity.getAmountUnit());
            zkRequestPushSendMainDrugInfoVO.setSingleDosage(BigDecimalUtil.getNoZeros((BigDecimal)drugDetailEntity.getSingleDose()));
            zkRequestPushSendMainDrugInfoVO.setSingleDosageUnit(drugDetailEntity.getMeasureUnit());
            zkRequestPushSendMainDrugInfoVO.setUseName(drugDetailEntity.getUsageDesc());
            zkRequestPushSendMainDrugInfoVO.setFrequencyName(drugDetailEntity.getFrequencyDesc());
            zkRequestPushSendMainDrugInfoVO.setUseDays(String.valueOf(drugDetailEntity.getDuration()));
            zkRequestPushSendMainVO.getDrugList().add(zkRequestPushSendMainDrugInfoVO);
        }
        this.nczkPushMainManage.pushMainOrder(dynamicServerVO.getConfigEntity().getRequestUrl(), zkRequestPushSendMainVO);
    }
}

