/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.service.impl;

import com.ebaiyihui.circulation.common.enums.RemarkTypeEnum;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.manage.NCZKPushMainManage;
import com.ebaiyihui.circulation.mapper.MosDrugDetailMapper;
import com.ebaiyihui.circulation.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugMainMapper;
import com.ebaiyihui.circulation.mapper.MosDrugOrderMapper;
import com.ebaiyihui.circulation.mapper.MosDrugStoreMapper;
import com.ebaiyihui.circulation.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.circulation.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.circulation.service.IZKWareHouseMainService;
import com.ebaiyihui.circulation.service.MosDrugPrescriptionService;
import com.ebaiyihui.circulation.service.MosDrugRemarkService;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.vo.ConfireResVO;
import com.ebaiyihui.three.zkhouse.pojo.vo.ZKRequestSendMainUpdateStatusVO;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="iZKWareHouseMainService")
public class ZKWareHouseMainServiceImpl
implements IZKWareHouseMainService {
    private static final Logger log = LoggerFactory.getLogger(ZKWareHouseMainServiceImpl.class);
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private MosDrugDetailMapper mosDrugDetailMapper;
    @Autowired
    private NCZKPushMainManage nczkPushMainManage;
    @Autowired
    private MosDrugStoreMapper mosDrugStoreMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private MosDrugRemarkService mosDrugRemarkService;
    @Autowired
    private MosDrugPrescriptionService mosDrugPrescriptionService;
    public static final String SPECIAL_HOSPITAL_NAME = "\u5357\u660c\u4f17\u5eb7\u533b\u9662";

    @Transactional(rollbackFor={Exception.class})
    public void updateOrderMainStatus(ZKRequestSendMainUpdateStatusVO mlUpdateOrderMainStatusVO) {
        log.info("\u4f17\u5eb7\u5f00\u59cb\u8c03\u7528\u53d1\u8d27\u63a5\u53e3");
        if (Objects.isNull(mlUpdateOrderMainStatusVO.getSendType())) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u53d1\u8d27\u7c7b\u578b");
        }
        if (Integer.valueOf(1).equals(mlUpdateOrderMainStatusVO.getSendType()) && (StringUtils.isEmpty((CharSequence)mlUpdateOrderMainStatusVO.getLogisticsName()) || StringUtils.isEmpty((CharSequence)mlUpdateOrderMainStatusVO.getMainNo()))) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u5feb\u9012\u516c\u53f8\u548c\u8ba2\u5355\u53f7");
        }
        if (Integer.valueOf(2).equals(mlUpdateOrderMainStatusVO.getSendType()) && (StringUtils.isEmpty((CharSequence)mlUpdateOrderMainStatusVO.getDistributor()) || StringUtils.isEmpty((CharSequence)mlUpdateOrderMainStatusVO.getDistributorPhone()))) {
            throw new BusinessException("\u8bf7\u8f93\u5165\u914d\u9001\u5458\u4e0e\u914d\u9001\u7535\u8bdd");
        }
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.queryById(mlUpdateOrderMainStatusVO.getPresNo());
        if (Objects.isNull(drugOrderEntity)) {
            throw new BusinessException("\u627e\u4e0d\u5230\u5904\u65b9\u7684\u8ba2\u5355\u4e86");
        }
        ConfireResVO confireResVO = new ConfireResVO();
        BeanUtils.copyProperties((Object)mlUpdateOrderMainStatusVO, (Object)confireResVO);
        confireResVO.setSender("\u4f17\u5eb7\u4e92\u8054\u7f51\u533b\u9662\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0");
        confireResVO.setSendRemark("");
        confireResVO.setMainId(drugOrderEntity.getMainId());
        BaseResponse response = this.mosDrugPrescriptionService.confirmDelivery(confireResVO);
        if (response.isSuccess()) {
            DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
            drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
            drugRemarkEntity.setxUpdateTime(new Date());
            drugRemarkEntity.setRemarkContent("\u4f17\u5eb7\u8c03\u7528\u4f70\u533b\u53d1\u8d27\u63a5\u53e3");
            drugRemarkEntity.setMainId(mlUpdateOrderMainStatusVO.getMainNo());
            drugRemarkEntity.setRemarkType(RemarkTypeEnum.CONFIRMSHIPMENT.getValue());
            drugRemarkEntity.setRemarkUser("\u4f17\u5eb7\u4e92\u8054\u7f51\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0");
            drugRemarkEntity.setxCreateTime(new Date());
            this.mosDrugRemarkService.insert(drugRemarkEntity);
            return;
        }
        throw new BusinessException(response.getCode(), response.getMsg());
    }
}

