/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.utils;

import com.ebaiyihui.circulation.factory.B64ImgReplacedElementFactory;
import com.ebaiyihui.circulation.utils.PdfUtil;
import com.itextpdf.text.DocumentException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PdfUtil {
    private static final Logger log = LoggerFactory.getLogger(PdfUtil.class);
    public static final String PDF_SUFFIX = ".pdf";
    private static Configuration configuration;

    private PdfUtil() {
    }

    public static boolean genPdf(List<String> docList, OutputStream os) {
        ITextRenderer renderer = new ITextRenderer();
        ResourceLoaderUserAgent callback = new ResourceLoaderUserAgent(renderer.getOutputDevice());
        SharedContext sharedContext = renderer.getSharedContext();
        sharedContext.setReplacedElementFactory((ReplacedElementFactory)new B64ImgReplacedElementFactory());
        sharedContext.setUserAgentCallback((UserAgentCallback)callback);
        callback.setSharedContext(sharedContext);
        renderer.setScaleToFit(true);
        try {
            renderer.getFontResolver().addFont("template/simsun.ttc", "Identity-H", false);
            renderer.setDocumentFromString(docList.get(0));
            renderer.layout();
            renderer.createPDF(os, false);
            for (int i = 1; i < docList.size(); ++i) {
                renderer.setDocumentFromString(docList.get(i));
                renderer.layout();
                renderer.writeNextDocument();
            }
            renderer.finishPDF();
            return true;
        }
        catch (Exception e) {
            log.error("html\u8f6cpdf\u5931\u8d25,docList={}", docList, (Object)e);
            return false;
        }
    }

    @Deprecated
    private void writeFile(String doc, String path) {
        try (FileOutputStream fos = new FileOutputStream(new File("/Users/imac/Documents/workspace/" + path));){
            fos.write(doc.getBytes());
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String freemarkerRender(Map<String, Object> dataMap, String fileName) {
        StringWriter out = new StringWriter();
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            configuration.setClassForTemplateLoading(PdfUtil.class, "/template");
            Template template = configuration.getTemplate(fileName);
            template.process(dataMap, (Writer)out);
            ((Writer)out).flush();
            String string = ((Object)out).toString();
            return string;
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u6a21\u677f\u5f02\u5e38->{}", (Throwable)e);
        }
        finally {
            try {
                ((Writer)out).close();
            }
            catch (IOException e) {
                log.error("\u5173\u95ed\u6d41\u5f02\u5e38->{}", (Throwable)e);
            }
        }
        return null;
    }

    public static void createPdf(String content, String dest) throws IOException, DocumentException {
        ITextRenderer render = new ITextRenderer();
        render.setDocumentFromString(content);
        ITextFontResolver fontResolver = render.getFontResolver();
        fontResolver.addFont("template/simsun.ttc", "Identity-H", false);
        render.layout();
        FileOutputStream os = new FileOutputStream(dest);
        render.createPDF((OutputStream)os);
        ((OutputStream)os).close();
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<PdfUtil> clazz = PdfUtil.class;
        synchronized (PdfUtil.class) {
            if (configuration == null) {
                configuration = new Configuration(Configuration.VERSION_2_3_28);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

