/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.utils;

import com.ebaiyihui.circulation.config.PrescPdfConfig;
import com.ebaiyihui.circulation.exception.BusinessException;
import com.ebaiyihui.circulation.pojo.dto.load.PresPdfInfoDTO;
import com.ebaiyihui.circulation.pojo.entity.PresPdfPathEntity;
import com.ebaiyihui.circulation.utils.GenSeqUtils;
import com.ebaiyihui.circulation.utils.OSSClientUtil;
import com.ebaiyihui.circulation.utils.PdfUtil;
import com.ebaiyihui.circulation.utils.QrcodeUtil;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class PresPdfUtil {
    public static final String PDF_PREIFIX = "byh-pres-";
    private String ossFile;
    private String fileName;
    private String ossPath;
    private String htmlPath;
    private List<PresPdfInfoDTO> prescInfoList;
    private List<String> docList;
    private PrescPdfConfig pdfConfig;
    private List<PresPdfPathEntity> pdfPath;

    public PresPdfUtil(List<PresPdfInfoDTO> prescInfos, PrescPdfConfig pdfConfig, String ossHost, String path) throws BusinessException {
        boolean empty = CollectionUtils.isEmpty(prescInfos);
        if (empty) {
            throw new BusinessException("\u5904\u65b9\u7b3a\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.prescInfoList = prescInfos;
        this.pdfConfig = pdfConfig;
        this.init(prescInfos, ossHost, path);
    }

    public boolean toPdf() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        boolean genPdf = PdfUtil.genPdf((List)this.docList, (OutputStream)os);
        if (!genPdf) {
            return false;
        }
        ByteArrayInputStream instream = new ByteArrayInputStream(os.toByteArray());
        OSSClientUtil.uploadFile2OSS((InputStream)instream, (String)this.ossFile);
        return true;
    }

    private void init(List<PresPdfInfoDTO> presInfoDTOS, String ossHost, String path) {
        this.docList = new ArrayList();
        this.pdfPath = new ArrayList();
        this.fileName = PDF_PREIFIX + presInfoDTOS.get(0).getMainId() + GenSeqUtils.genRandomSeq((int)6) + ".pdf";
        this.ossFile = this.pdfConfig.getPdfBasePath() + this.fileName;
        for (int i = 0; i < presInfoDTOS.size(); ++i) {
            PresPdfInfoDTO presInfoDTO = presInfoDTOS.get(i);
            this.htmlPath = path + this.fileName;
            this.ossPath = OSSClientUtil.getViewUrl((String)ossHost, (String)this.ossFile);
            PresPdfPathEntity perscPdfPath = this.genPrescPdfPath(presInfoDTO);
            this.pdfPath.add(perscPdfPath);
            String doc = this.getDoc(presInfoDTO, presInfoDTOS.size(), i);
            this.docList.add(doc);
        }
    }

    private PresPdfPathEntity genPrescPdfPath(PresPdfInfoDTO presInfoDTO) {
        PresPdfPathEntity presPdfPathEntity = new PresPdfPathEntity();
        presPdfPathEntity.setRecipeNo(presInfoDTO.getRecipeNo());
        presPdfPathEntity.setOssPath(this.ossPath);
        presPdfPathEntity.setHtmlPath(this.htmlPath);
        return presPdfPathEntity;
    }

    private String getDoc(PresPdfInfoDTO presInfoDTO, int total, int index) {
        try {
            Template template = this.pdfConfig.getConfiguration().getTemplate("prescTemplate", "utf-8");
            StringWriter out = new StringWriter();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("vo", presInfoDTO);
            map.put("price", presInfoDTO.getPrice());
            map.put("icon", presInfoDTO.getLogo());
            String qrcode = this.getQrcode(this.htmlPath);
            map.put("qrcode", qrcode);
            map.put("totalpage", total);
            map.put("currentPage", index + 1);
            template.process(map, (Writer)out);
            String doc = out.toString();
            return doc;
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getQrcode(String qrcodeContent) {
        int width = this.pdfConfig.getQrcodeWidth();
        int height = this.pdfConfig.getQrcodeHeight();
        BufferedImage genImage = QrcodeUtil.genImage((String)qrcodeContent, (int)width, (int)height);
        return QrcodeUtil.writeImageToString((BufferedImage)genImage);
    }

    public static String getZryhTemplateName(String basePath, String templateName) {
        byte[] downloadLocal = OSSClientUtil.downloadLocal((String)(basePath + templateName));
        return new String(downloadLocal, StandardCharsets.UTF_8);
    }

    public static String getPdfPrifix() {
        return PDF_PREIFIX;
    }

    public List<PresPdfInfoDTO> getPrescInfoList() {
        return this.prescInfoList;
    }

    public void setPrescInfoList(List<PresPdfInfoDTO> prescInfoList) {
        this.prescInfoList = prescInfoList;
    }

    public List<String> getDocList() {
        return this.docList;
    }

    public void setDocList(List<String> docList) {
        this.docList = docList;
    }

    public PrescPdfConfig getPdfConfig() {
        return this.pdfConfig;
    }

    public void setPdfConfig(PrescPdfConfig pdfConfig) {
        this.pdfConfig = pdfConfig;
    }

    public List<PresPdfPathEntity> getPdfPath() {
        return this.pdfPath;
    }

    public void setPdfPath(List<PresPdfPathEntity> pdfPath) {
        this.pdfPath = pdfPath;
    }

    public String getOssFile() {
        return this.ossFile;
    }

    public void setOssFile(String ossFile) {
        this.ossFile = ossFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getOssPath() {
        return this.ossPath;
    }

    public void setOssPath(String ossPath) {
        this.ossPath = ossPath;
    }

    public String getHtmlPath() {
        return this.htmlPath;
    }

    public void setHtmlPath(String htmlPath) {
        this.htmlPath = htmlPath;
    }
}

