/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.utils;

import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class SnowflakeIdWorker {
    private static final long twepoch = 1547117622229L;
    private static final long workerIdBits = 5L;
    private static final long datacenterIdBits = 5L;
    private static final long maxWorkerId = 31L;
    private static long maxDatacenterId = 31L;
    private static long sequenceBits;
    private static long workerIdShift;
    private static long datacenterIdShift;
    private static long timestampLeftShift;
    private static long sequenceMask;
    private static long workerId;
    private static long datacenterId;
    private static long sequence;
    private static long lastTimestamp;

    public SnowflakeIdWorker(long workerId, long datacenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (datacenterId > maxDatacenterId || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", maxDatacenterId));
        }
        SnowflakeIdWorker.workerId = workerId;
        SnowflakeIdWorker.datacenterId = datacenterId;
    }

    public SnowflakeIdWorker() {
    }

    public static synchronized long nextId() {
        long timestamp = SnowflakeIdWorker.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & sequenceMask) == 0L) {
                timestamp = SnowflakeIdWorker.tilNextMillis((long)lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        return timestamp - 1547117622229L << (int)timestampLeftShift | datacenterId << (int)datacenterIdShift | workerId << (int)workerIdShift | sequence;
    }

    protected static long tilNextMillis(long lastTimestamp) {
        long timestamp = SnowflakeIdWorker.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = SnowflakeIdWorker.timeGen();
        }
        return timestamp;
    }

    protected static long timeGen() {
        return System.currentTimeMillis();
    }

    static {
        workerIdShift = sequenceBits = 12L;
        datacenterIdShift = sequenceBits + 5L;
        timestampLeftShift = sequenceBits + 5L + 5L;
        sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)sequenceBits;
        sequence = 0L;
        lastTimestamp = -1L;
    }
}

