/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.utils;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringUtil {
    private static Logger logger = LoggerFactory.getLogger(StringUtil.class);
    public static final String EMPTY_STRING = "";

    private StringUtil() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() <= 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty((String)str);
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtil.isBlank((String)str);
    }

    public static long toLongValue(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        String str = null;
        str = obj instanceof String ? (String)obj : String.valueOf(obj);
        if (StringUtil.isBlank((String)str)) {
            return 0L;
        }
        if ("null".equals(str)) {
            return 0L;
        }
        try {
            return Long.valueOf(str);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static int toIntValue(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        String str = null;
        str = obj instanceof String ? (String)obj : String.valueOf(obj);
        if (StringUtil.isBlank((String)str)) {
            return 0;
        }
        if ("null".equals(str)) {
            return 0;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public static String trim(String str) {
        if (str == null || str.length() <= 0) {
            return "";
        }
        return str.trim();
    }

    public static void main(String[] args) {
        Map birAgeSex = StringUtil.getBirAgeSex((String)"110732199909202015");
        String birthday = (String)birAgeSex.get("birthday");
        String age = (String)birAgeSex.get("age");
        String sexCode = (String)birAgeSex.get("sexCode");
        System.out.println(birthday);
        System.out.println(age);
        System.out.println(sexCode);
    }

    private static boolean isNotEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    public static String filterEmoji(String source) {
        if (StringUtil.isNotEmpty((String)source)) {
            int len = source.length();
            StringBuilder buf = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                char codePoint = source.charAt(i);
                if (StringUtil.isNotEmojiCharacter((char)codePoint)) {
                    buf.append(codePoint);
                    continue;
                }
                buf.append("");
            }
            return buf.toString();
        }
        return "";
    }

    public static String getNoZeros(String str) {
        BigDecimal value = new BigDecimal(str);
        BigDecimal noZeros = value.stripTrailingZeros();
        String result = noZeros.toPlainString();
        return result;
    }

    public static Map<String, String> getBirAgeSex(String certificateNo) {
        String birthday = "";
        String age = "";
        String sexCode = "";
        int year = Calendar.getInstance().get(1);
        char[] number = certificateNo.toCharArray();
        boolean flag = true;
        if (number.length == 15) {
            for (char c : number) {
                if (!flag) {
                    return new HashMap<String, String>();
                }
                flag = Character.isDigit(c);
            }
        } else if (number.length == 18) {
            for (int x = 0; x < number.length - 1; ++x) {
                if (!flag) {
                    return new HashMap<String, String>();
                }
                flag = Character.isDigit(number[x]);
            }
        }
        if (flag && certificateNo.length() == 15) {
            birthday = "19" + certificateNo.substring(6, 8) + "-" + certificateNo.substring(8, 10) + "-" + certificateNo.substring(10, 12);
            sexCode = Integer.parseInt(certificateNo.substring(certificateNo.length() - 3, certificateNo.length())) % 2 == 0 ? "1" : "0";
            age = year - Integer.parseInt("19" + certificateNo.substring(6, 8)) + "";
        } else if (flag && certificateNo.length() == 18) {
            birthday = certificateNo.substring(6, 10) + "-" + certificateNo.substring(10, 12) + "-" + certificateNo.substring(12, 14);
            sexCode = Integer.parseInt(certificateNo.substring(certificateNo.length() - 4, certificateNo.length() - 1)) % 2 == 0 ? "1" : "0";
            age = year - Integer.parseInt(certificateNo.substring(6, 10)) + "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("birthday", birthday);
        map.put("age", age);
        map.put("sexCode", sexCode);
        return map;
    }
}

