/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.utils;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.circulation.config.ProjProperties;
import com.ebaiyihui.circulation.pojo.entity.TokenEntity;
import com.ebaiyihui.circulation.utils.RedisUtil;
import com.ebaiyihui.circulation.utils.newtokenutil.TokenBody;
import com.ebaiyihui.circulation.utils.newtokenutil.exception.TokenParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TokenUtil {
    private static final Logger log = LoggerFactory.getLogger(TokenUtil.class);
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    ProjProperties projProperties;

    public TokenEntity getTokenEntity(String tokenJson) {
        TokenBody tokenBody = new TokenBody();
        try {
            tokenBody = com.ebaiyihui.circulation.utils.newtokenutil.TokenUtil.parse((String)tokenJson, (String)this.projProperties.getAuthTokenAppSecret());
        }
        catch (TokenParseException e) {
            e.printStackTrace();
        }
        log.info("tokenbody:{}", (Object)tokenBody);
        TokenEntity tokenEntity = new TokenEntity();
        if (null == this.redisUtil.get(tokenBody.getTokenJson().getAccountId())) {
            tokenEntity.setId(tokenBody.getTokenJson().getAccountId());
        } else {
            tokenEntity = (TokenEntity)JSON.parseObject((String)this.redisUtil.get(tokenBody.getTokenJson().getAccountId()).toString(), TokenEntity.class);
        }
        return tokenEntity;
    }
}

