/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.utils;

import com.ebaiyihui.circulation.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);
    public static final String ZIP_SUFFIX = ".zip";

    public static void saveZip(String filePath, String zipPath, String name, HttpServletResponse response) {
        log.info("\u5f00\u59cb\u538b\u7f29" + System.currentTimeMillis());
        File zipFile = new File(zipPath + name + ZIP_SUFFIX);
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
            File[] files = new File(filePath).listFiles();
            byte[] buffer = new byte[1024];
            for (File file : files) {
                try (FileInputStream fis = new FileInputStream(file);){
                    int len;
                    zos.putNextEntry(new ZipEntry(file.getName()));
                    while ((len = fis.read(buffer)) != -1) {
                        zos.write(buffer, 0, len);
                    }
                    zos.flush();
                    zos.closeEntry();
                }
                catch (Exception e) {
                    log.info("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
            zos.close();
            log.info("\u538b\u7f29\u7ed3\u675f" + System.currentTimeMillis());
            log.info("\u5f00\u59cb\u4e0b\u8f7d" + System.currentTimeMillis());
            FileUtils.downloadZip1((File)zipFile, (HttpServletResponse)response);
            log.info("\u7ed3\u675f\u4e0b\u8f7d" + System.currentTimeMillis());
            FileUtils.deleteDir((String)filePath);
            FileUtils.deleteDir((String)zipPath);
        }
        catch (Exception e) {
            log.info("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }
}

