/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.utils.drugutil;

import org.apache.commons.lang.StringUtils;

public class DesensitizationUtil {
    public static final int ONE = 1;
    public static final int TWO = 2;
    public static final int THREE = 3;
    public static final int EIGHT = 8;

    public static String desensitizedName(String fullName) {
        if (fullName.length() == 1) {
            return fullName;
        }
        if (fullName.length() == 2) {
            fullName = fullName.replaceFirst(fullName.substring(0, 1), "*");
        }
        if (fullName.length() == 3) {
            fullName = fullName.replaceFirst(fullName.substring(1, fullName.length() - 1), "*");
        }
        if (fullName.length() > 3) {
            fullName = fullName.replaceFirst(fullName.substring(1, fullName.length() - 1), "**");
        }
        return fullName;
    }

    public static String desensitizedPhoneNumber(String phoneNumber) {
        if (StringUtils.isNotBlank((String)phoneNumber)) {
            phoneNumber = phoneNumber.replaceAll("(\\w{3})\\w*(\\w{4})", "$1****$2");
        }
        return phoneNumber;
    }

    public static String desensitizedIdNumber(String idNumber) {
        if (StringUtils.isNotBlank((String)idNumber)) {
            return StringUtils.left((String)idNumber, (int)3).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)idNumber, (int)4), (int)StringUtils.length((String)idNumber), (String)"*"), (String)"***"));
        }
        return idNumber;
    }

    public static String desensitizedMedicalCard(String medicalCard) {
        if (StringUtils.isNotBlank((String)medicalCard)) {
            if (medicalCard.length() < 8) {
                return medicalCard;
            }
            return medicalCard.replaceFirst(medicalCard.substring(3, medicalCard.length() - 4), "********");
        }
        return medicalCard;
    }
}

