/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.utils.medicalcloud;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;

public class BeanHelper {
    private static final Logger log = LoggerFactory.getLogger(BeanHelper.class);

    public static <T> void nullToEmpty(T bean) {
        Field[] field;
        for (Field item : field = bean.getClass().getDeclaredFields()) {
            String name = item.getName();
            name = name.substring(0, 1).toUpperCase() + name.substring(1);
            String type = item.getGenericType().toString();
            if (!"class java.lang.String".equals(type)) continue;
            try {
                Method mGet = bean.getClass().getMethod("get" + name, new Class[0]);
                String value = (String)mGet.invoke(bean, new Object[0]);
                if (value != null && !"".equals(value)) continue;
                Method mSet = bean.getClass().getMethod("set" + name, String.class);
                mSet.invoke(bean, "");
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.info("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }
}

