/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.utils.medicalcloud;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitMqUtils {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqUtils.class);
    public static final int ONE_THOUSAND = 1000;
    public static final String DELAY_STRING = "x-delay";

    public static void senderDelayedLogisticsOrder(RabbitTemplate rabbitTemplate, String logisticsOrderSeq, Integer orderExpireTime) {
        rabbitTemplate.convertAndSend("logistics.delayed_exchange_pre_new", "logistics.delayed_order_routing_key_pre_new", (Object)logisticsOrderSeq, message -> {
            message.getMessageProperties().setHeader(DELAY_STRING, (Object)(orderExpireTime * 1000));
            log.info("senderDelayedLogisticsOrder message to rabbitmq : " + logisticsOrderSeq);
            return message;
        });
    }

    public static void senderDelayedPrescriptionOrder(RabbitTemplate rabbitTemplate, String mainId, Integer orderExpireTime) {
        rabbitTemplate.convertAndSend("logistics.delayed_exchange_pre_new", "prescription.delayed_order_routing_key_pre_new", (Object)mainId, message -> {
            message.getMessageProperties().setHeader(DELAY_STRING, (Object)(orderExpireTime * 1000));
            log.info("senderDelayedPrescriptionOrder message to rabbitmq: " + mainId);
            return message;
        });
    }

    public static void addMainNoPay(RabbitTemplate rabbitTemplate, String mainId, Integer orderExpireTime) {
        rabbitTemplate.convertAndSend("logistics.delayed_exchange_pre_new", "prescription.delayed.main.no.pay.routing.key", (Object)mainId, message -> {
            message.getMessageProperties().setHeader(DELAY_STRING, (Object)(orderExpireTime * 1000));
            log.info("addMainNoPay message to rabbitmq: " + mainId);
            return message;
        });
    }

    public static void commerceNoPay(RabbitTemplate rabbitTemplate, String orderId, Integer orderExpireTime) {
        rabbitTemplate.convertAndSend("logistics.delayed_exchange_pre_new", "commerce.delayed.order.no.pay.routing.key", (Object)orderId, message -> {
            message.getMessageProperties().setHeader(DELAY_STRING, (Object)(orderExpireTime * 1000));
            log.info("send commerceOrderNoPay message to rabbitmq: " + orderId);
            return message;
        });
    }

    public static void commerceNextPayRemind(RabbitTemplate rabbitTemplate, String orderId, Long orderExpireTime) {
        rabbitTemplate.convertAndSend("logistics.delayed_exchange_pre_new", "prescription.commerce.order.next.buy.remind.routing.key", (Object)orderId, message -> {
            message.getMessageProperties().setHeader(DELAY_STRING, (Object)(orderExpireTime * 1000L));
            log.info("send commerceNextPayRemind message to rabbitmq: " + orderId);
            return message;
        });
    }
}

