/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.circulation.utils.newtokenutil;

import com.ebaiyihui.framework.utils.JsonUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Base64;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JwtUtil {
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);

    public static String genJwt(String id, Object arg, long timeToLive, TimeUnit unit, String secreKey) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        String subject = JsonUtil.convertObject((Object)arg);
        SecretKey key = JwtUtil.generalKey((String)secreKey);
        JwtBuilder builder = Jwts.builder().setId(id).setIssuedAt(now).setSubject(subject).signWith(signatureAlgorithm, (Key)key);
        long ttlMillis = unit.toMillis(timeToLive);
        if (ttlMillis > 0L) {
            long expMillis = nowMillis + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static Claims parseJWT(String jwt, String secreKey) throws Exception {
        SecretKey key = JwtUtil.generalKey((String)secreKey);
        Claims claims = (Claims)Jwts.parser().setSigningKey((Key)key).parseClaimsJws(jwt).getBody();
        return claims;
    }

    public static SecretKey generalKey(String secryKey) {
        Charset charset = Charset.forName("utf-8");
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] encodedKey = encoder.encode(secryKey.getBytes(charset));
        SecretKeySpec key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        return key;
    }
}

