<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width,initial-scale=1.0"/>
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests"/>
    <link rel="icon" href="https://cdn2019.oss-cn-beijing.aliyuncs.com/webStatic/favicon.png"/>
    <title></title>
    <style>
        *{
            margin: 0;
            padding: 0;
        }

        #print_order_wrap{
            width:100%;
            box-sizing: border-box;
            padding:20px;
        }

        .order_info_wrap{
            height:auto;
            margin-bottom:20px;
            box-sizing: border-box;
            padding:20px;
            border:2px solid #1a2f6c;
            border-radius: 25px;
            color: #1a2f6c;
        }


        .order_info_wrap .order_head_wrap{
            margin-bottom:30px;
        }


        .order_info_wrap .order_head_wrap .order_name_wrap{
            text-align:center;
            font-weight:bold;
            font-size:30px;
            color:#1a2f6c;
        }


        .order_info_wrap .order_group_wrap{
            overflow:hidden;
        }

        .order_info_wrap .order_side_wrap{
            width:50%;
            float: left;
        }

        .order_info_wrap .order_side_wrap .order_item_wrap{
            margin-bottom: 20px;
        }

        .order_info_wrap .order_side_wrap .order_item{
            margin-right:10px;
            font-size:14px;
            color:#1a2f6c;
        }

        .order_info_wrap .order_side_wrap .order_info{
            font-size:14px;
            color:#1a2f6c;
        }

        .order_info_wrap .order_side_wrap .order_address{
            font-size:12px;
            color:#1a2f6c;
        }

        .order_desc_wrap{
            box-sizing: border-box;
            padding:20px 40px;
            color: #231815;
            border:1px solid #1a2f6c;
        }

        .order_desc_wrap .desc_main_wrap{
            box-sizing: border-box;
            padding:10px 0;
            border-bottom:1px solid #231815;
        }

        .order_desc_wrap .desc_head_wrap{
            margin-bottom:20px;
            font-size:20px;
            color:#231815;
        }


        .order_desc_wrap .desc_info_wrap{
            font-size:16px;
            color:#231815;
        }


        .order_desc_wrap .desc_item_wrap{
            width:100%;
            overflow: hidden;
            margin:20px 0;
        }


        .order_desc_wrap .desc_item_wrap .drug_item_wrap {
            display: inline-block;
            width:20%;
            float:left;
        }


        .order_desc_wrap .desc_item_wrap .drug_center_wrap {
            display: inline-block;
            width:20%;
            float:left;
            margin:0 20px;
        }



        .drug_num_wrap{
            display: inline-block;
            width:80px;
            float:left;
            margin:0 10px;
        }



        .order_desc_wrap .desc_item_wrap .drug_temp_wrap{
            display:inline-block;
            width:50px;
            float:left;
            margin:0 10px;
        }


        .order_desc_wrap .drug_item{
            font-size:14px;
            color:#231815;
        }


        .order_desc_wrap .drug_info{
            font-size:12px;
            color:#231815;
        }

        .order_desc_wrap .desc_mark_wrap{
            margin:30px 0;
            font-weight:bold;
            font-size:16px;
            color:#231815;
        }

        .order_desc_wrap .desc_time_wrap{
            overflow: hidden;
        }


        .order_desc_wrap .desc_time_wrap .time_item_wrap{
            width:50%;
            float:left;
            font-size:14px;
            color:#231815;
        }
    </style>
</head>
<body style="font-family:SimSun; font-size:12px;">

 <div id="print_order_wrap">
    <div class="order_info_wrap">
      <div class="order_head_wrap">
        <div class="order_name_wrap">${orderDetail.presOrganName!""}</div>
        <div class="order_name_wrap">互联网医院药品清单</div>
      </div>
      <div class="order_group_wrap">
        <div class="order_side_wrap">
          <div class="order_item_wrap">
            <span class="order_item">医嘱编号:</span>
            <span class="order_info">${orderDetail.mainId!""}</span>
          </div>
          <div class="order_item_wrap">
            <span class="order_item">开方医生:</span>
            <span class="order_info">${orderDetail.presDoctorName!""}</span>
          </div>
          <div class="order_item_wrap">
            <span class="order_item">患者姓名:</span>
            <span class="order_info">${orderDetail.patientName!""}</span>
          </div>
          <div class="order_item_wrap">
            <span class="order_item">就诊卡号:</span>
            <span class="order_info">${orderDetail.patientNo!""}</span>
          </div>
          <div class="order_item_wrap">
            <span class="order_item">身份证号:</span>
            <span class="order_info">${orderDetail.patientCredNo!""}</span>
          </div>
        </div>
        <div class="order_side_wrap">
          <div class="order_item_wrap">
            <span class="order_item">金额:</span>
            <span class="order_info">¥ ${orderDetail.drugPayAmount!""}</span>
          </div>
          <div class="order_item_wrap">
            <span class="order_item">微信流水号:</span>
            <span class="order_info">${orderDetail.bankTradeNo!""}</span>
          </div>
          <div class="order_item_wrap">
            <span class="order_item">收件人:</span>
            <span class="order_info">${orderDetail.destName!""}</span>
          </div>
          <div class="order_item_wrap">
            <span class="order_item">收件人电话:</span>
            <span class="order_info">${orderDetail.destPhone!""}</span>
          </div>
          <div class="order_item_wrap">
            <span class="order_item">收件人地址:</span>
            <span class="order_address">${orderDetail.destAddress!""}</span>
          </div>
        </div>
      </div>
    </div>
    <div class="order_desc_wrap">
      <div class="desc_main_wrap">
        <div class="desc_head_wrap">诊断描述:</div>
        <div class="desc_info_wrap">${orderDetail.diagnostic!""}</div>
      </div>
      <br/>
      <#list orderDetail.drugDetailData as item>
        <div class="desc_item_wrap">
            <div class="drug_item_wrap">
            <div class="drug_item">${item.drugName!""}</div>
            </div>
            <div class="drug_center_wrap">
            <div class="drug_item">用法用量:</div>
            <div class="drug_info">${item.dosage!""}</div>
            </div>
            <div class="drug_item_wrap">
            <div class="drug_item">规格:</div>
            <div class="drug_info">${item.drugSpec!""}</div>
            </div>
            <div class="drug_num_wrap">
            <div class="drug_item">取药数量:</div>
            <div class="drug_info">${item.amount!""}${item.amountUnit!""}</div>
            </div>
            <div class="drug_temp_wrap">
            <div class="drug_item">单价:</div>
            <div class="drug_info">¥ ${item.unitPrice!""}</div>
            </div>
        </div>
      </#list>
      <div class="desc_mark_wrap">
        <span class="mark_item">处方备注:</span>
        <span class="mark_info">${orderDetail.presRemark!""}</span>
      </div>
      <div class="desc_time_wrap">
        <span class="time_item_wrap">医嘱时间: ${orderDetail.obtainTime!""}</span>
        <span class="time_item_wrap">支付时间: ${orderDetail.drugPayTime!""}</span>
      </div>
    </div>
</div>
</body>
</html>