/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.dfs.api;

import com.ebaiyihui.dfs.pojo.BaseResponse;
import com.ebaiyihui.dfs.pojo.DfsFileRespVo;
import io.swagger.annotations.Api;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(path={"/file/v1"})
@Api(tags={"\u6587\u4ef6\u64cd\u4f5c\u7c7b"})
public interface FileApi {
    @GetMapping(path={"/get/list"})
    public BaseResponse<List<DfsFileRespVo>> getListByFileIds(@RequestParam(value="fileIds", defaultValue="") List<String> var1);

    @GetMapping(value={"/get/one/{fileId}"})
    public BaseResponse<DfsFileRespVo> getOneByFileId(@PathVariable(value="fileId") String var1);

    @PostMapping(path={"/upload/default"}, consumes={"multipart/form-data"})
    public BaseResponse<DfsFileRespVo> uploadToDefault(@RequestParam(value="file") MultipartFile var1);

    @PostMapping(path={"/upload/group"}, consumes={"multipart/form-data"})
    public BaseResponse<DfsFileRespVo> uploadFileToGroup(@RequestParam(value="file", defaultValue="") MultipartFile var1, @RequestParam(value="busiCode") String var2);

    @PostMapping(path={"/upload/group/files"}, consumes={"multipart/form-data"})
    public BaseResponse<List<DfsFileRespVo>> uploadFiles(@RequestParam(value="files") MultipartFile[] var1, @RequestParam(value="busiCode") String var2);

    @PostMapping(path={"/upload/group/large"}, consumes={"multipart/form-data"})
    public BaseResponse<DfsFileRespVo> uploadBigFile(@RequestParam(value="files") MultipartFile var1, @RequestParam(value="busiCode") String var2);

    @GetMapping(path={"/{ts}/{fileId}"})
    public void display(@PathVariable(value="fileId") String var1, @PathVariable(value="ts") String var2);

    @GetMapping(path={"/t2/{ts}/{fileId}"})
    public void display2(@PathVariable(value="fileId") String var1, @PathVariable(value="ts") String var2);

    @GetMapping(value={"/get/urlWithToken/{fileId}"})
    public BaseResponse<DfsFileRespVo> getUrlWithToken(@PathVariable(value="fileId") String var1);

    @GetMapping(value={"/download/{fileId}"})
    public void downloadByFileId(@PathVariable(value="fileId") String var1);

    @GetMapping(value={"/delete/{fileId}"})
    public BaseResponse<?> delFileByFileId(@PathVariable(value="fileId") String var1);
}

