/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.dfs.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.dfs.common.HttpProfile;
import com.ebaiyihui.dfs.pojo.BaseResponse;
import com.ebaiyihui.dfs.pojo.DfsFileRespVo;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

public class DfsClient {
    @Autowired
    private RestTemplate restTemplate;

    public static BaseResponse<JSONObject> getListByFileIds(@Validated HttpProfile httpProfile, List<String> fileIds) {
        RestTemplate restTemplate = new RestTemplate();
        if (fileIds.isEmpty()) {
            throw new RuntimeException("\u6587\u4ef6Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("app_id", "odw");
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        String url = httpProfile.getProtocol() + httpProfile.getEndpoint() + "/file/v1/get/list?";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fileIds", fileIds);
        HttpEntity httpEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class, new Object[0]);
        System.out.println("-----------" + JSON.toJSONString((Object)response));
        if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
            return BaseResponse.success((Object)response.getBody());
        }
        return BaseResponse.success();
    }

    BaseResponse<JSONObject> getOneByFileId(@Validated HttpProfile httpProfile, String fileId) {
        if (StringUtils.isEmpty((Object)fileId)) {
            throw new RuntimeException("\u6587\u4ef6Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        String url = httpProfile.getProtocol() + httpProfile.getEndpoint() + "/file/v1/get/one";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fileId", (Object)fileId);
        HttpEntity httpEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class, new Object[0]);
        System.out.println("-----------" + JSON.toJSONString((Object)response));
        if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
            return BaseResponse.success((Object)response.getBody());
        }
        return null;
    }

    BaseResponse<JSONObject> uploadToDefault(@Validated HttpProfile httpProfile, MultipartFile file) {
        if (StringUtils.isEmpty((Object)file.getOriginalFilename())) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        String url = httpProfile.getProtocol() + httpProfile.getEndpoint() + "/file/v1/upload/default";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("file", (Object)file);
        HttpEntity httpEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
        System.out.println("-----------" + JSON.toJSONString((Object)response));
        if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
            return BaseResponse.success((Object)response.getBody());
        }
        return null;
    }

    BaseResponse<JSONObject> uploadFileToGroup(@Validated HttpProfile httpProfile, MultipartFile file, String busiCode) {
        if (StringUtils.isEmpty((Object)file.getOriginalFilename())) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)busiCode)) {
            throw new RuntimeException("busiCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        String url = httpProfile.getProtocol() + httpProfile.getEndpoint() + "/file/v1/upload/group";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("file", (Object)file);
        jsonObject.put("busiCode", (Object)busiCode);
        HttpEntity httpEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
        System.out.println("-----------" + JSON.toJSONString((Object)response));
        if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
            return BaseResponse.success((Object)response.getBody());
        }
        return null;
    }

    BaseResponse<List<DfsFileRespVo>> uploadFiles(@Validated HttpProfile httpProfile, MultipartFile[] multipartFiles, String busiCode) {
        if (null == multipartFiles) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)busiCode)) {
            throw new RuntimeException("busiCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return null;
    }

    BaseResponse<DfsFileRespVo> uploadBigFile(@Validated HttpProfile httpProfile, MultipartFile file, String busiCode) {
        if (StringUtils.isEmpty((Object)file.getOriginalFilename())) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)busiCode)) {
            throw new RuntimeException("busiCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return null;
    }

    void downloadByFileId(@Validated HttpProfile httpProfile, String fileId) {
    }

    BaseResponse<?> delFileByFileId(@Validated HttpProfile httpProfile, String fileId) {
        if (StringUtils.isEmpty((Object)fileId)) {
            throw new RuntimeException("\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return null;
    }

    public static void main(String[] args) {
        HttpProfile httpProfile = new HttpProfile();
        httpProfile.setEndpoint("localhost:6543");
        BaseResponse<JSONObject> oneByFileId = DfsClient.getListByFileIds(httpProfile, Arrays.asList("45d55f708ff24db2a9ddf33dd30189e1"));
    }
}

