/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.dfs.client;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.dfs.common.HttpProfile;
import com.ebaiyihui.dfs.common.RestTemplateUtils;
import com.ebaiyihui.dfs.pojo.BaseResponse;
import com.ebaiyihui.dfs.pojo.DfsFileRespVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Component
public class DfsClient {
    @Autowired
    private RestTemplate restTemplate;

    public BaseResponse<JSONObject> getListByFileIds(HttpProfile httpProfile, List<String> fileIds) {
        if (null == this.restTemplate) {
            this.restTemplate = RestTemplateUtils.getResttemplate();
        }
        if (fileIds.isEmpty()) {
            throw new RuntimeException("\u6587\u4ef6Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("appId", httpProfile.getAppId());
        headers.set("secret", httpProfile.getSecret());
        headers.set("channelsource", httpProfile.getChannelsource());
        headers.setContentType(httpProfile.getContentType());
        String url = httpProfile.getByhDomain() + "/cloud/fastdfs/file/v1/get/list?fileIds=" + String.join((CharSequence)",", fileIds);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class, new Object[0]);
        if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
            return BaseResponse.success((Object)response.getBody());
        }
        return BaseResponse.success();
    }

    public BaseResponse<JSONObject> getOneByFileId(@Validated HttpProfile httpProfile, String fileId) {
        if (null == this.restTemplate) {
            this.restTemplate = RestTemplateUtils.getResttemplate();
        }
        if (StringUtils.isEmpty((Object)fileId)) {
            throw new RuntimeException("\u6587\u4ef6Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("appId", httpProfile.getAppId());
        headers.set("secret", httpProfile.getSecret());
        headers.set("channelsource", httpProfile.getChannelsource());
        headers.setContentType(httpProfile.getContentType());
        String url = httpProfile.getByhDomain() + "/cloud/fastdfs/file/v1/get/one/" + fileId;
        JSONObject jsonObject = new JSONObject();
        HttpEntity httpEntity = new HttpEntity((Object)jsonObject.toString(), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class, new Object[0]);
        if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
            return BaseResponse.success((Object)response.getBody());
        }
        return null;
    }

    public BaseResponse<?> delFileByFileId(HttpProfile httpProfile, String fileId) {
        if (null == this.restTemplate) {
            this.restTemplate = RestTemplateUtils.getResttemplate();
        }
        if (StringUtils.isEmpty((Object)fileId)) {
            throw new RuntimeException("\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("appId", "odw");
        headers.set("secret", httpProfile.getSecret());
        headers.set("channelsource", httpProfile.getChannelsource());
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        String url = httpProfile.getByhDomain() + "/cloud/fastdfs/file/v1/delete/" + fileId;
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class, new Object[0]);
        if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
            return BaseResponse.success((Object)response.getBody());
        }
        throw new RuntimeException("\u5220\u9664\u6587\u4ef6\u5931\u8d25");
    }

    public BaseResponse<JSONObject> uploadToDefault(@Validated HttpProfile httpProfile, MultipartFile file) {
        if (StringUtils.isEmpty((Object)file.getOriginalFilename())) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("appId", httpProfile.getAppId());
        headers.set("secret", httpProfile.getSecret());
        headers.set("channelsource", httpProfile.getChannelsource());
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        String url = httpProfile.getByhDomain() + "/cloud/fastdfs/file/v1/upload/default";
        HttpEntity httpEntity = new HttpEntity((Object)file, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
        if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
            return BaseResponse.success((Object)response.getBody());
        }
        throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
    }

    public BaseResponse<JSONObject> uploadFileToGroup(@Validated HttpProfile httpProfile, MultipartFile file, String busiCode) {
        if (StringUtils.isEmpty((Object)file.getOriginalFilename())) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)busiCode)) {
            throw new RuntimeException("busiCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("appId", httpProfile.getAppId());
        headers.set("secret", httpProfile.getSecret());
        headers.set("channelsource", httpProfile.getChannelsource());
        headers.setContentType(httpProfile.getContentType());
        String url = httpProfile.getByhDomain() + "/cloud/fastdfs/file/v1/upload/group?busiCode=" + busiCode;
        HttpEntity httpEntity = new HttpEntity((Object)file, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
        if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
            return BaseResponse.success((Object)response.getBody());
        }
        throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
    }

    BaseResponse<List<DfsFileRespVo>> uploadFiles(@Validated HttpProfile httpProfile, MultipartFile[] multipartFiles, String busiCode) {
        if (null == multipartFiles) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)busiCode)) {
            throw new RuntimeException("busiCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return null;
    }
}

