/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.dfs.common;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtils {
    private RestTemplateUtils() {
    }

    public static RestTemplate getResttemplate() {
        RestTemplate restTemplate = new RestTemplate();
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(1000);
        requestFactory.setReadTimeout(1000);
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler());
        return restTemplate;
    }

    public static String get(String url, JSONObject params) {
        RestTemplate restTemplate = new RestTemplate();
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(1000);
        requestFactory.setReadTimeout(1000);
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler());
        return (String)restTemplate.getForObject(RestTemplateUtils.expandURL(url, params.keySet()), String.class, (Map)params);
    }

    public static String post(String url, JSONObject params, MediaType mediaType) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(mediaType);
        restTemplate.getMessageConverters().clear();
        restTemplate.getMessageConverters().add(new FastJsonHttpMessageConverter());
        HttpEntity requestEntity = mediaType == MediaType.APPLICATION_JSON || mediaType == MediaType.APPLICATION_JSON_UTF8 ? new HttpEntity((Object)params, (MultiValueMap)requestHeaders) : new HttpEntity(null, (MultiValueMap)requestHeaders);
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler());
        String result = mediaType == MediaType.APPLICATION_JSON || mediaType == MediaType.APPLICATION_JSON_UTF8 ? (String)restTemplate.postForObject(url, (Object)requestEntity, String.class, new Object[0]) : (String)restTemplate.postForObject(RestTemplateUtils.expandURL(url, params.keySet()), (Object)requestEntity, String.class, (Map)params);
        return result;
    }

    public static <T> T post(String url, JSONObject params, MediaType mediaType, Class<T> clz) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(new FormHttpMessageConverter());
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(mediaType);
        HttpEntity requestEntity = mediaType == MediaType.APPLICATION_JSON || mediaType == MediaType.APPLICATION_JSON_UTF8 ? new HttpEntity((Object)params, (MultiValueMap)requestHeaders) : (mediaType == MediaType.APPLICATION_FORM_URLENCODED ? new HttpEntity(RestTemplateUtils.createMultiValueMap(params), (MultiValueMap)requestHeaders) : new HttpEntity(null, (MultiValueMap)requestHeaders));
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler());
        Object result = mediaType == MediaType.APPLICATION_JSON || mediaType == MediaType.APPLICATION_JSON_UTF8 ? restTemplate.postForObject(url, (Object)requestEntity, clz, new Object[0]) : restTemplate.postForObject(mediaType == MediaType.APPLICATION_FORM_URLENCODED ? url : RestTemplateUtils.expandURL(url, params.keySet()), (Object)requestEntity, clz, (Map)params);
        return (T)result;
    }

    private static MultiValueMap<String, String> createMultiValueMap(JSONObject params) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (String key : params.keySet()) {
            if (params.get((Object)key) instanceof List) {
                for (String value : (List)params.get((Object)key)) {
                    map.add((Object)key, (Object)value);
                }
                continue;
            }
            map.add((Object)key, (Object)params.getString(key));
        }
        return map;
    }

    private static String expandURL(String url, Set<?> keys) {
        Pattern QUERY_PARAM_PATTERN = Pattern.compile("([^&=]+)(=?)([^&]+)?");
        Matcher mc = QUERY_PARAM_PATTERN.matcher(url);
        StringBuilder sb = new StringBuilder(url);
        if (mc.find()) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        for (Object key : keys) {
            sb.append(key).append("=").append("{").append(key).append("}").append("&");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private static class DefaultResponseErrorHandler
    implements ResponseErrorHandler {
        private DefaultResponseErrorHandler() {
        }

        public boolean hasError(ClientHttpResponse response) throws IOException {
            return response.getStatusCode().value() != 200;
        }

        public void handleError(ClientHttpResponse response) throws IOException {
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getBody()));
            StringBuilder sb = new StringBuilder();
            String str = null;
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            try {
                throw new Exception(sb.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

