/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.dfs.client;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.dfs.common.HttpProfile;
import com.ebaiyihui.dfs.common.RestTemplateUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.client.RestTemplate;

@Component
public class DfsClient {
    @Autowired
    private RestTemplate restTemplate;

    public BaseResponse<JSONObject> getListByFileIds(HttpProfile httpProfile, List<String> fileIds) {
        if (null == this.restTemplate) {
            this.restTemplate = RestTemplateUtils.getResttemplate();
        }
        if (fileIds.isEmpty()) {
            throw new RuntimeException("fileIds cannot is empty");
        }
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isEmpty((Object)httpProfile.getAppId()) || StringUtils.isEmpty((Object)httpProfile.getSecret())) {
            throw new RuntimeException("appid or secret cannot is empty");
        }
        if (StringUtils.isEmpty((Object)httpProfile.getChannelsource())) {
            throw new RuntimeException("channelsource cannot is empty");
        }
        headers.set("appId", httpProfile.getAppId());
        headers.set("secret", httpProfile.getSecret());
        headers.set("channelsource", httpProfile.getChannelsource());
        MediaType contentType = httpProfile.getContentType();
        headers.setContentType(contentType == null ? MediaType.APPLICATION_JSON_UTF8 : contentType);
        String url = httpProfile.getByhDomain() + "/cloud/fastdfs/file/v1/get/list?fileIds=" + String.join((CharSequence)",", fileIds);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class, new Object[0]);
        if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
            return BaseResponse.success((Object)response.getBody());
        }
        throw new RuntimeException("\u6587\u4ef6\u67e5\u8be2\u5931\u8d25");
    }

    public BaseResponse<JSONObject> getOneByFileId(@Validated HttpProfile httpProfile, String fileId) {
        if (null == this.restTemplate) {
            this.restTemplate = RestTemplateUtils.getResttemplate();
        }
        if (StringUtils.isEmpty((Object)fileId)) {
            throw new RuntimeException("fileId cannot is empty");
        }
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isEmpty((Object)httpProfile.getAppId()) || StringUtils.isEmpty((Object)httpProfile.getSecret())) {
            throw new RuntimeException("appid or secret cannot is empty");
        }
        if (StringUtils.isEmpty((Object)httpProfile.getChannelsource())) {
            throw new RuntimeException("channelsource cannot is empty");
        }
        headers.set("appId", httpProfile.getAppId());
        headers.set("secret", httpProfile.getSecret());
        headers.set("channelsource", httpProfile.getChannelsource());
        MediaType contentType = httpProfile.getContentType();
        headers.setContentType(contentType == null ? MediaType.APPLICATION_JSON_UTF8 : contentType);
        String url = httpProfile.getByhDomain() + "/cloud/fastdfs/file/v1/get/one/" + fileId;
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class, new Object[0]);
        if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
            return BaseResponse.success((Object)response.getBody());
        }
        throw new RuntimeException("\u6587\u4ef6\u67e5\u8be2\u5931\u8d25");
    }

    public BaseResponse<?> delFileByFileId(HttpProfile httpProfile, String fileId) {
        if (null == this.restTemplate) {
            this.restTemplate = RestTemplateUtils.getResttemplate();
        }
        if (StringUtils.isEmpty((Object)fileId)) {
            throw new RuntimeException("fileId cannot is empty");
        }
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.isEmpty((Object)httpProfile.getAppId()) || StringUtils.isEmpty((Object)httpProfile.getSecret())) {
            throw new RuntimeException("appid or secret cannot is empty");
        }
        if (StringUtils.isEmpty((Object)httpProfile.getChannelsource())) {
            throw new RuntimeException("channelsource cannot is empty");
        }
        headers.set("appId", httpProfile.getAppId());
        headers.set("secret", httpProfile.getSecret());
        headers.set("channelsource", httpProfile.getChannelsource());
        MediaType contentType = httpProfile.getContentType();
        headers.setContentType(contentType == null ? MediaType.APPLICATION_JSON_UTF8 : contentType);
        String url = httpProfile.getByhDomain() + "/cloud/fastdfs/file/v1/delete/" + fileId;
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class, new Object[0]);
        if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
            return BaseResponse.success((Object)response.getBody());
        }
        throw new RuntimeException("\u5220\u9664\u6587\u4ef6\u5931\u8d25");
    }
}

